/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-11-01 14:13:27 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `ee3j5m0_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=116 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_asenha_email_delivery` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('successful','failed','unknown') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'unknown',
  `error` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subject` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `send_to` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sender` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `reply_to` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `headers` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_type` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attachments` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `backtrace` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `processor` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sent_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `sent_on_unixtime` int NOT NULL DEFAULT '0',
  `extra` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_asenha_failed_logins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(24) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `fail_count` int NOT NULL DEFAULT '0',
  `lockout_count` int NOT NULL DEFAULT '0',
  `request_uri` varchar(24) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `unixtime` int NOT NULL DEFAULT '0',
  `datetime_wp` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `info` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip_address` (`ip_address`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_duplicator_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `archive_name` varchar(350) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `progress` float NOT NULL DEFAULT '0',
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `version` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_duplicator_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value_1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `version` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_easywpsmtp_debug_events` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_520_ci,
  `initiator` text COLLATE utf8mb4_unicode_520_ci,
  `event_type` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_easywpsmtp_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_bans` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `host` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'ip',
  `created_at` datetime NOT NULL,
  `actor_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `actor_id` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `host` (`host`),
  KEY `actor` (`actor_type`,`actor_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_dashboard_events` (
  `event_id` int unsigned NOT NULL AUTO_INCREMENT,
  `event_slug` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `event_time` datetime NOT NULL,
  `event_count` int unsigned NOT NULL DEFAULT '1',
  `event_consolidated` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`event_id`),
  UNIQUE KEY `event_slug__time__consolidated` (`event_slug`,`event_time`,`event_consolidated`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_dashboard_lockouts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `time` datetime NOT NULL,
  `count` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip__time` (`ip`,`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_distributed_storage` (
  `storage_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `storage_group` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `storage_key` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `storage_chunk` int NOT NULL DEFAULT '0',
  `storage_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `storage_updated` datetime NOT NULL,
  PRIMARY KEY (`storage_id`),
  UNIQUE KEY `storage_group__key__chunk` (`storage_group`,`storage_key`,`storage_chunk`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_fingerprints` (
  `fingerprint_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fingerprint_user` bigint unsigned NOT NULL,
  `fingerprint_hash` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_created_at` datetime NOT NULL,
  `fingerprint_approved_at` datetime NOT NULL,
  `fingerprint_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_snapshot` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_last_seen` datetime NOT NULL,
  `fingerprint_uses` int NOT NULL DEFAULT '0',
  `fingerprint_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_uuid` char(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`fingerprint_id`),
  UNIQUE KEY `fingerprint_user__hash` (`fingerprint_user`,`fingerprint_hash`),
  UNIQUE KEY `fingerprint_uuid` (`fingerprint_uuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_firewall_rules` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `provider` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `provider_ref` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `vulnerability` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `config` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime NOT NULL,
  `paused_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `provider__ref` (`provider`,`provider_ref`),
  KEY `vulnerability` (`vulnerability`),
  KEY `paused_at` (`paused_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_geolocation_cache` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_host` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_lat` decimal(10,8) NOT NULL,
  `location_long` decimal(11,8) NOT NULL,
  `location_label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_credit` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_meta` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_time` datetime NOT NULL,
  PRIMARY KEY (`location_id`),
  UNIQUE KEY `location_host` (`location_host`),
  KEY `location_time` (`location_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_lockouts` (
  `lockout_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lockout_user` bigint unsigned DEFAULT NULL,
  `lockout_username` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lockout_active` int NOT NULL DEFAULT '1',
  `lockout_context` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `code` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'notice',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `init_timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `memory_current` bigint unsigned NOT NULL DEFAULT '0',
  `memory_peak` bigint unsigned NOT NULL DEFAULT '0',
  `url` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blog_id` bigint NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `remote_ip` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `code` (`code`),
  KEY `type` (`type`),
  KEY `timestamp` (`timestamp`),
  KEY `init_timestamp` (`init_timestamp`),
  KEY `user_id` (`user_id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_mutexes` (
  `mutex_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `mutex_name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `mutex_expires` int unsigned NOT NULL,
  PRIMARY KEY (`mutex_id`),
  UNIQUE KEY `mutex_name` (`mutex_name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_opaque_tokens` (
  `token_id` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_hashed` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_data` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_created_at` datetime NOT NULL,
  PRIMARY KEY (`token_id`),
  UNIQUE KEY `token_hashed` (`token_hashed`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_temp` (
  `temp_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `temp_user` bigint unsigned DEFAULT NULL,
  `temp_username` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_user_groups` (
  `group_id` char(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `group_label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `group_roles` text COLLATE utf8mb4_unicode_520_ci,
  `group_canonical` text COLLATE utf8mb4_unicode_520_ci,
  `group_users` text COLLATE utf8mb4_unicode_520_ci,
  `group_min_role` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `group_created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_vulnerabilities` (
  `id` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `software_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `software_slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `first_seen` datetime NOT NULL,
  `last_seen` datetime NOT NULL,
  `resolved_at` datetime DEFAULT NULL,
  `resolved_by` bigint unsigned NOT NULL DEFAULT '0',
  `resolution` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `details` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `resolution` (`resolution`),
  KEY `software_type` (`software_type`),
  KEY `last_seen` (`last_seen`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_webauthn_credentials` (
  `ref` char(64) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `id` varchar(1024) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `transports` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `public_key` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sign_count` bigint unsigned NOT NULL,
  `backup_eligible` tinyint unsigned NOT NULL,
  `backed_up` tinyint unsigned NOT NULL,
  `webauthn_user` char(44) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime NOT NULL,
  `last_used` datetime DEFAULT NULL,
  `trashed_at` datetime DEFAULT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`ref`),
  KEY `webauthn_user__status` (`webauthn_user`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_itsec_webauthn_users` (
  `user_id` bigint unsigned NOT NULL,
  `webauthn_id` char(44) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=1558 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=114 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_rank_math_internal_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  `target_post_id` bigint unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_rank_math_internal_meta` (
  `object_id` bigint unsigned NOT NULL,
  `internal_link_count` int unsigned DEFAULT '0',
  `external_link_count` int unsigned DEFAULT '0',
  `incoming_link_count` int unsigned DEFAULT '0',
  PRIMARY KEY (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_smush_dir_images` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `path_hash` char(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `image_size` int unsigned DEFAULT NULL,
  `orig_size` int unsigned DEFAULT NULL,
  `file_time` int unsigned DEFAULT NULL,
  `last_scan` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15229 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfsecurityevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=2171 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wfwaffailures` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wpr_above_the_fold` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT '0',
  `lcp` longtext COLLATE utf8mb4_unicode_520_ci,
  `viewport` longtext COLLATE utf8mb4_unicode_520_ci,
  `error_message` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wpr_lazy_render_content` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT '0',
  `below_the_fold` longtext COLLATE utf8mb4_unicode_520_ci,
  `error_message` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wpr_rocket_cache` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wpr_rucss_used_css` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `css` longtext COLLATE utf8mb4_unicode_520_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `error_code` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error_message` longtext COLLATE utf8mb4_unicode_520_ci,
  `unprocessedcss` longtext COLLATE utf8mb4_unicode_520_ci,
  `retries` tinyint(1) NOT NULL DEFAULT '1',
  `is_mobile` tinyint(1) NOT NULL DEFAULT '0',
  `job_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `queue_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `next_retry_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wsal_metadata` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `occurrence_id` bigint NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `occurrence_name` (`occurrence_id`,`name`),
  KEY `name_value` (`name`,`value`(64))
) ENGINE=MyISAM AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ee3j5m0_wsal_occurrences` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `site_id` bigint NOT NULL,
  `alert_id` bigint NOT NULL,
  `created_on` double NOT NULL,
  `client_ip` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `severity` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `event_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_roles` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `site_alert_created` (`site_id`,`alert_id`,`created_on`),
  KEY `created_on` (`created_on`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `ee3j5m0_users` VALUES 
("1","OffCreaAdSite","$P$B2txORGQu8SXyL/RJ3EQLjf1vam9f01","offcreaadsite","info@creaweb.ma","http://192.168.100.112:8012/duplicator-creaweb","2022-03-24 10:40:23","","0","OffCreaAdSite"),
("2","mehdidev","$P$B8fiO2m8D8s3DbYBk1wXbpuemXAdRg.","mehdidev","mehdidev@creaweb.ma","","2022-03-24 11:01:31","","0","mehdidev"),
("3","abdeladim","$P$BoGnmicWcChbxMmvYUeROUnkVHM2lr/","abdeladim","abdeladim@creaweb.ma","","2022-03-24 11:01:53","","0","abdeladim"),
("4","mehdi","$P$BpRpFksXdHOn68kQUe9j00/S.lNFEk1","mehdi","mehdi@creaweb.ma","","2022-03-24 11:02:16","","0","mehdi");

INSERT IGNORE INTO `ee3j5m0_usermeta` VALUES 
("1","1","nickname","OffCreaAdSite"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","ee3j5m0_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","ee3j5m0_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","0"),
("17","1","ee3j5m0_dashboard_quick_press_last_post_id","4"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:13:\"192.168.100.0\";}"),
("19","1","itsec_user_activity_last_seen","1648118809"),
("20","1","_itsec_primary_dashboard","6"),
("21","2","nickname","mehdidev"),
("22","2","first_name",""),
("23","2","last_name",""),
("24","2","description",""),
("25","2","rich_editing","true"),
("26","2","syntax_highlighting","true"),
("27","2","comment_shortcuts","false"),
("28","2","admin_color","fresh"),
("29","2","use_ssl","0"),
("30","2","show_admin_bar_front","true"),
("31","2","locale","en_US"),
("32","2","ee3j5m0_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("33","2","ee3j5m0_user_level","10"),
("34","2","dismissed_wp_pointers",""),
("35","3","nickname","abdeladim"),
("36","3","first_name",""),
("37","3","last_name",""),
("38","3","description",""),
("39","3","rich_editing","true"),
("40","3","syntax_highlighting","true"),
("41","3","comment_shortcuts","false"),
("42","3","admin_color","fresh"),
("43","3","use_ssl","0"),
("44","3","show_admin_bar_front","true"),
("45","3","locale",""),
("46","3","ee3j5m0_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("47","3","ee3j5m0_user_level","10"),
("48","3","dismissed_wp_pointers",""),
("49","4","nickname","mehdi"),
("50","4","first_name",""),
("51","4","last_name",""),
("52","4","description",""),
("53","4","rich_editing","true"),
("54","4","syntax_highlighting","true"),
("55","4","comment_shortcuts","false"),
("56","4","admin_color","fresh"),
("57","4","use_ssl","0"),
("58","4","show_admin_bar_front","true"),
("59","4","locale",""),
("60","4","ee3j5m0_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("61","4","ee3j5m0_user_level","10"),
("62","4","dismissed_wp_pointers",""),
("77","1","duplicator_pro_created_format","1"),
("78","1","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:0:\"\";s:4:\"side\";s:0:\"\";s:7:\"column3\";s:22:\"itsec-dashboard-widget\";s:7:\"column4\";s:32:\"wordfence_activity_report_widget\";}"),
("79","1","itsec_user_activity_last_seen_notification_sent","1"),
("80","2","itsec-password-strength","4"),
("81","2","_itsec_password_requirements","a:1:{s:16:\"evaluation_times\";a:1:{s:8:\"strength\";i:1730464728;}}"),
("84","2","_itsec_has_logged_in","1730464728"),
("85","2","wfls-last-login","1730466207"),
("86","2","ame_rui_first_login_done","1"),
("87","2","itsec_user_activity_last_seen","1730468336"),
("88","2","_itsec_primary_dashboard","23"),
("89","2","session_tokens","a:1:{s:64:\"35b8d40f4a3eae58f8fa861c0f811640284d9507bed508f4f642dd3159ab8761\";a:4:{s:10:\"expiration\";i:1730639007;s:2:\"ip\";s:15:\"192.168.100.112\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:132.0) Gecko/20100101 Firefox/132.0\";s:5:\"login\";i:1730466207;}}"),
("90","2","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("91","2","manageedit-postcolumnshidden_default","1"),
("92","2","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("93","2","manageedit-pagecolumnshidden_default","1"),
("94","2","rocket_boxes","a:1:{i:1;s:34:\"rocket_warning_plugin_modification\";}");

INSERT IGNORE INTO `ee3j5m0_actionscheduler_actions` VALUES 
("16","action_scheduler/migration_hook","complete","2024-11-01 12:40:57","2024-11-01 12:40:57","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730464857;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730464857;}","1","1","2024-11-01 12:41:03","2024-11-01 12:41:03","0",NULL),
("17","action_scheduler/migration_hook","failed","2024-11-01 12:42:03","2024-11-01 12:42:03","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730464923;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730464923;}","1","1","2024-11-01 12:42:21","2024-11-01 12:42:21","0",NULL),
("18","action_scheduler/migration_hook","complete","2024-11-01 12:46:36","2024-11-01 12:46:36","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730465196;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730465196;}","1","1","2024-11-01 12:47:19","2024-11-01 12:47:19","0",NULL),
("19","action_scheduler/migration_hook","complete","2024-11-01 12:57:23","2024-11-01 12:57:23","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730465843;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730465843;}","1","1","2024-11-01 12:57:49","2024-11-01 12:57:49","0",NULL),
("20","action_scheduler/migration_hook","complete","2024-11-01 13:14:03","2024-11-01 13:14:03","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730466843;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730466843;}","1","1","2024-11-01 13:14:05","2024-11-01 13:14:05","0",NULL),
("21","action_scheduler/migration_hook","complete","2024-11-01 13:21:17","2024-11-01 13:21:17","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730467277;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730467277;}","1","1","2024-11-01 13:21:32","2024-11-01 13:21:32","0",NULL),
("22","rocket_preload_job_load_initial_sitemap","complete","2024-11-01 13:22:59","2024-11-01 13:22:59","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","2","1","2024-11-01 13:23:08","2024-11-01 13:23:08","0",NULL),
("23","rocket_job_warmup","complete","2024-11-01 13:23:02","2024-11-01 13:23:02","10","[]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-11-01 13:23:10","2024-11-01 13:23:10","0",NULL),
("24","rocket_preload_job_preload_url","complete","2024-11-01 13:23:05","2024-11-01 13:23:05","10","[\"http:\\/\\/192.168.100.112:8012\\/duplicator-creaweb\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","2","1","2024-11-01 13:23:10","2024-11-01 13:23:10","0",NULL),
("25","action_scheduler/migration_hook","complete","2024-11-01 13:25:06","2024-11-01 13:25:06","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730467506;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730467506;}","1","1","2024-11-01 13:25:07","2024-11-01 13:25:07","0",NULL),
("26","action_scheduler/migration_hook","complete","2024-11-01 13:27:50","2024-11-01 13:27:50","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730467670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730467670;}","1","1","2024-11-01 13:27:55","2024-11-01 13:27:55","0",NULL),
("27","action_scheduler/migration_hook","complete","2024-11-01 13:40:29","2024-11-01 13:40:29","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1730468429;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1730468429;}","1","1","2024-11-01 13:40:57","2024-11-01 13:40:57","0",NULL),
("28","easy_wp_smtp_admin_notifications_update","complete","2024-11-01 14:07:00","2024-11-01 14:07:00","10","[1]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730470020;s:18:\"\0*\0first_timestamp\";i:1730470020;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730470020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","1","2024-11-01 14:07:03","2024-11-01 14:07:03","0",NULL),
("29","easy_wp_smtp_admin_notifications_update","pending","2024-11-02 14:07:03","2024-11-02 14:07:03","10","[1]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730556423;s:18:\"\0*\0first_timestamp\";i:1730470020;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730556423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","4","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL);

INSERT IGNORE INTO `ee3j5m0_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2","rocket-preload"),
("3","rocket-performance-hints-warmup"),
("4","easy_wp_smtp");

INSERT IGNORE INTO `ee3j5m0_actionscheduler_logs` VALUES 
("1","16","action created","2024-11-01 12:39:57","2024-11-01 12:39:57"),
("2","16","action started via WP Cron","2024-11-01 12:41:03","2024-11-01 12:41:03"),
("3","16","action complete via WP Cron","2024-11-01 12:41:03","2024-11-01 12:41:03"),
("4","17","action created","2024-11-01 12:41:03","2024-11-01 12:41:03"),
("5","17","action started via Async Request","2024-11-01 12:42:21","2024-11-01 12:42:21"),
("6","17","action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-11-01 12:42:21","2024-11-01 12:42:21"),
("7","18","action created","2024-11-01 12:45:36","2024-11-01 12:45:36"),
("8","18","action started via WP Cron","2024-11-01 12:47:19","2024-11-01 12:47:19"),
("9","18","action complete via WP Cron","2024-11-01 12:47:19","2024-11-01 12:47:19"),
("10","19","action created","2024-11-01 12:56:23","2024-11-01 12:56:23"),
("11","19","action started via WP Cron","2024-11-01 12:57:49","2024-11-01 12:57:49"),
("12","19","action complete via WP Cron","2024-11-01 12:57:49","2024-11-01 12:57:49"),
("13","20","action created","2024-11-01 13:13:03","2024-11-01 13:13:03"),
("14","20","action started via WP Cron","2024-11-01 13:14:05","2024-11-01 13:14:05"),
("15","20","action complete via WP Cron","2024-11-01 13:14:05","2024-11-01 13:14:05"),
("16","21","action created","2024-11-01 13:20:17","2024-11-01 13:20:17"),
("17","21","action started via WP Cron","2024-11-01 13:21:32","2024-11-01 13:21:32"),
("18","21","action complete via WP Cron","2024-11-01 13:21:32","2024-11-01 13:21:32"),
("19","22","action created","2024-11-01 13:22:59","2024-11-01 13:22:59"),
("20","23","action created","2024-11-01 13:23:02","2024-11-01 13:23:02"),
("21","22","action started via WP Cron","2024-11-01 13:23:05","2024-11-01 13:23:05"),
("22","24","action created","2024-11-01 13:23:05","2024-11-01 13:23:05"),
("23","22","action complete via WP Cron","2024-11-01 13:23:08","2024-11-01 13:23:08"),
("24","23","action started via WP Cron","2024-11-01 13:23:08","2024-11-01 13:23:08"),
("25","23","action complete via WP Cron","2024-11-01 13:23:10","2024-11-01 13:23:10"),
("26","24","action started via WP Cron","2024-11-01 13:23:10","2024-11-01 13:23:10"),
("27","24","action complete via WP Cron","2024-11-01 13:23:10","2024-11-01 13:23:10"),
("28","25","action created","2024-11-01 13:24:06","2024-11-01 13:24:06"),
("29","25","action started via WP Cron","2024-11-01 13:25:07","2024-11-01 13:25:07"),
("30","25","action complete via WP Cron","2024-11-01 13:25:07","2024-11-01 13:25:07"),
("31","26","action created","2024-11-01 13:26:50","2024-11-01 13:26:50"),
("32","26","action started via WP Cron","2024-11-01 13:27:55","2024-11-01 13:27:55"),
("33","26","action complete via WP Cron","2024-11-01 13:27:55","2024-11-01 13:27:55"),
("34","27","action created","2024-11-01 13:39:29","2024-11-01 13:39:29"),
("35","27","action started via WP Cron","2024-11-01 13:40:57","2024-11-01 13:40:57"),
("36","27","action complete via WP Cron","2024-11-01 13:40:57","2024-11-01 13:40:57"),
("37","28","action created","2024-11-01 14:06:00","2024-11-01 14:06:00"),
("38","28","action started via WP Cron","2024-11-01 14:07:03","2024-11-01 14:07:03"),
("39","28","action complete via WP Cron","2024-11-01 14:07:03","2024-11-01 14:07:03"),
("40","29","action created","2024-11-01 14:07:03","2024-11-01 14:07:03");

INSERT IGNORE INTO `ee3j5m0_duplicator_backups` VALUES 
("4","20241101_creawebma","3d7eb369a13785a35526_20241101141246","20","2024-11-01 14:12:46","unknown","{\n    \"ID\": 4,\n    \"VersionWP\": \"6.6.2\",\n    \"VersionDB\": \"8.2.0\",\n    \"VersionPHP\": \"8.1.29\",\n    \"VersionOS\": \"WINNT\",\n    \"Name\": \"20241101_creawebma\",\n    \"Hash\": \"3d7eb369a13785a35526_20241101141246\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"http:\\/\\/192.168.100.112:8012\\/duplicator-creaweb\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20241101_creawebma_3d7eb369a13785a35526_20241101141246_scan.json\",\n    \"timer_start\": 1730470405.573624,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/.opcache\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/.tmb\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/ai1wm-backups\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/backups-dup-lite\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/backups-dup-pro\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/backupwordpress\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/bps-backup\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/cache\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/content\\/cache\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/contents\\/cache\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/infinitewp\\/backups\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/managewp\\/backups\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/old-cache\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/updraft\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/uploads\\/backup-guard\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/uploads\\/snapshots\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/uploads\\/sucuri\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/uploads\\/wp-clone\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/wfcache\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/wishlist-backup\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/wpvividbackups\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/.htaccess\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/.user.ini\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/php.ini\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/web.config\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-config.php\",\n            \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20241101_creawebma_3d7eb369a13785a35526_20241101141246_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"C:\\/wamp64\\/www\\/duplicator-creaweb\",\n        \"Size\": 234991380,\n        \"Dirs\": [],\n        \"DirCount\": 3033,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 15155,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20241101_creawebma_3d7eb369a13785a35526_20241101141246_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"QcBJYtT0pKnNP5Q1qzu\\/MY7Fiz8SkIkv2vMHqbt3Hg\\/Qflx0Dw5pqS+6WY3kx3nTj9Pfgyulx6HF3NwddQZOVg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_bin\",\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_0900_ai_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\",\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 1,\n            \"isNameUpperCase\": false,\n            \"name\": \"duplicator_creaweb\",\n            \"tablesBaseCount\": 71,\n            \"tablesFinalCount\": 71,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 1693,\n            \"tablesSizeOnDisk\": 2982091,\n            \"tablesList\": {\n                \"ee3j5m0_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 19480\n                },\n                \"ee3j5m0_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 3086\n                },\n                \"ee3j5m0_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 9328\n                },\n                \"ee3j5m0_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 0,\n                    \"size\": 5728\n                },\n                \"ee3j5m0_asenha_email_delivery\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_asenha_failed_logins\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ee3j5m0_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_duplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ee3j5m0_duplicator_entities\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 43076\n                },\n                \"ee3j5m0_easywpsmtp_debug_events\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ee3j5m0_easywpsmtp_tasks_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_itsec_bans\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ee3j5m0_itsec_dashboard_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ee3j5m0_itsec_dashboard_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_itsec_distributed_storage\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"ee3j5m0_itsec_fingerprints\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_itsec_firewall_rules\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ee3j5m0_itsec_geolocation_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_itsec_lockouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"ee3j5m0_itsec_logs\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 14204\n                },\n                \"ee3j5m0_itsec_mutexes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 5156\n                },\n                \"ee3j5m0_itsec_opaque_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"ee3j5m0_itsec_temp\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"ee3j5m0_itsec_user_groups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 2408\n                },\n                \"ee3j5m0_itsec_vulnerabilities\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ee3j5m0_itsec_webauthn_credentials\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"ee3j5m0_itsec_webauthn_users\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_options\": {\n                    \"inaccurateRows\": \"306\",\n                    \"insertedRows\": 0,\n                    \"size\": 2045996\n                },\n                \"ee3j5m0_postmeta\": {\n                    \"inaccurateRows\": \"72\",\n                    \"insertedRows\": 0,\n                    \"size\": 22508\n                },\n                \"ee3j5m0_posts\": {\n                    \"inaccurateRows\": \"22\",\n                    \"insertedRows\": 0,\n                    \"size\": 16472\n                },\n                \"ee3j5m0_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_smush_dir_images\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_term_relationships\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 3093\n                },\n                \"ee3j5m0_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 4168\n                },\n                \"ee3j5m0_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ee3j5m0_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 13396\n                },\n                \"ee3j5m0_usermeta\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 0,\n                    \"size\": 19552\n                },\n                \"ee3j5m0_users\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 8784\n                },\n                \"ee3j5m0_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_wfconfig\": {\n                    \"inaccurateRows\": \"273\",\n                    \"insertedRows\": 0,\n                    \"size\": 443852\n                },\n                \"ee3j5m0_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"ee3j5m0_wffilemods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_wfhits\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 5988\n                },\n                \"ee3j5m0_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 15456\n                },\n                \"ee3j5m0_wfknownfilelist\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_wflocs\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 2112\n                },\n                \"ee3j5m0_wflogins\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 4516\n                },\n                \"ee3j5m0_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ee3j5m0_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"ee3j5m0_wfls_settings\": {\n                    \"inaccurateRows\": \"27\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ee3j5m0_wfnotifications\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 3144\n                },\n                \"ee3j5m0_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 2088\n                },\n                \"ee3j5m0_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_wfstatus\": {\n                    \"inaccurateRows\": \"708\",\n                    \"insertedRows\": 0,\n                    \"size\": 88584\n                },\n                \"ee3j5m0_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"ee3j5m0_wpr_above_the_fold\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ee3j5m0_wpr_lazy_render_content\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ee3j5m0_wpr_rocket_cache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 11360\n                },\n                \"ee3j5m0_wpr_rucss_used_css\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"ee3j5m0_wsal_metadata\": {\n                    \"inaccurateRows\": \"87\",\n                    \"insertedRows\": 0,\n                    \"size\": 17504\n                },\n                \"ee3j5m0_wsal_occurrences\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 7692\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.2.0\",\n            \"versionComment\": \"MySQL Community Server - GPL\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20241101_creawebma_3d7eb369a13785a35526_20241101141246_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MySQL Community Server - GPL\",\n        \"dbStorePathPublic\": \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/wp-content\\/backups-dup-pro\\/tmp\\/20241101_creawebma_3d7eb369a13785a35526_20241101141246_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 20,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1730470408,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"ee3j5m0_users\",\n            \"ee3j5m0_usermeta\",\n            \"ee3j5m0_actionscheduler_actions\",\n            \"ee3j5m0_actionscheduler_claims\",\n            \"ee3j5m0_actionscheduler_groups\",\n            \"ee3j5m0_actionscheduler_logs\",\n            \"ee3j5m0_asenha_email_delivery\",\n            \"ee3j5m0_asenha_failed_logins\",\n            \"ee3j5m0_commentmeta\",\n            \"ee3j5m0_comments\",\n            \"ee3j5m0_duplicator_backups\",\n            \"ee3j5m0_duplicator_entities\",\n            \"ee3j5m0_easywpsmtp_debug_events\",\n            \"ee3j5m0_easywpsmtp_tasks_meta\",\n            \"ee3j5m0_itsec_bans\",\n            \"ee3j5m0_itsec_dashboard_events\",\n            \"ee3j5m0_itsec_dashboard_lockouts\",\n            \"ee3j5m0_itsec_distributed_storage\",\n            \"ee3j5m0_itsec_fingerprints\",\n            \"ee3j5m0_itsec_firewall_rules\",\n            \"ee3j5m0_itsec_geolocation_cache\",\n            \"ee3j5m0_itsec_lockouts\",\n            \"ee3j5m0_itsec_logs\",\n            \"ee3j5m0_itsec_mutexes\",\n            \"ee3j5m0_itsec_opaque_tokens\",\n            \"ee3j5m0_itsec_temp\",\n            \"ee3j5m0_itsec_user_groups\",\n            \"ee3j5m0_itsec_vulnerabilities\",\n            \"ee3j5m0_itsec_webauthn_credentials\",\n            \"ee3j5m0_itsec_webauthn_users\",\n            \"ee3j5m0_links\",\n            \"ee3j5m0_options\",\n            \"ee3j5m0_postmeta\",\n            \"ee3j5m0_posts\",\n            \"ee3j5m0_rank_math_internal_links\",\n            \"ee3j5m0_rank_math_internal_meta\",\n            \"ee3j5m0_smush_dir_images\",\n            \"ee3j5m0_term_relationships\",\n            \"ee3j5m0_term_taxonomy\",\n            \"ee3j5m0_termmeta\",\n            \"ee3j5m0_terms\",\n            \"ee3j5m0_wfblockediplog\",\n            \"ee3j5m0_wfblocks7\",\n            \"ee3j5m0_wfconfig\",\n            \"ee3j5m0_wfcrawlers\",\n            \"ee3j5m0_wffilechanges\",\n            \"ee3j5m0_wffilemods\",\n            \"ee3j5m0_wfhits\",\n            \"ee3j5m0_wfhoover\",\n            \"ee3j5m0_wfissues\",\n            \"ee3j5m0_wfknownfilelist\",\n            \"ee3j5m0_wflivetraffichuman\",\n            \"ee3j5m0_wflocs\",\n            \"ee3j5m0_wflogins\",\n            \"ee3j5m0_wfls_2fa_secrets\",\n            \"ee3j5m0_wfls_role_counts\",\n            \"ee3j5m0_wfls_settings\",\n            \"ee3j5m0_wfnotifications\",\n            \"ee3j5m0_wfpendingissues\",\n            \"ee3j5m0_wfreversecache\",\n            \"ee3j5m0_wfsecurityevents\",\n            \"ee3j5m0_wfsnipcache\",\n            \"ee3j5m0_wfstatus\",\n            \"ee3j5m0_wftrafficrates\",\n            \"ee3j5m0_wfwaffailures\",\n            \"ee3j5m0_wpr_above_the_fold\",\n            \"ee3j5m0_wpr_lazy_render_content\",\n            \"ee3j5m0_wpr_rocket_cache\",\n            \"ee3j5m0_wpr_rucss_used_css\",\n            \"ee3j5m0_wsal_metadata\",\n            \"ee3j5m0_wsal_occurrences\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1730470405.596354,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 1693,\n            \"tables\": {\n                \"ee3j5m0_users\": {\n                    \"start\": \"4\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_asenha_email_delivery\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_asenha_failed_logins\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_easywpsmtp_debug_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_easywpsmtp_tasks_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_bans\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_dashboard_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_dashboard_lockouts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_distributed_storage\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_fingerprints\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_firewall_rules\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_geolocation_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_lockouts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_mutexes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_opaque_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_temp\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_user_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_vulnerabilities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_webauthn_credentials\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_itsec_webauthn_users\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_rank_math_internal_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_rank_math_internal_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_smush_dir_images\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfblockediplog\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfblocks7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfconfig\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfcrawlers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wffilechanges\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wffilemods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfhits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfhoover\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfknownfilelist\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wflivetraffichuman\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wflocs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wflogins\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfls_2fa_secrets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfls_role_counts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfls_settings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfnotifications\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfpendingissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfreversecache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfsecurityevents\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfsnipcache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfstatus\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wftrafficrates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wfwaffailures\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wpr_above_the_fold\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wpr_lazy_render_content\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wpr_rocket_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wpr_rucss_used_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wsal_metadata\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ee3j5m0_wsal_occurrences\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 6,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.19.3\",\n    \"created\": \"2024-11-01 14:12:46\",\n    \"updated\": \"2024-11-01 14:13:28\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20241101_creawebma_3d7eb369a13785a35526_20241101141246_archive.zip","20","MANUAL,ZIP_ARCHIVE","4.5.19.3","2024-11-01 14:13:28");

INSERT IGNORE INTO `ee3j5m0_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"info@creaweb.ma\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": 0,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 524288,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": null,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 64,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 0,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"http:\\/\\/192.168.100.112:8012\\/duplicator-creaweb\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": null,\n    \"dropbox_transfer_mode\": null,\n    \"gdrive_upload_chunksize_in_kb\": null,\n    \"gdrive_transfer_mode\": null,\n    \"s3_upload_part_size_in_kb\": null,\n    \"onedrive_upload_chunksize_in_kb\": null,\n    \"local_upload_chunksize_in_MB\": null,\n    \"manual_mode_storage_ids\": [\n        6\n    ],\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"last_system_check_timestamp\": 1730464355,\n    \"initial_activation_timestamp\": 1648119062,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"id\": 1,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.19.3\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2024-11-01 14:12:46\"\n}","","","","","","4.5.19.3","0000-00-00 00:00:00","2024-11-01 14:12:46"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.19.3\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2024-11-01 12:48:17\"\n}","","","","","","4.5.19.3","0000-00-00 00:00:00","2024-11-01 12:48:17"),
("3","DUP_PRO_System_Global_Entity","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1730470404,\n    \"id\": 3,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.19.3\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2024-11-01 14:13:24\"\n}","","","","","","4.5.19.3","0000-00-00 00:00:00","2024-11-01 14:13:24"),
("4","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"ZhIDlW9yFNWnkWxsubjlkEmf5LhhVTNHS+7UHDaxieWMW2vRNNa4LrAVyI+Hv7BrovrMLEr7o8XhEfqXzpI6jw==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 4,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.19.3\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2024-11-01 12:48:17\"\n}","","","","","","4.5.19.3","0000-00-00 00:00:00","2024-11-01 12:48:17"),
("5","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"ySNfEkNBsDIks4sWOEynGj+K4baLwlZKC1MOmNqfibahS4R+Z537OOlRTSchtX9uCCG7jreEEzXR1VaOcxF7kg==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 5,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.19.3\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2024-11-01 14:12:46\"\n}","","","","","","4.5.19.3","0000-00-00 00:00:00","2024-11-01 14:12:46"),
("6","DUP_PRO_Storage_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"94hKtOf8cfVExhpAeBSMOIaAn9sIMrRJDUZC8gLESyBGkNISjm6N4N+uHQHjNexHictiW9ETXPzGvHj7PBsTrQK50TwG+t3ZiwTiwdsMyRWK8Jsi9+CZE67UJGRdOALdcNhdjAz\\/5xUYGyITGXmp3MjTYC2nhENl3nNowC8NG+1rq+rlMdDTYk+JErRwAYVQmK334GSsCWgzUA7rS3ja0PcQE5aEUB1GDtxqigus+Ai88nJJ4bC3AeSUCFoG54pIBv0N03fRU0e9iKuOlh2fhP81yK3Lsjy4\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 6,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.19.3\",\n    \"created\": \"2024-11-01 12:48:17\",\n    \"updated\": \"2024-11-01 12:48:17\"\n}","","","","","","4.5.19.3","2024-11-01 12:48:17","2024-11-01 12:48:17"),
("7","EmailSummary","{\n    \"manualPackageIds\": [\n        3\n    ],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [\n        6\n    ],\n    \"id\": 7,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.19.3\",\n    \"created\": \"2024-11-01 12:48:17\",\n    \"updated\": \"2024-11-01 14:09:50\"\n}","","","","","","4.5.19.3","2024-11-01 12:48:17","2024-11-01 14:09:50"),
("8","Dynamic_Entity","{\n    \"data\": {\n        \"dropbox_upload_chunksize_in_kb\": 2000,\n        \"dropbox_transfer_mode\": 1,\n        \"gdrive_upload_chunksize_in_kb\": 1024,\n        \"gdrive_transfer_mode\": 0,\n        \"s3_upload_part_size_in_kb\": 6000,\n        \"onedrive_upload_chunksize_in_kb\": 3200,\n        \"local_upload_chunksize_in_MB\": 16\n    },\n    \"id\": 8,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.19.3\",\n    \"created\": \"2024-11-01 12:48:17\",\n    \"updated\": \"2024-11-01 12:48:17\"\n}","","","","","","4.5.19.3","2024-11-01 12:48:17","2024-11-01 12:48:17"),
("9","LicenseDataEntity","{\n    \"licenseKey\": \"fUaJlC1nok3GSVukD6wcSgvQ1EZk49eLbYdryW\\/XwDjZ5rZ0kYwEfjSH8c8v5VsD9huVNb\\/4b4X5ugaNt\\/uscw==\",\n    \"status\": \"1p5HAfZQC6XwsyCPHoC5XC9vvpToP+VgcjEqEMuuj7vFNInZo3dylktER6SWCyDeHB4xoZy5vEOpd1ZXMKVfFEEf7bKpjVIy\",\n    \"type\": \"EKGNCQhjj8+AEcEOS67UUsHl76dLzAlTc5Ox6qAUp\\/vPB8iLw4IxVp4Rxtyjqj7wmF\\/P2n5MP+6CLwP4GjVdTpUTc94n+Vg7\",\n    \"data\": \"EW937uO1xQQYnPvifSBCkNY4S7egiHWyimjNKb7wNgSkE3ZJhHKkHTjvCBc1P6NiP0fFTaLxyxMF6KOeS30IRYaRN\\/PcubX2TRHLttT2SN9ezKMi6M3OLMmlJnp6uyamfYRiyzgp+X26Nyb6BVuV61Ug7CGInlhD491\\/04gUSMNCLZw4d77C\\/7maNri\\/O58N48wmyhvMqk8lDLDp5GDYHhmNsHKOFzHpGmq4MPrp22d3OS21qIQeNz9HxU2i8csTknEW12aM9gvohI0sWYTgaTvuq65zdEcaW1cT8mPTiLBvDq8pqzSXFWZfFiKuujg0YmuPE7p\\/oQD8BvzQ6CiYCoBOWQ+rrALnfpvAk7g96qrv+aVKwmGV+e3OcsNbxrryDl0V7ZBpYSPt+PoWQDo1GwBaj8qkqhTO+DxHvzfINkA=\",\n    \"lastRemoteUpdate\": \"\",\n    \"lastFailureTime\": \"\",\n    \"id\": 9,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.19.3\",\n    \"created\": \"2024-11-01 12:48:17\",\n    \"updated\": \"2024-11-01 14:13:28\"\n}","","","","","","4.5.19.3","2024-11-01 12:48:17","2024-11-01 14:13:28");

INSERT IGNORE INTO `ee3j5m0_easywpsmtp_debug_events` VALUES 
("1","Mailer: Autre SMTP\r\nSMTP Error: Could not authenticate.","{\"file\":\"C:\\\\wamp64\\\\www\\\\duplicator-creaweb\\\\wp-content\\\\plugins\\\\ithemes-security-pro\\\\core\\\\lib\\\\class-itsec-mail.php\",\"line\":896}","0","2024-11-01 13:11:51"),
("2","Mailer: Autre SMTP\r\nSMTP Error: Could not authenticate.","{\"file\":\"C:\\\\wamp64\\\\www\\\\duplicator-creaweb\\\\wp-content\\\\plugins\\\\ithemes-security-pro\\\\core\\\\lib\\\\class-itsec-mail.php\",\"line\":896}","0","2024-11-01 13:28:10"),
("3","Mailer: Autre SMTP\r\nSMTP Error: Could not authenticate.","{\"file\":\"C:\\\\wamp64\\\\www\\\\duplicator-creaweb\\\\wp-content\\\\plugins\\\\wordfence\\\\lib\\\\wfIssues.php\",\"line\":497}","0","2024-11-01 14:04:23");

INSERT IGNORE INTO `ee3j5m0_easywpsmtp_tasks_meta` VALUES 
("1","easy_wp_smtp_admin_notifications_update","W10=","2024-11-01 14:06:00");

INSERT IGNORE INTO `ee3j5m0_itsec_logs` VALUES 
("1","0","user_logging","plugin-activated::ithemes-security-pro/ithemes-security-pro.php,","b:0;","notice","2024-11-01 13:14:07","2024-11-01 13:14:06","85846480","86179976","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?action=activate&plugin=ithemes-security-pro%2Fithemes-security-pro.php&_wpnonce=9dac2386eb","1","2","192.168.100.112"),
("2","0","version_management","install::plugin,seo-by-rank-math-pro/rank-math-pro.php,3.0.74,manual","a:1:{s:7:\"context\";a:2:{s:4:\"type\";s:6:\"plugin\";s:6:\"action\";s:7:\"install\";}}","notice","2024-11-01 13:19:23","2024-11-01 13:19:20","88470824","88943904","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/update.php?action=upload-plugin","1","2","192.168.100.112"),
("3","0","version_management","install::plugin,seo-by-rank-math/rank-math.php,1.0.231,manual","a:1:{s:7:\"context\";a:2:{s:4:\"type\";s:6:\"plugin\";s:6:\"action\";s:7:\"install\";}}","notice","2024-11-01 13:19:33","2024-11-01 13:19:28","86048296","87275264","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?action=activate&plugin=seo-by-rank-math-pro%2Frank-math-pro.php&_wpnonce=d1b6c90a7c","1","2","192.168.100.112"),
("4","0","user_logging","plugin-activated::seo-by-rank-math/rank-math.php,","b:0;","notice","2024-11-01 13:19:39","2024-11-01 13:19:28","89215856","89464400","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?action=activate&plugin=seo-by-rank-math-pro%2Frank-math-pro.php&_wpnonce=d1b6c90a7c","1","2","192.168.100.112"),
("5","0","user_logging","plugin-activated::seo-by-rank-math-pro/rank-math-pro.php,","b:0;","notice","2024-11-01 13:19:39","2024-11-01 13:19:28","89229056","89472760","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?action=activate&plugin=seo-by-rank-math-pro%2Frank-math-pro.php&_wpnonce=d1b6c90a7c","1","2","192.168.100.112"),
("6","0","user_logging","plugin-deactivated::seo-by-rank-math-pro/rank-math-pro.php,","b:0;","notice","2024-11-01 13:20:16","2024-11-01 13:20:14","97963376","98247824","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?action=deactivate&plugin=seo-by-rank-math-pro%2Frank-math-pro.php&plugin_status=all&paged=1&s&_wpnonce=c7609a57f6","1","2","192.168.100.112"),
("7","0","user_logging","plugin-deactivated::seo-by-rank-math/rank-math.php,","b:0;","notice","2024-11-01 13:20:25","2024-11-01 13:20:23","94273528","94545008","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?action=deactivate&plugin=seo-by-rank-math%2Frank-math.php&plugin_status=all&paged=1&s&_wpnonce=a1a4d92b2c","1","2","192.168.100.112"),
("8","0","version_management","install::plugin,wp-rocket/wp-rocket.php,3.17.1,manual","a:1:{s:7:\"context\";a:2:{s:4:\"type\";s:6:\"plugin\";s:6:\"action\";s:7:\"install\";}}","notice","2024-11-01 13:22:35","2024-11-01 13:22:31","87842704","89691136","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/update.php?action=upload-plugin","1","2","192.168.100.112"),
("9","0","user_logging","plugin-activated::wp-rocket/wp-rocket.php,","b:0;","notice","2024-11-01 13:23:02","2024-11-01 13:22:56","88465824","88819312","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?action=activate&plugin=wp-rocket%2Fwp-rocket.php&_wpnonce=5d28f37fdf","1","2","192.168.100.112"),
("10","0","user_logging","plugin-deactivated::wp-rocket/wp-rocket.php,","b:0;","notice","2024-11-01 13:24:05","2024-11-01 13:24:03","95549824","95836792","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/admin-post.php?action=rocket_deactivation","1","2","192.168.100.112"),
("11","0","version_management","install::plugin,wp-smush-pro/wp-smush.php,3.16.8,manual","a:1:{s:7:\"context\";a:2:{s:4:\"type\";s:6:\"plugin\";s:6:\"action\";s:7:\"install\";}}","notice","2024-11-01 13:25:27","2024-11-01 13:25:24","87893312","88770936","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/update.php?action=upload-plugin","1","2","192.168.100.112"),
("12","0","user_logging","plugin-activated::wp-smush-pro/wp-smush.php,","b:0;","notice","2024-11-01 13:25:35","2024-11-01 13:25:33","89869136","90307176","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?action=activate&plugin=wp-smush-pro%2Fwp-smush.php&_wpnonce=80a0302428","1","2","192.168.100.112"),
("13","0","user_logging","plugin-deactivated::wp-smush-pro/wp-smush.php,","b:0;","notice","2024-11-01 13:26:49","2024-11-01 13:26:48","91138456","91405936","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?action=deactivate&plugin=wp-smush-pro%2Fwp-smush.php&plugin_status=all&paged=1&s&_wpnonce=75aca2cc6a","1","2","192.168.100.112"),
("14","0","site-scanner","scan","a:1:{s:7:\"site_id\";i:0;}","process-start","2024-11-01 13:28:07","2024-11-01 13:28:06","74284456","74425752","wp-cron","1","0","192.168.100.112"),
("15","0","site-scanner","register-site","a:1:{s:7:\"site_id\";i:1;}","process-start","2024-11-01 13:28:07","2024-11-01 13:28:06","74906120","74996920","wp-cron","1","0","192.168.100.112"),
("16","15","site-scanner","register-site","a:4:{s:5:\"route\";s:17:\"api/register-site\";s:6:\"method\";s:4:\"POST\";s:4:\"body\";a:3:{s:3:\"url\";s:46:\"http://192.168.100.112:8012/duplicator-creaweb\";s:7:\"keyPair\";a:2:{s:6:\"public\";s:64:\"atIWSEhAvcyFZ3BaD8KWDzKGVw6jRbcvSteDP13PkpchBXA8Tb218YtfjZLJhfFO\";s:6:\"secret\";s:172:\"MWE2NDQzYWY5MDI1NjNiZjU2YTBkNTJmNTY3OGY5MmJlNDQwNDFkMDlmZDg5Njg0MmNhZmEwOTUzNzUxZWNjYXwzNzZmZGU4ZjVkMGZhNDkxNGQzODU5MWIwZDA3NzU5MThkMzQ0MDg5MDQ5NTIwMTc3ODI4NDE2YTEyZTk4YjM3\";}s:12:\"verifyTarget\";s:99:\"http://192.168.100.112:8012/duplicator-creaweb/wp-json/ithemes-security/v1/site-scanner/verify-scan\";}s:7:\"headers\";a:2:{s:12:\"Content-Type\";s:16:\"application/json\";s:6:\"Accept\";s:42:\"application/vnd.site-scanner.ithemes;v=1.1\";}}","process-update","2024-11-01 13:28:07","2024-11-01 13:28:06","74918592","74996920","wp-cron","1","0","192.168.100.112"),
("17","15","site-scanner","register-site","O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:37:\"site_verification_failed.private_host\";a:1:{i:0;s:90:\"Unable to determine if the scan target is allowed: Scan target is not publicly accessible.\";}}s:10:\"error_data\";a:0:{}s:18:\"\0*\0additional_data\";a:0:{}}","process-stop","2024-11-01 13:28:07","2024-11-01 13:28:06","75392728","75518344","wp-cron","1","0","192.168.100.112"),
("18","14","site-scanner","scan","a:2:{s:7:\"results\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:37:\"site_verification_failed.private_host\";a:1:{i:0;s:90:\"Unable to determine if the scan target is allowed: Scan target is not publicly accessible.\";}}s:10:\"error_data\";a:1:{s:37:\"site_verification_failed.private_host\";a:1:{s:3:\"url\";s:46:\"http://192.168.100.112:8012/duplicator-creaweb\";}}s:18:\"\0*\0additional_data\";a:0:{}}s:6:\"cached\";b:0;}","process-stop","2024-11-01 13:28:07","2024-11-01 13:28:06","75377744","75518344","wp-cron","1","0","192.168.100.112"),
("19","0","site-scanner","scan-failure-client-error","a:2:{s:7:\"results\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:37:\"site_verification_failed.private_host\";a:1:{i:0;s:90:\"Unable to determine if the scan target is allowed: Scan target is not publicly accessible.\";}}s:10:\"error_data\";a:1:{s:37:\"site_verification_failed.private_host\";a:1:{s:3:\"url\";s:46:\"http://192.168.100.112:8012/duplicator-creaweb\";}}s:18:\"\0*\0additional_data\";a:0:{}}s:6:\"cached\";b:0;}","warning","2024-11-01 13:28:07","2024-11-01 13:28:06","75418832","75518344","wp-cron","1","0","192.168.100.112"),
("20","0","notification_center","send::malware-scheduling","a:2:{s:10:\"recipients\";a:5:{i:0;s:20:\"abdeladim@creaweb.ma\";i:1;s:22:\"abdeljaouad@creaweb.ma\";i:2;s:16:\"mehdi@creaweb.ma\";i:3;s:19:\"mehdidev@creaweb.ma\";i:4;s:15:\"info@creaweb.ma\";}s:7:\"subject\";s:77:\"[192.168.100.112/duplicator-creaweb] Scheduled site scan resulted in an error\";}","debug","2024-11-01 13:28:07","2024-11-01 13:28:06","75869088","75904880","wp-cron","1","0","192.168.100.112"),
("21","0","notification_center","send_failed::malware-scheduling","a:1:{s:5:\"error\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:14:\"wp_mail_failed\";a:1:{i:0;s:35:\"SMTP Error: Could not authenticate.\";}}s:10:\"error_data\";a:1:{s:14:\"wp_mail_failed\";a:6:{s:2:\"to\";a:5:{i:0;s:20:\"abdeladim@creaweb.ma\";i:1;s:22:\"abdeljaouad@creaweb.ma\";i:2;s:16:\"mehdi@creaweb.ma\";i:3;s:19:\"mehdidev@creaweb.ma\";i:4;s:15:\"info@creaweb.ma\";}s:7:\"subject\";s:77:\"[192.168.100.112/duplicator-creaweb] Scheduled site scan resulted in an error\";s:7:\"message\";s:35727:\"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" lang=\"fr-FR\">\n<head>\n	<meta charset=\"UTF-8\">\n	<meta content=\"width=device-width, initial-scale=1\" name=\"viewport\">\n	<meta name=\"x-apple-disable-message-reformatting\">\n	<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" charset=UTF-8>\n	<meta content=\"telephone=no\" name=\"format-detection\">\n	<title>Site Scan</title><!--[if (mso 16)]>\n	<style type=\"text/css\">\n		a {\n			text-decoration: none;\n		}\n	</style>\n	<![endif]--><!--[if gte mso 9]>\n	<style>sup {\n		font-size: 100% !important;\n	}</style><![endif]--><!--[if gte mso 9]>\n	<xml>\n		<o:OfficeDocumentSettings>\n			<o:AllowPNG></o:AllowPNG>\n			<o:PixelsPerInch>96</o:PixelsPerInch>\n		</o:OfficeDocumentSettings>\n	</xml>\n	<![endif]-->\n	<style type=\"text/css\">\n		#outlook a {\n			padding: 0;\n		}\n\n		.es-button {\n			mso-style-priority: 100 !important;\n			text-decoration: none !important;\n		}\n\n		a[x-apple-data-detectors] {\n			color: inherit !important;\n			text-decoration: none !important;\n			font-size: inherit !important;\n			font-family: inherit !important;\n			font-weight: inherit !important;\n			line-height: inherit !important;\n		}\n\n		.es-desk-hidden {\n			display: none;\n			float: left;\n			overflow: hidden;\n			width: 0;\n			max-height: 0;\n			line-height: 0;\n			mso-hide: all;\n		}\n\n		[data-ogsb] .es-button.es-button-1 {\n			padding: 20px 40px !important;\n		}\n\n		@media only screen and (max-width: 600px) {\n			p, ul li, ol li, a {\n				line-height: 150% !important\n			}\n\n			h1, h2, h3, h1 a, h2 a, h3 a {\n				line-height: 120% !important\n			}\n\n			h1 {\n				font-size: 36px !important;\n				text-align: left\n			}\n\n			h2 {\n				font-size: 26px !important;\n				text-align: left\n			}\n\n			h3 {\n				font-size: 20px !important;\n				text-align: left\n			}\n\n			.es-header-body h1 a, .es-content-body h1 a, .es-footer-body h1 a {\n				font-size: 36px !important;\n				text-align: left\n			}\n\n			.es-header-body h2 a, .es-content-body h2 a, .es-footer-body h2 a {\n				font-size: 26px !important;\n				text-align: left\n			}\n\n			.es-header-body h3 a, .es-content-body h3 a, .es-footer-body h3 a {\n				font-size: 20px !important;\n				text-align: left\n			}\n\n			.es-menu td a {\n				font-size: 12px !important\n			}\n\n			.es-header-body p, .es-header-body ul li, .es-header-body ol li, .es-header-body a {\n				font-size: 14px !important\n			}\n\n			.es-content-body p, .es-content-body ul li, .es-content-body ol li, .es-content-body a {\n				font-size: 14px !important\n			}\n\n			.es-footer-body p, .es-footer-body ul li, .es-footer-body ol li, .es-footer-body a {\n				font-size: 14px !important\n			}\n\n			.es-infoblock p, .es-infoblock ul li, .es-infoblock ol li, .es-infoblock a {\n				font-size: 12px !important\n			}\n\n			*[class=\"gmail-fix\"] {\n				display: none !important\n			}\n\n			.es-m-txt-c, .es-m-txt-c h1, .es-m-txt-c h2, .es-m-txt-c h3 {\n				text-align: center !important\n			}\n\n			.es-m-txt-r, .es-m-txt-r h1, .es-m-txt-r h2, .es-m-txt-r h3 {\n				text-align: right !important\n			}\n\n			.es-m-txt-l, .es-m-txt-l h1, .es-m-txt-l h2, .es-m-txt-l h3 {\n				text-align: left !important\n			}\n\n			.es-m-txt-r img, .es-m-txt-c img, .es-m-txt-l img {\n				display: inline !important\n			}\n\n			.es-button-border {\n				display: inline-block !important\n			}\n\n			a.es-button, button.es-button {\n				font-size: 20px !important;\n				display: inline-block !important\n			}\n\n			.es-adaptive table, .es-left, .es-right {\n				width: 100% !important\n			}\n\n			.es-content table, .es-header table, .es-footer table, .es-content, .es-footer, .es-header {\n				width: 100% !important;\n				max-width: 600px !important\n			}\n\n			.es-adapt-td {\n				display: block !important;\n				width: 100% !important\n			}\n\n			.adapt-img {\n				width: 100% !important;\n				height: auto !important\n			}\n\n			.es-m-p0 {\n				padding: 0 !important\n			}\n\n			.es-m-p0r {\n				padding-right: 0 !important\n			}\n\n			.es-m-p0l {\n				padding-left: 0 !important\n			}\n\n			.es-m-p0t {\n				padding-top: 0 !important\n			}\n\n			.es-m-p0b {\n				padding-bottom: 0 !important\n			}\n\n			.es-m-p20b {\n				padding-bottom: 20px !important\n			}\n\n			.es-mobile-hidden, .es-hidden {\n				display: none !important\n			}\n\n			tr.es-desk-hidden, td.es-desk-hidden, table.es-desk-hidden {\n				width: auto !important;\n				overflow: visible !important;\n				float: none !important;\n				max-height: inherit !important;\n				line-height: inherit !important\n			}\n\n			tr.es-desk-hidden {\n				display: table-row !important\n			}\n\n			table.es-desk-hidden {\n				display: table !important\n			}\n\n			td.es-desk-menu-hidden {\n				display: table-cell !important\n			}\n\n			.es-menu td {\n				width: 1% !important\n			}\n\n			table.es-table-not-adapt, .esd-block-html table {\n				width: auto !important\n			}\n\n			table.es-social {\n				display: inline-block !important\n			}\n\n			table.es-social td {\n				display: inline-block !important\n			}\n\n			.es-m-p5 {\n				padding: 5px !important\n			}\n\n			.es-m-p5t {\n				padding-top: 5px !important\n			}\n\n			.es-m-p5b {\n				padding-bottom: 5px !important\n			}\n\n			.es-m-p5r {\n				padding-right: 5px !important\n			}\n\n			.es-m-p5l {\n				padding-left: 5px !important\n			}\n\n			.es-m-p10 {\n				padding: 10px !important\n			}\n\n			.es-m-p10t {\n				padding-top: 10px !important\n			}\n\n			.es-m-p10b {\n				padding-bottom: 10px !important\n			}\n\n			.es-m-p10r {\n				padding-right: 10px !important\n			}\n\n			.es-m-p10l {\n				padding-left: 10px !important\n			}\n\n			.es-m-p15 {\n				padding: 15px !important\n			}\n\n			.es-m-p15t {\n				padding-top: 15px !important\n			}\n\n			.es-m-p15b {\n				padding-bottom: 15px !important\n			}\n\n			.es-m-p15r {\n				padding-right: 15px !important\n			}\n\n			.es-m-p15l {\n				padding-left: 15px !important\n			}\n\n			.es-m-p20 {\n				padding: 20px !important\n			}\n\n			.es-m-p20t {\n				padding-top: 20px !important\n			}\n\n			.es-m-p20r {\n				padding-right: 20px !important\n			}\n\n			.es-m-p20l {\n				padding-left: 20px !important\n			}\n\n			.es-m-p25 {\n				padding: 25px !important\n			}\n\n			.es-m-p25t {\n				padding-top: 25px !important\n			}\n\n			.es-m-p25b {\n				padding-bottom: 25px !important\n			}\n\n			.es-m-p25r {\n				padding-right: 25px !important\n			}\n\n			.es-m-p25l {\n				padding-left: 25px !important\n			}\n\n			.es-m-p30 {\n				padding: 30px !important\n			}\n\n			.es-m-p30t {\n				padding-top: 30px !important\n			}\n\n			.es-m-p30b {\n				padding-bottom: 30px !important\n			}\n\n			.es-m-p30r {\n				padding-right: 30px !important\n			}\n\n			.es-m-p30l {\n				padding-left: 30px !important\n			}\n\n			.es-m-p35 {\n				padding: 35px !important\n			}\n\n			.es-m-p35t {\n				padding-top: 35px !important\n			}\n\n			.es-m-p35b {\n				padding-bottom: 35px !important\n			}\n\n			.es-m-p35r {\n				padding-right: 35px !important\n			}\n\n			.es-m-p35l {\n				padding-left: 35px !important\n			}\n\n			.es-m-p40 {\n				padding: 40px !important\n			}\n\n			.es-m-p40t {\n				padding-top: 40px !important\n			}\n\n			.es-m-p40b {\n				padding-bottom: 40px !important\n			}\n\n			.es-m-p40r {\n				padding-right: 40px !important\n			}\n\n			.es-m-p40l {\n				padding-left: 40px !important\n			}\n\n			.es-desk-hidden {\n				display: table-row !important;\n				width: auto !important;\n				overflow: visible !important;\n				max-height: inherit !important\n			}\n		}\n	</style>\n</head>\n<meta charset=\"UTF-8\">\n<meta content=\"width=device-width, initial-scale=1\" name=\"viewport\">\n<meta name=\"x-apple-disable-message-reformatting\">\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" ; charset=UTF-8>\n<meta content=\"telephone=no\" name=\"format-detection\">\n<title>Site Scan</title><!--[if (mso 16)]>\n<style type=\"text/css\">\n	a {\n		text-decoration: none;\n	}\n</style>\n<![endif]--><!--[if gte mso 9]>\n<style>sup {\n	font-size: 100% !important;\n}</style><![endif]--><!--[if gte mso 9]>\n<xml>\n	<o:OfficeDocumentSettings>\n		<o:AllowPNG></o:AllowPNG>\n		<o:PixelsPerInch>96</o:PixelsPerInch>\n	</o:OfficeDocumentSettings>\n</xml>\n<![endif]-->\n<style type=\"text/css\">\n	#outlook a {\n		padding: 0;\n	}\n\n	.es-button {\n		mso-style-priority: 100 !important;\n		text-decoration: none !important;\n	}\n\n	a[x-apple-data-detectors] {\n		color: inherit !important;\n		text-decoration: none !important;\n		font-size: inherit !important;\n		font-family: inherit !important;\n		font-weight: inherit !important;\n		line-height: inherit !important;\n	}\n\n	.es-desk-hidden {\n		display: none;\n		float: left;\n		overflow: hidden;\n		width: 0;\n		max-height: 0;\n		line-height: 0;\n		mso-hide: all;\n	}\n\n	@media only screen and (max-width: 600px) {\n		p, ul li, ol li, a {\n			line-height: 150% !important\n		}\n\n		h1, h2, h3, h1 a, h2 a, h3 a {\n			line-height: 120% !important\n		}\n\n		h1 {\n			font-size: 36px !important;\n			text-align: left\n		}\n\n		h2 {\n			font-size: 26px !important;\n			text-align: left\n		}\n\n		h3 {\n			font-size: 20px !important;\n			text-align: left\n		}\n\n		.es-header-body h1 a, .es-content-body h1 a, .es-footer-body h1 a {\n			font-size: 36px !important;\n			text-align: left\n		}\n\n		.es-header-body h2 a, .es-content-body h2 a, .es-footer-body h2 a {\n			font-size: 26px !important;\n			text-align: left\n		}\n\n		.es-header-body h3 a, .es-content-body h3 a, .es-footer-body h3 a {\n			font-size: 20px !important;\n			text-align: left\n		}\n\n		.es-menu td a {\n			font-size: 12px !important\n		}\n\n		.es-header-body p, .es-header-body ul li, .es-header-body ol li, .es-header-body a {\n			font-size: 14px !important\n		}\n\n		.es-content-body p, .es-content-body ul li, .es-content-body ol li, .es-content-body a {\n			font-size: 14px !important\n		}\n\n		.es-footer-body p, .es-footer-body ul li, .es-footer-body ol li, .es-footer-body a {\n			font-size: 14px !important\n		}\n\n		.es-infoblock p, .es-infoblock ul li, .es-infoblock ol li, .es-infoblock a {\n			font-size: 12px !important\n		}\n\n		*[class=\"gmail-fix\"] {\n			display: none !important\n		}\n\n		.es-m-txt-c, .es-m-txt-c h1, .es-m-txt-c h2, .es-m-txt-c h3 {\n			text-align: center !important\n		}\n\n		.es-m-txt-r, .es-m-txt-r h1, .es-m-txt-r h2, .es-m-txt-r h3 {\n			text-align: right !important\n		}\n\n		.es-m-txt-l, .es-m-txt-l h1, .es-m-txt-l h2, .es-m-txt-l h3 {\n			text-align: left !important\n		}\n\n		.es-m-txt-r img, .es-m-txt-c img, .es-m-txt-l img {\n			display: inline !important\n		}\n\n		.es-button-border {\n			display: inline-block !important\n		}\n\n		a.es-button, button.es-button {\n			font-size: 20px !important;\n			display: inline-block !important\n		}\n\n		.es-adaptive table, .es-left, .es-right {\n			width: 100% !important\n		}\n\n		.es-content table, .es-header table, .es-footer table, .es-content, .es-footer, .es-header {\n			width: 100% !important;\n			max-width: 600px !important\n		}\n\n		.es-adapt-td {\n			display: block !important;\n			width: 100% !important\n		}\n\n		.adapt-img {\n			width: 100% !important;\n			height: auto !important\n		}\n\n		.es-m-p0 {\n			padding: 0 !important\n		}\n\n		.es-m-p0r {\n			padding-right: 0 !important\n		}\n\n		.es-m-p0l {\n			padding-left: 0 !important\n		}\n\n		.es-m-p0t {\n			padding-top: 0 !important\n		}\n\n		.es-m-p0b {\n			padding-bottom: 0 !important\n		}\n\n		.es-m-p20b {\n			padding-bottom: 20px !important\n		}\n\n		.es-mobile-hidden, .es-hidden {\n			display: none !important\n		}\n\n		tr.es-desk-hidden, td.es-desk-hidden, table.es-desk-hidden {\n			width: auto !important;\n			overflow: visible !important;\n			float: none !important;\n			max-height: inherit !important;\n			line-height: inherit !important\n		}\n\n		tr.es-desk-hidden {\n			display: table-row !important\n		}\n\n		table.es-desk-hidden {\n			display: table !important\n		}\n\n		td.es-desk-menu-hidden {\n			display: table-cell !important\n		}\n\n		.es-menu td {\n			width: 1% !important\n		}\n\n		table.es-table-not-adapt, .esd-block-html table {\n			width: auto !important\n		}\n\n		table.es-social {\n			display: inline-block !important\n		}\n\n		table.es-social td {\n			display: inline-block !important\n		}\n\n		.es-m-p5 {\n			padding: 5px !important\n		}\n\n		.es-m-p5t {\n			padding-top: 5px !important\n		}\n\n		.es-m-p5b {\n			padding-bottom: 5px !important\n		}\n\n		.es-m-p5r {\n			padding-right: 5px !important\n		}\n\n		.es-m-p5l {\n			padding-left: 5px !important\n		}\n\n		.es-m-p10 {\n			padding: 10px !important\n		}\n\n		.es-m-p10t {\n			padding-top: 10px !important\n		}\n\n		.es-m-p10b {\n			padding-bottom: 10px !important\n		}\n\n		.es-m-p10r {\n			padding-right: 10px !important\n		}\n\n		.es-m-p10l {\n			padding-left: 10px !important\n		}\n\n		.es-m-p15 {\n			padding: 15px !important\n		}\n\n		.es-m-p15t {\n			padding-top: 15px !important\n		}\n\n		.es-m-p15b {\n			padding-bottom: 15px !important\n		}\n\n		.es-m-p15r {\n			padding-right: 15px !important\n		}\n\n		.es-m-p15l {\n			padding-left: 15px !important\n		}\n\n		.es-m-p20 {\n			padding: 20px !important\n		}\n\n		.es-m-p20t {\n			padding-top: 20px !important\n		}\n\n		.es-m-p20r {\n			padding-right: 20px !important\n		}\n\n		.es-m-p20l {\n			padding-left: 20px !important\n		}\n\n		.es-m-p25 {\n			padding: 25px !important\n		}\n\n		.es-m-p25t {\n			padding-top: 25px !important\n		}\n\n		.es-m-p25b {\n			padding-bottom: 25px !important\n		}\n\n		.es-m-p25r {\n			padding-right: 25px !important\n		}\n\n		.es-m-p25l {\n			padding-left: 25px !important\n		}\n\n		.es-m-p30 {\n			padding: 30px !important\n		}\n\n		.es-m-p30t {\n			padding-top: 30px !important\n		}\n\n		.es-m-p30b {\n			padding-bottom: 30px !important\n		}\n\n		.es-m-p30r {\n			padding-right: 30px !important\n		}\n\n		.es-m-p30l {\n			padding-left: 30px !important\n		}\n\n		.es-m-p35 {\n			padding: 35px !important\n		}\n\n		.es-m-p35t {\n			padding-top: 35px !important\n		}\n\n		.es-m-p35b {\n			padding-bottom: 35px !important\n		}\n\n		.es-m-p35r {\n			padding-right: 35px !important\n		}\n\n		.es-m-p35l {\n			padding-left: 35px !important\n		}\n\n		.es-m-p40 {\n			padding: 40px !important\n		}\n\n		.es-m-p40t {\n			padding-top: 40px !important\n		}\n\n		.es-m-p40b {\n			padding-bottom: 40px !important\n		}\n\n		.es-m-p40r {\n			padding-right: 40px !important\n		}\n\n		.es-m-p40l {\n			padding-left: 40px !important\n		}\n\n		.es-desk-hidden {\n			display: table-row !important;\n			width: auto !important;\n			overflow: visible !important;\n			max-height: inherit !important\n		}\n	}\n</style>\n</head>\n<body style=\"width:100%;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;padding:0;Margin:0\">\n<div class=\"es-wrapper-color\" style=\"background-color:#F6F7F7\"><!--[if gte mso 9]>\n	<v:background xmlns:v=\"urn:schemas-microsoft-com:vml\" fill=\"t\">\n		<v:fill type=\"tile\" color=\"#F6F7F7\"></v:fill>\n	</v:background>\n	<![endif]-->\n	<table class=\"es-wrapper\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"\n		   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;padding:0;Margin:0;width:100%;height:100%;background-repeat:repeat;background-position:center top;background-color:#F6F7F7\">\n		<tr>\n			<td valign=\"top\" style=\"padding:0;Margin:0\">\n				<table cellpadding=\"0\" cellspacing=\"0\" class=\"es-content\" align=\"center\"\n					   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%\">\n					<tr>\n						<td align=\"center\" bgcolor=\"#E9E7EE\" style=\"padding:0;Margin:0;background-color:#e9e7ee\">\n							<table class=\"es-content-body\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\"\n								   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:transparent;\" bgcolor=\"#FFFFFF\">\n								<tr>\n									<td align=\"left\" style=\"padding:0;Margin:0;padding-left:20px;padding-right:20px\">\n										<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n											<tr>\n												<td align=\"center\" valign=\"top\" style=\"padding:0;Margin:0;width:560px\">\n													<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\"\n														   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n														<tr>\n															<td align=\"left\" class=\"es-infoblock\" style=\"padding:10px;Margin:0;line-height:14px;font-size:12px;color:#CCCCCC\"><p\n																	style=\"Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;line-height:14px;color:#232323;font-size:12px;text-align:center\">\n																Site Scan for <b>novembre 1, 2024</b></p></td>\n														</tr>\n													</table>\n												</td>\n											</tr>\n										</table>\n									</td>\n								</tr>\n							</table>\n						</td>\n					</tr>\n				</table>\n				<table cellpadding=\"0\" cellspacing=\"0\" class=\"es-header\" align=\"center\"\n					   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%;background-color:transparent;background-repeat:repeat;background-position:center top\">\n					<tr>\n						<td align=\"center\" style=\"padding:0;Margin:0\">\n							<table bgcolor=\"#ffffff\" class=\"es-header-body\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\"\n								   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:transparent;\">\n								<tr>\n									<td align=\"left\" style=\"Margin:0;padding-top:10px;padding-bottom:10px;padding-left:20px;padding-right:20px\">\n										<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n											<tr>\n												<td class=\"es-m-p0r\" valign=\"top\" align=\"center\" style=\"padding:0;Margin:0;width:560px\">\n													<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\"\n														   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n														<tr>\n															<td align=\"center\" style=\"padding:0;Margin:0;padding-top:30px;padding-bottom:30px;font-size:0px\"><img src=\"http://192.168.100.112:8012/duplicator-creaweb/wp-content/plugins/ithemes-security-pro/core/img/mail/solid_security_pro_logo.png\" alt=\"Logo\"\n																																								  style=\"display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic;font-size:12px;width:100%;max-width:312px;\"\n																																								  width=\"312\" title=\"Logo\">\n															</td>\n														</tr>\n													</table>\n												</td>\n											</tr>\n										</table>\n									</td>\n								</tr>\n							</table>\n						</td>\n					</tr>\n				</table>\n				<table cellpadding=\"0\" cellspacing=\"0\" class=\"es-content\" align=\"center\"\n					   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%\">\n					<tr>\n						<td align=\"center\" style=\"padding:0;Margin:0\">\n							<table bgcolor=\"#ffffff\" class=\"es-content-body\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\"\n								   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#FFFFFF;\">\n								<tr>\n									<td align=\"left\" style=\"padding:0;Margin:0;padding-bottom:40px;padding-left:40px;padding-right:40px\">\n										<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n											<tr>\n												<td align=\"center\" valign=\"top\" style=\"padding:0;Margin:0;width:520px\">\n													<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\"\n														   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n														<tr>\n															<td align=\"center\" class=\"es-m-txt-c\" style=\"padding:0;Margin:0;padding-bottom:5px;padding-top:20px\"><h1\n																	style=\"Margin:0;line-height:29px;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;font-size:24px;font-style:normal;font-weight:bold;color:#333333;text-align:left\">\n																Site Scan</h1></td>\n														</tr>\n													</table>\n												</td>\n											</tr>\n										</table>\n									</td>\n								</tr>\n							</table>\n						</td>\n					</tr>\n				</table>\n				<table cellpadding=\"0\" cellspacing=\"0\" class=\"es-content\" align=\"center\"\n					   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%\">\n					<tr>\n						<td align=\"center\" style=\"padding:0;Margin:0\">\n							<table bgcolor=\"#ffffff\" class=\"es-content-body\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\"\n								   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#ffffff;\">\n<tr>\n	<td align=\"left\" style=\"padding:0;Margin:0;padding-bottom:10px;padding-left:40px;padding-right:40px\">\n		<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"padding:0;Margin:0;width:520px\">\n					<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n						<tr>\n							<td align=\"left\" style=\"padding:0;Margin:0;\"><h4 style=\"Margin:0;line-height:24px;mso-line-height-rule:exactly;font-family:arial, \'helvetica neue\', helvetica, sans-serif;font-size:20px\"></h4></td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr><tr>\n	<td align=\"left\" style=\"padding:0;Margin:0;padding-bottom:40px;padding-left:40px;padding-right:40px\">\n		<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"padding:0;Margin:0;width:520px\">\n					<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\"\n						   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n						<tr>\n							<td align=\"left\" style=\"padding:0;Margin:0\">\n								<ul style=\"font-size: 15px; line-height: 1.2; text-align: left; margin: 20px 0 20px 20px; padding: 0;\">\n									<li style=\"margin: 0; padding: 5px 10px;font-weight: bold;\">An error occurred while running the scheduled site scan on CREAWEB.MA:</li><li style=\"margin: 0; padding: 5px 10px;\">Error Message: Unable to determine if the scan target is allowed: Scan target is not publicly accessible.</li><li style=\"margin: 0; padding: 5px 10px;\">Error Code: <code>site_verification_failed.private_host</code></li>\n								</ul>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr><tr>\n	<td align=\"left\" style=\"padding:0;Margin:0;padding-left:20px;padding-right:20px;padding-bottom:40px\">\n		<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"padding:0;Margin:0;width:560px\">\n					<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\"\n						   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n						<tr>\n							<td align=\"center\" class=\"es-m-txt-c\" style=\"padding:0;Margin:0\"><!--[if mso]><a href=\"http://192.168.100.112:8012/duplicator-creaweb/wp-admin/admin.php?page=itsec-logs&filters%5B0%5D=id%7C19\" target=\"_blank\" hidden>\n								<v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" esdevVmlButton href=\"http://192.168.100.112:8012/duplicator-creaweb/wp-admin/admin.php?page=itsec-logs&filters%5B0%5D=id%7C19\"\n											 style=\"height:35px; v-text-anchor:middle; width:111px\" arcsize=\"6%\" stroke=\"f\" fillcolor=\"#232323\">\n									<w:anchorlock></w:anchorlock>\n									<center style=\'color:#FFFFFF; font-family:helvetica, \"helvetica neue\", arial, verdana, sans-serif; font-size:12px; font-weight:400; line-height:12px;  mso-text-raise:1px\'>\n										View Report\n									</center>\n								</v:roundrect>\n							</a>\n								<![endif]--><!--[if !mso]><!-- --><span class=\"msohide es-button-border\"\n																		style=\"border-style:solid;border-color:#232323;background:#232323;border-width:0px;display:inline-block;border-radius:2px;width:auto;mso-hide:all\"><a\n										href=\"http://192.168.100.112:8012/duplicator-creaweb/wp-admin/admin.php?page=itsec-logs&filters%5B0%5D=id%7C19\" class=\"es-button es-button-1690568108431\" target=\"_blank\"\n										style=\"mso-style-priority:100 !important;text-decoration:none;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;color:#FFFFFF;font-size:13px;padding:10px;display:inline-block;background:#232323;border-radius:2px;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;font-weight:normal;font-style:normal;line-height:16px;width:auto;text-align:center;mso-padding-alt:0;mso-border-alt:10px solid #232323\">View Report</a></span>\n								<!--<![endif]--></td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr><tr>\n	<td align=\"left\" style=\"padding:0;Margin:0;padding-bottom:20px;padding-left:40px;padding-right:40px\"><!--[if mso]>\n		<table style=\"width:520px\" cellpadding=\"0\" cellspacing=\"0\">\n			<tr>\n				<td style=\"width:250px\" valign=\"top\"><![endif]-->\n		<table cellpadding=\"0\" cellspacing=\"0\" class=\"es-left\" align=\"left\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left\">\n			<tr>\n				<td class=\"es-m-p20b\" align=\"left\" style=\"padding:0;Margin:0;width:250px\">\n					<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n						<tr>\n							<td align=\"left\" style=\"padding:0;Margin:0;padding-bottom:10px\"><p\n									style=\"Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;line-height:26px;color:#6817c5;font-size:17px\">\n								<strong>WordPress Security News</strong></p></td>\n						</tr>\n						<tr>\n							<td align=\"left\" style=\"padding:0;Margin:0\"><p\n									style=\"Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;line-height:21px;color:#545454;font-size:14px\">\n								Be the first to get the latest WordPress security news, tips, and updates on the <a style=\"color: #3C1596; text-decoration: underline;\" href=\"https://go.solidwp.com/security-blog-category?utm_source=email_footer&utm_medium=link&utm_campaign=itsecprocta\">SolidWP Blog</a>, including the <a style=\"color: #3C1596; text-decoration: underline;\" href=\"https://go.solidwp.com/footer-vuln-report?utm_source=email_footer&utm_medium=link&utm_campaign=itsecprocta\">Weekly WordPress Vulnerability Report.</a></p></td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n		<!--[if mso]></td>\n		<td style=\"width:20px\"></td>\n		<td style=\"width:250px\" valign=\"top\"><![endif]-->\n		<table cellpadding=\"0\" cellspacing=\"0\" class=\"es-right\" align=\"right\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right\">\n			<tr>\n				<td align=\"left\" style=\"padding:0;Margin:0;width:250px\">\n					<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n						<tr>\n							<td align=\"left\" style=\"padding:0;Margin:0;padding-bottom:10px\"><p\n									style=\"Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;line-height:26px;color:#6817c5;font-size:17px\">\n								<strong>Tutorials</strong></p></td>\n						</tr>\n						<tr>\n							<td align=\"left\" style=\"padding:0;Margin:0\"><p\n									style=\"Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;line-height:21px;color:#545454;font-size:14px\">\n								Vulnerable WordPress plugins and themes are the #1 reason WordPress sites get hacked. Either quickly update the vulnerable theme, plugin or WordPress version immediately to the newest version or immediately deactivate the plugin or theme until a fix is available.</p></td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n		<!--[if mso]></td></tr></table><![endif]--></td>\n</tr>\n<tr>\n	<td align=\"left\" style=\"padding:0;Margin:0;padding-bottom:40px;padding-left:40px;padding-right:40px\"><!--[if mso]>\n		<table style=\"width:520px\" cellpadding=\"0\" cellspacing=\"0\">\n			<tr>\n				<td style=\"width:246px\" valign=\"top\"><![endif]-->\n		<table cellpadding=\"0\" cellspacing=\"0\" class=\"es-left\" align=\"left\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left\">\n			<tr>\n				<td class=\"es-m-p20b\" align=\"left\" style=\"padding:0;Margin:0;width:246px\">\n					<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n						<tr>\n							<td align=\"left\" style=\"padding:0;Margin:0;padding-bottom:10px\"><p\n									style=\"Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;line-height:26px;color:#6817c5;font-size:17px\">\n								<strong>Documentation</strong></p></td>\n						</tr>\n						<tr>\n							<td align=\"left\" style=\"padding:0;Margin:0\"><p\n									style=\"Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;line-height:21px;color:#545454;font-size:14px\">\n								Read Solid Security documentation and Frequently Asked Questions on the <a style=\"color: #3C1596; text-decoration: underline;\" href=\"https://go.solidwp.com/security-footer-tutorials-category?utm_source=email_footer&utm_medium=link&utm_campaign=itsecprocta\">SolidWP Help Center.</a></p></td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n		<!--[if mso]></td>\n		<td style=\"width:20px\"></td>\n		<td style=\"width:254px\" valign=\"top\"><![endif]-->\n		<table cellpadding=\"0\" cellspacing=\"0\" class=\"es-right\" align=\"right\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right\">\n			<tr>\n				<td align=\"left\" style=\"padding:0;Margin:0;width:254px\">\n					<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n						<tr>\n							<td align=\"left\" style=\"padding:0;Margin:0;padding-bottom:10px\"><p\n									style=\"Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;line-height:26px;color:#6817c5;font-size:17px\">\n								<strong>Support&nbsp; &nbsp; </strong><sup\n									style=\"font-size:12px;line-height:0;vertical-align:0.4em;color:#1f1f1f;border:1px solid #1F1F1F;padding:7px 14px;border-radius:100px\">Pro Feature</sup></p></td>\n						</tr>\n						<tr>\n							<td align=\"left\" style=\"padding:0;Margin:0\"><p\n									style=\"Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;line-height:21px;color:#545454;font-size:14px\">\n								Pro customers have the best support team available as their security team. Contact the <a style=\"color: #3C1596; text-decoration: underline;\" href=\"https://go.solidwp.com/footer-helpdesk?utm_source=email_footer&utm_medium=link&utm_campaign=itsecprocta\"> SolidWP Help Desk</a> for help when you need answers.</p></td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n		<!--[if mso]></td></tr></table><![endif]--></td>\n</tr>\n<tr>\n	<td class=\"es-m-p0\" align=\"left\" style=\"padding:0;Margin:0;padding-bottom:30px;padding-left:40px;padding-right:40px\">\n		<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"padding:0;Margin:0;width:520px\">\n					<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n						<tr>\n							<td align=\"left\" bgcolor=\"#F6F7F7\" style=\"padding:20px;Margin:0\"><p\n									style=\"Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;line-height:26px;color:#6817c5;font-size:17px\">\n								<strong>Check Out Our Free WordPress Security Guide</strong></p></td>\n						</tr>\n						<tr>\n							<td align=\"left\" bgcolor=\"#F6F7F7\" style=\"padding:0;Margin:0;padding-bottom:20px;padding-left:20px;padding-right:20px\"><p\n									style=\"Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;line-height:24px;color:#333333;font-size:16px\">Learn simple WordPress security tips — including 3 kinds of security your site needs and 4 best security practices for keeping your WordPress site safe with our <a style=\"color: #3C1596; text-decoration: underline;\" href=\"https://go.solidwp.com/footer-security-pocket-guide?utm_source=email_footer&utm_medium=link&utm_campaign=itsecprocta\">free guide.</a></p></td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n</tr>\n</table>\n<table cellpadding=\"0\" cellspacing=\"0\" class=\"es-footer\" align=\"center\"\n	   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%;background-color:transparent;background-repeat:repeat;background-position:center top\">\n	<tr>\n		<td align=\"center\" style=\"padding:0;Margin:0\">\n			<table class=\"es-footer-body\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\"\n				   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:transparent;width:600px\">\n				<tr>\n					<td align=\"left\" style=\"padding:20px;Margin:0\">\n						<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n							<tr>\n								<td align=\"center\" valign=\"top\" style=\"padding:0;Margin:0;width:560px\">\n									<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\"\n										   style=\"mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px\">\n										<tr>\n											<td align=\"center\" class=\"es-infoblock\" style=\"padding:0;Margin:0;padding-top:40px;line-height:14px;font-size:12px;color:#CCCCCC\"><p\n													style=\"Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica, \'helvetica neue\', arial, verdana, sans-serif;line-height:14px;color:#545454;font-size:12px\">\n												This email was generated by the Solid Security plugin.<br>To unsubscribe from these updates, visit the <a href=\"http://192.168.100.112:8012/duplicator-creaweb/wp-admin/admin.php?page=itsec\" style=\"color: #32174D; text-decoration: underline;\">Settings page</a> in the Solid Security plugin menu.</p>\n											</td>\n										</tr>\n									</table>\n								</td>\n							</tr>\n						</table>\n					</td>\n				</tr>\n			</table>\n		</td>\n	</tr>\n</table>\n					</td>\n				</tr>\n			</table>\n		</div>\n	</body>\n</html>\n\";s:7:\"headers\";a:0:{}s:11:\"attachments\";a:0:{}s:24:\"phpmailer_exception_code\";i:0;}}s:18:\"\0*\0additional_data\";a:0:{}}}","error","2024-11-01 13:28:10","2024-11-01 13:28:06","77544144","77630352","wp-cron","1","0","192.168.100.112"),
("22","0","version_management","install::plugin,admin-site-enhancements-pro/admin-site-enhancements.php,7.4.8,manual","a:1:{s:7:\"context\";a:2:{s:4:\"type\";s:6:\"plugin\";s:6:\"action\";s:7:\"install\";}}","notice","2024-11-01 13:28:33","2024-11-01 13:28:28","88329752","89472232","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/update.php?action=upload-plugin","1","2","192.168.100.112"),
("23","0","user_logging","plugin-activated::admin-site-enhancements-pro/admin-site-enhancements.php,","b:0;","notice","2024-11-01 13:28:40","2024-11-01 13:28:36","91096544","92713008","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?action=activate&plugin=admin-site-enhancements-pro%2Fadmin-site-enhancements.php&_wpnonce=55214ba504","1","2","192.168.100.112"),
("24","0","version_management","install::plugin,contact-form-7/wp-contact-form-7.php,5.9.8,manual","a:1:{s:7:\"context\";a:2:{s:4:\"type\";s:6:\"plugin\";s:6:\"action\";s:7:\"install\";}}","notice","2024-11-01 13:29:57","2024-11-01 13:29:54","88772496","88850888","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/admin-ajax.php","1","2","192.168.100.112"),
("25","0","user_logging","post-status-changed::2,41,new,publish","a:4:{s:7:\"user_id\";i:2;s:7:\"post_id\";i:41;s:10:\"old_status\";s:3:\"new\";s:10:\"new_status\";s:7:\"publish\";}","notice","2024-11-01 13:30:10","2024-11-01 13:30:08","93738576","93836008","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?_wpnonce=10229e52c4&action=activate&plugin=contact-form-7%2Fwp-contact-form-7.php","1","2","192.168.100.112"),
("26","0","user_logging","plugin-activated::contact-form-7/wp-contact-form-7.php,","b:0;","notice","2024-11-01 13:30:10","2024-11-01 13:30:08","93736960","93836008","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?_wpnonce=10229e52c4&action=activate&plugin=contact-form-7%2Fwp-contact-form-7.php","1","2","192.168.100.112"),
("27","0","security-check-pro","start-scan","b:0;","process-start","2024-11-01 13:34:06","2024-11-01 13:34:06","13494328","14116616","wp-cron","1","0","192.168.100.112"),
("28","27","security-check-pro","start-scan","a:2:{s:6:\"status\";i:200;s:4:\"body\";a:3:{s:8:\"complete\";b:1;s:9:\"remote_ip\";b:0;s:13:\"ssl_supported\";b:0;}}","process-stop","2024-11-01 13:34:27","2024-11-01 13:34:06","22001440","27577432","wp-cron","1","0","192.168.100.112"),
("29","0","user_logging","plugin-deactivated::admin-site-enhancements-pro/admin-site-enhancements.php,","b:0;","notice","2024-11-01 13:39:28","2024-11-01 13:39:27","17245672","17398392","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?action=deactivate&plugin=admin-site-enhancements-pro%2Fadmin-site-enhancements.php&plugin_status=all&paged=1&s&_wpnonce=3e41bdc240","1","2","192.168.100.112"),
("30","0","user_logging","plugin-activated::admin-site-enhancements-pro/admin-site-enhancements.php,","b:0;","notice","2024-11-01 13:39:51","2024-11-01 13:39:50","17363216","25711224","http://192.168.100.112:8012/duplicator-creaweb/wp-admin/plugins.php?action=activate&plugin=admin-site-enhancements-pro%2Fadmin-site-enhancements.php&plugin_status=all&paged=1&s&_wpnonce=55214ba504","1","2","192.168.100.112");

INSERT IGNORE INTO `ee3j5m0_itsec_opaque_tokens` VALUES 
("1a6443af902563bf56a0d52f5678f92be44041d09fd896842cafa0953751ecca","5314b6aecf00cec8c553c5745ea5a5d970b2b8813627ab534739091a9afc06f0","site-scanner-verify","{\"public\":\"atIWSEhAvcyFZ3BaD8KWDzKGVw6jRbcvSteDP13PkpchBXA8Tb218YtfjZLJhfFO\"}","2024-11-01 13:28:06");

INSERT IGNORE INTO `ee3j5m0_itsec_user_groups` VALUES 
("639052e2-58d3-4b63-85b1-b43bff806f52","Editors","","editor","","","2024-11-01 13:15:47"),
("781e6a4c-ab61-49fe-a874-902b1709bb03","Customers","administrator","","","","2024-11-01 13:15:47"),
("9445bfa7-57e8-4c92-b3aa-610b03d8c982","Authors","","author","","","2024-11-01 13:15:47"),
("a92c70e0-0bad-40be-8328-9c172fc7fc96","Contributors","","contributor","","","2024-11-01 13:15:47"),
("c3e96e91-a012-48ae-b50e-074b3075ed42","Administrators","","administrator","","","2024-11-01 13:15:47");

INSERT IGNORE INTO `ee3j5m0_options` VALUES 
("1","siteurl","http://192.168.100.112:8012/duplicator-creaweb","yes"),
("2","home","http://192.168.100.112:8012/duplicator-creaweb","yes"),
("3","blogname","CREAWEB.MA","yes"),
("4","blogdescription","","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","info@creaweb.ma","yes"),
("7","start_of_week","1","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","0","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","F j, Y","yes"),
("24","time_format","g:i a","yes"),
("25","links_updated_date_format","F j, Y g:i a","yes"),
("26","comment_moderation","0","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("29","rewrite_rules","a:119:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:41:\"itsec-dashboard/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"itsec-dashboard/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"itsec-dashboard/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"itsec-dashboard/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"itsec-dashboard/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"itsec-dashboard/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"itsec-dashboard/(.+?)/embed/?$\";s:48:\"index.php?itsec-dashboard=$matches[1]&embed=true\";s:34:\"itsec-dashboard/(.+?)/trackback/?$\";s:42:\"index.php?itsec-dashboard=$matches[1]&tb=1\";s:42:\"itsec-dashboard/(.+?)/page/?([0-9]{1,})/?$\";s:55:\"index.php?itsec-dashboard=$matches[1]&paged=$matches[2]\";s:49:\"itsec-dashboard/(.+?)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?itsec-dashboard=$matches[1]&cpage=$matches[2]\";s:38:\"itsec-dashboard/(.+?)(?:/([0-9]+))?/?$\";s:54:\"index.php?itsec-dashboard=$matches[1]&page=$matches[2]\";s:43:\"itsec-dash-card/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"itsec-dash-card/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"itsec-dash-card/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"itsec-dash-card/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"itsec-dash-card/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"itsec-dash-card/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"itsec-dash-card/([^/]+)/embed/?$\";s:48:\"index.php?itsec-dash-card=$matches[1]&embed=true\";s:36:\"itsec-dash-card/([^/]+)/trackback/?$\";s:42:\"index.php?itsec-dash-card=$matches[1]&tb=1\";s:44:\"itsec-dash-card/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?itsec-dash-card=$matches[1]&paged=$matches[2]\";s:51:\"itsec-dash-card/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?itsec-dash-card=$matches[1]&cpage=$matches[2]\";s:40:\"itsec-dash-card/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?itsec-dash-card=$matches[1]&page=$matches[2]\";s:32:\"itsec-dash-card/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"itsec-dash-card/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"itsec-dash-card/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"itsec-dash-card/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"itsec-dash-card/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"itsec-dash-card/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:10:{i:0;s:55:\"admin-site-enhancements-pro/admin-site-enhancements.php\";i:1;s:37:\"admin-menu-editor-pro/menu-editor.php\";i:2;s:43:\"ame-branding-add-on/ame-branding-add-on.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:33:\"duplicator-pro/duplicator-pro.php\";i:5;s:33:\"duplicator-pro/duplicator-pro.php\";i:6;s:29:\"easy-wp-smtp/easy-wp-smtp.php\";i:7;s:45:\"ithemes-security-pro/ithemes-security-pro.php\";i:8;s:23:\"wordfence/wordfence.php\";i:9;s:26:\"wp-toolbar-editor/load.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","http://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","0","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","","no"),
("40","template","twentytwentyfour","yes"),
("41","stylesheet","twentytwentyfour","yes"),
("42","comment_registration","0","yes"),
("43","html_type","text/html","yes"),
("44","use_trackback","0","yes"),
("45","default_role","subscriber","yes"),
("46","db_version","57155","yes"),
("47","uploads_use_yearmonth_folders","1","yes"),
("48","upload_path","","yes"),
("49","blog_public","0","yes"),
("50","default_link_category","2","yes"),
("51","show_on_front","posts","yes"),
("52","tag_base","","yes"),
("53","show_avatars","1","yes"),
("54","avatar_rating","G","yes"),
("55","upload_url_path","","yes"),
("56","thumbnail_size_w","150","yes"),
("57","thumbnail_size_h","150","yes"),
("58","thumbnail_crop","1","yes"),
("59","medium_size_w","300","yes"),
("60","medium_size_h","300","yes"),
("61","avatar_default","mystery","yes"),
("62","large_size_w","1024","yes"),
("63","large_size_h","1024","yes"),
("64","image_default_link_type","none","yes"),
("65","image_default_size","","yes"),
("66","image_default_align","","yes"),
("67","close_comments_for_old_posts","0","yes"),
("68","close_comments_days_old","14","yes"),
("69","thread_comments","1","yes"),
("70","thread_comments_depth","5","yes"),
("71","page_comments","0","yes"),
("72","comments_per_page","50","yes"),
("73","default_comments_page","newest","yes"),
("74","comment_order","asc","yes"),
("75","sticky_posts","a:0:{}","yes"),
("76","widget_categories","a:0:{}","yes"),
("77","widget_text","a:0:{}","yes"),
("78","widget_rss","a:0:{}","yes"),
("79","uninstall_plugins","a:4:{s:29:\"easy-wp-smtp/easy-wp-smtp.php\";s:17:\"swpsmtp_uninstall\";s:33:\"duplicator-pro/duplicator-pro.php\";a:2:{i:0;s:24:\"Duplicator\\Core\\Unistall\";i:1;s:8:\"unistall\";}s:47:\"wp-security-audit-log/wp-security-audit-log.php\";a:2:{i:0;s:29:\"WSAL\\Helpers\\Uninstall_Helper\";i:1;s:9:\"uninstall\";}s:45:\"ithemes-security-pro/ithemes-security-pro.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:16:\"handle_uninstall\";}}","no"),
("80","timezone_string","","yes"),
("81","page_for_posts","0","yes"),
("82","page_on_front","0","yes"),
("83","default_post_format","0","yes"),
("84","link_manager_enabled","0","yes"),
("85","finished_splitting_shared_terms","1","yes"),
("86","site_icon","0","yes"),
("87","medium_large_size_w","768","yes"),
("88","medium_large_size_h","0","yes"),
("89","wp_page_for_privacy_policy","3","yes"),
("90","show_comments_cookies_opt_in","1","yes"),
("91","admin_email_lifespan","1746018214","yes"),
("92","disallowed_keys","","no"),
("93","comment_previously_approved","1","yes"),
("94","auto_plugin_theme_update_emails","a:0:{}","no"),
("95","auto_update_core_dev","enabled","yes"),
("96","auto_update_core_minor","enabled","yes"),
("97","auto_update_core_major","enabled","yes"),
("98","wp_force_deactivated_plugins","a:0:{}","yes"),
("99","initial_db_version","51917","yes"),
("100","ee3j5m0_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:90:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;s:23:\"rank_math_edit_htaccess\";b:1;s:16:\"rank_math_titles\";b:1;s:17:\"rank_math_general\";b:1;s:17:\"rank_math_sitemap\";b:1;s:21:\"rank_math_404_monitor\";b:1;s:22:\"rank_math_link_builder\";b:1;s:22:\"rank_math_redirections\";b:1;s:22:\"rank_math_role_manager\";b:1;s:19:\"rank_math_analytics\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:25:\"rank_math_onpage_advanced\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:20:\"rank_math_content_ai\";b:1;s:19:\"rank_math_admin_bar\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:14:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes"),
("101","fresh_site","1","yes"),
("102","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","yes"),
("103","sidebars_widgets","a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}","yes"),
("104","cron","a:53:{i:1730470437;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1730470566;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"12ca8767a64eac20d01836398698c811\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:1:{i:0;s:11:\"flush-files\";}s:8:\"interval\";i:3600;}}}i:1730471996;a:1:{s:17:\"wsal_cleanup_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1730472005;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1730472010;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1730472024;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1730472293;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"bad9df8a7c3fa92d28999d03f4ccb29e\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:18;}}}}i:1730472459;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"45f91c1ee81280c48cfb715d2c9931b0\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:19;}}}}i:1730472667;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"c235acd81e1457babc4e93303796723c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:20;}}}}i:1730472718;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"c4b66550e50f6ae8347c6592ebc1a4d1\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:21;}}}}i:1730472769;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"26e9e6ff95b3d23cf3d0202a8d7dfd36\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:22;}}}}i:1730473888;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"b76accc01229b487518cb150a88235da\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:34;}}}}i:1730474027;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"3c2f09ef3307c7968f556ae704095acf\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:35;}}}}i:1730474362;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"1116d9ef00bc7112389bca5c44a23a14\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:36;}}}}i:1730474552;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"9ef847872aca0012b660ad0925fa2b67\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:37;}}}}i:1730474725;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"4810282cdc4e37bf548c8a4459f8e9ef\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:39;}}}}i:1730474910;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"b4267a67df0cfb11e30d6396f858b5c9\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:40;}}}}i:1730478599;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"604f3c77921d1836cbdac7799c386d9d\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1730478599;}}}}i:1730498889;a:1:{s:44:\"puc_cron_check_updates-admin-menu-editor-pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1730500824;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1730502577;a:1:{s:42:\"puc_cron_check_updates-ame-branding-add-on\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1730505600;a:2:{s:27:\"wsal_periodic_reports_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:22:\"wdev_logger_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1730507938;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1730509468;a:1:{s:40:\"puc_cron_check_updates-wp-toolbar-editor\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1730510886;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"52e238d4feebebdd3474a3fd6c58d2cf\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:1:{i:0;s:12:\"malware-scan\";}s:8:\"interval\";i:43200;}}}i:1730529846;a:1:{s:15:\"itsec_cron_test\";a:1:{s:32:\"1e89805226c93b894e8cd1b911d3d48d\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1730529846;}}}}i:1730544023;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1730544033;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1730544034;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1730551196;a:1:{s:25:\"wsal_reports_pruning_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1730551210;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1730553426;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"aa768a35ceed34e467f270ebdc5d82f4\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:14:\"purge-lockouts\";}s:8:\"interval\";i:86400;}}}i:1730553486;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"de1a6e58e1b94847566fa6a96efc8463\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:17:\"enable-encryption\";}s:8:\"interval\";i:86400;}}}i:1730553784;a:1:{s:32:\"rocket_performance_hints_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1730554266;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"abcdd2161b38ff88bddcea9ec08412b6\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:28:\"dashboard-consolidate-events\";}s:8:\"interval\";i:86400;}}}i:1730554446;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"223359ca4d47abc3b282b06c15294ad4\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:18:\"security-check-pro\";}s:8:\"interval\";i:86400;}}}i:1730554506;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"7a0fd5d064c59cf40c3df9ad0bb6e63d\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:11:\"clear-locks\";}s:8:\"interval\";i:86400;}}}i:1730554686;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"3ec3d6914daf50bcdb5e5b065213e29b\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:17:\"purge-log-entries\";}s:8:\"interval\";i:86400;}}}i:1730554866;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"986946c37854816225bfe2c9bac49d44\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:17:\"outdated-software\";}s:8:\"interval\";i:86400;}}}i:1730554926;a:1:{s:10:\"itsec_cron\";a:2:{s:32:\"91ed9e6ce3fd2e95cc140964d5c85e55\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:19:\"identify-server-ips\";}s:8:\"interval\";i:86400;}s:32:\"c0ae31dfe60fdb9da055aa838519db0f\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:12:\"clear-tokens\";}s:8:\"interval\";i:86400;}}}i:1730678400;a:1:{s:28:\"wsal_periodic_reports_weekly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1730681527;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1730728800;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1730736000;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1730737799;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"d8043745cda6bfacabd564b6bb3c0695\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1730737799;}}}}i:1730996999;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"d1aec113079d42d8f4f6a4baa4d78450\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1730996999;}}}}i:1731062423;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1731069513;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1731072184;a:1:{s:27:\"rocket_update_dynamic_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1731072784;a:1:{s:36:\"rocket_preload_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1733011200;a:1:{s:29:\"wsal_periodic_reports_monthly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2635200;}}}i:1740787200;a:1:{s:31:\"wsal_periodic_reports_quarterly\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"quarterly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:10540800;}}}s:7:\"version\";i:2;}","yes"),
("105","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("106","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("107","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("108","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("109","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("110","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("111","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("112","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("113","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("114","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("115","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("116","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("118","recovery_keys","a:0:{}","yes"),
("119","https_detection_errors","a:1:{s:20:\"https_request_failed\";a:1:{i:0;s:28:\"La demande HTTPS a échoué.\";}}","yes"),
("128","theme_mods_twentytwentytwo","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1730465686;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off"),
("151","WPLANG","fr_FR","yes"),
("152","new_admin_email","info@creaweb.ma","yes"),
("165","finished_updating_comment_type","1","yes"),
("176","recently_activated","a:4:{s:25:\"wp-smush-pro/wp-smush.php\";i:1730467609;s:30:\"seo-by-rank-math/rank-math.php\";i:1730467225;s:38:\"seo-by-rank-math-pro/rank-math-pro.php\";i:1730467216;s:47:\"wp-security-audit-log/wp-security-audit-log.php\";i:1730465135;}","yes"),
("183","swpsmtp_options","a:10:{s:16:\"from_email_field\";s:15:\"test@creaweb.ma\";s:15:\"from_name_field\";s:10:\"CREAWEB.MA\";s:23:\"force_from_name_replace\";b:0;s:8:\"sub_mode\";b:0;s:13:\"smtp_settings\";a:10:{s:4:\"host\";s:15:\"mail.creaweb.ma\";s:15:\"type_encryption\";s:3:\"ssl\";s:4:\"port\";s:3:\"465\";s:13:\"autentication\";s:3:\"yes\";s:8:\"username\";s:15:\"test@creaweb.ma\";s:8:\"password\";s:24:\"NDJUUzhTR0F4ckRGZmhlWQ==\";s:13:\"log_file_name\";s:33:\"logs\\.623c4bafb69738.52035204.txt\";s:12:\"enable_debug\";b:0;s:12:\"insecure_ssl\";b:0;s:12:\"encrypt_pass\";b:0;}s:15:\"allowed_domains\";s:20:\"MTkyLjE2OC4xMDAuMTE4\";s:14:\"reply_to_email\";s:0:\"\";s:9:\"bcc_email\";s:0:\"\";s:17:\"email_ignore_list\";s:0:\"\";s:19:\"enable_domain_check\";b:0;}","yes"),
("230","wordfence_ls_version","1.1.12","yes"),
("231","wfls_last_role_change","1730464795","off"),
("232","wordfence_version","7.11.7","yes"),
("233","wordfence_case","","yes"),
("234","wordfence_installed","1","yes"),
("235","wordfenceActivated","1","yes"),
("237","wf_plugin_act_error","","yes"),
("239","ws_menu_editor_pro","a:28:{s:22:\"hide_advanced_settings\";b:1;s:16:\"show_extra_icons\";b:0;s:11:\"custom_menu\";a:10:{s:4:\"tree\";a:17:{s:9:\"index.php\";a:33:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:10:\">index.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:19:\"index.php>index.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Accueil\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"index.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"index.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"index.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:25:\"index.php>update-core.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:93:\"Mises à jour <span class=\"update-plugins count-2\"><span class=\"update-count\">2</span></span>\";s:12:\"access_level\";s:11:\"update_core\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"update-core.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"index.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:15:\"update-core.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:15:\"Tableau de bord\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"index.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:43:\"menu-top menu-top-first menu-icon-dashboard\";s:8:\"hookname\";s:14:\"menu-dashboard\";s:8:\"icon_url\";s:19:\"dashicons-dashboard\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"index.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";s:4:\"read\";}s:13:\"wsal-auditlog\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:14:\">wsal-auditlog\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:10:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:27:\"wsal-auditlog>wsal-auditlog\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:4:{s:14:\"user:abdeladim\";b:0;s:16:\"user:abdeljaouad\";b:0;s:10:\"user:mehdi\";b:0;s:13:\"user:mehdidev\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:36:\"Visionneuse du journal d’activité\";s:10:\"menu_title\";s:22:\"Visionneuse du journal\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"wsal-auditlog\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:13:\"wsal-auditlog\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:28:\"admin.php?page=wsal-auditlog\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:37:\"wsal-auditlog>wsal-emailnotifications\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:4:{s:14:\"user:abdeladim\";b:0;s:16:\"user:abdeljaouad\";b:0;s:10:\"user:mehdi\";b:0;s:13:\"user:mehdidev\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:26:\"Extension de notifications\";s:10:\"menu_title\";s:27:\"Email Notifications &#8682;\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"wsal-emailnotifications\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:13:\"wsal-auditlog\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:38:\"admin.php?page=wsal-emailnotifications\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:26:\"wsal-auditlog>wsal-reports\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:4:{s:14:\"user:abdeladim\";b:0;s:16:\"user:abdeljaouad\";b:0;s:10:\"user:mehdi\";b:0;s:13:\"user:mehdidev\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:21:\"Extension de rapports\";s:10:\"menu_title\";s:22:\"Create Reports &#8682;\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"wsal-reports\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:13:\"wsal-auditlog\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:27:\"admin.php?page=wsal-reports\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:25:\"wsal-auditlog>wsal-search\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:4:{s:14:\"user:abdeladim\";b:0;s:16:\"user:abdeljaouad\";b:0;s:10:\"user:mehdi\";b:0;s:13:\"user:mehdidev\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:22:\"Extension de recherche\";s:10:\"menu_title\";s:18:\"Log Search &#8682;\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"wsal-search\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:13:\"wsal-auditlog\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"admin.php?page=wsal-search\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:29:\"wsal-auditlog>wsal-loginusers\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:4:{s:14:\"user:abdeladim\";b:0;s:16:\"user:abdeljaouad\";b:0;s:10:\"user:mehdi\";b:0;s:13:\"user:mehdidev\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:44:\"Extension de gestion des sessions de comptes\";s:10:\"menu_title\";s:26:\"Comptes connectés &#8682;\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"wsal-loginusers\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:13:\"wsal-auditlog\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"admin.php?page=wsal-loginusers\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:27:\"wsal-auditlog>wsal-settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:4:{s:14:\"user:abdeladim\";b:0;s:16:\"user:abdeljaouad\";b:0;s:10:\"user:mehdi\";b:0;s:13:\"user:mehdidev\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:9:\"Réglages\";s:10:\"menu_title\";s:9:\"Réglages\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"wsal-settings\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:13:\"wsal-auditlog\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:28:\"admin.php?page=wsal-settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:31:\"wsal-auditlog>wsal-togglealerts\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:4:{s:14:\"user:abdeladim\";b:0;s:16:\"user:abdeljaouad\";b:0;s:10:\"user:mehdi\";b:0;s:13:\"user:mehdidev\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:36:\"Activer/désactiver les évènements\";s:10:\"menu_title\";s:36:\"Activer/désactiver les évènements\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"wsal-togglealerts\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:13:\"wsal-auditlog\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"admin.php?page=wsal-togglealerts\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:7;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:29:\"wsal-auditlog>wsal-externaldb\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:4:{s:14:\"user:abdeladim\";b:0;s:16:\"user:abdeljaouad\";b:0;s:10:\"user:mehdi\";b:0;s:13:\"user:mehdidev\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:37:\"Extension de base de données externe\";s:10:\"menu_title\";s:20:\"Integrations &#8682;\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"wsal-externaldb\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:13:\"wsal-auditlog\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"admin.php?page=wsal-externaldb\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:8;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:8;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:23:\"wsal-auditlog>wsal-help\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:4:{s:14:\"user:abdeladim\";b:0;s:16:\"user:abdeljaouad\";b:0;s:10:\"user:mehdi\";b:0;s:13:\"user:mehdidev\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:4:\"Aide\";s:10:\"menu_title\";s:21:\"Aide & Nous contacter\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"wsal-help\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:13:\"wsal-auditlog\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:24:\"admin.php?page=wsal-help\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:9;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:9;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:35:\"wsal-auditlog>wsal-auditlog-pricing\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:4:{s:14:\"user:abdeladim\";b:0;s:16:\"user:abdeljaouad\";b:0;s:10:\"user:mehdi\";b:0;s:13:\"user:mehdidev\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:31:\"WP Activity Log &ndash; Pricing\";s:10:\"menu_title\";s:107:\"<span class=\"fs-submenu-item wp-security-audit-log pricing upgrade-mode\">Upgrade&nbsp;&nbsp;&#x27a4;</span>\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:21:\"wsal-auditlog-pricing\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:13:\"wsal-auditlog\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:36:\"admin.php?page=wsal-auditlog-pricing\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:4:{s:14:\"user:abdeladim\";b:0;s:16:\"user:abdeljaouad\";b:0;s:10:\"user:mehdi\";b:0;s:13:\"user:mehdidev\";b:0;}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:15:\"WP Activity Log\";s:10:\"menu_title\";s:15:\"WP Activity Log\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"wsal-auditlog\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:36:\"menu-top toplevel_page_wsal-auditlog\";s:8:\"hookname\";s:27:\"toplevel_page_wsal-auditlog\";s:8:\"icon_url\";s:3598:\"data:image/svg+xml;base64,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\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:28:\"admin.php?page=wsal-auditlog\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"separator_6\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:12:\">separator_6\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"separator_6\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:8:\"edit.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:9:\">edit.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:4:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:17:\"edit.php>edit.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:17:\"Tous les articles\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:8:\"edit.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:8:\"edit.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:21:\"edit.php>post-new.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Ajouter\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"post-new.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:12:\"post-new.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:40:\"edit.php>edit-tags.php?taxonomy=category\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:11:\"Catégories\";s:12:\"access_level\";s:17:\"manage_categories\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:31:\"edit-tags.php?taxonomy=category\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"edit-tags.php?taxonomy=category\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:40:\"edit.php>edit-tags.php?taxonomy=post_tag\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:11:\"Étiquettes\";s:12:\"access_level\";s:16:\"manage_post_tags\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:31:\"edit-tags.php?taxonomy=post_tag\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"edit-tags.php?taxonomy=post_tag\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Articles\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:8:\"edit.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:37:\"menu-top menu-icon-post open-if-no-js\";s:8:\"hookname\";s:10:\"menu-posts\";s:8:\"icon_url\";s:20:\"dashicons-admin-post\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:8:\"edit.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:10:\"upload.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:11:\">upload.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:21:\"upload.php>upload.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:13:\"Médiathèque\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"upload.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"upload.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"upload.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:24:\"upload.php>media-new.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Ajouter\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"media-new.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"upload.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:13:\"media-new.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Médias\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"upload.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:24:\"menu-top menu-icon-media\";s:8:\"hookname\";s:10:\"menu-media\";s:8:\"icon_url\";s:21:\"dashicons-admin-media\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"upload.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:23:\"edit.php?post_type=page\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:24:\">edit.php?post_type=page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:47:\"edit.php?post_type=page>edit.php?post_type=page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:16:\"Toutes les pages\";s:12:\"access_level\";s:10:\"edit_pages\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"edit.php?post_type=page\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:23:\"edit.php?post_type=page\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"edit.php?post_type=page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:51:\"edit.php?post_type=page>post-new.php?post_type=page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Ajouter\";s:12:\"access_level\";s:10:\"edit_pages\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:27:\"post-new.php?post_type=page\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:23:\"edit.php?post_type=page\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:27:\"post-new.php?post_type=page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Pages\";s:12:\"access_level\";s:10:\"edit_pages\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"edit.php?post_type=page\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:23:\"menu-top menu-icon-page\";s:8:\"hookname\";s:10:\"menu-pages\";s:8:\"icon_url\";s:20:\"dashicons-admin-page\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"edit.php?post_type=page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:17:\"edit-comments.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:18:\">edit-comments.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:1:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:35:\"edit-comments.php>edit-comments.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:21:\"Tous les commentaires\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"edit-comments.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:17:\"edit-comments.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"edit-comments.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:206:\"Commentaires <span class=\"awaiting-mod count-0\"><span class=\"pending-count\" aria-hidden=\"true\">0</span><span class=\"comments-in-moderation-text screen-reader-text\">0 commentaire en modération</span></span>\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"edit-comments.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:27:\"menu-top menu-icon-comments\";s:8:\"hookname\";s:13:\"menu-comments\";s:8:\"icon_url\";s:24:\"dashicons-admin-comments\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"edit-comments.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"separator_7\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:12:\">separator_7\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"separator_7\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:10:\"themes.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:8;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:11:\">themes.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:21:\"themes.php>themes.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:86:\"Thèmes <span class=\"update-plugins count-0\"><span class=\"theme-count\">0</span></span>\";s:12:\"access_level\";s:13:\"switch_themes\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"themes.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"themes.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:26:\"themes.php>site-editor.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:47:\"Éditeur <span class=\"awaiting-mod\">beta</span>\";s:12:\"access_level\";s:18:\"edit_theme_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"site-editor.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:10:\"themes.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:15:\"site-editor.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Apparence\";s:12:\"access_level\";s:13:\"switch_themes\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"themes.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:29:\"menu-top menu-icon-appearance\";s:8:\"hookname\";s:15:\"menu-appearance\";s:8:\"icon_url\";s:26:\"dashicons-admin-appearance\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"themes.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"plugins.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:9;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:12:\">plugins.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:23:\"plugins.php>plugins.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:22:\"Extensions installées\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"plugins.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:11:\"plugins.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:11:\"plugins.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:30:\"plugins.php>plugin-install.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Ajouter\";s:12:\"access_level\";s:15:\"install_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:18:\"plugin-install.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:11:\"plugins.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:18:\"plugin-install.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:90:\"Extensions <span class=\"update-plugins count-2\"><span class=\"plugin-count\">2</span></span>\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"plugins.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:26:\"menu-top menu-icon-plugins\";s:8:\"hookname\";s:12:\"menu-plugins\";s:8:\"icon_url\";s:23:\"dashicons-admin-plugins\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:11:\"plugins.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:9:\"users.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:10;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:10:\">users.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:19:\"users.php>users.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:16:\"Tous les comptes\";s:12:\"access_level\";s:10:\"list_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"users.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"users.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"users.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:22:\"users.php>user-new.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Ajouter\";s:12:\"access_level\";s:12:\"create_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"user-new.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"users.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:12:\"user-new.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:21:\"users.php>profile.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Profil\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"profile.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"users.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:11:\"profile.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Comptes\";s:12:\"access_level\";s:10:\"list_users\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"users.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:24:\"menu-top menu-icon-users\";s:8:\"hookname\";s:10:\"menu-users\";s:8:\"icon_url\";s:21:\"dashicons-admin-users\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"users.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:9:\"tools.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:11;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:10:\">tools.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:6:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:19:\"tools.php>tools.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:18:\"Outils disponibles\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"tools.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"tools.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:20:\"tools.php>import.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Importer\";s:12:\"access_level\";s:6:\"import\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"import.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"import.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:20:\"tools.php>export.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Exporter\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"export.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"export.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:25:\"tools.php>site-health.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:14:\"Santé du site\";s:12:\"access_level\";s:23:\"view_site_health_checks\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"site-health.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:15:\"site-health.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:34:\"tools.php>export-personal-data.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:21:\"Exporter les données\";s:12:\"access_level\";s:27:\"export_others_personal_data\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:24:\"export-personal-data.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:24:\"export-personal-data.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:33:\"tools.php>erase-personal-data.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:20:\"Effacer les données\";s:12:\"access_level\";s:26:\"erase_others_personal_data\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"erase-personal-data.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"tools.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"erase-personal-data.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Outils\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"tools.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:24:\"menu-top menu-icon-tools\";s:8:\"hookname\";s:10:\"menu-tools\";s:8:\"icon_url\";s:21:\"dashicons-admin-tools\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"tools.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:19:\"options-general.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:12;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:20:\">options-general.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:11:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:39:\"options-general.php>options-general.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Général\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-general.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-general.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:39:\"options-general.php>options-writing.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Écriture\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-writing.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-writing.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:39:\"options-general.php>options-reading.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Lecture\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-reading.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-reading.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:42:\"options-general.php>options-discussion.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:12:\"Commentaires\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:22:\"options-discussion.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:22:\"options-discussion.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:37:\"options-general.php>options-media.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:7:\"Médias\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"options-media.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"options-media.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:41:\"options-general.php>options-permalink.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Permaliens\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:21:\"options-permalink.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:21:\"options-permalink.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:39:\"options-general.php>options-privacy.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:16:\"Confidentialité\";s:12:\"access_level\";s:22:\"manage_privacy_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-privacy.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-privacy.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:7;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:36:\"options-general.php>swpsmtp_settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:12:\"Easy WP SMTP\";s:10:\"menu_title\";s:12:\"Easy WP SMTP\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"swpsmtp_settings\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:41:\"options-general.php?page=swpsmtp_settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:8;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:8;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:39:\"options-general.php>ws-admin-bar-editor\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:24:\"WordPress Toolbar Editor\";s:10:\"menu_title\";s:14:\"Toolbar Editor\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"ws-admin-bar-editor\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:44:\"options-general.php?page=ws-admin-bar-editor\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:9;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:9;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:37:\"options-general.php>ithemes-licensing\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:17:\"iThemes Licensing\";s:10:\"menu_title\";s:17:\"iThemes Licensing\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"ithemes-licensing\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:42:\"options-general.php?page=ithemes-licensing\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:10;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:10;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:31:\"options-general.php>menu_editor\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:15:\"Menu Editor Pro\";s:10:\"menu_title\";s:15:\"Menu Editor Pro\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"menu_editor\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:19:\"options-general.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:36:\"options-general.php?page=menu_editor\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Réglages\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"options-general.php\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:27:\"menu-top menu-icon-settings\";s:8:\"hookname\";s:13:\"menu-settings\";s:8:\"icon_url\";s:24:\"dashicons-admin-settings\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"options-general.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"separator_8\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:13;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:12:\">separator_8\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"separator_8\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:9:\"Wordfence\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:14;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:10:\">Wordfence\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:8:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:19:\"Wordfence>Wordfence\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:19:\"Wordfence Dashboard\";s:10:\"menu_title\";s:9:\"Dashboard\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"Wordfence\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:24:\"admin.php?page=Wordfence\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:22:\"Wordfence>WordfenceWAF\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:8:\"Firewall\";s:10:\"menu_title\";s:8:\"Firewall\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"WordfenceWAF\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:27:\"admin.php?page=WordfenceWAF\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:23:\"Wordfence>WordfenceScan\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:4:\"Scan\";s:10:\"menu_title\";s:4:\"Scan\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"WordfenceScan\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:28:\"admin.php?page=WordfenceScan\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:24:\"Wordfence>WordfenceTools\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:5:\"Tools\";s:10:\"menu_title\";s:5:\"Tools\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:14:\"WordfenceTools\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:29:\"admin.php?page=WordfenceTools\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:14:\"Wordfence>WFLS\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:14:\"Login Security\";s:10:\"menu_title\";s:14:\"Login Security\";s:12:\"access_level\";s:23:\"wf2fa_activate_2fa_self\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:4:\"WFLS\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:19:\"admin.php?page=WFLS\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:26:\"Wordfence>WordfenceOptions\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:11:\"All Options\";s:10:\"menu_title\";s:11:\"All Options\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"WordfenceOptions\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=WordfenceOptions\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:26:\"Wordfence>WordfenceSupport\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:4:\"Help\";s:10:\"menu_title\";s:4:\"Help\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"WordfenceSupport\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=WordfenceSupport\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:7;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:32:\"Wordfence>WordfenceUpgradeToCare\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:15:\"Upgrade to Care\";s:10:\"menu_title\";s:75:\"<strong id=\"wfMenuCallout\" style=\"color: #FCB214;\">Upgrade to Care</strong>\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:22:\"WordfenceUpgradeToCare\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:9:\"Wordfence\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:37:\"admin.php?page=WordfenceUpgradeToCare\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:9:\"Wordfence\";s:10:\"menu_title\";s:165:\"Wordfence <span class=\'update-plugins wf-menu-badge wf-notification-count-container\' title=\'3\'><span class=\'update-count wf-notification-count-value\'>3</span></span>\";s:12:\"access_level\";s:16:\"activate_plugins\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"Wordfence\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:32:\"menu-top toplevel_page_Wordfence\";s:8:\"hookname\";s:23:\"toplevel_page_Wordfence\";s:8:\"icon_url\";s:4:\"none\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:24:\"admin.php?page=Wordfence\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:15:\"itsec-dashboard\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:15;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:16:\">itsec-dashboard\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:31:\"itsec-dashboard>itsec-dashboard\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:9:\"Dashboard\";s:10:\"menu_title\";s:9:\"Dashboard\";s:12:\"access_level\";s:20:\"itsec_dashboard_menu\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"itsec-dashboard\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:15:\"itsec-dashboard\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"admin.php?page=itsec-dashboard\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:21:\"itsec-dashboard>itsec\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:25:\"iThemes Security Settings\";s:10:\"menu_title\";s:8:\"Settings\";s:12:\"access_level\";s:12:\"itsec_manage\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:5:\"itsec\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:15:\"itsec-dashboard\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:20:\"admin.php?page=itsec\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:26:\"itsec-dashboard>itsec-logs\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:21:\"iThemes Security Logs\";s:10:\"menu_title\";s:4:\"Logs\";s:12:\"access_level\";s:12:\"itsec_manage\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"itsec-logs\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:15:\"itsec-dashboard\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:25:\"admin.php?page=itsec-logs\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:8:\"Security\";s:10:\"menu_title\";s:8:\"Security\";s:12:\"access_level\";s:20:\"itsec_dashboard_menu\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"itsec-dashboard\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:56:\"menu-top menu-icon-generic toplevel_page_itsec-dashboard\";s:8:\"hookname\";s:29:\"toplevel_page_itsec-dashboard\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"admin.php?page=itsec-dashboard\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:14:\"duplicator-pro\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:16;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:15:\">duplicator-pro\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:6:{i:0;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:29:\"duplicator-pro>duplicator-pro\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:8:\"Packages\";s:10:\"menu_title\";s:8:\"Packages\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:14:\"duplicator-pro\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:14:\"duplicator-pro\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:29:\"admin.php?page=duplicator-pro\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:36:\"duplicator-pro>duplicator-pro-import\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:6:\"Import\";s:10:\"menu_title\";s:6:\"Import\";s:12:\"access_level\";s:6:\"import\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:21:\"duplicator-pro-import\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:14:\"duplicator-pro\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:36:\"admin.php?page=duplicator-pro-import\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:39:\"duplicator-pro>duplicator-pro-schedules\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:9:\"Schedules\";s:10:\"menu_title\";s:9:\"Schedules\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:24:\"duplicator-pro-schedules\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:14:\"duplicator-pro\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:39:\"admin.php?page=duplicator-pro-schedules\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:37:\"duplicator-pro>duplicator-pro-storage\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:7:\"Storage\";s:10:\"menu_title\";s:7:\"Storage\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:22:\"duplicator-pro-storage\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:14:\"duplicator-pro\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:37:\"admin.php?page=duplicator-pro-storage\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:35:\"duplicator-pro>duplicator-pro-tools\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:5:\"Tools\";s:10:\"menu_title\";s:5:\"Tools\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:20:\"duplicator-pro-tools\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:14:\"duplicator-pro\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:35:\"admin.php?page=duplicator-pro-tools\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:25:\"is_iframe_scroll_disabled\";N;s:11:\"template_id\";s:38:\"duplicator-pro>duplicator-pro-settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:8:\"Settings\";s:10:\"menu_title\";s:8:\"Settings\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"duplicator-pro-settings\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";s:14:\"duplicator-pro\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:38:\"admin.php?page=duplicator-pro-settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:21:{s:10:\"page_title\";s:17:\"Duplicator Plugin\";s:10:\"menu_title\";s:14:\"Duplicator Pro\";s:12:\"access_level\";s:6:\"export\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:14:\"duplicator-pro\";s:12:\"page_heading\";s:0:\"\";s:6:\"parent\";N;s:9:\"css_class\";s:37:\"menu-top toplevel_page_duplicator-pro\";s:8:\"hookname\";s:28:\"toplevel_page_duplicator-pro\";s:8:\"icon_url\";s:7146:\"data:image/svg+xml;base64,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\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:25:\"is_iframe_scroll_disabled\";b:0;s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:29:\"admin.php?page=duplicator-pro\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:6:\"format\";a:3:{s:4:\"name\";s:22:\"Admin Menu Editor menu\";s:7:\"version\";s:3:\"7.0\";s:13:\"is_normalized\";b:1;}s:13:\"color_presets\";a:0:{}s:20:\"component_visibility\";a:0:{}s:22:\"has_modified_dashicons\";b:0;s:16:\"last_modified_on\";s:25:\"2022-03-24T11:04:17+00:00\";s:9:\"color_css\";s:0:\"\";s:18:\"color_css_modified\";i:0;s:20:\"icon_color_overrides\";N;s:21:\"prebuilt_virtual_caps\";a:2:{i:2;a:0:{}i:3;a:0:{}}}s:19:\"custom_network_menu\";N;s:18:\"first_install_time\";i:1648118809;s:21:\"display_survey_notice\";b:1;s:17:\"plugin_db_version\";i:140;s:24:\"security_logging_enabled\";b:0;s:17:\"menu_config_scope\";s:6:\"global\";s:13:\"plugin_access\";s:14:\"manage_options\";s:15:\"allowed_user_id\";N;s:28:\"plugins_page_allowed_user_id\";N;s:27:\"show_deprecated_hide_button\";b:1;s:37:\"dashboard_hiding_confirmation_enabled\";b:1;s:21:\"submenu_icons_enabled\";s:9:\"if_custom\";s:22:\"force_custom_dashicons\";b:1;s:16:\"ui_colour_scheme\";s:7:\"classic\";s:13:\"visible_users\";a:5:{i:0;s:13:\"OffCreaAdSite\";i:1;s:9:\"abdeladim\";i:2;s:11:\"abdeljaouad\";i:3;s:5:\"mehdi\";i:4;s:8:\"mehdidev\";}s:23:\"show_plugin_menu_notice\";b:0;s:20:\"unused_item_position\";s:8:\"relative\";s:23:\"unused_item_permissions\";s:9:\"unchanged\";s:15:\"error_verbosity\";i:2;s:20:\"compress_custom_menu\";b:0;s:20:\"wpml_support_enabled\";b:1;s:24:\"bbpress_override_enabled\";b:0;s:20:\"deep_nesting_enabled\";N;s:24:\"was_nesting_ever_changed\";b:0;s:16:\"is_active_module\";a:1:{s:19:\"highlight-new-menus\";b:0;}}","yes"),
("244","ws_abe_external_updates","O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1730466243;s:14:\"checkedVersion\";s:5:\"1.5.1\";s:6:\"update\";O:8:\"stdClass\":11:{s:4:\"slug\";s:17:\"wp-toolbar-editor\";s:7:\"version\";s:5:\"1.5.1\";s:12:\"download_url\";N;s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:28:\"https://adminmenueditor.com/\";s:6:\"tested\";s:7:\"6.5.999\";s:12:\"requires_php\";s:3:\"7.2\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:0:{}s:8:\"filename\";s:26:\"wp-toolbar-editor/load.php\";}s:11:\"updateClass\";s:50:\"YahnisElsts\\PluginUpdateChecker\\v5p4\\Plugin\\Update\";s:15:\"updateBaseClass\";s:13:\"Plugin\\Update\";}","off"),
("245","ame_pro_external_updates","O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1730466242;s:14:\"checkedVersion\";s:4:\"2.26\";s:6:\"update\";O:8:\"stdClass\":11:{s:4:\"slug\";s:21:\"admin-menu-editor-pro\";s:7:\"version\";s:6:\"2.26.1\";s:12:\"download_url\";N;s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:27:\"http://adminmenueditor.com/\";s:6:\"tested\";s:5:\"6.6.2\";s:12:\"requires_php\";s:3:\"5.6\";s:14:\"upgrade_notice\";N;s:5:\"icons\";a:0:{}s:8:\"filename\";s:37:\"admin-menu-editor-pro/menu-editor.php\";}s:11:\"updateClass\";s:50:\"YahnisElsts\\PluginUpdateChecker\\v5p4\\Plugin\\Update\";s:15:\"updateBaseClass\";s:13:\"Plugin\\Update\";}","off"),
("246","wslm_auto_activation_failed-admin-menu-editor-pro","a:2:{s:8:\"failures\";i:9;s:15:\"lastAttemptTime\";i:1730466094;}","off"),
("247","ithemes-updater-cache","a:15:{s:18:\"timeout-multiplier\";i:1;s:10:\"expiration\";i:1730513598;s:9:\"timestamp\";i:1730466731;s:15:\"error_timestamp\";i:0;s:8:\"packages\";a:1:{i:0;s:20:\"ithemes-security-pro\";}s:14:\"update_plugins\";a:0:{}s:24:\"update_plugins_no_update\";a:1:{s:11:\"backupbuddy\";O:8:\"stdClass\":2:{s:4:\"slug\";s:1:\".\";s:6:\"plugin\";s:11:\"backupbuddy\";}}s:13:\"update_themes\";a:0:{}s:23:\"update_themes_no_update\";a:0:{}s:12:\"use_ca_patch\";b:0;s:7:\"use_ssl\";b:1;s:14:\"quick_releases\";b:0;s:16:\"site_url_history\";a:1:{s:46:\"http://192.168.100.112:8012/duplicator-creaweb\";i:1730469885;}s:18:\"timeout-mulitplier\";i:1;s:15:\"package_details\";a:1:{s:20:\"ithemes-security-pro\";a:4:{s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:11:\"backupbuddy\";s:7:\"version\";b:1;s:14:\"license_status\";s:6:\"active\";}}}","off"),
("250","ithemes-updater-keys","a:0:{}","no"),
("257","duplicator_pro_reset_user_settings_required","0","yes"),
("258","duplicator_pro_plugin_version","4.5.19.3","on"),
("260","duplicator_expire_rename_delay","{\"expire\":1730507557,\"value\":true}","yes"),
("261","duplicator_expire_duplicator_pro_frotend_delay","{\"expire\":1730470430,\"value\":true}","on"),
("262","duplicator_expire_license_check","{\"expire\":1730470431,\"value\":true}","on"),
("285","fs_active_plugins","O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:36:\"admin-site-enhancements-pro/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:5:\"2.8.1\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1730467719;s:11:\"plugin_path\";s:55:\"admin-site-enhancements-pro/admin-site-enhancements.php\";}}s:7:\"abspath\";s:33:\"C:\\wamp64\\www\\duplicator-creaweb/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:55:\"admin-site-enhancements-pro/admin-site-enhancements.php\";s:8:\"sdk_path\";s:36:\"admin-site-enhancements-pro/freemius\";s:7:\"version\";s:5:\"2.8.1\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1730467719;}}","yes"),
("286","fs_debug_mode","","yes"),
("287","fs_accounts","a:5:{s:21:\"id_slug_type_path_map\";a:1:{i:94;a:3:{s:4:\"slug\";s:21:\"wp-security-audit-log\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:47:\"wp-security-audit-log/wp-security-audit-log.php\";}}s:11:\"plugin_data\";a:1:{s:21:\"wp-security-audit-log\";a:14:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:47:\"wp-security-audit-log/wp-security-audit-log.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1648119175;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:5:\"2.4.3\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"4.4.0\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:20:\"192.168.100.118:8050\";s:9:\"server_ip\";s:15:\"192.168.100.118\";s:9:\"is_active\";b:0;s:9:\"timestamp\";i:1648119175;s:7:\"version\";s:5:\"4.4.0\";}}}s:13:\"file_slug_map\";a:1:{s:47:\"wp-security-audit-log/wp-security-audit-log.php\";s:21:\"wp-security-audit-log\";}s:7:\"plugins\";a:1:{s:21:\"wp-security-audit-log\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:15:\"WP Activity Log\";s:4:\"slug\";s:21:\"wp-security-audit-log\";s:12:\"premium_slug\";s:29:\"wp-security-audit-log-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:47:\"wp-security-audit-log/wp-security-audit-log.php\";s:7:\"version\";s:5:\"4.4.0\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_d602740d3088272d75906045af9fa\";s:10:\"secret_key\";N;s:2:\"id\";s:2:\"94\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:1;}}s:9:\"unique_id\";s:32:\"1a1c906a0d4c204ea028a8e134bed38f\";}","yes"),
("288","fs_gdpr","a:1:{s:2:\"u1\";a:1:{s:8:\"required\";N;}}","yes"),
("298","fs_wsalp","no","yes"),
("304","fs_api_cache","a:0:{}","no"),
("314","wsal_details-level","geek","no"),
("328","wsal_setup-complete","yes","no"),
("330","ws_ame_dashboard_widgets","WHgz64DeJztWctu2zgU3fcrCK1HbeykjxhtAY+bwWzSGHXRLMrCoMhrmw1FqnxYMIr8+5CU5Fddyx3MoIFjL+JY95Ai7z3nkJS+P0H+k0yUzolNeuh7/B2vSZKDv5L0Wc4lugbp0BXjVmnEiJllimiGSs6mYE3yx6rZHLThSoaWnaedJAbuq3jSwHvo87LB6o4RwlloubzD2HAL4xkQYWdrd4lQy62II9wOCEWJrcewHSs0V5rbxa4YN0MNBmRIhNUOtsJTTaTtUwrGbGRqCdBKQI+EdHFjNfGp8rgJEWarpxUYYkLbUMTZWTuKKmk1z9wBHRqXGeqxsA/pDOjezWQy0ED6bOTr0AYmGQNBGM8PAn4lyhHWBs1hxvhBIAbzBrcBu98qY0XCj4sicqfUpCh8HrZB8TK7jdjd1V7SD7uzM3ppiUUMkPEcCRfgEjGHAnuTHaNeZ6gM2hO7UOtcpUpDsn9eZD99KREiI/TuLy7gfa3tQQ/jkuTFiwv/XZYYM1cITgN1U+rrXkLmA0UaSY0xl1Q4BsbjGoE+LWbFalxrY2rRtebTmR1LVZ5UfVL1HtBvU/U77LpnnUsnEVWuQKz66aXdeX7Od8r1JGpCLZ+HuZ00fdL0z0G/TdP9ip/V+nySMFpJeNn9eKXmKv0PS8ufv/zvvr9MxTEQJFiN7xjjQrgpl2YDWGiFsdEU408cSh9719S+ytSvcahUmk1AUlguA2MNhdL2kRLptskHavKB/DnazgAVxFhUAtwdJ8OWRMBY8ACa1L67+BD58Gu04tYATZeulD5OMo2U4AyNgLowYDTU6ji5w70+cjCpqWdaeVT8s00BjKkgxqS7CVItjf92I/vNcXo3LnQo74Ni2mkv+wP4ke5lX5uC+LNpkMAbnMz8QFI+SaVKvxqcvP1TK8eFUBL5Ln3sNX4W8G/R7maxzSdlUNa0M0hX22TqmWma5m2mY3x/D9ty/vtDr59bTvTpzHvyiQfpE9XT6XkU8yvpF1cvZwQWSeXm4GtXqdygsF0d7ljwYm+PU+NAzGJcFmOT26I+y5j6MDMWPz7ZP/pN6JXPB7odotH1x+Fxbj9DxVMfCRWvj8b9ikz7j8bxvzr/SQmCqhyGRILYyOhejz7Yn9u9ud2XD/Tkw/z4YC8+yIcP9OBW/23x3qpkzYvp8J5uoPJCSc+Hv32pA42yi3NKLrMXL0kn61x0Sfe8y15B1ul2OqT7nDUPEBO/l7LXivEJhzDYs/oygwlxwt5oBvpmDlr7cVxJkgnYmlKi1iFD0P64HCvSKDq8nqfABkq4XA6Ui1qQTogd4VGgDkwXP0eYehAbN3py/w+y7mrp","off"),
("422","smtp_test_mail","a:3:{s:10:\"swpsmtp_to\";s:15:\"test@creaweb.ma\";s:15:\"swpsmtp_subject\";s:4:\"test\";s:15:\"swpsmtp_message\";s:3:\"ttt\";}","yes"),
("433","ws_ame_meta_boxes","{\"format\":{\"name\":\"Admin Menu Editor meta boxes\",\"version\":\"2.0\"},\"screens\":{\"post\":{\"metaBoxes:\":[],\"postTypeFeatures:\":{\"title\":{\"id\":\"title\",\"title\":\"Title\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"amePostTypeFeature\",\"parentCollectionKey\":\"postTypeFeatures:\",\"isVirtual\":true},\"editor\":{\"id\":\"editor\",\"title\":\"Content Editor\",\"context\":\"normal\",\"isPresent\":true,\"grantAccess\":[],\"defaultVisibility\":[],\"isHiddenByDefault\":false,\"className\":\"amePostTypeFeature\",\"parentCollectionKey\":\"postTypeFeatures:\",\"isVirtual\":true}}}},\"isInitialRefreshDone\":false}","no"),
("582","itsec_remote_messages","a:3:{s:8:\"response\";a:4:{s:3:\"ttl\";i:43200;s:8:\"messages\";a:0:{}s:8:\"features\";a:3:{s:12:\"site_scanner\";a:3:{s:4:\"rate\";i:10;s:8:\"disabled\";b:1;s:12:\"requirements\";a:0:{}}s:15:\"site_scanner_p1\";a:3:{s:4:\"rate\";i:90;s:8:\"disabled\";b:0;s:12:\"requirements\";a:0:{}}s:17:\"enable_encryption\";a:3:{s:4:\"rate\";i:100;s:8:\"disabled\";b:0;s:12:\"requirements\";a:0:{}}}s:7:\"actions\";a:0:{}}s:3:\"ttl\";i:43200;s:9:\"requested\";i:1730465236;}","off"),
("866","duplicator_pro_exe_safe_mode","0","yes"),
("867","duplicator_pro_activate_plugins_after_installation","a:0:{}","yes"),
("869","duplicator_pro_migration_data","{\n    \"installType\": -1,\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/20220324_creawebma_2bc9b49ad703d0165562_20220324112743_archive.zip\",\n    \"packageHash\": \"2bc9b49-24112743\",\n    \"installerPath\": \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/installer.php\",\n    \"installerBootLog\": \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/dup-installer-bootlog__03d10c2-24112743.txt\",\n    \"installerLog\": \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/dup-installer\\/dup-installer-log__03d10c2-24112743.txt\",\n    \"dupInstallerPath\": \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/dup-installer\",\n    \"origFileFolderPath\": \"C:\\/wamp64\\/www\\/duplicator-creaweb\\/dup-installer\\/original_files_2bc9b49-24112743\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true\n}","no"),
("884","_transient_timeout_wsal__file_list_563a31b9feee68070b3d5334e9154907","1730550757","no"),
("885","_transient_wsal__file_list_563a31b9feee68070b3d5334e9154907","a:1:{i:0;s:102:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Loggers/Database.php\";}","no"),
("886","_transient_timeout_wsal__file_list_1e2190e0afcf3df45dd8276255c86769","1730550757","no"),
("887","_transient_wsal__file_list_1e2190e0afcf3df45dd8276255c86769","a:16:{i:0;s:101:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/ACFMeta.php\";i:1;s:102:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/Comments.php\";i:2;s:101:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/Content.php\";i:3;s:102:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/Database.php\";i:4;s:99:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/Files.php\";i:5;s:102:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/LogInOut.php\";i:6;s:100:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/MainWP.php\";i:7;s:99:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/Menus.php\";i:8;s:102:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/MetaData.php\";i:9;s:103:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/Multisite.php\";i:10;s:109:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/MultisiteSignUp.php\";i:11;s:107:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/PluginsThemes.php\";i:12;s:102:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/Register.php\";i:13;s:100:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/System.php\";i:14;s:105:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/UserProfile.php\";i:15;s:101:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log\\classes/Sensors/Widgets.php\";}","no"),
("894","_transient_timeout_global_styles_twentytwentytwo","1730464417","no"),
("895","_transient_global_styles_twentytwentytwo","body{--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--color--foreground: #000000;--wp--preset--color--background: #ffffff;--wp--preset--color--primary: #1a4548;--wp--preset--color--secondary: #ffe2c7;--wp--preset--color--tertiary: #F6F6F6;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--gradient--vertical-secondary-to-tertiary: linear-gradient(to bottom,var(--wp--preset--color--secondary) 0%,var(--wp--preset--color--tertiary) 100%);--wp--preset--gradient--vertical-secondary-to-background: linear-gradient(to bottom,var(--wp--preset--color--secondary) 0%,var(--wp--preset--color--background) 100%);--wp--preset--gradient--vertical-tertiary-to-background: linear-gradient(to bottom,var(--wp--preset--color--tertiary) 0%,var(--wp--preset--color--background) 100%);--wp--preset--gradient--diagonal-primary-to-foreground: linear-gradient(to bottom right,var(--wp--preset--color--primary) 0%,var(--wp--preset--color--foreground) 100%);--wp--preset--gradient--diagonal-secondary-to-background: linear-gradient(to bottom right,var(--wp--preset--color--secondary) 50%,var(--wp--preset--color--background) 50%);--wp--preset--gradient--diagonal-background-to-secondary: linear-gradient(to bottom right,var(--wp--preset--color--background) 50%,var(--wp--preset--color--secondary) 50%);--wp--preset--gradient--diagonal-tertiary-to-background: linear-gradient(to bottom right,var(--wp--preset--color--tertiary) 50%,var(--wp--preset--color--background) 50%);--wp--preset--gradient--diagonal-background-to-tertiary: linear-gradient(to bottom right,var(--wp--preset--color--background) 50%,var(--wp--preset--color--tertiary) 50%);--wp--preset--duotone--dark-grayscale: url(\'#wp-duotone-dark-grayscale\');--wp--preset--duotone--grayscale: url(\'#wp-duotone-grayscale\');--wp--preset--duotone--purple-yellow: url(\'#wp-duotone-purple-yellow\');--wp--preset--duotone--blue-red: url(\'#wp-duotone-blue-red\');--wp--preset--duotone--midnight: url(\'#wp-duotone-midnight\');--wp--preset--duotone--magenta-yellow: url(\'#wp-duotone-magenta-yellow\');--wp--preset--duotone--purple-green: url(\'#wp-duotone-purple-green\');--wp--preset--duotone--blue-orange: url(\'#wp-duotone-blue-orange\');--wp--preset--duotone--foreground-and-background: url(\'#wp-duotone-foreground-and-background\');--wp--preset--duotone--foreground-and-secondary: url(\'#wp-duotone-foreground-and-secondary\');--wp--preset--duotone--foreground-and-tertiary: url(\'#wp-duotone-foreground-and-tertiary\');--wp--preset--duotone--primary-and-background: url(\'#wp-duotone-primary-and-background\');--wp--preset--duotone--primary-and-secondary: url(\'#wp-duotone-primary-and-secondary\');--wp--preset--duotone--primary-and-tertiary: url(\'#wp-duotone-primary-and-tertiary\');--wp--preset--font-size--small: 1rem;--wp--preset--font-size--medium: 1.125rem;--wp--preset--font-size--large: 1.75rem;--wp--preset--font-size--x-large: clamp(1.75rem, 3vw, 2.25rem);--wp--preset--font-family--system-font: -apple-system,BlinkMacSystemFont,\"Segoe UI\",Roboto,Oxygen-Sans,Ubuntu,Cantarell,\"Helvetica Neue\",sans-serif;--wp--preset--font-family--source-serif-pro: \"Source Serif Pro\", serif;--wp--custom--spacing--small: max(1.25rem, 5vw);--wp--custom--spacing--medium: clamp(2rem, 8vw, calc(4 * var(--wp--style--block-gap)));--wp--custom--spacing--large: clamp(4rem, 10vw, 8rem);--wp--custom--spacing--outer: var(--wp--custom--spacing--small, 1.25rem);--wp--custom--typography--font-size--huge: clamp(2.25rem, 4vw, 2.75rem);--wp--custom--typography--font-size--gigantic: clamp(2.75rem, 6vw, 3.25rem);--wp--custom--typography--font-size--colossal: clamp(3.25rem, 8vw, 6.25rem);--wp--custom--typography--line-height--tiny: 1.15;--wp--custom--typography--line-height--small: 1.2;--wp--custom--typography--line-height--medium: 1.4;--wp--custom--typography--line-height--normal: 1.6;}body { margin: 0; }body{background-color: var(--wp--preset--color--background);color: var(--wp--preset--color--foreground);font-family: var(--wp--preset--font-family--system-font);font-size: var(--wp--preset--font-size--medium);line-height: var(--wp--custom--typography--line-height--normal);--wp--style--block-gap: 1.5rem;}.wp-site-blocks > .alignleft { float: left; margin-right: 2em; }.wp-site-blocks > .alignright { float: right; margin-left: 2em; }.wp-site-blocks > .aligncenter { justify-content: center; margin-left: auto; margin-right: auto; }.wp-site-blocks > * { margin-top: 0; margin-bottom: 0; }.wp-site-blocks > * + * { margin-top: var( --wp--style--block-gap ); }h1{font-family: var(--wp--preset--font-family--source-serif-pro);font-size: var(--wp--custom--typography--font-size--colossal);font-weight: 300;line-height: var(--wp--custom--typography--line-height--tiny);}h2{font-family: var(--wp--preset--font-family--source-serif-pro);font-size: var(--wp--custom--typography--font-size--gigantic);font-weight: 300;line-height: var(--wp--custom--typography--line-height--small);}h3{font-family: var(--wp--preset--font-family--source-serif-pro);font-size: var(--wp--custom--typography--font-size--huge);font-weight: 300;line-height: var(--wp--custom--typography--line-height--tiny);}h4{font-family: var(--wp--preset--font-family--source-serif-pro);font-size: var(--wp--preset--font-size--x-large);font-weight: 300;line-height: var(--wp--custom--typography--line-height--tiny);}h5{font-family: var(--wp--preset--font-family--system-font);font-size: var(--wp--preset--font-size--medium);font-weight: 700;line-height: var(--wp--custom--typography--line-height--normal);text-transform: uppercase;}h6{font-family: var(--wp--preset--font-family--system-font);font-size: var(--wp--preset--font-size--medium);font-weight: 400;line-height: var(--wp--custom--typography--line-height--normal);text-transform: uppercase;}a{color: var(--wp--preset--color--foreground);}.wp-block-button__link{background-color: var(--wp--preset--color--primary);border-radius: 0;color: var(--wp--preset--color--background);font-size: var(--wp--preset--font-size--medium);}.wp-block-post-title{font-family: var(--wp--preset--font-family--source-serif-pro);font-size: var(--wp--custom--typography--font-size--gigantic);font-weight: 300;line-height: var(--wp--custom--typography--line-height--tiny);}.wp-block-post-comments{padding-top: var(--wp--custom--spacing--small);}.wp-block-pullquote{border-width: 1px 0;}.wp-block-query-title{font-family: var(--wp--preset--font-family--source-serif-pro);font-size: var(--wp--custom--typography--font-size--gigantic);font-weight: 300;line-height: var(--wp--custom--typography--line-height--small);}.wp-block-quote{border-width: 1px;}.wp-block-site-title{font-family: var(--wp--preset--font-family--system-font);font-size: var(--wp--preset--font-size--medium);font-weight: normal;line-height: var(--wp--custom--typography--line-height--normal);}.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-foreground-color{color: var(--wp--preset--color--foreground) !important;}.has-background-color{color: var(--wp--preset--color--background) !important;}.has-primary-color{color: var(--wp--preset--color--primary) !important;}.has-secondary-color{color: var(--wp--preset--color--secondary) !important;}.has-tertiary-color{color: var(--wp--preset--color--tertiary) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-foreground-background-color{background-color: var(--wp--preset--color--foreground) !important;}.has-background-background-color{background-color: var(--wp--preset--color--background) !important;}.has-primary-background-color{background-color: var(--wp--preset--color--primary) !important;}.has-secondary-background-color{background-color: var(--wp--preset--color--secondary) !important;}.has-tertiary-background-color{background-color: var(--wp--preset--color--tertiary) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-foreground-border-color{border-color: var(--wp--preset--color--foreground) !important;}.has-background-border-color{border-color: var(--wp--preset--color--background) !important;}.has-primary-border-color{border-color: var(--wp--preset--color--primary) !important;}.has-secondary-border-color{border-color: var(--wp--preset--color--secondary) !important;}.has-tertiary-border-color{border-color: var(--wp--preset--color--tertiary) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-vertical-secondary-to-tertiary-gradient-background{background: var(--wp--preset--gradient--vertical-secondary-to-tertiary) !important;}.has-vertical-secondary-to-background-gradient-background{background: var(--wp--preset--gradient--vertical-secondary-to-background) !important;}.has-vertical-tertiary-to-background-gradient-background{background: var(--wp--preset--gradient--vertical-tertiary-to-background) !important;}.has-diagonal-primary-to-foreground-gradient-background{background: var(--wp--preset--gradient--diagonal-primary-to-foreground) !important;}.has-diagonal-secondary-to-background-gradient-background{background: var(--wp--preset--gradient--diagonal-secondary-to-background) !important;}.has-diagonal-background-to-secondary-gradient-background{background: var(--wp--preset--gradient--diagonal-background-to-secondary) !important;}.has-diagonal-tertiary-to-background-gradient-background{background: var(--wp--preset--gradient--diagonal-tertiary-to-background) !important;}.has-diagonal-background-to-tertiary-gradient-background{background: var(--wp--preset--gradient--diagonal-background-to-tertiary) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}.has-system-font-font-family{font-family: var(--wp--preset--font-family--system-font) !important;}.has-source-serif-pro-font-family{font-family: var(--wp--preset--font-family--source-serif-pro) !important;}","no"),
("896","_transient_timeout_global_styles_svg_filters_twentytwentytwo","1730464417","no"),
("897","_transient_global_styles_svg_filters_twentytwentytwo","<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-dark-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncG type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncB type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.54901960784314 0.98823529411765\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.71764705882353 0.25490196078431\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-red\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 0.27843137254902\" /><feFuncB type=\"table\" tableValues=\"0.5921568627451 0.27843137254902\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-midnight\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0\" /><feFuncG type=\"table\" tableValues=\"0 0.64705882352941\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-magenta-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.78039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.94901960784314\" /><feFuncB type=\"table\" tableValues=\"0.35294117647059 0.47058823529412\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-green\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.65098039215686 0.40392156862745\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.44705882352941 0.4\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-orange\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.098039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.66274509803922\" /><feFuncB type=\"table\" tableValues=\"0.84705882352941 0.41960784313725\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-foreground-and-background\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-foreground-and-secondary\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 0.88627450980392\" /><feFuncB type=\"table\" tableValues=\"0 0.78039215686275\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-foreground-and-tertiary\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0.96470588235294\" /><feFuncG type=\"table\" tableValues=\"0 0.96470588235294\" /><feFuncB type=\"table\" tableValues=\"0 0.96470588235294\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-primary-and-background\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.10196078431373 1\" /><feFuncG type=\"table\" tableValues=\"0.27058823529412 1\" /><feFuncB type=\"table\" tableValues=\"0.28235294117647 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-primary-and-secondary\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.10196078431373 1\" /><feFuncG type=\"table\" tableValues=\"0.27058823529412 0.88627450980392\" /><feFuncB type=\"table\" tableValues=\"0.28235294117647 0.78039215686275\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-primary-and-tertiary\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.10196078431373 0.96470588235294\" /><feFuncG type=\"table\" tableValues=\"0.27058823529412 0.96470588235294\" /><feFuncB type=\"table\" tableValues=\"0.28235294117647 0.96470588235294\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg>","no"),
("900","_site_transient_timeout_available_translations","1730475158","no"),
("901","_site_transient_available_translations","a:128:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-02 19:28:57\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-02-24 06:01:42\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-09-08 17:57:56\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.10/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.26/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-29 12:06:55\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-10-31 08:48:37\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.16/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-31 23:04:39\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-04 09:05:54\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 19:47:03\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-31 09:09:16\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-02-25 09:25:03\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-17 12:58:14\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-04 09:14:58\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-04 09:15:40\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/5.9.2/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-01-24 12:22:31\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/5.9.2/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-01-24 12:26:13\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 09:37:19\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.9.2/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 12:16:36\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2021-12-24 12:36:39\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-01 22:35:50\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-01 10:50:39\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-01 04:45:08\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-01 22:35:34\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-01 08:44:40\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 04:45:11\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 04:41:53\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 04:44:22\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-07-30 00:35:05\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2024-10-27 16:47:11\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2024-10-16 21:26:46\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.16/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 04:42:59\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.21/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 14:14:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-02-28 00:39:08\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-08-12 08:38:59\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-06 18:28:40\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-03 21:39:42\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-11-20 16:34:11\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-02-22 17:24:14\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-01 20:02:47\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-05 18:53:50\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-22 13:54:46\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-04 16:36:42\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2024-02-07 08:07:00\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.26/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.33\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.33/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-02-14 22:20:29\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:6:\"5.5.15\";s:7:\"updated\";s:19:\"2023-08-11 04:03:50\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.15/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-05 09:21:50\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 09:38:59\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.9.2/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-05 08:34:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-02-22 09:07:27\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 08:09:26\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-29 23:58:18\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-01-24 08:56:29\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-04 17:50:21\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.9.2/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.26/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.21/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-02-23 01:39:33\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-02 01:11:00\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-12-07 16:32:30\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.8.10/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-23 12:35:40\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-04 15:22:04\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-17 12:19:10\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 07:29:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2024-10-17 09:20:05\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.26/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.15\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.15/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-31 01:41:17\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-18 17:18:02\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-20 07:46:40\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/5.9.2/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-05 08:58:24\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 12:50:43\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-01 05:34:07\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.34\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.34/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-31 16:27:44\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-01 09:32:49\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-11-27 16:28:47\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2023-09-28 12:14:48\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/core/5.8.10/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 16:36:19\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 14:45:05\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.16/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-02-23 08:05:13\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-01-24 13:37:43\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.9.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-02-01 10:20:40\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-04 20:07:24\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2024-09-05 07:49:38\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-04 13:36:02\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:6:\"5.3.18\";s:7:\"updated\";s:19:\"2019-10-13 15:35:35\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.3.18/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.10/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.25/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-06 13:13:53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2021-07-03 18:41:33\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2022-03-06 15:05:20\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.10/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.16/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-30 13:50:02\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.9.2/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-18 15:13:38\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-04-01 20:41:20\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:19:\"2022-03-14 15:03:38\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.9.2/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}","no"),
("911","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("912","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("913","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:5:\"6.6.2\";s:5:\"files\";a:496:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:29:\"comment-content/style-rtl.css\";i:77;s:33:\"comment-content/style-rtl.min.css\";i:78;s:25:\"comment-content/style.css\";i:79;s:29:\"comment-content/style.min.css\";i:80;s:30:\"comment-template/style-rtl.css\";i:81;s:34:\"comment-template/style-rtl.min.css\";i:82;s:26:\"comment-template/style.css\";i:83;s:30:\"comment-template/style.min.css\";i:84;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:85;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:86;s:38:\"comments-pagination-numbers/editor.css\";i:87;s:42:\"comments-pagination-numbers/editor.min.css\";i:88;s:34:\"comments-pagination/editor-rtl.css\";i:89;s:38:\"comments-pagination/editor-rtl.min.css\";i:90;s:30:\"comments-pagination/editor.css\";i:91;s:34:\"comments-pagination/editor.min.css\";i:92;s:33:\"comments-pagination/style-rtl.css\";i:93;s:37:\"comments-pagination/style-rtl.min.css\";i:94;s:29:\"comments-pagination/style.css\";i:95;s:33:\"comments-pagination/style.min.css\";i:96;s:29:\"comments-title/editor-rtl.css\";i:97;s:33:\"comments-title/editor-rtl.min.css\";i:98;s:25:\"comments-title/editor.css\";i:99;s:29:\"comments-title/editor.min.css\";i:100;s:23:\"comments/editor-rtl.css\";i:101;s:27:\"comments/editor-rtl.min.css\";i:102;s:19:\"comments/editor.css\";i:103;s:23:\"comments/editor.min.css\";i:104;s:22:\"comments/style-rtl.css\";i:105;s:26:\"comments/style-rtl.min.css\";i:106;s:18:\"comments/style.css\";i:107;s:22:\"comments/style.min.css\";i:108;s:20:\"cover/editor-rtl.css\";i:109;s:24:\"cover/editor-rtl.min.css\";i:110;s:16:\"cover/editor.css\";i:111;s:20:\"cover/editor.min.css\";i:112;s:19:\"cover/style-rtl.css\";i:113;s:23:\"cover/style-rtl.min.css\";i:114;s:15:\"cover/style.css\";i:115;s:19:\"cover/style.min.css\";i:116;s:22:\"details/editor-rtl.css\";i:117;s:26:\"details/editor-rtl.min.css\";i:118;s:18:\"details/editor.css\";i:119;s:22:\"details/editor.min.css\";i:120;s:21:\"details/style-rtl.css\";i:121;s:25:\"details/style-rtl.min.css\";i:122;s:17:\"details/style.css\";i:123;s:21:\"details/style.min.css\";i:124;s:20:\"embed/editor-rtl.css\";i:125;s:24:\"embed/editor-rtl.min.css\";i:126;s:16:\"embed/editor.css\";i:127;s:20:\"embed/editor.min.css\";i:128;s:19:\"embed/style-rtl.css\";i:129;s:23:\"embed/style-rtl.min.css\";i:130;s:15:\"embed/style.css\";i:131;s:19:\"embed/style.min.css\";i:132;s:19:\"embed/theme-rtl.css\";i:133;s:23:\"embed/theme-rtl.min.css\";i:134;s:15:\"embed/theme.css\";i:135;s:19:\"embed/theme.min.css\";i:136;s:19:\"file/editor-rtl.css\";i:137;s:23:\"file/editor-rtl.min.css\";i:138;s:15:\"file/editor.css\";i:139;s:19:\"file/editor.min.css\";i:140;s:18:\"file/style-rtl.css\";i:141;s:22:\"file/style-rtl.min.css\";i:142;s:14:\"file/style.css\";i:143;s:18:\"file/style.min.css\";i:144;s:23:\"footnotes/style-rtl.css\";i:145;s:27:\"footnotes/style-rtl.min.css\";i:146;s:19:\"footnotes/style.css\";i:147;s:23:\"footnotes/style.min.css\";i:148;s:23:\"freeform/editor-rtl.css\";i:149;s:27:\"freeform/editor-rtl.min.css\";i:150;s:19:\"freeform/editor.css\";i:151;s:23:\"freeform/editor.min.css\";i:152;s:22:\"gallery/editor-rtl.css\";i:153;s:26:\"gallery/editor-rtl.min.css\";i:154;s:18:\"gallery/editor.css\";i:155;s:22:\"gallery/editor.min.css\";i:156;s:21:\"gallery/style-rtl.css\";i:157;s:25:\"gallery/style-rtl.min.css\";i:158;s:17:\"gallery/style.css\";i:159;s:21:\"gallery/style.min.css\";i:160;s:21:\"gallery/theme-rtl.css\";i:161;s:25:\"gallery/theme-rtl.min.css\";i:162;s:17:\"gallery/theme.css\";i:163;s:21:\"gallery/theme.min.css\";i:164;s:20:\"group/editor-rtl.css\";i:165;s:24:\"group/editor-rtl.min.css\";i:166;s:16:\"group/editor.css\";i:167;s:20:\"group/editor.min.css\";i:168;s:19:\"group/style-rtl.css\";i:169;s:23:\"group/style-rtl.min.css\";i:170;s:15:\"group/style.css\";i:171;s:19:\"group/style.min.css\";i:172;s:19:\"group/theme-rtl.css\";i:173;s:23:\"group/theme-rtl.min.css\";i:174;s:15:\"group/theme.css\";i:175;s:19:\"group/theme.min.css\";i:176;s:21:\"heading/style-rtl.css\";i:177;s:25:\"heading/style-rtl.min.css\";i:178;s:17:\"heading/style.css\";i:179;s:21:\"heading/style.min.css\";i:180;s:19:\"html/editor-rtl.css\";i:181;s:23:\"html/editor-rtl.min.css\";i:182;s:15:\"html/editor.css\";i:183;s:19:\"html/editor.min.css\";i:184;s:20:\"image/editor-rtl.css\";i:185;s:24:\"image/editor-rtl.min.css\";i:186;s:16:\"image/editor.css\";i:187;s:20:\"image/editor.min.css\";i:188;s:19:\"image/style-rtl.css\";i:189;s:23:\"image/style-rtl.min.css\";i:190;s:15:\"image/style.css\";i:191;s:19:\"image/style.min.css\";i:192;s:19:\"image/theme-rtl.css\";i:193;s:23:\"image/theme-rtl.min.css\";i:194;s:15:\"image/theme.css\";i:195;s:19:\"image/theme.min.css\";i:196;s:29:\"latest-comments/style-rtl.css\";i:197;s:33:\"latest-comments/style-rtl.min.css\";i:198;s:25:\"latest-comments/style.css\";i:199;s:29:\"latest-comments/style.min.css\";i:200;s:27:\"latest-posts/editor-rtl.css\";i:201;s:31:\"latest-posts/editor-rtl.min.css\";i:202;s:23:\"latest-posts/editor.css\";i:203;s:27:\"latest-posts/editor.min.css\";i:204;s:26:\"latest-posts/style-rtl.css\";i:205;s:30:\"latest-posts/style-rtl.min.css\";i:206;s:22:\"latest-posts/style.css\";i:207;s:26:\"latest-posts/style.min.css\";i:208;s:18:\"list/style-rtl.css\";i:209;s:22:\"list/style-rtl.min.css\";i:210;s:14:\"list/style.css\";i:211;s:18:\"list/style.min.css\";i:212;s:25:\"media-text/editor-rtl.css\";i:213;s:29:\"media-text/editor-rtl.min.css\";i:214;s:21:\"media-text/editor.css\";i:215;s:25:\"media-text/editor.min.css\";i:216;s:24:\"media-text/style-rtl.css\";i:217;s:28:\"media-text/style-rtl.min.css\";i:218;s:20:\"media-text/style.css\";i:219;s:24:\"media-text/style.min.css\";i:220;s:19:\"more/editor-rtl.css\";i:221;s:23:\"more/editor-rtl.min.css\";i:222;s:15:\"more/editor.css\";i:223;s:19:\"more/editor.min.css\";i:224;s:30:\"navigation-link/editor-rtl.css\";i:225;s:34:\"navigation-link/editor-rtl.min.css\";i:226;s:26:\"navigation-link/editor.css\";i:227;s:30:\"navigation-link/editor.min.css\";i:228;s:29:\"navigation-link/style-rtl.css\";i:229;s:33:\"navigation-link/style-rtl.min.css\";i:230;s:25:\"navigation-link/style.css\";i:231;s:29:\"navigation-link/style.min.css\";i:232;s:33:\"navigation-submenu/editor-rtl.css\";i:233;s:37:\"navigation-submenu/editor-rtl.min.css\";i:234;s:29:\"navigation-submenu/editor.css\";i:235;s:33:\"navigation-submenu/editor.min.css\";i:236;s:25:\"navigation/editor-rtl.css\";i:237;s:29:\"navigation/editor-rtl.min.css\";i:238;s:21:\"navigation/editor.css\";i:239;s:25:\"navigation/editor.min.css\";i:240;s:24:\"navigation/style-rtl.css\";i:241;s:28:\"navigation/style-rtl.min.css\";i:242;s:20:\"navigation/style.css\";i:243;s:24:\"navigation/style.min.css\";i:244;s:23:\"nextpage/editor-rtl.css\";i:245;s:27:\"nextpage/editor-rtl.min.css\";i:246;s:19:\"nextpage/editor.css\";i:247;s:23:\"nextpage/editor.min.css\";i:248;s:24:\"page-list/editor-rtl.css\";i:249;s:28:\"page-list/editor-rtl.min.css\";i:250;s:20:\"page-list/editor.css\";i:251;s:24:\"page-list/editor.min.css\";i:252;s:23:\"page-list/style-rtl.css\";i:253;s:27:\"page-list/style-rtl.min.css\";i:254;s:19:\"page-list/style.css\";i:255;s:23:\"page-list/style.min.css\";i:256;s:24:\"paragraph/editor-rtl.css\";i:257;s:28:\"paragraph/editor-rtl.min.css\";i:258;s:20:\"paragraph/editor.css\";i:259;s:24:\"paragraph/editor.min.css\";i:260;s:23:\"paragraph/style-rtl.css\";i:261;s:27:\"paragraph/style-rtl.min.css\";i:262;s:19:\"paragraph/style.css\";i:263;s:23:\"paragraph/style.min.css\";i:264;s:25:\"post-author/style-rtl.css\";i:265;s:29:\"post-author/style-rtl.min.css\";i:266;s:21:\"post-author/style.css\";i:267;s:25:\"post-author/style.min.css\";i:268;s:33:\"post-comments-form/editor-rtl.css\";i:269;s:37:\"post-comments-form/editor-rtl.min.css\";i:270;s:29:\"post-comments-form/editor.css\";i:271;s:33:\"post-comments-form/editor.min.css\";i:272;s:32:\"post-comments-form/style-rtl.css\";i:273;s:36:\"post-comments-form/style-rtl.min.css\";i:274;s:28:\"post-comments-form/style.css\";i:275;s:32:\"post-comments-form/style.min.css\";i:276;s:27:\"post-content/editor-rtl.css\";i:277;s:31:\"post-content/editor-rtl.min.css\";i:278;s:23:\"post-content/editor.css\";i:279;s:27:\"post-content/editor.min.css\";i:280;s:23:\"post-date/style-rtl.css\";i:281;s:27:\"post-date/style-rtl.min.css\";i:282;s:19:\"post-date/style.css\";i:283;s:23:\"post-date/style.min.css\";i:284;s:27:\"post-excerpt/editor-rtl.css\";i:285;s:31:\"post-excerpt/editor-rtl.min.css\";i:286;s:23:\"post-excerpt/editor.css\";i:287;s:27:\"post-excerpt/editor.min.css\";i:288;s:26:\"post-excerpt/style-rtl.css\";i:289;s:30:\"post-excerpt/style-rtl.min.css\";i:290;s:22:\"post-excerpt/style.css\";i:291;s:26:\"post-excerpt/style.min.css\";i:292;s:34:\"post-featured-image/editor-rtl.css\";i:293;s:38:\"post-featured-image/editor-rtl.min.css\";i:294;s:30:\"post-featured-image/editor.css\";i:295;s:34:\"post-featured-image/editor.min.css\";i:296;s:33:\"post-featured-image/style-rtl.css\";i:297;s:37:\"post-featured-image/style-rtl.min.css\";i:298;s:29:\"post-featured-image/style.css\";i:299;s:33:\"post-featured-image/style.min.css\";i:300;s:34:\"post-navigation-link/style-rtl.css\";i:301;s:38:\"post-navigation-link/style-rtl.min.css\";i:302;s:30:\"post-navigation-link/style.css\";i:303;s:34:\"post-navigation-link/style.min.css\";i:304;s:28:\"post-template/editor-rtl.css\";i:305;s:32:\"post-template/editor-rtl.min.css\";i:306;s:24:\"post-template/editor.css\";i:307;s:28:\"post-template/editor.min.css\";i:308;s:27:\"post-template/style-rtl.css\";i:309;s:31:\"post-template/style-rtl.min.css\";i:310;s:23:\"post-template/style.css\";i:311;s:27:\"post-template/style.min.css\";i:312;s:24:\"post-terms/style-rtl.css\";i:313;s:28:\"post-terms/style-rtl.min.css\";i:314;s:20:\"post-terms/style.css\";i:315;s:24:\"post-terms/style.min.css\";i:316;s:24:\"post-title/style-rtl.css\";i:317;s:28:\"post-title/style-rtl.min.css\";i:318;s:20:\"post-title/style.css\";i:319;s:24:\"post-title/style.min.css\";i:320;s:26:\"preformatted/style-rtl.css\";i:321;s:30:\"preformatted/style-rtl.min.css\";i:322;s:22:\"preformatted/style.css\";i:323;s:26:\"preformatted/style.min.css\";i:324;s:24:\"pullquote/editor-rtl.css\";i:325;s:28:\"pullquote/editor-rtl.min.css\";i:326;s:20:\"pullquote/editor.css\";i:327;s:24:\"pullquote/editor.min.css\";i:328;s:23:\"pullquote/style-rtl.css\";i:329;s:27:\"pullquote/style-rtl.min.css\";i:330;s:19:\"pullquote/style.css\";i:331;s:23:\"pullquote/style.min.css\";i:332;s:23:\"pullquote/theme-rtl.css\";i:333;s:27:\"pullquote/theme-rtl.min.css\";i:334;s:19:\"pullquote/theme.css\";i:335;s:23:\"pullquote/theme.min.css\";i:336;s:39:\"query-pagination-numbers/editor-rtl.css\";i:337;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:338;s:35:\"query-pagination-numbers/editor.css\";i:339;s:39:\"query-pagination-numbers/editor.min.css\";i:340;s:31:\"query-pagination/editor-rtl.css\";i:341;s:35:\"query-pagination/editor-rtl.min.css\";i:342;s:27:\"query-pagination/editor.css\";i:343;s:31:\"query-pagination/editor.min.css\";i:344;s:30:\"query-pagination/style-rtl.css\";i:345;s:34:\"query-pagination/style-rtl.min.css\";i:346;s:26:\"query-pagination/style.css\";i:347;s:30:\"query-pagination/style.min.css\";i:348;s:25:\"query-title/style-rtl.css\";i:349;s:29:\"query-title/style-rtl.min.css\";i:350;s:21:\"query-title/style.css\";i:351;s:25:\"query-title/style.min.css\";i:352;s:20:\"query/editor-rtl.css\";i:353;s:24:\"query/editor-rtl.min.css\";i:354;s:16:\"query/editor.css\";i:355;s:20:\"query/editor.min.css\";i:356;s:19:\"quote/style-rtl.css\";i:357;s:23:\"quote/style-rtl.min.css\";i:358;s:15:\"quote/style.css\";i:359;s:19:\"quote/style.min.css\";i:360;s:19:\"quote/theme-rtl.css\";i:361;s:23:\"quote/theme-rtl.min.css\";i:362;s:15:\"quote/theme.css\";i:363;s:19:\"quote/theme.min.css\";i:364;s:23:\"read-more/style-rtl.css\";i:365;s:27:\"read-more/style-rtl.min.css\";i:366;s:19:\"read-more/style.css\";i:367;s:23:\"read-more/style.min.css\";i:368;s:18:\"rss/editor-rtl.css\";i:369;s:22:\"rss/editor-rtl.min.css\";i:370;s:14:\"rss/editor.css\";i:371;s:18:\"rss/editor.min.css\";i:372;s:17:\"rss/style-rtl.css\";i:373;s:21:\"rss/style-rtl.min.css\";i:374;s:13:\"rss/style.css\";i:375;s:17:\"rss/style.min.css\";i:376;s:21:\"search/editor-rtl.css\";i:377;s:25:\"search/editor-rtl.min.css\";i:378;s:17:\"search/editor.css\";i:379;s:21:\"search/editor.min.css\";i:380;s:20:\"search/style-rtl.css\";i:381;s:24:\"search/style-rtl.min.css\";i:382;s:16:\"search/style.css\";i:383;s:20:\"search/style.min.css\";i:384;s:20:\"search/theme-rtl.css\";i:385;s:24:\"search/theme-rtl.min.css\";i:386;s:16:\"search/theme.css\";i:387;s:20:\"search/theme.min.css\";i:388;s:24:\"separator/editor-rtl.css\";i:389;s:28:\"separator/editor-rtl.min.css\";i:390;s:20:\"separator/editor.css\";i:391;s:24:\"separator/editor.min.css\";i:392;s:23:\"separator/style-rtl.css\";i:393;s:27:\"separator/style-rtl.min.css\";i:394;s:19:\"separator/style.css\";i:395;s:23:\"separator/style.min.css\";i:396;s:23:\"separator/theme-rtl.css\";i:397;s:27:\"separator/theme-rtl.min.css\";i:398;s:19:\"separator/theme.css\";i:399;s:23:\"separator/theme.min.css\";i:400;s:24:\"shortcode/editor-rtl.css\";i:401;s:28:\"shortcode/editor-rtl.min.css\";i:402;s:20:\"shortcode/editor.css\";i:403;s:24:\"shortcode/editor.min.css\";i:404;s:24:\"site-logo/editor-rtl.css\";i:405;s:28:\"site-logo/editor-rtl.min.css\";i:406;s:20:\"site-logo/editor.css\";i:407;s:24:\"site-logo/editor.min.css\";i:408;s:23:\"site-logo/style-rtl.css\";i:409;s:27:\"site-logo/style-rtl.min.css\";i:410;s:19:\"site-logo/style.css\";i:411;s:23:\"site-logo/style.min.css\";i:412;s:27:\"site-tagline/editor-rtl.css\";i:413;s:31:\"site-tagline/editor-rtl.min.css\";i:414;s:23:\"site-tagline/editor.css\";i:415;s:27:\"site-tagline/editor.min.css\";i:416;s:25:\"site-title/editor-rtl.css\";i:417;s:29:\"site-title/editor-rtl.min.css\";i:418;s:21:\"site-title/editor.css\";i:419;s:25:\"site-title/editor.min.css\";i:420;s:24:\"site-title/style-rtl.css\";i:421;s:28:\"site-title/style-rtl.min.css\";i:422;s:20:\"site-title/style.css\";i:423;s:24:\"site-title/style.min.css\";i:424;s:26:\"social-link/editor-rtl.css\";i:425;s:30:\"social-link/editor-rtl.min.css\";i:426;s:22:\"social-link/editor.css\";i:427;s:26:\"social-link/editor.min.css\";i:428;s:27:\"social-links/editor-rtl.css\";i:429;s:31:\"social-links/editor-rtl.min.css\";i:430;s:23:\"social-links/editor.css\";i:431;s:27:\"social-links/editor.min.css\";i:432;s:26:\"social-links/style-rtl.css\";i:433;s:30:\"social-links/style-rtl.min.css\";i:434;s:22:\"social-links/style.css\";i:435;s:26:\"social-links/style.min.css\";i:436;s:21:\"spacer/editor-rtl.css\";i:437;s:25:\"spacer/editor-rtl.min.css\";i:438;s:17:\"spacer/editor.css\";i:439;s:21:\"spacer/editor.min.css\";i:440;s:20:\"spacer/style-rtl.css\";i:441;s:24:\"spacer/style-rtl.min.css\";i:442;s:16:\"spacer/style.css\";i:443;s:20:\"spacer/style.min.css\";i:444;s:20:\"table/editor-rtl.css\";i:445;s:24:\"table/editor-rtl.min.css\";i:446;s:16:\"table/editor.css\";i:447;s:20:\"table/editor.min.css\";i:448;s:19:\"table/style-rtl.css\";i:449;s:23:\"table/style-rtl.min.css\";i:450;s:15:\"table/style.css\";i:451;s:19:\"table/style.min.css\";i:452;s:19:\"table/theme-rtl.css\";i:453;s:23:\"table/theme-rtl.min.css\";i:454;s:15:\"table/theme.css\";i:455;s:19:\"table/theme.min.css\";i:456;s:23:\"tag-cloud/style-rtl.css\";i:457;s:27:\"tag-cloud/style-rtl.min.css\";i:458;s:19:\"tag-cloud/style.css\";i:459;s:23:\"tag-cloud/style.min.css\";i:460;s:28:\"template-part/editor-rtl.css\";i:461;s:32:\"template-part/editor-rtl.min.css\";i:462;s:24:\"template-part/editor.css\";i:463;s:28:\"template-part/editor.min.css\";i:464;s:27:\"template-part/theme-rtl.css\";i:465;s:31:\"template-part/theme-rtl.min.css\";i:466;s:23:\"template-part/theme.css\";i:467;s:27:\"template-part/theme.min.css\";i:468;s:30:\"term-description/style-rtl.css\";i:469;s:34:\"term-description/style-rtl.min.css\";i:470;s:26:\"term-description/style.css\";i:471;s:30:\"term-description/style.min.css\";i:472;s:27:\"text-columns/editor-rtl.css\";i:473;s:31:\"text-columns/editor-rtl.min.css\";i:474;s:23:\"text-columns/editor.css\";i:475;s:27:\"text-columns/editor.min.css\";i:476;s:26:\"text-columns/style-rtl.css\";i:477;s:30:\"text-columns/style-rtl.min.css\";i:478;s:22:\"text-columns/style.css\";i:479;s:26:\"text-columns/style.min.css\";i:480;s:19:\"verse/style-rtl.css\";i:481;s:23:\"verse/style-rtl.min.css\";i:482;s:15:\"verse/style.css\";i:483;s:19:\"verse/style.min.css\";i:484;s:20:\"video/editor-rtl.css\";i:485;s:24:\"video/editor-rtl.min.css\";i:486;s:16:\"video/editor.css\";i:487;s:20:\"video/editor.min.css\";i:488;s:19:\"video/style-rtl.css\";i:489;s:23:\"video/style-rtl.min.css\";i:490;s:15:\"video/style.css\";i:491;s:19:\"video/style.min.css\";i:492;s:19:\"video/theme-rtl.css\";i:493;s:23:\"video/theme-rtl.min.css\";i:494;s:15:\"video/theme.css\";i:495;s:19:\"video/theme.min.css\";}}","on"),
("918","wp_attachment_pages_enabled","1","on"),
("919","user_count","4","off"),
("920","db_upgraded","","auto"),
("929","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:15:\"info@creaweb.ma\";s:7:\"version\";s:5:\"6.6.2\";s:9:\"timestamp\";i:1730464392;}","no"),
("930","_site_transient_timeout_php_check_1a31e573deff9bf63840fe4b3ef8afb9","1731069196","no"),
("931","_site_transient_php_check_1a31e573deff9bf63840fe4b3ef8afb9","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","no"),
("932","_transient_health-check-site-status-result","{\"good\":14,\"recommended\":4,\"critical\":1}","yes"),
("934","_transient_timeout_wsal__file_list_fecc01d4ac37309ee0425c894ca6dfc1","1730550801","off"),
("935","_transient_wsal__file_list_fecc01d4ac37309ee0425c894ca6dfc1","a:10:{i:0;s:100:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log/classes/Views/AuditLog.php\";i:1;s:110:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log/classes/Views/EmailNotifications.php\";i:2;s:102:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log/classes/Views/ExternalDB.php\";i:3;s:96:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log/classes/Views/Help.php\";i:4;s:102:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log/classes/Views/LogInUsers.php\";i:5;s:99:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log/classes/Views/Reports.php\";i:6;s:98:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log/classes/Views/Search.php\";i:7;s:100:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log/classes/Views/Settings.php\";i:8;s:103:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log/classes/Views/SetupWizard.php\";i:9;s:104:\"C:\\wamp64\\www\\duplicator-creaweb\\wp-content\\plugins\\wp-security-audit-log/classes/Views/ToggleAlerts.php\";}","off"),
("964","_transient_timeout_fs_wsalp","1730551143","off"),
("965","_transient_fs_wsalp","no","off"),
("969","_site_transient_timeout_it-updater-get_package_details-cad50","1730551148","off"),
("970","_site_transient_it-updater-get_package_details-cad50","a:3:{s:8:\"packages\";a:1:{s:20:\"ithemes-security-pro\";a:1:{s:5:\"error\";a:3:{s:4:\"code\";i:8012;s:4:\"type\";s:33:\"ITXAPI_Updater_Missing_Legacy_Key\";s:7:\"message\";s:55:\"A legacy key was not provided with the package details.\";}}}s:9:\"time_skew\";i:0;s:13:\"min_poll_time\";i:30;}","off"),
("973","can_compress_scripts","1","on"),
("984","wsal_disabled-alerts","a:26:{i:0;s:4:\"5010\";i:1;s:4:\"5011\";i:2;s:4:\"5012\";i:3;s:4:\"5013\";i:4;s:4:\"5014\";i:5;s:4:\"5015\";i:6;s:4:\"5016\";i:7;s:4:\"5017\";i:8;s:4:\"5018\";i:9;s:4:\"5022\";i:10;s:4:\"5023\";i:11;s:4:\"5024\";i:12;i:5010;i:13;i:5011;i:14;i:5012;i:15;i:5013;i:16;i:5014;i:17;i:5015;i:18;i:5016;i:19;i:5017;i:20;i:5018;i:21;i:5022;i:22;i:5023;i:23;i:5024;i:24;i:6069;i:25;i:6070;}","off"),
("986","wsal_pruning-date","6 months","off"),
("987","wsal_pruning-date-e","no","off"),
("990","wsal_frontend-events","a:3:{s:8:\"register\";b:1;s:5:\"login\";b:1;s:11:\"woocommerce\";b:0;}","on"),
("991","wsal_setup-modal-dismissed","yes","on"),
("993","wsal_extensions-merged-notice","1","off"),
("994","wsal_free-search-try","1","off"),
("995","wsal_plugin_version","5.2.1","off"),
("998","action_scheduler_hybrid_store_demarkation","15","auto"),
("999","schema-ActionScheduler_StoreSchema","7.0.1730464797","auto"),
("1000","schema-ActionScheduler_LoggerSchema","3.0.1730464797","auto"),
("1003","_transient_timeout_as-post-store-dependencies-met","1730551197","off"),
("1004","_transient_as-post-store-dependencies-met","yes","off"),
("1006","easy_wp_smtp_mail_key","PIR/M4WPwDlM/UtD2WfqHEkdz6+m1dNo+JAtB2fZ6C8=","auto"),
("1007","easy_wp_smtp","a:12:{s:4:\"mail\";a:10:{s:10:\"from_email\";s:15:\"test@creaweb.ma\";s:9:\"from_name\";s:10:\"CREAWEB.MA\";s:15:\"from_name_force\";b:0;s:14:\"reply_to_email\";s:0:\"\";s:21:\"reply_to_replace_from\";b:0;s:10:\"bcc_emails\";s:0:\"\";s:31:\"from_email_force_exclude_emails\";s:0:\"\";s:6:\"mailer\";s:4:\"smtp\";s:16:\"from_email_force\";b:1;s:8:\"advanced\";b:0;}s:4:\"smtp\";a:7:{s:4:\"host\";s:23:\"mail.prowebplanners.com\";s:10:\"encryption\";s:3:\"ssl\";s:4:\"port\";i:465;s:4:\"auth\";b:1;s:4:\"user\";s:23:\"smtp@prowebplanners.com\";s:4:\"pass\";s:80:\"iOHJYNZiQ5mWm7mdybxxPZnsg1PUMQ9qvA1HVR1OR0qtJWVX0/O4s1gPN6uYba7kbz+v+Iegkbivhw==\";s:7:\"autotls\";b:0;}s:7:\"general\";a:3:{s:23:\"allow_smtp_insecure_ssl\";b:0;s:12:\"domain_check\";b:0;s:28:\"domain_check_allowed_domains\";s:15:\"192.168.100.118\";}s:10:\"deprecated\";a:1:{s:17:\"debug_log_enabled\";b:0;}s:9:\"sendlayer\";a:1:{s:7:\"api_key\";s:0:\"\";}s:10:\"sendinblue\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";}s:7:\"mailgun\";a:3:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";s:6:\"region\";s:2:\"US\";}s:8:\"postmark\";a:2:{s:16:\"server_api_token\";s:0:\"\";s:14:\"message_stream\";s:0:\"\";}s:8:\"sendgrid\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";}s:7:\"smtpcom\";a:2:{s:7:\"api_key\";s:0:\"\";s:7:\"channel\";s:0:\"\";}s:7:\"smtp2go\";a:1:{s:7:\"api_key\";s:0:\"\";}s:9:\"sparkpost\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"region\";s:2:\"US\";}}","off"),
("1008","easy_wp_smtp_test_email","a:3:{s:2:\"to\";s:19:\"mehdidev@creaweb.ma\";s:7:\"subject\";s:4:\"test\";s:7:\"message\";s:3:\"ttt\";}","off"),
("1009","easy_wp_smtp_deprecated_options_migration_version","1","on"),
("1010","easy_wp_smtp_migration_version","1","on"),
("1011","easy_wp_smtp_debug_events_db_version","1","on"),
("1012","_transient_timeout_action_scheduler_last_pastdue_actions_check","1730486398","off"),
("1013","_transient_action_scheduler_last_pastdue_actions_check","1730464798","off"),
("1014","easy_wp_smtp_user_feedback_notice","a:2:{s:4:\"time\";i:1730464798;s:9:\"dismissed\";b:0;}","auto"),
("1015","action_scheduler_lock_async-request-runner","6724e1d99d7026.86546058|1730470421","no"),
("1026","_site_transient_wp_plugin_dependencies_plugin_data","a:0:{}","off"),
("1030","_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a","1730475880","off"),
("1031","_site_transient_poptags_40cd750bba9870f18aada2478b24840a","O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:6579;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4852;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2793;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2683;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2084;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1979;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1928;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1772;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1586;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1586;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1548;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1543;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1513;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1503;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1435;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1316;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1311;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1180;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1170;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1162;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1149;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1027;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1019;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:991;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:982;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:947;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:937;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:918;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:907;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:900;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:898;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:896;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:895;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:844;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:828;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:816;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:808;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:779;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:778;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:757;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:757;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:754;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:733;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:717;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:702;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:698;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:673;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:663;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:657;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:633;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:632;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:631;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:613;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:612;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:606;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:603;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:601;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:601;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:598;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:597;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:592;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:582;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:577;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:576;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:574;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:573;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:568;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:566;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:554;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:551;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:542;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:539;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:532;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:528;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:524;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:521;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:515;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:509;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:501;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:492;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:486;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:459;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:459;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:452;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:451;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:450;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:450;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:449;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:444;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:438;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:436;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:433;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:430;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:430;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:419;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:417;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:415;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:404;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:397;}s:16:\"google-analytics\";a:3:{s:4:\"name\";s:16:\"google analytics\";s:4:\"slug\";s:16:\"google-analytics\";s:5:\"count\";i:392;}}","off"),
("1046","stellarwp_telemetry_last_send","2024-11-01 12:48:28","auto"),
("1047","stellarwp_telemetry","a:2:{s:7:\"plugins\";a:1:{s:14:\"solid-security\";a:2:{s:7:\"wp_slug\";s:45:\"ithemes-security-pro/ithemes-security-pro.php\";s:5:\"optin\";b:1;}}s:5:\"token\";s:64:\"cc045f0dcc6da5acc23e36e5e9bb4822593533b082d872372b11998df67b32c6\";}","auto"),
("1052","_site_transient_timeout_it-updater-get_package_details-ec801","1730551532","off"),
("1053","_site_transient_it-updater-get_package_details-ec801","a:3:{s:8:\"packages\";a:1:{s:20:\"ithemes-security-pro\";a:1:{s:5:\"error\";a:3:{s:4:\"code\";i:8012;s:4:\"type\";s:33:\"ITXAPI_Updater_Missing_Legacy_Key\";s:7:\"message\";s:55:\"A legacy key was not provided with the package details.\";}}}s:9:\"time_skew\";i:0;s:13:\"min_poll_time\";i:30;}","off"),
("1073","duplicator_pro_capabilities","a:9:{s:20:\"duplicator_pro_basic\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:21:\"duplicator_pro_create\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:23:\"duplicator_pro_schedule\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:22:\"duplicator_pro_storage\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:29:\"duplicator_pro_backup_restore\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:21:\"duplicator_pro_import\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:21:\"duplicator_pro_export\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:23:\"duplicator_pro_settings\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}s:22:\"duplicator_pro_license\";a:2:{s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:5:\"users\";a:0:{}}}","auto"),
("1075","edd_sl_d4cddcbfacec1cb84c2108addd3c8f99","a:2:{s:7:\"timeout\";i:1730476099;s:5:\"value\";s:1609:\"{\"new_version\":\"4.5.19.3\",\"stable_version\":\"4.5.19.3\",\"name\":\"Duplicator Pro\",\"slug\":\"duplicator-pro\",\"url\":\"https:\\/\\/duplicator.com\\/downloads\\/duplicator-pro\\/?changelog=1\",\"last_updated\":\"2024-10-30 17:51:00\",\"homepage\":\"https:\\/\\/duplicator.com\\/downloads\\/duplicator-pro\\/\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"<p>Duplicator Pro backup and migration WordPress plugin<\\/p>\\n\",\"changelog\":\"<p>Please go here to find the Duplicator Pro changelog:<\\/p>\\n<p>https:\\/\\/duplicator.com\\/knowledge-base\\/changelog\\/<\\/p>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":{\"1x\":\"https:\\/\\/duplicator.com\\/wp-content\\/uploads\\/edd\\/2023\\/10\\/icon-256x256-1-128x128.png\",\"2x\":\"https:\\/\\/duplicator.com\\/wp-content\\/uploads\\/edd\\/2023\\/10\\/icon-256x256-1.png\"},\"msg\":\"No license key has been provided.\",\"contributors\":{\"seedprod\":{\"display_name\":\"seedprod\",\"profile\":\"\\/\\/profiles.wordpress.org\\/seedprod\",\"avatar\":\"https:\\/\\/wordpress.org\\/grav-redirect.php?user=seedprod\"},\"smub\":{\"display_name\":\"smub\",\"profile\":\"\\/\\/profiles.wordpress.org\\/smub\",\"avatar\":\"https:\\/\\/wordpress.org\\/grav-redirect.php?user=smub\"},\"andreamk\":{\"display_name\":\"andreamk\",\"profile\":\"\\/\\/profiles.wordpress.org\\/andreamk\",\"avatar\":\"https:\\/\\/wordpress.org\\/grav-redirect.php?user=andreamk\"}},\"tested\":\"6.6.99\",\"description\":[\"<p>Duplicator Pro backup and migration WordPress plugin<\\/p>\\n\"],\"changelog\":[\"<p>Please go here to find the Duplicator Pro changelog:<\\/p>\\n<p>https:\\/\\/duplicator.com\\/knowledge-base\\/changelog\\/<\\/p>\\n\"],\"plugin\":\"duplicator-pro\\/duplicator-pro.php\",\"id\":\"duplicator-pro\\/duplicator-pro.php\"}\";}","off"),
("1076","duplicator_pro_install_info","a:3:{s:7:\"version\";s:8:\"4.5.19.3\";s:4:\"time\";i:1730465297;s:10:\"updateTime\";i:1730465297;}","off"),
("1077","duplicator_pro_plugin_data_stats","{\n    \"CL_-=_-=\": \"Duplicator\\\\Utils\\\\UsageStatistics\\\\PluginData\",\n    \"lastSendTime\": 0,\n    \"identifier\": \"ld81yTzp8eI,hrIMeGw.+7ZMKme0Bwqij7f.NkK__s6j\",\n    \"plugin\": \"dup-pro\",\n    \"pluginStatus\": \"active\",\n    \"anonymous\": false,\n    \"buildCount\": 1,\n    \"buildLastDate\": 1730470192,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"packagesBuildCompFullCount\": 1,\n    \"packagesBuildCompDbOnlyCount\": 0,\n    \"packagesBuildCompMdOnlyCount\": 0,\n    \"packagesBuildCompCustomCount\": 0,\n    \"packagesBuildCompCustomOnlyActiveCount\": 0,\n    \"schedulesBuildCount\": 0,\n    \"schedulesBuildLastDate\": 0,\n    \"schedulesBuildFailedCount\": 0,\n    \"schedulesBuildFailedLastDate\": 0,\n    \"schedulesBuildCompFullCount\": 0,\n    \"schedulesBuildCompDbOnlyCount\": 0,\n    \"schedulesBuildCompMdOnlyCount\": 0,\n    \"schedulesBuildCompCustomCount\": 0,\n    \"schedulesBuildCompCustomOnlyActiveCount\": 0,\n    \"usedRecoveryCount\": 0,\n    \"siteSizeMB\": 224.11,\n    \"siteNumFiles\": 18188,\n    \"siteDbSizeMB\": 2.84,\n    \"siteDbNumTables\": 71\n}","auto"),
("1078","duplicator_pro_notifications","a:4:{s:6:\"update\";i:1730465297;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}","auto"),
("1079","duplicator_expire_tmp_cleanup_check","{\"expire\":1730551697,\"value\":true}","on"),
("1080","duplicator_expire_daily_bootstrap_actions","{\"expire\":1730551697,\"value\":true}","on"),
("1083","duplicator_pro_license_key","activated","auto"),
("1084","stellarwp_telemetry_user_info","a:1:{s:4:\"user\";s:1133:\"{\"name\":\"mehdidev\",\"email\":\"mehdidev@creaweb.ma\",\"plugin_slug\":\"solid-security\",\"opt_in_text\":\"Hi mehdidev! At Solid, we\\u2019re committed to delivering top-notch services, and your valuable insights play a crucial role in helping us achieve that goal. We\\u2019re excited to invite you to participate in our opt-in program, designed to enhance your experience with Solid Security and contribute to the continuous improvement of StellarWP Products. By opting in, you allow our teams to access certain data related to your website data. This information will be used responsibly to gain insights into your preferences and patterns, enabling us to tailor our services and products to better meet your needs. Rest assured, we take data privacy seriously, and our usage of your information will adhere to the highest standards, respecting all relevant regulations and guidelines. Your trust means the world to us, and we are committed to maintaining the confidentiality and security of your data. To join this initiative and be part of shaping the future of Solid Security and StellarWP, simply click \\u201cAllow & Continue\\u201d below.\"}\";}","off"),
("1085","itsec_dismissed_notices","a:1:{i:0;s:15:\"welcome-solidwp\";}","off"),
("1092","_site_transient_timeout_browser_c9be4293e2195a39d8ceef2d00b07d0e","1731070163","off"),
("1093","_site_transient_browser_c9be4293e2195a39d8ceef2d00b07d0e","a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"132.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","off"),
("1094","_transient_timeout_easy_wp_smtp_error_debug_events_transient_30-days","1730468963","off"),
("1095","_transient_easy_wp_smtp_error_debug_events_transient_30-days","0","off"),
("1105","_transient_timeout_wsdst25-ame-menu-style-bundle.global.css","1733057494","off"),
("1106","_transient_wsdst25-ame-menu-style-bundle.global.css","a:3:{s:7:\"content\";s:0:\"\";s:12:\"lastModified\";i:0;s:10:\"expiration\";i:1733057494;}","off"),
("1107","_transient_wsdst25-ame-menu-style-bundle.global.meta","a:2:{s:12:\"lastModified\";i:0;s:14:\"isContentEmpty\";b:1;}","on"),
("1123","external_updates-ame-branding-add-on","O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1730466243;s:14:\"checkedVersion\";s:5:\"1.3.7\";s:6:\"update\";O:8:\"stdClass\":11:{s:4:\"slug\";s:19:\"ame-branding-add-on\";s:7:\"version\";s:5:\"1.3.7\";s:12:\"download_url\";N;s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:44:\"https://adminmenueditor.com/branding-add-on/\";s:6:\"tested\";s:5:\"6.4.1\";s:12:\"requires_php\";N;s:14:\"upgrade_notice\";N;s:5:\"icons\";a:0:{}s:8:\"filename\";s:43:\"ame-branding-add-on/ame-branding-add-on.php\";}s:11:\"updateClass\";s:50:\"YahnisElsts\\PluginUpdateChecker\\v5p3\\Plugin\\Update\";s:15:\"updateBaseClass\";s:13:\"Plugin\\Update\";}","off"),
("1132","current_theme","Twenty Twenty-Four","auto"),
("1133","theme_mods_twentytwentyfour","a:4:{i:0;b:0;s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;}","on"),
("1134","theme_switched","","auto"),
("1159","_site_transient_timeout_ithemes-security-news","1730552204","off"),
("1160","_site_transient_ithemes-security-news","a:19:{s:2:\"id\";i:102982;s:4:\"date\";s:19:\"2024-10-30T06:45:07\";s:4:\"slug\";s:46:\"wordpress-vulnerability-report-october-30-2024\";s:4:\"type\";s:4:\"post\";s:4:\"link\";s:72:\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/\";s:5:\"title\";a:1:{s:8:\"rendered\";s:51:\"WordPress Vulnerability Report — October 30, 2024\";}s:7:\"excerpt\";a:2:{s:8:\"rendered\";s:258:\"<p>Since last week, 251 new vulnerabilities emerged in the WordPress ecosystem including 245 plugins and 6 themes. 110 of the vulnerable plugins and themes remain unpatched, but Solid Security Pro users are protected by virtual patching from Patchstack.</p>\n\";s:9:\"protected\";b:0;}s:6:\"author\";i:59680;s:14:\"featured_media\";i:94501;s:3:\"acf\";a:0:{}s:10:\"yoast_head\";s:5901:\"<!-- This site is optimized with the Yoast SEO Premium plugin v20.8 (Yoast SEO v23.5) - https://yoast.com/wordpress/plugins/seo/ -->\n<title>WordPress Vulnerability Report — October 30, 2024 - SolidWP</title>\n<meta name=\"description\" content=\"Since last week, 251 new vulnerabilities emerged in the WordPress ecosystem including 245 plugins and 6 themes. 110 of the vulnerable plugins and themes remain unpatched, but Solid Security Pro users are protected by virtual patching from Patchstack.\" />\n<meta name=\"robots\" content=\"index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1\" />\n<link rel=\"canonical\" href=\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/\" />\n<meta property=\"og:locale\" content=\"en_US\" />\n<meta property=\"og:type\" content=\"article\" />\n<meta property=\"og:title\" content=\"WordPress Vulnerability Report — October 30, 2024\" />\n<meta property=\"og:description\" content=\"Each week, we report the latest vulnerabilities in WordPress plugins and themes. Vulnerable WordPress plugins and themes are among the reasons WordPress sites get hacked.\" />\n<meta property=\"og:url\" content=\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/\" />\n<meta property=\"og:site_name\" content=\"SolidWP\" />\n<meta property=\"article:published_time\" content=\"2024-10-30T13:45:07+00:00\" />\n<meta property=\"article:modified_time\" content=\"2024-10-30T13:45:09+00:00\" />\n<meta property=\"og:image\" content=\"https://solidwp.com/wp-content/uploads/2023/11/Vulnerability-Report-8.png\" />\n	<meta property=\"og:image:width\" content=\"2501\" />\n	<meta property=\"og:image:height\" content=\"1311\" />\n	<meta property=\"og:image:type\" content=\"image/png\" />\n<meta name=\"author\" content=\"Sarah Zuercher\" />\n<meta name=\"twitter:card\" content=\"summary_large_image\" />\n<meta name=\"twitter:description\" content=\"Each week, we report the latest vulnerabilities in WordPress plugins and themes. Vulnerable WordPress plugins and themes are among the reasons WordPress sites get hacked.\" />\n<meta name=\"twitter:image\" content=\"https://solidwp.com/wp-content/uploads/2023/11/Vulnerability-Report-1.png\" />\n<meta name=\"twitter:label1\" content=\"Written by\" />\n	<meta name=\"twitter:data1\" content=\"Sarah Zuercher\" />\n	<meta name=\"twitter:label2\" content=\"Est. reading time\" />\n	<meta name=\"twitter:data2\" content=\"45 minutes\" />\n<script type=\"application/ld+json\" class=\"yoast-schema-graph\">{\"@context\":\"https://schema.org\",\"@graph\":[{\"@type\":\"WebPage\",\"@id\":\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/\",\"url\":\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/\",\"name\":\"WordPress Vulnerability Report — October 30, 2024 - SolidWP\",\"isPartOf\":{\"@id\":\"https://solidwp.com/#website\"},\"primaryImageOfPage\":{\"@id\":\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/#primaryimage\"},\"image\":{\"@id\":\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/#primaryimage\"},\"thumbnailUrl\":\"https://solidwp.com/wp-content/uploads/2023/11/Vulnerability-Report-8.png\",\"datePublished\":\"2024-10-30T13:45:07+00:00\",\"dateModified\":\"2024-10-30T13:45:09+00:00\",\"author\":{\"@id\":\"https://solidwp.com/#/schema/person/f3ddd6bc130c734ee5bde67d2d0b983c\"},\"description\":\"Since last week, 251 new vulnerabilities emerged in the WordPress ecosystem including 245 plugins and 6 themes. 110 of the vulnerable plugins and themes remain unpatched, but Solid Security Pro users are protected by virtual patching from Patchstack.\",\"breadcrumb\":{\"@id\":\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/#breadcrumb\"},\"inLanguage\":\"en-US\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/\"]}]},{\"@type\":\"ImageObject\",\"inLanguage\":\"en-US\",\"@id\":\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/#primaryimage\",\"url\":\"https://solidwp.com/wp-content/uploads/2023/11/Vulnerability-Report-8.png\",\"contentUrl\":\"https://solidwp.com/wp-content/uploads/2023/11/Vulnerability-Report-8.png\",\"width\":2501,\"height\":1311,\"caption\":\"Line illustration showing a black application window on a purple gradient background overlaid with a large exclamation point alert icon and three bugs.\"},{\"@type\":\"BreadcrumbList\",\"@id\":\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/#breadcrumb\",\"itemListElement\":[{\"@type\":\"ListItem\",\"position\":1,\"name\":\"Home\",\"item\":\"https://solidwp.com/\"},{\"@type\":\"ListItem\",\"position\":2,\"name\":\"WordPress Vulnerability Report — October 30, 2024\"}]},{\"@type\":\"WebSite\",\"@id\":\"https://solidwp.com/#website\",\"url\":\"https://solidwp.com/\",\"name\":\"SolidWP\",\"description\":\"Protect Your WordPress Website with the Best Security Available\",\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":{\"@type\":\"EntryPoint\",\"urlTemplate\":\"https://solidwp.com/?s={search_term_string}\"},\"query-input\":{\"@type\":\"PropertyValueSpecification\",\"valueRequired\":true,\"valueName\":\"search_term_string\"}}],\"inLanguage\":\"en-US\"},{\"@type\":\"Person\",\"@id\":\"https://solidwp.com/#/schema/person/f3ddd6bc130c734ee5bde67d2d0b983c\",\"name\":\"Sarah Zuercher\",\"image\":{\"@type\":\"ImageObject\",\"inLanguage\":\"en-US\",\"@id\":\"https://solidwp.com/#/schema/person/image/\",\"url\":\"https://secure.gravatar.com/avatar/1b31f6d603fe91256e9b525a3e73613d?s=96&d=mm&r=g\",\"contentUrl\":\"https://secure.gravatar.com/avatar/1b31f6d603fe91256e9b525a3e73613d?s=96&d=mm&r=g\",\"caption\":\"Sarah Zuercher\"},\"description\":\"Sarah has been with StellarWP since 2024. As our marketing generalist, she spends her day writing content and completing projects for SolidWP, LearnDash, and The Events Calendar. In her free time, Sarah can be found playing pickleball, enjoying coffee at a local coffee shop, and spending time with her husband.\",\"url\":\"https://solidwp.com/blog/author/sarahz/\"}]}</script>\n<!-- / Yoast SEO Premium plugin. -->\";s:15:\"yoast_head_json\";a:19:{s:5:\"title\";s:61:\"WordPress Vulnerability Report — October 30, 2024 - SolidWP\";s:11:\"description\";s:250:\"Since last week, 251 new vulnerabilities emerged in the WordPress ecosystem including 245 plugins and 6 themes. 110 of the vulnerable plugins and themes remain unpatched, but Solid Security Pro users are protected by virtual patching from Patchstack.\";s:6:\"robots\";a:5:{s:5:\"index\";s:5:\"index\";s:6:\"follow\";s:6:\"follow\";s:11:\"max-snippet\";s:14:\"max-snippet:-1\";s:17:\"max-image-preview\";s:23:\"max-image-preview:large\";s:17:\"max-video-preview\";s:20:\"max-video-preview:-1\";}s:9:\"canonical\";s:72:\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/\";s:9:\"og_locale\";s:5:\"en_US\";s:7:\"og_type\";s:7:\"article\";s:8:\"og_title\";s:51:\"WordPress Vulnerability Report — October 30, 2024\";s:14:\"og_description\";s:170:\"Each week, we report the latest vulnerabilities in WordPress plugins and themes. Vulnerable WordPress plugins and themes are among the reasons WordPress sites get hacked.\";s:6:\"og_url\";s:72:\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/\";s:12:\"og_site_name\";s:7:\"SolidWP\";s:22:\"article_published_time\";s:25:\"2024-10-30T13:45:07+00:00\";s:21:\"article_modified_time\";s:25:\"2024-10-30T13:45:09+00:00\";s:8:\"og_image\";a:1:{i:0;a:4:{s:5:\"width\";i:2501;s:6:\"height\";i:1311;s:3:\"url\";s:73:\"https://solidwp.com/wp-content/uploads/2023/11/Vulnerability-Report-8.png\";s:4:\"type\";s:9:\"image/png\";}}s:6:\"author\";s:14:\"Sarah Zuercher\";s:12:\"twitter_card\";s:19:\"summary_large_image\";s:19:\"twitter_description\";s:170:\"Each week, we report the latest vulnerabilities in WordPress plugins and themes. Vulnerable WordPress plugins and themes are among the reasons WordPress sites get hacked.\";s:13:\"twitter_image\";s:73:\"https://solidwp.com/wp-content/uploads/2023/11/Vulnerability-Report-1.png\";s:12:\"twitter_misc\";a:2:{s:10:\"Written by\";s:14:\"Sarah Zuercher\";s:17:\"Est. reading time\";s:10:\"45 minutes\";}s:6:\"schema\";a:2:{s:8:\"@context\";s:18:\"https://schema.org\";s:6:\"@graph\";a:5:{i:0;a:15:{s:5:\"@type\";s:7:\"WebPage\";s:3:\"@id\";s:72:\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/\";s:3:\"url\";s:72:\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/\";s:4:\"name\";s:61:\"WordPress Vulnerability Report — October 30, 2024 - SolidWP\";s:8:\"isPartOf\";a:1:{s:3:\"@id\";s:28:\"https://solidwp.com/#website\";}s:18:\"primaryImageOfPage\";a:1:{s:3:\"@id\";s:85:\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/#primaryimage\";}s:5:\"image\";a:1:{s:3:\"@id\";s:85:\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/#primaryimage\";}s:12:\"thumbnailUrl\";s:73:\"https://solidwp.com/wp-content/uploads/2023/11/Vulnerability-Report-8.png\";s:13:\"datePublished\";s:25:\"2024-10-30T13:45:07+00:00\";s:12:\"dateModified\";s:25:\"2024-10-30T13:45:09+00:00\";s:6:\"author\";a:1:{s:3:\"@id\";s:68:\"https://solidwp.com/#/schema/person/f3ddd6bc130c734ee5bde67d2d0b983c\";}s:11:\"description\";s:250:\"Since last week, 251 new vulnerabilities emerged in the WordPress ecosystem including 245 plugins and 6 themes. 110 of the vulnerable plugins and themes remain unpatched, but Solid Security Pro users are protected by virtual patching from Patchstack.\";s:10:\"breadcrumb\";a:1:{s:3:\"@id\";s:83:\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/#breadcrumb\";}s:10:\"inLanguage\";s:5:\"en-US\";s:15:\"potentialAction\";a:1:{i:0;a:2:{s:5:\"@type\";s:10:\"ReadAction\";s:6:\"target\";a:1:{i:0;s:72:\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/\";}}}}i:1;a:8:{s:5:\"@type\";s:11:\"ImageObject\";s:10:\"inLanguage\";s:5:\"en-US\";s:3:\"@id\";s:85:\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/#primaryimage\";s:3:\"url\";s:73:\"https://solidwp.com/wp-content/uploads/2023/11/Vulnerability-Report-8.png\";s:10:\"contentUrl\";s:73:\"https://solidwp.com/wp-content/uploads/2023/11/Vulnerability-Report-8.png\";s:5:\"width\";i:2501;s:6:\"height\";i:1311;s:7:\"caption\";s:151:\"Line illustration showing a black application window on a purple gradient background overlaid with a large exclamation point alert icon and three bugs.\";}i:2;a:3:{s:5:\"@type\";s:14:\"BreadcrumbList\";s:3:\"@id\";s:83:\"https://solidwp.com/blog/wordpress-vulnerability-report-october-30-2024/#breadcrumb\";s:15:\"itemListElement\";a:2:{i:0;a:4:{s:5:\"@type\";s:8:\"ListItem\";s:8:\"position\";i:1;s:4:\"name\";s:4:\"Home\";s:4:\"item\";s:20:\"https://solidwp.com/\";}i:1;a:3:{s:5:\"@type\";s:8:\"ListItem\";s:8:\"position\";i:2;s:4:\"name\";s:51:\"WordPress Vulnerability Report — October 30, 2024\";}}}i:3;a:7:{s:5:\"@type\";s:7:\"WebSite\";s:3:\"@id\";s:28:\"https://solidwp.com/#website\";s:3:\"url\";s:20:\"https://solidwp.com/\";s:4:\"name\";s:7:\"SolidWP\";s:11:\"description\";s:63:\"Protect Your WordPress Website with the Best Security Available\";s:15:\"potentialAction\";a:1:{i:0;a:3:{s:5:\"@type\";s:12:\"SearchAction\";s:6:\"target\";a:2:{s:5:\"@type\";s:10:\"EntryPoint\";s:11:\"urlTemplate\";s:43:\"https://solidwp.com/?s={search_term_string}\";}s:11:\"query-input\";a:3:{s:5:\"@type\";s:26:\"PropertyValueSpecification\";s:13:\"valueRequired\";b:1;s:9:\"valueName\";s:18:\"search_term_string\";}}}s:10:\"inLanguage\";s:5:\"en-US\";}i:4;a:6:{s:5:\"@type\";s:6:\"Person\";s:3:\"@id\";s:68:\"https://solidwp.com/#/schema/person/f3ddd6bc130c734ee5bde67d2d0b983c\";s:4:\"name\";s:14:\"Sarah Zuercher\";s:5:\"image\";a:6:{s:5:\"@type\";s:11:\"ImageObject\";s:10:\"inLanguage\";s:5:\"en-US\";s:3:\"@id\";s:42:\"https://solidwp.com/#/schema/person/image/\";s:3:\"url\";s:81:\"https://secure.gravatar.com/avatar/1b31f6d603fe91256e9b525a3e73613d?s=96&d=mm&r=g\";s:10:\"contentUrl\";s:81:\"https://secure.gravatar.com/avatar/1b31f6d603fe91256e9b525a3e73613d?s=96&d=mm&r=g\";s:7:\"caption\";s:14:\"Sarah Zuercher\";}s:11:\"description\";s:311:\"Sarah has been with StellarWP since 2024. As our marketing generalist, she spends her day writing content and completing projects for SolidWP, LearnDash, and The Events Calendar. In her free time, Sarah can be found playing pickleball, enjoying coffee at a local coffee shop, and spending time with her husband.\";s:3:\"url\";s:39:\"https://solidwp.com/blog/author/sarahz/\";}}}}s:13:\"taxonomy_info\";a:1:{s:8:\"category\";a:2:{i:0;a:2:{s:5:\"value\";i:380;s:5:\"label\";s:18:\"WordPress Security\";}i:1;a:2:{s:5:\"value\";i:4766;s:5:\"label\";s:30:\"WordPress Vulnerability Report\";}}}s:24:\"featured_image_src_large\";a:4:{i:0;s:82:\"https://solidwp.com/wp-content/uploads/2023/11/Vulnerability-Report-8-1024x537.png\";i:1;i:1024;i:2;i:537;i:3;b:1;}s:11:\"author_info\";a:2:{s:12:\"display_name\";s:14:\"Sarah Zuercher\";s:11:\"author_link\";s:39:\"https://solidwp.com/blog/author/sarahz/\";}s:12:\"comment_info\";s:0:\"\";s:13:\"category_info\";a:2:{i:0;a:16:{s:7:\"term_id\";i:380;s:4:\"name\";s:18:\"WordPress Security\";s:4:\"slug\";s:18:\"wordpress-security\";s:10:\"term_group\";i:0;s:16:\"term_taxonomy_id\";i:403;s:8:\"taxonomy\";s:8:\"category\";s:11:\"description\";s:53:\"The latest WordPress security news, tips and updates.\";s:6:\"parent\";i:0;s:5:\"count\";i:186;s:6:\"filter\";s:3:\"raw\";s:6:\"cat_ID\";i:380;s:14:\"category_count\";i:186;s:20:\"category_description\";s:53:\"The latest WordPress security news, tips and updates.\";s:8:\"cat_name\";s:18:\"WordPress Security\";s:17:\"category_nicename\";s:18:\"wordpress-security\";s:15:\"category_parent\";i:0;}i:1;a:16:{s:7:\"term_id\";i:4766;s:4:\"name\";s:30:\"WordPress Vulnerability Report\";s:4:\"slug\";s:30:\"wordpress-vulnerability-report\";s:10:\"term_group\";i:0;s:16:\"term_taxonomy_id\";i:4770;s:8:\"taxonomy\";s:8:\"category\";s:11:\"description\";s:876:\"New WordPress plugin and theme vulnerabilities were disclosed during the second week of April. This post covers the recent WordPress plugin, theme, and core vulnerabilities and what to do if you run one of the vulnerable plugins or themes on your website.\r\n\r\nThe WordPress Vulnerability Roundup is divided into three different categories: WordPress core, WordPress plugins, and WordPress themes. Each vulnerability will have a severity rating of <span class=\"has-inline-color has-luminous-vivid-amber-color\">Low</span>, <span class=\"has-inline-color has-luminous-vivid-orange-color\">Medium</span>, <span class=\"has-inline-color\">High</span>, or <span class=\"has-inline-color has-vivid-red-color\">Critical</span>.\r\n\r\n<!-- This site is converting visitors into subscribers and customers with OptinMonster - https://optinmonster.com -->\r\n\r\n<!-- / https://optinmonster.com -->\";s:6:\"parent\";i:0;s:5:\"count\";i:234;s:6:\"filter\";s:3:\"raw\";s:6:\"cat_ID\";i:4766;s:14:\"category_count\";i:234;s:20:\"category_description\";s:876:\"New WordPress plugin and theme vulnerabilities were disclosed during the second week of April. This post covers the recent WordPress plugin, theme, and core vulnerabilities and what to do if you run one of the vulnerable plugins or themes on your website.\r\n\r\nThe WordPress Vulnerability Roundup is divided into three different categories: WordPress core, WordPress plugins, and WordPress themes. Each vulnerability will have a severity rating of <span class=\"has-inline-color has-luminous-vivid-amber-color\">Low</span>, <span class=\"has-inline-color has-luminous-vivid-orange-color\">Medium</span>, <span class=\"has-inline-color\">High</span>, or <span class=\"has-inline-color has-vivid-red-color\">Critical</span>.\r\n\r\n<!-- This site is converting visitors into subscribers and customers with OptinMonster - https://optinmonster.com -->\r\n\r\n<!-- / https://optinmonster.com -->\";s:8:\"cat_name\";s:30:\"WordPress Vulnerability Report\";s:17:\"category_nicename\";s:30:\"wordpress-vulnerability-report\";s:15:\"category_parent\";i:0;}}s:8:\"tag_info\";b:0;s:6:\"_links\";a:11:{s:4:\"self\";a:1:{i:0;a:1:{s:4:\"href\";s:46:\"https://solidwp.com/wp-json/wp/v2/posts/102982\";}}s:10:\"collection\";a:1:{i:0;a:1:{s:4:\"href\";s:39:\"https://solidwp.com/wp-json/wp/v2/posts\";}}s:5:\"about\";a:1:{i:0;a:1:{s:4:\"href\";s:44:\"https://solidwp.com/wp-json/wp/v2/types/post\";}}s:6:\"author\";a:1:{i:0;a:2:{s:10:\"embeddable\";b:1;s:4:\"href\";s:45:\"https://solidwp.com/wp-json/wp/v2/users/59680\";}}s:7:\"replies\";a:1:{i:0;a:2:{s:10:\"embeddable\";b:1;s:4:\"href\";s:54:\"https://solidwp.com/wp-json/wp/v2/comments?post=102982\";}}s:15:\"version-history\";a:1:{i:0;a:2:{s:5:\"count\";i:3;s:4:\"href\";s:56:\"https://solidwp.com/wp-json/wp/v2/posts/102982/revisions\";}}s:19:\"predecessor-version\";a:1:{i:0;a:2:{s:2:\"id\";i:103011;s:4:\"href\";s:63:\"https://solidwp.com/wp-json/wp/v2/posts/102982/revisions/103011\";}}s:16:\"wp:featuredmedia\";a:1:{i:0;a:2:{s:10:\"embeddable\";b:1;s:4:\"href\";s:45:\"https://solidwp.com/wp-json/wp/v2/media/94501\";}}s:13:\"wp:attachment\";a:1:{i:0;a:1:{s:4:\"href\";s:53:\"https://solidwp.com/wp-json/wp/v2/media?parent=102982\";}}s:7:\"wp:term\";a:2:{i:0;a:3:{s:8:\"taxonomy\";s:8:\"category\";s:10:\"embeddable\";b:1;s:4:\"href\";s:56:\"https://solidwp.com/wp-json/wp/v2/categories?post=102982\";}i:1;a:3:{s:8:\"taxonomy\";s:8:\"post_tag\";s:10:\"embeddable\";b:1;s:4:\"href\";s:50:\"https://solidwp.com/wp-json/wp/v2/tags?post=102982\";}}s:6:\"curies\";a:1:{i:0;a:3:{s:4:\"name\";s:2:\"wp\";s:4:\"href\";s:23:\"https://api.w.org/{rel}\";s:9:\"templated\";b:1;}}}}","off"),
("1188","easy_wp_smtp_debug","a:0:{}","off"),
("1192","_site_transient_timeout_it-updater-get_package_details-bd8f1","1730553131","off"),
("1193","_site_transient_it-updater-get_package_details-bd8f1","a:3:{s:8:\"packages\";a:1:{s:20:\"ithemes-security-pro\";a:1:{s:5:\"error\";a:3:{s:4:\"code\";i:8012;s:4:\"type\";s:33:\"ITXAPI_Updater_Missing_Legacy_Key\";s:7:\"message\";s:55:\"A legacy key was not provided with the package details.\";}}}s:9:\"time_skew\";i:0;s:13:\"min_poll_time\";i:30;}","off"),
("1197","_site_transient_timeout_itsec_wp_upload_dir","1730553190","off"),
("1198","_site_transient_itsec_wp_upload_dir","a:6:{s:4:\"path\";s:59:\"C:\\wamp64\\www\\duplicator-creaweb/wp-content/uploads/2024/11\";s:3:\"url\";s:73:\"http://192.168.100.112:8012/duplicator-creaweb/wp-content/uploads/2024/11\";s:6:\"subdir\";s:8:\"/2024/11\";s:7:\"basedir\";s:51:\"C:\\wamp64\\www\\duplicator-creaweb/wp-content/uploads\";s:7:\"baseurl\";s:65:\"http://192.168.100.112:8012/duplicator-creaweb/wp-content/uploads\";s:5:\"error\";b:0;}","off"),
("1207","itsec_user_encryption_test","$t1$JRkAOa2ots27drnzRyiKdp8L4tYylHh55SLzn1Aam3XtDPyKwLLMF9UUQr9IVmEJjkgL","off"),
("1221","itsec_cron","a:2:{s:6:\"single\";a:3:{s:22:\"preload-ithemes-hashes\";a:0:{}s:21:\"preload-plugin-hashes\";a:0:{}s:26:\"confirm-valid-wporg-plugin\";a:0:{}}s:9:\"recurring\";a:11:{s:17:\"purge-log-entries\";a:1:{s:4:\"data\";a:0:{}}s:17:\"outdated-software\";a:1:{s:4:\"data\";a:0:{}}s:12:\"malware-scan\";a:1:{s:4:\"data\";a:0:{}}s:19:\"identify-server-ips\";a:1:{s:4:\"data\";a:0:{}}s:28:\"dashboard-consolidate-events\";a:1:{s:4:\"data\";a:0:{}}s:11:\"clear-locks\";a:1:{s:4:\"data\";a:0:{}}s:12:\"clear-tokens\";a:1:{s:4:\"data\";a:0:{}}s:14:\"purge-lockouts\";a:1:{s:4:\"data\";a:0:{}}s:17:\"enable-encryption\";a:1:{s:4:\"data\";a:0:{}}s:11:\"flush-files\";a:1:{s:4:\"data\";a:0:{}}s:18:\"security-check-pro\";a:1:{s:4:\"data\";a:0:{}}}}","off"),
("1247","itsec-storage","a:12:{s:6:\"global\";a:34:{s:11:\"write_files\";b:1;s:10:\"nginx_file\";s:43:\"C:\\wamp64\\www\\duplicator-creaweb/nginx.conf\";s:14:\"lockout_period\";i:15;s:16:\"blacklist_period\";i:7;s:9:\"blacklist\";b:1;s:15:\"blacklist_count\";i:3;s:15:\"lockout_message\";s:5:\"error\";s:20:\"user_lockout_message\";s:61:\"You have been locked out for too many invalid login attempts.\";s:25:\"community_lockout_message\";s:75:\"Your IP address has been flagged as a threat by the Solid Security network.\";s:19:\"automatic_temp_auth\";b:1;s:18:\"lockout_white_list\";a:0:{}s:8:\"log_type\";s:8:\"database\";s:12:\"log_rotation\";i:60;s:17:\"file_log_rotation\";i:180;s:12:\"log_location\";s:73:\"C:\\wamp64\\www\\duplicator-creaweb/wp-content/uploads/ithemes-security/logs\";s:5:\"proxy\";s:8:\"disabled\";s:12:\"proxy_header\";s:20:\"HTTP_X_FORWARDED_FOR\";s:14:\"hide_admin_bar\";b:0;s:14:\"allow_tracking\";b:1;s:16:\"show_error_codes\";b:0;s:5:\"build\";i:4128;s:13:\"initial_build\";i:4128;s:20:\"activation_timestamp\";i:1730466846;s:11:\"cron_status\";i:-1;s:8:\"use_cron\";b:1;s:14:\"cron_test_time\";i:1730529846;s:10:\"server_ips\";a:1:{i:0;s:15:\"192.168.100.112\";}s:24:\"licensed_hostname_prompt\";b:0;s:16:\"onboard_complete\";b:1;s:13:\"enabled_tools\";a:0:{}s:18:\"enable_remote_help\";b:1;s:13:\"feature_flags\";a:0:{}s:8:\"log_info\";s:0:\"\";s:12:\"manage_group\";a:1:{i:0;s:36:\"c3e96e91-a012-48ae-b50e-074b3075ed42\";}}s:10:\"__extended\";a:1:{s:10:\"two-factor\";a:4:{i:0;s:24:\"protect_vulnerable_users\";i:1;s:23:\"protect_vulnerable_site\";i:2;s:18:\"protect_user_group\";i:3;s:14:\"remember_group\";}}s:13:\"feature-flags\";a:3:{s:7:\"enabled\";a:1:{i:0;s:17:\"enable_encryption\";}s:5:\"rates\";a:1:{s:17:\"enable_encryption\";i:100;}s:8:\"opt_outs\";a:0:{}}s:18:\"passwordless-login\";a:7:{s:7:\"methods\";a:2:{i:0;s:5:\"magic\";i:1;s:8:\"webauthn\";}s:12:\"availability\";s:7:\"enabled\";s:4:\"flow\";s:12:\"method-first\";s:12:\"integrations\";a:0:{}s:25:\"passkey_user_verification\";s:9:\"preferred\";s:5:\"group\";a:6:{i:0;s:36:\"781e6a4c-ab61-49fe-a874-902b1709bb03\";i:1;s:36:\"c3e96e91-a012-48ae-b50e-074b3075ed42\";i:2;s:36:\"639052e2-58d3-4b63-85b1-b43bff806f52\";i:3;s:36:\"9445bfa7-57e8-4c92-b3aa-610b03d8c982\";i:4;s:36:\"a92c70e0-0bad-40be-8328-9c172fc7fc96\";i:5;s:14:\"everybody-else\";}s:16:\"2fa_bypass_group\";a:0:{}}s:21:\"password-requirements\";a:2:{s:20:\"enabled_requirements\";a:4:{s:8:\"strength\";b:0;s:4:\"hibp\";b:0;s:3:\"age\";b:0;s:5:\"force\";b:0;}s:20:\"requirement_settings\";a:3:{s:8:\"strength\";a:1:{s:5:\"group\";a:6:{i:0;s:36:\"781e6a4c-ab61-49fe-a874-902b1709bb03\";i:1;s:36:\"c3e96e91-a012-48ae-b50e-074b3075ed42\";i:2;s:36:\"639052e2-58d3-4b63-85b1-b43bff806f52\";i:3;s:36:\"9445bfa7-57e8-4c92-b3aa-610b03d8c982\";i:4;s:36:\"a92c70e0-0bad-40be-8328-9c172fc7fc96\";i:5;s:14:\"everybody-else\";}}s:4:\"hibp\";a:1:{s:5:\"group\";a:6:{i:0;s:36:\"781e6a4c-ab61-49fe-a874-902b1709bb03\";i:1;s:36:\"c3e96e91-a012-48ae-b50e-074b3075ed42\";i:2;s:36:\"639052e2-58d3-4b63-85b1-b43bff806f52\";i:3;s:36:\"9445bfa7-57e8-4c92-b3aa-610b03d8c982\";i:4;s:36:\"a92c70e0-0bad-40be-8328-9c172fc7fc96\";i:5;s:14:\"everybody-else\";}}s:3:\"age\";a:2:{s:10:\"expire_max\";i:120;s:5:\"group\";a:0:{}}}}s:12:\"user-logging\";a:1:{s:5:\"group\";a:1:{i:0;s:36:\"c3e96e91-a012-48ae-b50e-074b3075ed42\";}}s:9:\"dashboard\";a:2:{s:8:\"migrated\";b:0;s:5:\"group\";a:1:{i:0;s:36:\"c3e96e91-a012-48ae-b50e-074b3075ed42\";}}s:4:\"core\";a:1:{s:17:\"last_seen_lockout\";i:1730467027;}s:18:\"version-management\";a:10:{s:27:\"wordpress_automatic_updates\";b:1;s:24:\"plugin_automatic_updates\";s:4:\"none\";s:23:\"theme_automatic_updates\";s:4:\"none\";s:8:\"packages\";a:0:{}s:28:\"scan_for_old_wordpress_sites\";b:0;s:20:\"update_if_vulnerable\";b:0;s:14:\"update_details\";a:1:{s:7:\"plugins\";a:1:{s:37:\"admin-menu-editor-pro/menu-editor.php\";a:2:{s:7:\"current\";s:4:\"2.26\";s:4:\"time\";i:1730468468;}}}s:20:\"is_software_outdated\";b:0;s:16:\"old_site_details\";a:2:{s:9:\"last_scan\";i:0;s:5:\"sites\";a:0:{}}s:10:\"first_seen\";a:2:{s:6:\"plugin\";a:1:{s:37:\"admin-menu-editor-pro/menu-editor.php\";a:1:{s:6:\"2.26.1\";i:1730467164;}}s:5:\"theme\";a:0:{}}}s:19:\"notification-center\";a:8:{s:9:\"last_sent\";a:0:{}s:9:\"resend_at\";a:0:{}s:4:\"data\";a:0:{}s:15:\"last_mail_error\";s:35:\"SMTP Error: Could not authenticate.\";s:10:\"from_email\";s:0:\"\";s:18:\"default_recipients\";a:1:{s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}}s:13:\"notifications\";a:9:{s:6:\"digest\";a:5:{s:8:\"schedule\";s:5:\"daily\";s:7:\"subject\";N;s:7:\"enabled\";b:1;s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}s:14:\"recipient_type\";s:7:\"default\";}s:6:\"backup\";a:2:{s:7:\"subject\";N;s:10:\"email_list\";a:1:{i:0;s:15:\"info@creaweb.ma\";}}s:18:\"malware-scheduling\";a:3:{s:7:\"enabled\";b:1;s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}s:14:\"recipient_type\";s:7:\"default\";}s:21:\"magic-link-login-page\";a:2:{s:7:\"subject\";N;s:7:\"message\";N;}s:23:\"automatic-updates-debug\";a:3:{s:7:\"enabled\";b:1;s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}s:14:\"recipient_type\";s:7:\"default\";}s:18:\"passwordless-login\";a:2:{s:7:\"subject\";N;s:7:\"message\";N;}s:13:\"import-export\";a:2:{s:7:\"subject\";N;s:7:\"message\";N;}s:14:\"inactive-users\";a:5:{s:8:\"schedule\";s:5:\"daily\";s:7:\"subject\";N;s:7:\"enabled\";b:1;s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}s:14:\"recipient_type\";s:7:\"default\";}s:7:\"lockout\";a:4:{s:7:\"subject\";N;s:7:\"enabled\";b:1;s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}s:14:\"recipient_type\";s:7:\"default\";}}s:12:\"admin_emails\";a:0:{}}s:12:\"online-files\";a:1:{s:19:\"valid_wporg_plugins\";a:4:{s:20:\"seo-by-rank-math-pro\";a:2:{s:5:\"valid\";b:0;s:10:\"checked_at\";i:1730467709;}s:9:\"wp-rocket\";a:2:{s:5:\"valid\";b:0;s:10:\"checked_at\";i:1730467984;}s:12:\"wp-smush-pro\";a:2:{s:5:\"valid\";b:0;s:10:\"checked_at\";i:1730468567;}s:27:\"admin-site-enhancements-pro\";a:2:{s:5:\"valid\";b:0;s:10:\"checked_at\";i:1730469053;}}}s:18:\"security-check-pro\";a:7:{s:19:\"last_scan_timestamp\";N;s:9:\"ip_header\";a:2:{s:4:\"name\";s:0:\"\";s:17:\"position_from_end\";i:-1;}s:15:\"remote_ip_index\";N;s:13:\"ssl_supported\";N;s:20:\"remote_ips_timestamp\";N;s:10:\"remote_ips\";a:0:{}s:8:\"key_salt\";s:60:\"o.5jg:^)n`8q/1,?hB^spSZq{:m3SM[b&yjS,6MHSZ.iUrN8<MqYeLIvD^hR\";}}","auto"),
("1250","itsec_temp_whitelist_ip","a:1:{s:15:\"192.168.100.112\";i:1730553247;}","off"),
("1251","stellarwp_telemetry_solid-security_show_optin","0","auto"),
("1254","itsec_active_modules","a:11:{s:9:\"ban-users\";b:1;s:8:\"firewall\";b:1;s:11:\"brute-force\";b:1;s:19:\"network-brute-force\";b:1;s:6:\"backup\";b:1;s:18:\"malware-scheduling\";b:1;s:11:\"magic-links\";b:1;s:12:\"user-logging\";b:1;s:18:\"version-management\";b:1;s:8:\"webauthn\";b:1;s:18:\"passwordless-login\";b:1;}","auto"),
("1260","itsec_online_files_hashes","a:2:{s:14:\"ithemes_hashes\";a:1:{s:20:\"ithemes-security-pro\";a:1:{s:5:\"8.5.0\";a:2:{s:6:\"hashes\";a:0:{}s:10:\"checked_at\";i:1730466967;}}}s:19:\"wporg_plugin_hashes\";a:6:{s:9:\"wp-rocket\";a:1:{s:6:\"3.17.1\";a:2:{s:6:\"hashes\";a:0:{}s:10:\"checked_at\";i:1730467444;}}s:20:\"seo-by-rank-math-pro\";a:1:{s:6:\"3.0.74\";a:2:{s:6:\"hashes\";a:0:{}s:10:\"checked_at\";i:1730467528;}}s:16:\"seo-by-rank-math\";a:1:{s:7:\"1.0.231\";a:2:{s:6:\"hashes\";a:840:{s:27:\"assets/admin/css/blocks.css\";s:32:\"0f35b70d9c72a73c02e26e40c655c352\";s:25:\"assets/admin/css/cmb2.css\";s:32:\"56eb29342ffe72bda4ee940322040831\";s:27:\"assets/admin/css/common.css\";s:32:\"497f77cfa56c083ce9e544c85668f262\";s:37:\"assets/admin/css/dashboard-widget.css\";s:32:\"6d24ddffd2cd42e9cc2d57400a50eb3a\";s:30:\"assets/admin/css/dashboard.css\";s:32:\"53682b6d20cfaeaf49e86747e3d3b939\";s:25:\"assets/admin/css/divi.css\";s:32:\"57a50848deda05f117282855d8c4a6ca\";s:35:\"assets/admin/css/elementor-dark.css\";s:32:\"af6117823fb19d99488af8d8e7bf75b6\";s:30:\"assets/admin/css/elementor.css\";s:32:\"207f4fb10b011e42d5ce7bfd395226ee\";s:30:\"assets/admin/css/gutenberg.css\";s:32:\"e1a514c913dd6c43f92743e6c537b19c\";s:28:\"assets/admin/css/metabox.css\";s:32:\"5b6c0855d6af5b79ce73a11a65b3eca7\";s:33:\"assets/admin/css/option-panel.css\";s:32:\"dec3c9450fe4fb5308a7e5d026832e44\";s:30:\"assets/admin/css/post-list.css\";s:32:\"f2699e6d8ae0a43860da332e4c653218\";s:27:\"assets/admin/css/schema.css\";s:32:\"8efa8e9e0fee14456cdb60f2ae3e498e\";s:33:\"assets/admin/css/setup-wizard.css\";s:32:\"9aff3b40300fceb9a12422a6c5a9a53a\";s:32:\"assets/admin/fonts/Rank-Math.svg\";s:32:\"f87a0e3948f896485e0f7a478a2c42e8\";s:32:\"assets/admin/fonts/Rank-Math.ttf\";s:32:\"50b412dba5ee47b854082e6b36452926\";s:33:\"assets/admin/fonts/Rank-Math.woff\";s:32:\"5ec08a072c6ff3f8bebd5485d6b4291c\";s:29:\"assets/admin/img/icon-gif.png\";s:32:\"40c2767c5a4b370d67843c40603c5fb9\";s:30:\"assets/admin/img/icon-play.png\";s:32:\"2995d3970cd80bb84f57dd041e0d75b8\";s:27:\"assets/admin/img/loader.svg\";s:32:\"a6faa06794636218806de0b2353917db\";s:25:\"assets/admin/img/logo.svg\";s:32:\"09dca3ecfb71f34c03ce789f125efc44\";s:30:\"assets/admin/img/menu-icon.svg\";s:32:\"0e9c0fa2a3f210f9ddf95911bdfdc7a6\";s:27:\"assets/admin/img/pillar.svg\";s:32:\"cf0cc75439508f9c66070a0287b6b112\";s:30:\"assets/admin/img/score-100.png\";s:32:\"55cbf345d4776d0a8e4e18a2d84c6b88\";s:39:\"assets/admin/img/social-placeholder.jpg\";s:32:\"59754350ea23e8621298409ef7a5cb3f\";s:35:\"assets/admin/img/trends-preview.jpg\";s:32:\"7c1835f61576918c009a2510cda2b79a\";s:27:\"assets/admin/js/analyzer.js\";s:32:\"7038a68f1af43bd4e3b4366f02c14b60\";s:25:\"assets/admin/js/blocks.js\";s:32:\"62ed2c4855b5497c860a6d01c4022c63\";s:26:\"assets/admin/js/classic.js\";s:32:\"23a3b28e8754a4788901a72b9eb8341a\";s:25:\"assets/admin/js/common.js\";s:32:\"0a259ddb0121e78dc675bada7d120182\";s:29:\"assets/admin/js/components.js\";s:32:\"a528526fc2ee723077ff0f5d3662621a\";s:32:\"assets/admin/js/custom-fields.js\";s:32:\"3da29a9013c12653eec34ab8bbc61ff0\";s:28:\"assets/admin/js/dashboard.js\";s:32:\"ae81f7a3ca0ea44bf490b14a824d7a65\";s:37:\"assets/admin/js/glue-custom-fields.js\";s:32:\"83b5e43b17d724f6426577e03a941e3b\";s:36:\"assets/admin/js/gutenberg-formats.js\";s:32:\"57622c3bd0f9b2ff218f5958c646753e\";s:41:\"assets/admin/js/gutenberg-primary-term.js\";s:32:\"76606e2eceed9972e391dbc65d82ccb5\";s:28:\"assets/admin/js/gutenberg.js\";s:32:\"e87a759560dcd439c517e8b8479252d7\";s:32:\"assets/admin/js/import-export.js\";s:32:\"544cb184450be8df2653df02c46a4ccb\";s:31:\"assets/admin/js/option-panel.js\";s:32:\"13160fbcf74f4f11168cdd287fa88712\";s:28:\"assets/admin/js/post-list.js\";s:32:\"d7fdad9bc1fb32381f0af270543fd2bd\";s:32:\"assets/admin/js/rank-math-app.js\";s:32:\"dd7d46e74575c6030243290b6d34ae06\";s:27:\"assets/admin/js/validate.js\";s:32:\"db2ed6218d6e4104876caa21e252cc6e\";s:25:\"assets/admin/js/wizard.js\";s:32:\"b46e18966c5a85d0ed632098a05983c0\";s:25:\"assets/admin/js/wplink.js\";s:32:\"15ba91019087cb557b8e377b1a6c54f1\";s:43:\"assets/front/css/rank-math-contact-info.css\";s:32:\"a1862ee414d5a215448f0a393e586141\";s:40:\"assets/front/css/rank-math-seo-score.css\";s:32:\"fcec67cb596e238b099276e2a63ac52f\";s:38:\"assets/front/css/rank-math-snippet.css\";s:32:\"149a0b20bcecfdf2662724bd4f15aa66\";s:30:\"assets/front/css/rank-math.css\";s:32:\"f5e50939924d52d90893714ed552f4a7\";s:34:\"assets/front/css/rank-math.min.css\";s:32:\"c316149485a865d31892025ca9143ae2\";s:28:\"assets/front/js/rank-math.js\";s:32:\"2d8dfe20b251c13499f8d083c1c0aef0\";s:22:\"assets/vendor/autop.js\";s:32:\"9ee849d27d56067ff12a68be248815c1\";s:30:\"assets/vendor/clipboard.min.js\";s:32:\"9dd6efa74ab85b8084d08502f3db0777\";s:51:\"assets/vendor/date-range-picker/daterangepicker.css\";s:32:\"a25397cc4882178a175cc15988e807d8\";s:55:\"assets/vendor/date-range-picker/daterangepicker.min.css\";s:32:\"e463244064e1a7fe8f05d532fa621657\";s:61:\"assets/vendor/date-range-picker/jquery.daterangepicker.min.js\";s:32:\"8b1f66d0637a7fda3d9e5da9e6fd3774\";s:31:\"assets/vendor/diacritics/de.php\";s:32:\"2ece22b0688a9e988e80e6592373655b\";s:31:\"assets/vendor/diacritics/en.php\";s:32:\"cc816b294b4af5569d7bf09c79eaa032\";s:31:\"assets/vendor/diacritics/ru.php\";s:32:\"6feaa337683fd0548f24415158367255\";s:22:\"assets/vendor/hooks.js\";s:32:\"d157cee5ef22f03d1178cca24fef5851\";s:21:\"assets/vendor/i18n.js\";s:32:\"937150080d6310a2a1465b5fa9212713\";s:23:\"assets/vendor/lodash.js\";s:32:\"9a4e6a435f6edac93978d7930fc35392\";s:31:\"assets/vendor/powerwords/de.php\";s:32:\"f52f3a68c46310085230fee5716081f1\";s:31:\"assets/vendor/powerwords/en.php\";s:32:\"494781461df3b1da8e72ff2c6f1e3b31\";s:31:\"assets/vendor/powerwords/es.php\";s:32:\"642ed99d22e8a3501efd02372c050c60\";s:31:\"assets/vendor/powerwords/fi.php\";s:32:\"0b4296488cba6f9d7dd8f2e179fe676d\";s:31:\"assets/vendor/powerwords/fr.php\";s:32:\"de18e1c30c6019f32150809700363a94\";s:31:\"assets/vendor/powerwords/hu.php\";s:32:\"4c3b5557201b6e82a6bb1afd84e4db6e\";s:31:\"assets/vendor/powerwords/id.php\";s:32:\"b24df7486e2195d6acd92716eb7fc660\";s:31:\"assets/vendor/powerwords/it.php\";s:32:\"c7a57768b056e0ae1e53cd396dc8aab8\";s:31:\"assets/vendor/powerwords/ja.php\";s:32:\"27b4c0080e19ffce945063bedb61a311\";s:31:\"assets/vendor/powerwords/nl.php\";s:32:\"e0761b13703887aa3b895698aab5fe76\";s:31:\"assets/vendor/powerwords/sv.php\";s:32:\"c50497e4ac26950b3984d8a4fc216d73\";s:35:\"assets/vendor/schema/schema-map.php\";s:32:\"f35e7f0fd5bcfe9616c8ff1e64141efb\";s:37:\"assets/vendor/select2/select2.min.css\";s:32:\"af22a7e2bfec4d2a82c4dde613a52fb1\";s:36:\"assets/vendor/select2/select2.min.js\";s:32:\"3e6e33cd306b1235add3d25fcda8541d\";s:20:\"assets/vendor/url.js\";s:32:\"b123bc551e874307f990c86d0f63a9fb\";s:26:\"assets/vendor/wordcount.js\";s:32:\"873f1b72861996b8155467eace89e337\";s:42:\"includes/3rdparty/divi/assets/css/divi.css\";s:32:\"931706c63af14ef9cfd639e6cdb94dff\";s:46:\"includes/3rdparty/divi/assets/js/divi-admin.js\";s:32:\"7a6fddaad366d927fbcded434951f996\";s:47:\"includes/3rdparty/divi/assets/js/divi-iframe.js\";s:32:\"0ca4350c75cd127377de7295de300ffe\";s:40:\"includes/3rdparty/divi/assets/js/divi.js\";s:32:\"106960a0c439c4a2891d8a035b8fe3c7\";s:43:\"includes/3rdparty/divi/class-divi-admin.php\";s:32:\"cb7dba6c1a290bf2db84b0730cc16e8e\";s:37:\"includes/3rdparty/divi/class-divi.php\";s:32:\"0394b77057497a2fee0ba683c4a575b2\";s:57:\"includes/3rdparty/elementor/assets/css/elementor-dark.css\";s:32:\"6c4e4acb6ddf6a346e03f8adf5a0a091\";s:52:\"includes/3rdparty/elementor/assets/css/elementor.css\";s:32:\"93279472a27bdcdc5620793a231ef963\";s:50:\"includes/3rdparty/elementor/assets/js/elementor.js\";s:32:\"b0ab84b6ca91f8728d8ca64a945d7054\";s:47:\"includes/3rdparty/elementor/class-elementor.php\";s:32:\"96ce058eddbd5356d2ac1db25c344fd4\";s:39:\"includes/admin/class-admin-bar-menu.php\";s:32:\"ef8123de2dfda252d689c8266778205c\";s:42:\"includes/admin/class-admin-breadcrumbs.php\";s:32:\"9d59a65f6b4577e75ea14fa9a24a9e28\";s:44:\"includes/admin/class-admin-dashboard-nav.php\";s:32:\"8347b7c2158c3a74892b9011321cedaa\";s:37:\"includes/admin/class-admin-header.php\";s:32:\"cd5bc9f4c43184ec30c79e6efd579f45\";s:37:\"includes/admin/class-admin-helper.php\";s:32:\"5439859c64f17e3e08e9c9ae39f614c3\";s:35:\"includes/admin/class-admin-init.php\";s:32:\"792648a76871dadcdb3b5af03ed98de9\";s:35:\"includes/admin/class-admin-menu.php\";s:32:\"fbff6827a16bedf2c7530044c127a98f\";s:30:\"includes/admin/class-admin.php\";s:32:\"1ca93191f282da463458ec098ab7ee82\";s:28:\"includes/admin/class-api.php\";s:32:\"1bc6c7b016d02ab20e3db4ba6086e748\";s:35:\"includes/admin/class-ask-review.php\";s:32:\"80bf2fa8a4af12537f4b02c7b62edf20\";s:31:\"includes/admin/class-assets.php\";s:32:\"adf400476f444a1adc255d47b88a0262\";s:37:\"includes/admin/class-bulk-actions.php\";s:32:\"17507b3f1b741b2fe71eca51b761b436\";s:36:\"includes/admin/class-cmb2-fields.php\";s:32:\"17dee29d4ba663105f7cc0ecc5d180d7\";s:41:\"includes/admin/class-dashboard-widget.php\";s:32:\"45c50495c5c20c75bfe4cb12d4d986d2\";s:38:\"includes/admin/class-import-export.php\";s:32:\"492099125970ac9140c5017f321c3405\";s:35:\"includes/admin/class-list-table.php\";s:32:\"09a58c630b17a469df68148f78a5b64c\";s:43:\"includes/admin/class-lock-modified-date.php\";s:32:\"7e92f6269cef69e72221c9d81096fbfb\";s:32:\"includes/admin/class-notices.php\";s:32:\"57de6ff9cd7452cae8fa34bf95f75ad9\";s:38:\"includes/admin/class-option-center.php\";s:32:\"febf2d0114e1cdeafdecf283f3206868\";s:32:\"includes/admin/class-options.php\";s:32:\"6360180a1b95eb8084a64c4e4705bf4b\";s:29:\"includes/admin/class-page.php\";s:32:\"3c563ae672a07c2999fc493df228b519\";s:37:\"includes/admin/class-post-columns.php\";s:32:\"06732fe41915c7f528973fbf3f1af828\";s:37:\"includes/admin/class-post-filters.php\";s:32:\"8ba807e9d52d7a97d9c0381c927411e7\";s:35:\"includes/admin/class-pro-notice.php\";s:32:\"8faee4e7d62cb9c5491575c65bd9907d\";s:37:\"includes/admin/class-registration.php\";s:32:\"fa965c77e0ad76bb1e52f446ff9912ff\";s:37:\"includes/admin/class-setup-wizard.php\";s:32:\"2cc10e0bd7cd637181e3b6937a05c8a7\";s:41:\"includes/admin/database/class-clauses.php\";s:32:\"2b73b05a7aa4601c25927cc759a3b36f\";s:42:\"includes/admin/database/class-database.php\";s:32:\"a0ac617df9eda55af3548272cb613c16\";s:40:\"includes/admin/database/class-escape.php\";s:32:\"560088c0d5f99b9f6140dd125637f657\";s:41:\"includes/admin/database/class-groupby.php\";s:32:\"01f3586e7291ea711c491715590ab665\";s:39:\"includes/admin/database/class-joins.php\";s:32:\"f3e7adccfd0e4f4140866ca744158a07\";s:41:\"includes/admin/database/class-orderby.php\";s:32:\"9a2bb265c836d6d0ec2a9811a8d7fb40\";s:47:\"includes/admin/database/class-query-builder.php\";s:32:\"ca1d82345ae582e89ccb5ff7d3540b51\";s:40:\"includes/admin/database/class-select.php\";s:32:\"05e7becf44cde783dba2472d745f083b\";s:43:\"includes/admin/database/class-translate.php\";s:32:\"50e0c5e1bc0df6d93e41c5d6ca79d7eb\";s:39:\"includes/admin/database/class-where.php\";s:32:\"df6477f09625d4f4d093a13112aa918c\";s:33:\"includes/admin/database/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:46:\"includes/admin/importers/abstract-importer.php\";s:32:\"688bb65ed3822871cfe6031a6842cce0\";s:51:\"includes/admin/importers/class-aio-rich-snippet.php\";s:32:\"50c1be42fa2e0bfdff149836cbcea990\";s:41:\"includes/admin/importers/class-aioseo.php\";s:32:\"c31aab2a139228be87dbe14faaa8b268\";s:43:\"includes/admin/importers/class-detector.php\";s:32:\"0d2dbebf1b707a82b9867ab29f18805e\";s:47:\"includes/admin/importers/class-redirections.php\";s:32:\"66e33380b125518d076f2edba227f37d\";s:43:\"includes/admin/importers/class-seopress.php\";s:32:\"f93efe69f1307e290b900013cad930a9\";s:41:\"includes/admin/importers/class-status.php\";s:32:\"b55280690f05d3feefef886b250851a1\";s:48:\"includes/admin/importers/class-wp-schema-pro.php\";s:32:\"8555962d1b6de5fa3f7c3d6a246fd224\";s:40:\"includes/admin/importers/class-yoast.php\";s:32:\"f60102bc3e87452deab2f21c7dd9c54d\";s:34:\"includes/admin/importers/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:24:\"includes/admin/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:40:\"includes/admin/metabox/class-metabox.php\";s:32:\"1a629af481c43f034c2c2b0e21ce7b51\";s:44:\"includes/admin/metabox/class-post-screen.php\";s:32:\"cc4f2d676d8674f59cf11565d8a84858\";s:39:\"includes/admin/metabox/class-screen.php\";s:32:\"2c1f84bfc9acccb0b6d47f3d1a63ed26\";s:48:\"includes/admin/metabox/class-taxonomy-screen.php\";s:32:\"053fdd7daf3443b9172a87e10048c874\";s:44:\"includes/admin/metabox/class-user-screen.php\";s:32:\"9c36788fa6222e4efacea93ec5269afd\";s:43:\"includes/admin/metabox/interface-screen.php\";s:32:\"b9298db9775b16fdc26be7d79b9f1094\";s:58:\"includes/admin/notifications/class-notification-center.php\";s:32:\"f6de8956003185e0cd6a5e00b0f080ff\";s:51:\"includes/admin/notifications/class-notification.php\";s:32:\"e7ba4707219edb47ef3c6b70a9035e3e\";s:39:\"includes/admin/views/dashboard-help.php\";s:32:\"caef3474bee0de6c9ee1776e9783851c\";s:34:\"includes/admin/views/dashboard.php\";s:32:\"b3fe8ff2927e73c5c1997391baec37f7\";s:51:\"includes/admin/views/import-export/backup-panel.php\";s:32:\"0e3b766d436f7462b9efa3706fba4ad7\";s:58:\"includes/admin/views/import-export/import-export-panel.php\";s:32:\"99ed8e21f7c9c60f10ac3960a7ac479a\";s:44:\"includes/admin/views/import-export/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:43:\"includes/admin/views/import-export/main.php\";s:32:\"4bb678bf8037a8f037543f0ed34af447\";s:52:\"includes/admin/views/import-export/plugins-panel.php\";s:32:\"733acdfa91b7e3251311c985346a2f0f\";s:30:\"includes/admin/views/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:42:\"includes/admin/views/plugin-activation.php\";s:32:\"2e850355dbcd93ea3cf8199545e4af04\";s:40:\"includes/admin/watcher/class-watcher.php\";s:32:\"7c4c6c3f22c6135ffbb12c1414d5de3b\";s:45:\"includes/admin/wizard/class-compatibility.php\";s:32:\"5384d5cdef8cabbaba894cbc9810fc61\";s:38:\"includes/admin/wizard/class-import.php\";s:32:\"89d3338a92077927c10bc3a3e07a668d\";s:51:\"includes/admin/wizard/class-monitor-redirection.php\";s:32:\"954b4580fd81637f7206c96250e3ebc4\";s:44:\"includes/admin/wizard/class-optimization.php\";s:32:\"e4adebb7c0d3a7b65df3048d36a6ea3c\";s:37:\"includes/admin/wizard/class-ready.php\";s:32:\"435bb333f64e5d6a671730d68dc4c7ef\";s:36:\"includes/admin/wizard/class-role.php\";s:32:\"f6d86dbca04a1f5e27b9272600e27aa8\";s:45:\"includes/admin/wizard/class-schema-markup.php\";s:32:\"4e62f764ad5324b7633c3535ee14d48e\";s:46:\"includes/admin/wizard/class-search-console.php\";s:32:\"2a052f02ce12a55bbb66c93cbd42572c\";s:39:\"includes/admin/wizard/class-sitemap.php\";s:32:\"4e8439879bb3078ed53af17649b2377a\";s:41:\"includes/admin/wizard/class-your-site.php\";s:32:\"11734d0832f6f8265a495866c421b57f\";s:47:\"includes/admin/wizard/interface-wizard-step.php\";s:32:\"d76578f49cbb7204a1a88e287a2302cd\";s:45:\"includes/admin/wizard/views/compatibility.php\";s:32:\"e4e73a5acfcb83d3bd81012fd1a58a28\";s:39:\"includes/admin/wizard/views/content.php\";s:32:\"d30ccdac4433d1d7b3a0f7e9eb13fcf3\";s:38:\"includes/admin/wizard/views/footer.php\";s:32:\"32d3fd83032542e7652de56732391b6a\";s:46:\"includes/admin/wizard/views/google-connect.php\";s:32:\"59135c80686dfb8ef6b9a186e445442d\";s:38:\"includes/admin/wizard/views/header.php\";s:32:\"c0cd3aca449e176c8ba09c765a9052f7\";s:37:\"includes/admin/wizard/views/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:42:\"includes/admin/wizard/views/navigation.php\";s:32:\"0bf98dff007d3b3cf3103bd8ff481d82\";s:45:\"includes/admin/wizard/views/no-navigation.php\";s:32:\"5e3e613de9f77f4040457050b4f2d80c\";s:49:\"includes/admin/wizard/views/rank-math-connect.php\";s:32:\"29ddf8791ea3c20282f91c962db41d2c\";s:37:\"includes/admin/wizard/views/ready.php\";s:32:\"b5c203d6c28396a88342e94ac67f7e47\";s:49:\"includes/admin/wizard/views/search-console-ui.php\";s:32:\"c0721a9d28e2cfec28ef15a9372f6bea\";s:41:\"includes/admin/wizard/views/your-site.php\";s:32:\"b08077346cdd045b4bcf0410dec8b3e7\";s:31:\"includes/class-auto-updater.php\";s:32:\"785d50ac6f4c4b377762cc7e9875f745\";s:23:\"includes/class-cmb2.php\";s:32:\"56cd76c2f6605178a5549c86c7ae018b\";s:25:\"includes/class-common.php\";s:32:\"eda995f13bb058015505bfa219c82d7a\";s:32:\"includes/class-compatibility.php\";s:32:\"810d856825e6642caad3689e3170332f\";s:34:\"includes/class-data-encryption.php\";s:32:\"ba2cab468838927f44683d1e24fe4e76\";s:27:\"includes/class-defaults.php\";s:32:\"69d31fcb665e73c42b0e971358c11f33\";s:37:\"includes/class-frontend-seo-score.php\";s:32:\"361aa2ab73976d09c4c10545849255ac\";s:25:\"includes/class-helper.php\";s:32:\"f918324954f1ff47dfcaf3aeaf4fc280\";s:28:\"includes/class-installer.php\";s:32:\"3a336c0ab6815cbd14c82623429c0a94\";s:31:\"includes/class-json-manager.php\";s:32:\"b15444a9dc169005fc0ed1a9108c227f\";s:21:\"includes/class-kb.php\";s:32:\"ea7653d0e456e930a990a8f8b75b2630\";s:27:\"includes/class-metadata.php\";s:32:\"a1100d872d2d21942b27b916b3eb6c8f\";s:23:\"includes/class-post.php\";s:32:\"3a16a217527d94fbf900e8dec88ca07a\";s:26:\"includes/class-rewrite.php\";s:32:\"208aa9dbf6dfee943192393bdb2c587e\";s:27:\"includes/class-settings.php\";s:32:\"1aa9d5f5d81b436c968acd0b9a154dd9\";s:23:\"includes/class-term.php\";s:32:\"4592285a64670e403238c6abd61e0b08\";s:36:\"includes/class-thumbnail-overlay.php\";s:32:\"9a1aba2ef9d7bb6e5a4f0427c6546d9a\";s:31:\"includes/class-update-email.php\";s:32:\"e5decf6dee649708fa469105b4dd3519\";s:26:\"includes/class-updates.php\";s:32:\"43446455f1d92a29b5932bca8a07eea1\";s:23:\"includes/class-user.php\";s:32:\"2e5e77bcd63c01304cd763a933f92eb0\";s:31:\"includes/cli/class-commands.php\";s:32:\"bc05a627b1c24a22a33bb6cdde2f2e15\";s:39:\"includes/frontend/class-breadcrumbs.php\";s:32:\"7891413004f8503e6765210752c9628c\";s:36:\"includes/frontend/class-comments.php\";s:32:\"e0e00ef4c0a70a92f3251bde0d5a9ffd\";s:36:\"includes/frontend/class-frontend.php\";s:32:\"d9c63bc8302c2f647b2b6a85e7ef11a1\";s:32:\"includes/frontend/class-head.php\";s:32:\"80e68dce1ec45d58587745ea182f3cf5\";s:43:\"includes/frontend/class-link-attributes.php\";s:32:\"e7401eff4cbb8a2bf9e360ae48be5f4d\";s:39:\"includes/frontend/class-redirection.php\";s:32:\"38b11e421e8e42affd8f82ad1bacf56a\";s:38:\"includes/frontend/class-shortcodes.php\";s:32:\"1b24e08963ab47918691a6b924010dd0\";s:41:\"includes/frontend/paper/class-archive.php\";s:32:\"a7d460aa74a7c6809e374dc1348f2553\";s:40:\"includes/frontend/paper/class-author.php\";s:32:\"323294d60cd8a375a0c2435de2617ece\";s:38:\"includes/frontend/paper/class-blog.php\";s:32:\"edf72f04c88d3299b08cf4d16d618766\";s:38:\"includes/frontend/paper/class-date.php\";s:32:\"fb0fa2bde2c2e179aaf37a95b932ecb0\";s:43:\"includes/frontend/paper/class-error-404.php\";s:32:\"e665b92d36963e975ef7a798b6804335\";s:38:\"includes/frontend/paper/class-misc.php\";s:32:\"6b2dc9c3f701a8f66f1b5705af63c71c\";s:39:\"includes/frontend/paper/class-paper.php\";s:32:\"a1b91cea39e5c59bf459f9ec5d363e5e\";s:40:\"includes/frontend/paper/class-search.php\";s:32:\"3524c25fa894a86a1c6b2ea534928052\";s:38:\"includes/frontend/paper/class-shop.php\";s:32:\"5b2bf8e6f1382714e71afce17947a92d\";s:42:\"includes/frontend/paper/class-singular.php\";s:32:\"a8efa07b24d768945e651510aaa0d97d\";s:42:\"includes/frontend/paper/class-taxonomy.php\";s:32:\"7d93c2ae7a9e556490b522722d7a6b8b\";s:43:\"includes/frontend/paper/interface-paper.php\";s:32:\"90f88e56f4d054fb48f2ac611e47caec\";s:36:\"includes/helpers/class-analytics.php\";s:32:\"ce9eb6bab75287e7aeb4babe6917d5d1\";s:30:\"includes/helpers/class-api.php\";s:32:\"2cc82628f9e8d0a6d549985c9503855b\";s:30:\"includes/helpers/class-arr.php\";s:32:\"788f1c4a472f650433d1b2e527a8fdd7\";s:37:\"includes/helpers/class-attachment.php\";s:32:\"12e0dcfc92badad9a3a07cc89fbc5d9f\";s:34:\"includes/helpers/class-choices.php\";s:32:\"d8ffdf23801d8602ec3a1ac2bceb5b84\";s:38:\"includes/helpers/class-conditional.php\";s:32:\"56d29fa0465f2e13cecce343c21b585d\";s:37:\"includes/helpers/class-content-ai.php\";s:32:\"c72b4275108606b77cf18f68e1663c8b\";s:29:\"includes/helpers/class-db.php\";s:32:\"96c4c2c104afc70ec3729e121f33948a\";s:33:\"includes/helpers/class-editor.php\";s:32:\"bd5b5733dbff0c2776620f32840d39e1\";s:31:\"includes/helpers/class-html.php\";s:32:\"b7a290040ce0ac7c0a80e15dbc804ad0\";s:33:\"includes/helpers/class-locale.php\";s:32:\"38871cbc69315d68ae22d3b834473156\";s:34:\"includes/helpers/class-options.php\";s:32:\"d6d75052ce3237d16b637dee5c817bcc\";s:32:\"includes/helpers/class-param.php\";s:32:\"086ea01471826d7167da7ae73425a48d\";s:36:\"includes/helpers/class-post-type.php\";s:32:\"c9af3975cd7edd7eb5f6b031d14af0ab\";s:33:\"includes/helpers/class-schema.php\";s:32:\"e035fa2381c7cb8cbc33232991b868d5\";s:35:\"includes/helpers/class-security.php\";s:32:\"ddd8be7f989df2b5a8761e882d42aecb\";s:36:\"includes/helpers/class-sitepress.php\";s:32:\"0e0ad5b9d52c0fc811e76b5a503a887a\";s:30:\"includes/helpers/class-str.php\";s:32:\"448efbe7f27603462ae38bdcbfacb4d8\";s:35:\"includes/helpers/class-taxonomy.php\";s:32:\"79f7deea5e16eaad63e1ea3b0a7626f3\";s:30:\"includes/helpers/class-url.php\";s:32:\"77f0ef64ca62ba9e3578af50ab75d714\";s:36:\"includes/helpers/class-wordpress.php\";s:32:\"87d10b486329d26a713e9e45a96ea974\";s:26:\"includes/helpers/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:18:\"includes/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:29:\"includes/interface-runner.php\";s:32:\"398f2e0b1d7ffda0458e450f4f06839f\";s:28:\"includes/metaboxes/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:39:\"includes/metaboxes/link-suggestions.php\";s:32:\"1d77814e03ae128de82db4a106124928\";s:30:\"includes/module/class-base.php\";s:32:\"1bf4cdbecc000082b3ad2aecde86c1b3\";s:33:\"includes/module/class-manager.php\";s:32:\"a710848619c60d2a8e36577de2997360\";s:32:\"includes/module/class-module.php\";s:32:\"7606cbc96fe2b847758fb57a676a88cb\";s:55:\"includes/modules/404-monitor/assets/css/404-monitor.css\";s:32:\"054bf8d17c5e7d91fd62cbc730381d9d\";s:53:\"includes/modules/404-monitor/assets/js/404-monitor.js\";s:32:\"0105bf58d903acc77c27c6e4785e5905\";s:57:\"includes/modules/404-monitor/assets/scss/404-monitor.scss\";s:32:\"e6774ed7c54706a0d504768d3fc2e40c\";s:44:\"includes/modules/404-monitor/class-admin.php\";s:32:\"2e029b3f6de56afe7ccb8a7d9ffc39cd\";s:41:\"includes/modules/404-monitor/class-db.php\";s:32:\"a1afaa5d89d172a3b76910e00a5177b1\";s:46:\"includes/modules/404-monitor/class-monitor.php\";s:32:\"47e55be48c28757de62900562e966231\";s:44:\"includes/modules/404-monitor/class-table.php\";s:32:\"7f45e5e0df59a525e87af9d8967d2718\";s:38:\"includes/modules/404-monitor/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:55:\"includes/modules/404-monitor/views/help-tab-actions.php\";s:32:\"e97a2b034697beb5f932c6837a9251a3\";s:52:\"includes/modules/404-monitor/views/help-tab-bulk.php\";s:32:\"5a5beb69f0f24ad826e45ae27e413ee9\";s:56:\"includes/modules/404-monitor/views/help-tab-overview.php\";s:32:\"fa4408816a30a71cb06c3c68297ccb4d\";s:62:\"includes/modules/404-monitor/views/help-tab-screen-content.php\";s:32:\"528a911d92e9ce2e2a77f64d4aa2782b\";s:44:\"includes/modules/404-monitor/views/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:43:\"includes/modules/404-monitor/views/main.php\";s:32:\"04803a62fba1405224ba1ca28665d5ca\";s:46:\"includes/modules/404-monitor/views/options.php\";s:32:\"7703d4b579e2b4c6b87a3707c2a7efcf\";s:37:\"includes/modules/acf/assets/js/acf.js\";s:32:\"4e9462734a6d2ff663c5d6387cbc72bc\";s:34:\"includes/modules/acf/class-acf.php\";s:32:\"fa32ebde33fbc9e5f96633b7db7f0468\";s:51:\"includes/modules/analytics/assets/css/admin-bar.css\";s:32:\"9db8229264da59ccf05f4bb744c16004\";s:47:\"includes/modules/analytics/assets/css/stats.css\";s:32:\"ab94700999681d8705dda7bb7078b95b\";s:55:\"includes/modules/analytics/assets/img/rank-math-pro.jpg\";s:32:\"98bbf67c367a53f6b6b32c5bd6ebf8eb\";s:62:\"includes/modules/analytics/assets/img/report-icon-external.png\";s:32:\"51c31cc49e41c5a7453344379fe4c806\";s:53:\"includes/modules/analytics/assets/img/report-logo.png\";s:32:\"230887a79c50680bd95ef72df82afddd\";s:60:\"includes/modules/analytics/assets/img/single-post-report.jpg\";s:32:\"6ac510a629262f5f279b4f46ad9e5859\";s:49:\"includes/modules/analytics/assets/js/admin-bar.js\";s:32:\"bc3731ff4c0682f22e9d4736ae9e9375\";s:45:\"includes/modules/analytics/assets/js/stats.js\";s:32:\"106a34497e0717aa6239f4910620b7d1\";s:41:\"includes/modules/analytics/class-ajax.php\";s:32:\"c98f57e64f6b3394a9fadb029d20a1ed\";s:53:\"includes/modules/analytics/class-analytics-common.php\";s:32:\"d3ec1f49af521e6fbe713dcd9577d515\";s:52:\"includes/modules/analytics/class-analytics-stats.php\";s:32:\"6cec9b45436202be65eef1bc92485324\";s:46:\"includes/modules/analytics/class-analytics.php\";s:32:\"7985b93f1a03c0c62eefb8cad2d53480\";s:39:\"includes/modules/analytics/class-db.php\";s:32:\"17c51c3e6bc0eab40af0822e0e1e0008\";s:50:\"includes/modules/analytics/class-email-reports.php\";s:32:\"d28630a96497b12ccc9c363a38ce6672\";s:41:\"includes/modules/analytics/class-gtag.php\";s:32:\"30fba712148051b71bcc15e9aa81618c\";s:45:\"includes/modules/analytics/class-keywords.php\";s:32:\"b4060a1512b361270c7f9eceabc04ab1\";s:44:\"includes/modules/analytics/class-objects.php\";s:32:\"4ba29ecc4c395a9db66181333590a98c\";s:42:\"includes/modules/analytics/class-posts.php\";s:32:\"cc03259d6bb5f67fe259d488caa2642c\";s:42:\"includes/modules/analytics/class-stats.php\";s:32:\"22bdfadd4a2f1c782c92a65b2bf6a9a9\";s:44:\"includes/modules/analytics/class-summary.php\";s:32:\"6b67864afb3b59d0740dcccfd082297e\";s:51:\"includes/modules/analytics/class-url-inspection.php\";s:32:\"18d4d09d27737465324a733e353c7040\";s:44:\"includes/modules/analytics/class-watcher.php\";s:32:\"684ba66fcec11a3eca946f4c8ca89f62\";s:53:\"includes/modules/analytics/google/class-analytics.php\";s:32:\"5c7097f8995967e4a1e2f14aefb6f002\";s:47:\"includes/modules/analytics/google/class-api.php\";s:32:\"cdc1c629ba1ee5fed90ec44037921c50\";s:58:\"includes/modules/analytics/google/class-authentication.php\";s:32:\"e1eda1a9707fe98fe7ec02246f035c51\";s:51:\"includes/modules/analytics/google/class-console.php\";s:32:\"f0ee5400030ff933b41734324de8e781\";s:55:\"includes/modules/analytics/google/class-permissions.php\";s:32:\"b72e0b21b8a3bfb614d85881138b07b1\";s:51:\"includes/modules/analytics/google/class-request.php\";s:32:\"3feb7d66c11b2cd02467c6619feb44b0\";s:58:\"includes/modules/analytics/google/class-url-inspection.php\";s:32:\"92ad619ec8f55b23522a422869aceced\";s:36:\"includes/modules/analytics/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:46:\"includes/modules/analytics/rest/class-rest.php\";s:32:\"91f31b1ea598d380dfe7cee616fcb9e3\";s:46:\"includes/modules/analytics/views/dashboard.php\";s:32:\"738851324cad41668729b07cc9295a6e\";s:54:\"includes/modules/analytics/views/email-reports/cta.php\";s:32:\"ec1f97dbf4586237c51662c42683163f\";s:57:\"includes/modules/analytics/views/email-reports/footer.php\";s:32:\"ffbea0bd51f613e738890fa063a8b7eb\";s:63:\"includes/modules/analytics/views/email-reports/header-after.php\";s:32:\"1909aa50330143f645cd0957a576cdb6\";s:57:\"includes/modules/analytics/views/email-reports/header.php\";s:32:\"3fcaa54738fd9b0122380708030ad0c8\";s:57:\"includes/modules/analytics/views/email-reports/report.php\";s:32:\"d665b45bbd549df28f66d8156c70d429\";s:69:\"includes/modules/analytics/views/email-reports/sections/positions.php\";s:32:\"974e29a5bb7cafc7f1442fa58a9af4c2\";s:67:\"includes/modules/analytics/views/email-reports/sections/summary.php\";s:32:\"1379d4490d8199f56370f3b24c913af2\";s:55:\"includes/modules/analytics/views/email-reports/stat.php\";s:32:\"48c086c33ef34802f38946cf9a197460\";s:56:\"includes/modules/analytics/views/email-reports/style.php\";s:32:\"75feedb7ef7b80682b223e1eda90093c\";s:42:\"includes/modules/analytics/views/index.php\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";s:44:\"includes/modules/analytics/views/options.php\";s:32:\"931731f120ed96b3b3711fc2c8ec5e3d\";s:51:\"includes/modules/analytics/workflows/class-base.php\";s:32:\"aa1507c2d4c76e8b3a69ef04e7e8371c\";s:54:\"includes/modules/analytics/workflows/class-console.php\";s:32:\"47d9494c8640bef96ea5616d5d4f7c6e\";s:58:\"includes/modules/analytics/workflows/class-inspections.php\";s:32:\"904d026d528c9e6e0e1d758194b30a29\";s:51:\"includes/modules/analytics/workflows/class-jobs.php\";s:32:\"ff951caf3ada6d928753f42909eec276\";s:52:\"includes/modules/analytics/workflows/class-oauth.php\";s:32:\"71ba3809ec4f2f14c4464625049497de\";s:54:\"includes/modules/analytics/workflows/class-objects.php\";s:32:\"7268284b093c484ae20a66fd7b4bcdc6\";s:55:\"includes/modules/analytics/workflows/class-workflow.php\";s:32:\"dae28bcccc8f2102d653d6390077443a\";s:43:\"includes/modules/buddypress/class-admin.php\";s:32:\"b657d7a56124ed761eaeacd49bf4be2f\";s:48:\"includes/modules/buddypress/class-buddypress.php\";s:32:\"28f42bbef548db701c562d8298b6478a\";s:52:\"includes/modules/buddypress/paper/class-bp-group.php\";s:32:\"be6d32cd5309a8128e4ba4f2ae912c88\";s:51:\"includes/modules/buddypress/paper/class-bp-user.php\";s:32:\"baf9fa93333d0332a11c2a33375886e3\";s:52:\"includes/modules/buddypress/views/options-titles.php\";s:32:\"4289a151f361b5de881a55a8a1c12db2\";s:58:\"includes/modules/content-ai/assets/css/content-ai-dark.css\";s:32:\"dc93ba3712aa7d16bf6b75a0249a5580\";s:58:\"includes/modules/content-ai/assets/css/content-ai-page.css\";s:32:\"8b5d1ec49f119df5df80cbe21d5f4c20\";s:53:\"includes/modules/content-ai/assets/css/content-ai.css\";s:32:\"2b6a6cc2ff4fbac5577edb6b70d59f41\";s:49:\"includes/modules/content-ai/assets/img/loader.svg\";s:32:\"a6faa06794636218806de0b2353917db\";s:57:\"includes/modules/content-ai/assets/js/content-ai-media.js\";s:32:\"0a541a48c0af9fc3f9e3771c21bac7e6\";s:56:\"includes/modules/content-ai/assets/js/content-ai-page.js\";s:32:\"7a62d0208c87420432680a11d4eda666\";s:51:\"includes/modules/content-ai/assets/js/content-ai.js\";s:32:\"d8714598811dab07074de6e9c2806533\";s:68:\"includes/modules/content-ai/blocks/command/assets/js/index.asset.php\";s:32:\"cc2aab5eca059963efcb065ae4b59586\";s:61:\"includes/modules/content-ai/blocks/command/assets/js/index.js\";s:32:\"7113be51cfddcd5e7177f7f2dddc6fd9\";s:64:\"includes/modules/content-ai/blocks/command/assets/src/block.json\";s:32:\"3ad7bb3c9f9ad75bb6985c64d11cb045\";s:61:\"includes/modules/content-ai/blocks/command/assets/src/edit.js\";s:32:\"3a233173b9f076a8652bbf57d899e725\";s:62:\"includes/modules/content-ai/blocks/command/assets/src/index.js\";s:32:\"ef4847c2ae1eaa0980e61017d4e6e2b6\";s:66:\"includes/modules/content-ai/blocks/command/class-block-command.php\";s:32:\"978b2c3044e77aff3db704cdec75dbbe\";s:43:\"includes/modules/content-ai/class-admin.php\";s:32:\"a6a1ce007a7639710ca3292fff8f414b\";s:44:\"includes/modules/content-ai/class-assets.php\";s:32:\"0e28a1a3dc3e39ecf7b31b77fe64a623\";s:50:\"includes/modules/content-ai/class-bulk-actions.php\";s:32:\"d99fc0afd5e510cd6bfccc6cd74019be\";s:56:\"includes/modules/content-ai/class-bulk-edit-seo-meta.php\";s:32:\"00077f0c49fae341feb96accb2441888\";s:52:\"includes/modules/content-ai/class-bulk-image-alt.php\";s:32:\"ae23838faafb424786df549174487971\";s:53:\"includes/modules/content-ai/class-content-ai-page.php\";s:32:\"cb6aed8fa5b4736ea8cb10431b9597f3\";s:48:\"includes/modules/content-ai/class-content-ai.php\";s:32:\"7cd3d3fa31cab651e8164fdfac44c07e\";s:53:\"includes/modules/content-ai/class-event-scheduler.php\";s:32:\"9ee2667fa4e6d1cdb717e1cd07f7e8c6\";s:42:\"includes/modules/content-ai/class-rest.php\";s:32:\"c45683c2d14a7fb1600b997ed75e8c34\";s:42:\"includes/modules/content-ai/views/main.php\";s:32:\"e61fc36ec956b14ecd253973796d0db7\";s:45:\"includes/modules/content-ai/views/options.php\";s:32:\"538a372a89131fd45e6bbff9f078bec7\";s:55:\"includes/modules/database-tools/class-aioseo-blocks.php\";s:32:\"d61dca456cc4df20fb2c0b67ddeeaedd\";s:62:\"includes/modules/database-tools/class-aioseo-toc-converter.php\";s:32:\"02386402b3046946c41a5f9ace8a500c\";s:56:\"includes/modules/database-tools/class-database-tools.php\";s:32:\"df3af2313ed846d16ccfdc1e7c2420a3\";s:54:\"includes/modules/database-tools/class-update-score.php\";s:32:\"1e205866ffd786e82d55e02a279ff806\";s:54:\"includes/modules/database-tools/class-yoast-blocks.php\";s:32:\"21aed070b60c1f2466476aaea9744033\";s:61:\"includes/modules/database-tools/class-yoast-faq-converter.php\";s:32:\"6d8d4a3c221c4f1bb892ee2fcf291c5b\";s:63:\"includes/modules/database-tools/class-yoast-howto-converter.php\";s:32:\"5a3b15f4a4fdfd66381ec5b3cd034133\";s:63:\"includes/modules/database-tools/class-yoast-local-converter.php\";s:32:\"cd288c5651946076f5604f07f0aac93b\";s:61:\"includes/modules/database-tools/class-yoast-toc-converter.php\";s:32:\"7ce40917b755f33dc2029293b1afd113\";s:51:\"includes/modules/image-seo/class-add-attributes.php\";s:32:\"2e9137ec7c2b345d237414e726b1b312\";s:42:\"includes/modules/image-seo/class-admin.php\";s:32:\"4dedbf7c367b1a3ff2bddd57939608b8\";s:46:\"includes/modules/image-seo/class-image-seo.php\";s:32:\"7b344bc927773ee485a1dfd36707fd1b\";s:36:\"includes/modules/image-seo/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:38:\"includes/modules/image-seo/options.php\";s:32:\"95d587305ea7e1e7f60bfeccb26aafc3\";s:26:\"includes/modules/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:63:\"includes/modules/instant-indexing/assets/js/instant-indexing.js\";s:32:\"7f9ad36015ea45e647e2e36896f66e65\";s:47:\"includes/modules/instant-indexing/class-api.php\";s:32:\"95fa01b709d7532f075ab09cae165181\";s:60:\"includes/modules/instant-indexing/class-instant-indexing.php\";s:32:\"c0674b50beffc3eac4565a670b5a1b8e\";s:48:\"includes/modules/instant-indexing/class-rest.php\";s:32:\"59e3cd23618b9115b6d41cf6307d6435\";s:51:\"includes/modules/instant-indexing/views/console.php\";s:32:\"5323aa3352b93c863cfe457e73d71067\";s:51:\"includes/modules/instant-indexing/views/history.php\";s:32:\"ab8e6468c2498c5e27937dac30a56a62\";s:49:\"includes/modules/instant-indexing/views/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:51:\"includes/modules/instant-indexing/views/options.php\";s:32:\"ccd3e17d449320e714529f3dee7c68af\";s:49:\"includes/modules/links/class-contentprocessor.php\";s:32:\"b7361a2fb8804a720b089630183c66ec\";s:37:\"includes/modules/links/class-link.php\";s:32:\"6bb71eed8a0463cc9074c1848b06c51b\";s:38:\"includes/modules/links/class-links.php\";s:32:\"524ed9b571abee18993bf33d96143624\";s:40:\"includes/modules/links/class-storage.php\";s:32:\"0122d5b632e20911da12bfbbca5f0e62\";s:45:\"includes/modules/local-seo/class-kml-file.php\";s:32:\"cb9052783c92ccdb10975d09c4b9be0c\";s:46:\"includes/modules/local-seo/class-local-seo.php\";s:32:\"84ed422b9716257c66ef329743961fb1\";s:36:\"includes/modules/local-seo/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:42:\"includes/modules/local-seo/views/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:51:\"includes/modules/local-seo/views/titles-options.php\";s:32:\"ed85702639f4cdf339f6f3de9d68eb74\";s:57:\"includes/modules/redirections/assets/css/redirections.css\";s:32:\"0eba3522c12d33eb6eec2381b3d1189f\";s:55:\"includes/modules/redirections/assets/js/redirections.js\";s:32:\"6fbce1d818c8d1c85a118947697a0872\";s:45:\"includes/modules/redirections/class-admin.php\";s:32:\"f3995a90a0e0380f7d4392ced91af62e\";s:45:\"includes/modules/redirections/class-cache.php\";s:32:\"fd56cd4bb8e8c453b88a8d2d9824d817\";s:42:\"includes/modules/redirections/class-db.php\";s:32:\"73efe6ee2ee9611699a77943c98858b4\";s:48:\"includes/modules/redirections/class-debugger.php\";s:32:\"c5d1f0e4f31bbdb7a8d55d8a96a7e287\";s:46:\"includes/modules/redirections/class-export.php\";s:32:\"c3d608fc65c701b8733f8b13b8df2ae5\";s:53:\"includes/modules/redirections/class-import-export.php\";s:32:\"6e99149262aad945a91ac76364151514\";s:47:\"includes/modules/redirections/class-metabox.php\";s:32:\"e66ad037af9480690dacc49bf73693f1\";s:51:\"includes/modules/redirections/class-redirection.php\";s:32:\"7c1867ed46af34cc94b734b5fbcea78d\";s:52:\"includes/modules/redirections/class-redirections.php\";s:32:\"5ba60ddbbecb4cf5d479ff182f3de042\";s:50:\"includes/modules/redirections/class-redirector.php\";s:32:\"c069cb6d3e5144ca177c9b1362b2b832\";s:45:\"includes/modules/redirections/class-table.php\";s:32:\"db3f0935624baa398152ea6a7f5ba8ea\";s:47:\"includes/modules/redirections/class-watcher.php\";s:32:\"34a4c7e730ce494dfc99a8f2a4504815\";s:49:\"includes/modules/redirections/views/debugging.php\";s:32:\"b3a878d80e047e4cc9606e6ec75f1d50\";s:56:\"includes/modules/redirections/views/help-tab-actions.php\";s:32:\"fd16c0c9ba67f4fde1c1816d74416827\";s:53:\"includes/modules/redirections/views/help-tab-bulk.php\";s:32:\"ffc9c50e7bbda4debcf12b45ddf90d25\";s:57:\"includes/modules/redirections/views/help-tab-overview.php\";s:32:\"d32158343e22a25f68721ec110b7db07\";s:63:\"includes/modules/redirections/views/help-tab-screen-content.php\";s:32:\"1630e21df3c8897a3e2d973d528186bb\";s:44:\"includes/modules/redirections/views/main.php\";s:32:\"d896c22d6d52af70d1f5297a0d017d1d\";s:47:\"includes/modules/redirections/views/options.php\";s:32:\"cd3720bf24b77b29eeb87605e37c79dc\";s:48:\"includes/modules/robots-txt/class-robots-txt.php\";s:32:\"0c0e59886d399b7877ce59f806a35214\";s:37:\"includes/modules/robots-txt/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:39:\"includes/modules/robots-txt/options.php\";s:32:\"f1a398ebdd4e7d858e380f58ad81f0b9\";s:55:\"includes/modules/role-manager/assets/js/role-manager.js\";s:32:\"34a291e7ef18286f25af9b31bdce0e06\";s:58:\"includes/modules/role-manager/class-capability-manager.php\";s:32:\"3a80ae1923ffbab2b44e8547e00401e0\";s:47:\"includes/modules/role-manager/class-members.php\";s:32:\"128f14e30807a505a5176a424a62d5a9\";s:52:\"includes/modules/role-manager/class-role-manager.php\";s:32:\"528e2ef1dcaf5e8f1d73169eea5b67e0\";s:56:\"includes/modules/role-manager/class-user-role-editor.php\";s:32:\"afd3229be1b04ba559c6b9dadeeaf250\";s:39:\"includes/modules/role-manager/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:50:\"includes/modules/schema/assets/css/schema-dark.css\";s:32:\"41f606f2edb6c141e32082db849e3e87\";s:45:\"includes/modules/schema/assets/css/schema.css\";s:32:\"6956917842e5b39c224342e3995321fa\";s:60:\"includes/modules/schema/assets/img/custom-schema-builder.jpg\";s:32:\"fc8b40a4f6ace288e6d3b081b346109e\";s:53:\"includes/modules/schema/assets/js/schema-gutenberg.js\";s:32:\"690d0e577ce151f5d4153a83bf24e736\";s:52:\"includes/modules/schema/assets/js/schema-template.js\";s:32:\"d83b8170c72af1f8941ddc8bd52e51e6\";s:46:\"includes/modules/schema/blocks/class-admin.php\";s:32:\"ba7be22681fa7a08d7666ae608c3afc4\";s:50:\"includes/modules/schema/blocks/class-block-faq.php\";s:32:\"96e2110fc8e13fbc9d559f7fdd943376\";s:52:\"includes/modules/schema/blocks/class-block-howto.php\";s:32:\"b51011de13c418c3f674d69b51fee383\";s:53:\"includes/modules/schema/blocks/class-block-parser.php\";s:32:\"15658ddf2515177fa2d64a675c0e0dbf\";s:46:\"includes/modules/schema/blocks/class-block.php\";s:32:\"10363fff845fc72199f4f07035fe129b\";s:53:\"includes/modules/schema/blocks/toc/assets/css/toc.css\";s:32:\"4cb5f2f1dd2e947804ccfc7fa347c71a\";s:64:\"includes/modules/schema/blocks/toc/assets/css/toc_list_style.css\";s:32:\"8fc08160d3e88fe360a49f9997cd7bda\";s:60:\"includes/modules/schema/blocks/toc/assets/js/index.asset.php\";s:32:\"052610d0dce8fca70dd81fab01b67393\";s:53:\"includes/modules/schema/blocks/toc/assets/js/index.js\";s:32:\"a5a177d51d4b82327d3752945b366706\";s:55:\"includes/modules/schema/blocks/toc/assets/scss/toc.scss\";s:32:\"3e0e5d5b808dabacab32897933eb2cfc\";s:66:\"includes/modules/schema/blocks/toc/assets/scss/toc_list_style.scss\";s:32:\"b1a150a1444d566299252b176c83e7be\";s:59:\"includes/modules/schema/blocks/toc/assets/src/deprecated.js\";s:32:\"36ef03a23f76518b763bfadced334ee5\";s:53:\"includes/modules/schema/blocks/toc/assets/src/edit.js\";s:32:\"5435135999863467e50b6f5be4a10582\";s:54:\"includes/modules/schema/blocks/toc/assets/src/index.js\";s:32:\"3ea97d2ff8620be8d28c9099692ce51a\";s:64:\"includes/modules/schema/blocks/toc/assets/src/inspectControls.js\";s:32:\"af1c1e71d6ee6a2853447ae4207492c2\";s:53:\"includes/modules/schema/blocks/toc/assets/src/list.js\";s:32:\"ab7330353b267da1e2659c748bfe1e12\";s:53:\"includes/modules/schema/blocks/toc/assets/src/save.js\";s:32:\"a472521550536a6014a5bbbbf503878d\";s:56:\"includes/modules/schema/blocks/toc/assets/src/toolbar.js\";s:32:\"c22323d4a6a3b75a9b7d782967d05dac\";s:54:\"includes/modules/schema/blocks/toc/assets/src/utils.js\";s:32:\"4e598591830a8f5ce6188ebe8c04ac8c\";s:45:\"includes/modules/schema/blocks/toc/block.json\";s:32:\"c3d824678f20b2d555523045e5368309\";s:54:\"includes/modules/schema/blocks/toc/class-block-toc.php\";s:32:\"4fd1b38b64dc5fd97a38715c1aba65cf\";s:56:\"includes/modules/schema/blocks/views/options-general.php\";s:32:\"0b264bc4caba92ef82351a7fc9ab6685\";s:39:\"includes/modules/schema/class-admin.php\";s:32:\"6810bd56c3c465c989a2686ff2d123d9\";s:40:\"includes/modules/schema/class-blocks.php\";s:32:\"ef6a6a36cb83f3c7a310fa632af677ad\";s:36:\"includes/modules/schema/class-db.php\";s:32:\"cd03ded74d18c2eb90da5a7d8e58aaba\";s:42:\"includes/modules/schema/class-frontend.php\";s:32:\"5e3de5151e7a17d9ec278e9c5f6464e6\";s:40:\"includes/modules/schema/class-jsonld.php\";s:32:\"70294111c3771ede624583e4f907735b\";s:43:\"includes/modules/schema/class-opengraph.php\";s:32:\"f88568f908212b43f985d18568380b5a\";s:40:\"includes/modules/schema/class-schema.php\";s:32:\"c2f0365825bf7f46ad5f022adb3bb77d\";s:51:\"includes/modules/schema/class-snippet-shortcode.php\";s:32:\"6731b3e55a50671af5c1640c8b2f5ff0\";s:33:\"includes/modules/schema/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:45:\"includes/modules/schema/interface-snippet.php\";s:32:\"7ce074de04a6e7e898497448b0476914\";s:42:\"includes/modules/schema/shortcode/book.php\";s:32:\"1cc6c3a8e7008a5349122f5879f4dcc9\";s:44:\"includes/modules/schema/shortcode/course.php\";s:32:\"a6a8f52c5279551f06cd92f9277ba89b\";s:43:\"includes/modules/schema/shortcode/event.php\";s:32:\"eaa4dad5923520b03bc7d3b416c12a00\";s:43:\"includes/modules/schema/shortcode/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:48:\"includes/modules/schema/shortcode/jobposting.php\";s:32:\"0d640ffbb3c550121536777f4aee1b85\";s:43:\"includes/modules/schema/shortcode/music.php\";s:32:\"490f34fbec8f3821b6719abc8bbf57d9\";s:44:\"includes/modules/schema/shortcode/person.php\";s:32:\"b097b5335c0cfabe7585d0e7daad582d\";s:45:\"includes/modules/schema/shortcode/product.php\";s:32:\"c7275fba7c1bd74ac08ad9e90cfcae36\";s:44:\"includes/modules/schema/shortcode/recipe.php\";s:32:\"d37cd399efe1b753c9c6bbd46b267268\";s:48:\"includes/modules/schema/shortcode/restaurant.php\";s:32:\"df7d972d7b2f09d7dc5749ceb4e80fa4\";s:45:\"includes/modules/schema/shortcode/service.php\";s:32:\"70816f597518a963de51956c3cbbb425\";s:57:\"includes/modules/schema/shortcode/softwareapplication.php\";s:32:\"d115f9fa3d4164296150a986af6bca47\";s:49:\"includes/modules/schema/shortcode/videoobject.php\";s:32:\"800bfde14be5bbbadd36dca2c03418a2\";s:50:\"includes/modules/schema/snippets/class-article.php\";s:32:\"9f20d14a76406aabdd2bdf63cc8001e0\";s:49:\"includes/modules/schema/snippets/class-author.php\";s:32:\"bbd3c5db6f7411c74358599d5fd1fc1d\";s:54:\"includes/modules/schema/snippets/class-breadcrumbs.php\";s:32:\"4292146d5b6a6a8a78fac5e3f57275a6\";s:55:\"includes/modules/schema/snippets/class-primaryimage.php\";s:32:\"c1078bb1e633812d180570ffaa8e5622\";s:54:\"includes/modules/schema/snippets/class-product-edd.php\";s:32:\"9051da83867786a8a7e235e9f963a634\";s:62:\"includes/modules/schema/snippets/class-product-woocommerce.php\";s:32:\"ffb1fe33b91d5740048003beb2c5cb89\";s:50:\"includes/modules/schema/snippets/class-product.php\";s:32:\"ed969eb84cc7217c73859d10da827b0d\";s:56:\"includes/modules/schema/snippets/class-products-page.php\";s:32:\"6052528e36968a190876ef1c2a268bc6\";s:52:\"includes/modules/schema/snippets/class-publisher.php\";s:32:\"711b39a50fdae12400d79d56060aeea0\";s:51:\"includes/modules/schema/snippets/class-singular.php\";s:32:\"943ce871f1f0fb369d05337475e9eb88\";s:56:\"includes/modules/schema/snippets/class-wc-attributes.php\";s:32:\"96d39fae8f24927c14e6778b88f303bd\";s:50:\"includes/modules/schema/snippets/class-webpage.php\";s:32:\"eb02010d8d338a8749c45934d6d5caf0\";s:50:\"includes/modules/schema/snippets/class-website.php\";s:32:\"e39a0942caf9904621f0e74057f0c44d\";s:49:\"includes/modules/schema/views/metabox-options.php\";s:32:\"2d259b2d68b3e95769315389f57fe177\";s:57:\"includes/modules/seo-analysis/assets/css/seo-analysis.css\";s:32:\"537b863a4be35d71dd1fb0217172ecb8\";s:62:\"includes/modules/seo-analysis/assets/js/circle-progress.min.js\";s:32:\"ef8b334cc6f1654079d3b1d94ac3e8f1\";s:55:\"includes/modules/seo-analysis/assets/js/seo-analysis.js\";s:32:\"b4e3efb20fee45ae13f1218a258ebb36\";s:50:\"includes/modules/seo-analysis/class-admin-tabs.php\";s:32:\"547f65472c9aa141699d1b29fb3f7d11\";s:45:\"includes/modules/seo-analysis/class-admin.php\";s:32:\"2d8491a59fac50c345221598be04f4de\";s:46:\"includes/modules/seo-analysis/class-result.php\";s:32:\"d6b9ab4e5c3f0f96e4ade500726e6044\";s:52:\"includes/modules/seo-analysis/class-seo-analysis.php\";s:32:\"06ab5799bed13ff00327280806eee236\";s:52:\"includes/modules/seo-analysis/class-seo-analyzer.php\";s:32:\"bcaed0b9b8fd2eea139802f228287aee\";s:39:\"includes/modules/seo-analysis/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:52:\"includes/modules/seo-analysis/seo-analysis-tests.php\";s:32:\"1a0d12234512a6ad00a210dff42cfa46\";s:59:\"includes/modules/seo-analysis/views/competitor-analysis.php\";s:32:\"115178fba53b0fa4999cb53ae6a4de0a\";s:44:\"includes/modules/seo-analysis/views/form.php\";s:32:\"c5ddb269f595ffab494f1d731d9c5639\";s:46:\"includes/modules/seo-analysis/views/graphs.php\";s:32:\"a1c9f9a7c981c6af0819282fc13a8211\";s:45:\"includes/modules/seo-analysis/views/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:44:\"includes/modules/seo-analysis/views/main.php\";s:32:\"da96850c86cdde806a0bf16a415201eb\";s:52:\"includes/modules/seo-analysis/views/seo-analyzer.php\";s:32:\"2a78e4a2339a6d0f9b195e3eada22612\";s:52:\"includes/modules/seo-analysis/views/serp-preview.php\";s:32:\"1fbee90b8dce2016b17ceffc9e12cf10\";s:41:\"includes/modules/sitemap/abstract-xml.php\";s:32:\"6173ebccde799d8a7e028b6b06cae259\";s:40:\"includes/modules/sitemap/class-admin.php\";s:32:\"78ce17473ca4dfce4a6627a92bc6f607\";s:48:\"includes/modules/sitemap/class-cache-watcher.php\";s:32:\"8b5c9412856431e6434d0fbb12b0d257\";s:40:\"includes/modules/sitemap/class-cache.php\";s:32:\"1a2961184e83a047e415a7eb9913dba5\";s:45:\"includes/modules/sitemap/class-classifier.php\";s:32:\"b7ce6804974b31f26dc70186e03a9d43\";s:44:\"includes/modules/sitemap/class-generator.php\";s:32:\"f84124040a43eca305a40f7f06077db9\";s:47:\"includes/modules/sitemap/class-image-parser.php\";s:32:\"3665a14b434f50e9c556e83d4a30eda2\";s:57:\"includes/modules/sitemap/class-redirect-core-sitemaps.php\";s:32:\"5d6a62b485ff47d3268de9df4667516e\";s:41:\"includes/modules/sitemap/class-router.php\";s:32:\"2ccd644d9fa4a285663943266a667b89\";s:48:\"includes/modules/sitemap/class-sitemap-index.php\";s:32:\"1cd3ad981afd350b34ea035569c621ac\";s:46:\"includes/modules/sitemap/class-sitemap-xml.php\";s:32:\"449bf09303396cf43647c02fed5e9e63\";s:42:\"includes/modules/sitemap/class-sitemap.php\";s:32:\"3a766cfc0f4517221ed72b653d3b7b2c\";s:45:\"includes/modules/sitemap/class-stylesheet.php\";s:32:\"8f4c2c781a92d540144add5ef1f0aa29\";s:43:\"includes/modules/sitemap/class-timezone.php\";s:32:\"9ea74592744379db9cee9c5427271f47\";s:55:\"includes/modules/sitemap/html-sitemap/class-authors.php\";s:32:\"d14509879821bd53046df3b32fe7d749\";s:53:\"includes/modules/sitemap/html-sitemap/class-posts.php\";s:32:\"356e047fd4fa91c367d63855fe300be0\";s:55:\"includes/modules/sitemap/html-sitemap/class-sitemap.php\";s:32:\"f7221017fa1557df4129642b0b051c42\";s:53:\"includes/modules/sitemap/html-sitemap/class-terms.php\";s:32:\"af52d81d70494531411d938f58714c72\";s:34:\"includes/modules/sitemap/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:51:\"includes/modules/sitemap/providers/class-author.php\";s:32:\"9b60ffb1102c91203cf61b091e09a083\";s:54:\"includes/modules/sitemap/providers/class-post-type.php\";s:32:\"075b218bd51895a480d21000139de81d\";s:53:\"includes/modules/sitemap/providers/class-taxonomy.php\";s:32:\"c92ec493a44e3823bacbe775672ab50f\";s:44:\"includes/modules/sitemap/providers/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:57:\"includes/modules/sitemap/providers/interface-provider.php\";s:32:\"fe98c846982b5662305b947d6e474142\";s:45:\"includes/modules/sitemap/settings/authors.php\";s:32:\"e7c5d883cabc08448801715aa6fdb502\";s:45:\"includes/modules/sitemap/settings/general.php\";s:32:\"4d5decba436df2c008e0212e1c173990\";s:50:\"includes/modules/sitemap/settings/html-sitemap.php\";s:32:\"e2dc490233ad2ec2e248afda4a3b33c6\";s:43:\"includes/modules/sitemap/settings/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:48:\"includes/modules/sitemap/settings/post-types.php\";s:32:\"86a2ef5c78ecc4975ad49c77696e09d1\";s:48:\"includes/modules/sitemap/settings/taxonomies.php\";s:32:\"8c91d5ad22106be744d180a878cab96c\";s:40:\"includes/modules/sitemap/sitemap-xsl.php\";s:32:\"2cc49bfadcd79c87d6144ff70d2c706f\";s:45:\"includes/modules/status/assets/css/status.css\";s:32:\"333d39f1bd0c0bd102ac577323ea96b5\";s:43:\"includes/modules/status/assets/js/status.js\";s:32:\"47f142854b9bbf1d5e74a474e56e96d2\";s:43:\"includes/modules/status/class-error-log.php\";s:32:\"10872c51b3b4cff360a1bde4f8beb8a0\";s:40:\"includes/modules/status/class-status.php\";s:32:\"da7d4bac54b98cedb2659a527324fe71\";s:47:\"includes/modules/status/class-system-status.php\";s:32:\"5c42aae4f2558fbe070e03bc9b828a5c\";s:33:\"includes/modules/status/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:39:\"includes/modules/status/views/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:38:\"includes/modules/status/views/main.php\";s:32:\"8239a12fe77894500974d01f3c297a24\";s:57:\"includes/modules/status/views/system-status-accordion.php\";s:32:\"e8162d833b7de7da2bc37a0c6f88b5f8\";s:63:\"includes/modules/version-control/assets/css/version-control.css\";s:32:\"d9d62726881d2f9d2a3aaeb6857423c5\";s:61:\"includes/modules/version-control/assets/js/version-control.js\";s:32:\"9dcdf63fd31b4c602d59af12ba0e9ab4\";s:53:\"includes/modules/version-control/class-beta-optin.php\";s:32:\"fcddd87ceb05746e5a8c73f83987186a\";s:59:\"includes/modules/version-control/class-rollback-version.php\";s:32:\"201f01056cd1d0f021739e0ff0562a46\";s:58:\"includes/modules/version-control/class-version-control.php\";s:32:\"7d65261429f87629bc4f0cd4472a7f78\";s:44:\"includes/modules/version-control/display.php\";s:32:\"0cfbfab4a84c60fbe2a727375c86b557\";s:42:\"includes/modules/version-control/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:60:\"includes/modules/version-control/views/auto-update-panel.php\";s:32:\"6f2a6294325da826abcdbd878627fd89\";s:59:\"includes/modules/version-control/views/beta-optin-panel.php\";s:32:\"e1197326095e25fa5ab4d58760a006d6\";s:48:\"includes/modules/version-control/views/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:64:\"includes/modules/version-control/views/version-control-panel.php\";s:32:\"f8dcd9e01f142c1d34ceab543c04df59\";s:50:\"includes/modules/web-stories/class-web-stories.php\";s:32:\"0e827363724eb5da54caa156177edbda\";s:38:\"includes/modules/web-stories/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:53:\"includes/modules/woocommerce/assets/js/woocommerce.js\";s:32:\"b4c1495b986377e80c8b137933303c2f\";s:44:\"includes/modules/woocommerce/class-admin.php\";s:32:\"f10d5101b508068e806e87f0833ecbd6\";s:48:\"includes/modules/woocommerce/class-opengraph.php\";s:32:\"41171dc6dff8f59ebd1d891f8c891219\";s:56:\"includes/modules/woocommerce/class-permalink-watcher.php\";s:32:\"7008dea21dc35b2809523fff312bc3c5\";s:58:\"includes/modules/woocommerce/class-product-redirection.php\";s:32:\"becccb63341ff9eb5515ed820df8986f\";s:46:\"includes/modules/woocommerce/class-sitemap.php\";s:32:\"eb3473ec3fc9a9bce16c676d0ef560f2\";s:46:\"includes/modules/woocommerce/class-wc-vars.php\";s:32:\"e97bb6ba973ebf043782189cf3c793ca\";s:50:\"includes/modules/woocommerce/class-woocommerce.php\";s:32:\"0a70929331ef61709b34680d4f7dab0f\";s:38:\"includes/modules/woocommerce/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:44:\"includes/modules/woocommerce/views/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:54:\"includes/modules/woocommerce/views/options-general.php\";s:32:\"075ef25330cdf65c54bcb9789977489f\";s:44:\"includes/opengraph/class-facebook-locale.php\";s:32:\"27d7f6b186a67e7f75dd5db4ac3b0df3\";s:37:\"includes/opengraph/class-facebook.php\";s:32:\"883b9b550a42fb5affe3168ec62ebbf5\";s:34:\"includes/opengraph/class-image.php\";s:32:\"d99945652a52a5b5308a911de0ef3eab\";s:38:\"includes/opengraph/class-opengraph.php\";s:32:\"f9a35e1d95fa5a2296ba1d3dea07d25c\";s:34:\"includes/opengraph/class-slack.php\";s:32:\"1aeb10a66522dd9d4e80f9ab35229df0\";s:36:\"includes/opengraph/class-twitter.php\";s:32:\"cd930fce48186f84a21e4bf35534749d\";s:28:\"includes/opengraph/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:55:\"includes/replace-variables/class-advanced-variables.php\";s:32:\"b982f3d741f114b057844d7fdf721ccd\";s:53:\"includes/replace-variables/class-author-variables.php\";s:32:\"c8607821590e348784ddf0b34b43e3f8\";s:41:\"includes/replace-variables/class-base.php\";s:32:\"dc4c20b14ab01cda8a9935bf71584fc3\";s:52:\"includes/replace-variables/class-basic-variables.php\";s:32:\"3315bbffbd44d470b8eeb277ab1f165f\";s:42:\"includes/replace-variables/class-cache.php\";s:32:\"b709402ee011ddf8f01528c7d99e54bb\";s:44:\"includes/replace-variables/class-manager.php\";s:32:\"6db83c8843754486b905a7109496adca\";s:51:\"includes/replace-variables/class-post-variables.php\";s:32:\"d2eb6e18d30197637e3522c39c1847e1\";s:45:\"includes/replace-variables/class-replacer.php\";s:32:\"aa6b4f6f6843898c99618821792356b0\";s:51:\"includes/replace-variables/class-term-variables.php\";s:32:\"d530fbdffaaf4ef84cc2a6fb1f9c8175\";s:45:\"includes/replace-variables/class-variable.php\";s:32:\"f0f3bf552e030673a0fde079b7d45500\";s:29:\"includes/rest/class-admin.php\";s:32:\"c3cdf77af0bd35e41e92cb0c0b9f6a41\";s:29:\"includes/rest/class-front.php\";s:32:\"3b0f70f1c6c336b7b9d367a9f6f660b6\";s:32:\"includes/rest/class-headless.php\";s:32:\"1fe85598c190831c85c56913b1f49159\";s:28:\"includes/rest/class-post.php\";s:32:\"b71a4d6aaa48c1d0f28a0dd1472299d4\";s:35:\"includes/rest/class-rest-helper.php\";s:32:\"314873e1e6c30a204875177008dfd346\";s:32:\"includes/rest/class-sanitize.php\";s:32:\"d411bc8bcf209f64e20bed103b5c5d97\";s:30:\"includes/rest/class-shared.php\";s:32:\"b167faa2351174c7ffdb8605d5878dad\";s:41:\"includes/settings/general/breadcrumbs.php\";s:32:\"9e80644066c7b25c87e53a158d94cba1\";s:38:\"includes/settings/general/htaccess.php\";s:32:\"d193edba9b415a79f4409154a8c3d937\";s:35:\"includes/settings/general/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:35:\"includes/settings/general/links.php\";s:32:\"6ec7673c50033bff496f0b4fc92696c1\";s:36:\"includes/settings/general/others.php\";s:32:\"084a68963243f57c678d3259f8643cf5\";s:44:\"includes/settings/general/rss-vars-table.php\";s:32:\"963e2f0b9b47120accc0bd7882d52b6f\";s:39:\"includes/settings/general/webmaster.php\";s:32:\"d104595d3ce1d934b4d5a325aa43d371\";s:27:\"includes/settings/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:35:\"includes/settings/titles/author.php\";s:32:\"c4e4cc67fd06ab89964d06d97293ae9d\";s:35:\"includes/settings/titles/global.php\";s:32:\"e1c5699d644bad0d0c7c46cbe965c586\";s:37:\"includes/settings/titles/homepage.php\";s:32:\"f633c94007e173f0fb5c52c630605476\";s:34:\"includes/settings/titles/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:34:\"includes/settings/titles/local.php\";s:32:\"ec7c5026f031afd7f0baa99ae858596d\";s:33:\"includes/settings/titles/misc.php\";s:32:\"24a679eb9efa64c758df7a58ba6240f1\";s:39:\"includes/settings/titles/post-types.php\";s:32:\"ba1ba593cd3e5668abdce269de498d3f\";s:35:\"includes/settings/titles/social.php\";s:32:\"67e6feeea68a86a58119e20897b02be3\";s:39:\"includes/settings/titles/taxonomies.php\";s:32:\"082b707d6e8245a77dce72c73df4263b\";s:26:\"includes/template-tags.php\";s:32:\"0baa91fc2c1fb95517642e2cfa5d65ce\";s:30:\"includes/traits/class-ajax.php\";s:32:\"23d7a9f3f17655570e27894ee70da93a\";s:31:\"includes/traits/class-cache.php\";s:32:\"91e5a04e5d6920a57d17a9b381504a70\";s:32:\"includes/traits/class-hooker.php\";s:32:\"befaa9931c8af2239011c8716749a46f\";s:30:\"includes/traits/class-meta.php\";s:32:\"25082491aa21cab8f12fe7067166e3dd\";s:35:\"includes/traits/class-shortcode.php\";s:32:\"dc6b8361b05d40bf0829b0f763435ece\";s:32:\"includes/traits/class-wizard.php\";s:32:\"fc63136c563a156a37b19612f2e65de2\";s:25:\"includes/traits/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:37:\"includes/updates/update-1.0.103.1.php\";s:32:\"924059be65cf24e0ac2214da921790fe\";s:35:\"includes/updates/update-1.0.104.php\";s:32:\"56e5c0ce38fee62ec4e791f51a205a57\";s:37:\"includes/updates/update-1.0.107.3.php\";s:32:\"64eacb92fe07886e8e87f3911dbc4cde\";s:35:\"includes/updates/update-1.0.110.php\";s:32:\"277714b3c3eb0691d3eb2c233a8110bc\";s:37:\"includes/updates/update-1.0.201.1.php\";s:32:\"e2931e0c9a8e3064698877853437e5d5\";s:35:\"includes/updates/update-1.0.201.php\";s:32:\"bebbbe6d60b961f63ab6b3b20d8eaedd\";s:35:\"includes/updates/update-1.0.202.php\";s:32:\"ebcfb0a3d8615cd8253ab5252c291f03\";s:35:\"includes/updates/update-1.0.208.php\";s:32:\"ece5a517923888ad505987cfbe3e4b8e\";s:35:\"includes/updates/update-1.0.209.php\";s:32:\"ec6166ec8f208643aba944cd9d76b948\";s:35:\"includes/updates/update-1.0.211.php\";s:32:\"a4781b45ae53dc3ee7ab4f5144c21a5c\";s:34:\"includes/updates/update-1.0.84.php\";s:32:\"98a82f735bdc38ddcc6edc73774ba743\";s:34:\"includes/updates/update-1.0.86.php\";s:32:\"667ad811417c5b75265bd76833cf6add\";s:34:\"includes/updates/update-1.0.89.php\";s:32:\"f3fc58d8bc7385f0bf95afe59ec630b8\";s:34:\"includes/updates/update-1.0.98.php\";s:32:\"47fc86709e71baa72f4ad261754a3a9d\";s:23:\"languages/rank-math.pot\";s:32:\"02d53d68a02c9fdb686de2ef6b2153a4\";s:13:\"rank-math.php\";s:32:\"4c4deb8e97694febd3dcd0b70213ed41\";s:10:\"readme.txt\";s:32:\"bc1e0b4af6bf4b5ebbbe193b4893722a\";s:13:\"uninstall.php\";s:32:\"ae9140530677e5ab1e778527056f16d8\";s:63:\"vendor/a5hleyrich/wp-background-processing/.circleci/config.yml\";s:32:\"d9674ea5e57108ed567cf2112e5aa140\";s:53:\"vendor/a5hleyrich/wp-background-processing/.phpcs.xml\";s:32:\"12b36481b7dfc43ebf5d4400f57a46d4\";s:51:\"vendor/a5hleyrich/wp-background-processing/Makefile\";s:32:\"4cbb3489e82d5e7d5dc010486811011a\";s:71:\"vendor/a5hleyrich/wp-background-processing/classes/wp-async-request.php\";s:32:\"a00d9e876ab2f37ca417dfc58a7d9865\";s:76:\"vendor/a5hleyrich/wp-background-processing/classes/wp-background-process.php\";s:32:\"f0e20090e35fb17564ca4ff0344f9457\";s:54:\"vendor/a5hleyrich/wp-background-processing/license.txt\";s:32:\"8dc15a482314ccb972005b821686118f\";s:71:\"vendor/a5hleyrich/wp-background-processing/wp-background-processing.php\";s:32:\"cd5b40c66b467d7656212193e7b0ac5b\";s:19:\"vendor/autoload.php\";s:32:\"5c256a1dbef492fbcb78b29bc282837c\";s:24:\"vendor/cmb2/cmb2/LICENSE\";s:32:\"1ebbd3e34237af26da5dc08a4e440464\";s:30:\"vendor/cmb2/cmb2/bootstrap.php\";s:32:\"24d4acd1f49023664d0ca3dc6f3df3e4\";s:33:\"vendor/cmb2/cmb2/css/cmb2-rtl.css\";s:32:\"f5e65abf76e962f2aee7cd5dcdcda6af\";s:37:\"vendor/cmb2/cmb2/css/cmb2-rtl.min.css\";s:32:\"60fb306214808e2ad0fa353c44bf5a4c\";s:29:\"vendor/cmb2/cmb2/css/cmb2.css\";s:32:\"4f9ec7b7dcd3f2fbb2e8c96ea6bb46a6\";s:33:\"vendor/cmb2/cmb2/css/cmb2.min.css\";s:32:\"037c51796b425ff9d5fb8ec9843960c6\";s:30:\"vendor/cmb2/cmb2/css/index.php\";s:32:\"691196b33d9fed0013a58c215cd5dfff\";s:34:\"vendor/cmb2/cmb2/includes/CMB2.php\";s:32:\"c8407067c3163e6714babab69afa89b8\";s:39:\"vendor/cmb2/cmb2/includes/CMB2_Ajax.php\";s:32:\"578a377c893ed9cb52f3ae3c97d35fd8\";s:39:\"vendor/cmb2/cmb2/includes/CMB2_Base.php\";s:32:\"3e512f8fbb0fef15d17778f34caeaca2\";s:40:\"vendor/cmb2/cmb2/includes/CMB2_Boxes.php\";s:32:\"2d7de6c5f135703ea52950f19a2ac610\";s:40:\"vendor/cmb2/cmb2/includes/CMB2_Field.php\";s:32:\"d3f480b20b0081068e4561b5b09a6ffc\";s:48:\"vendor/cmb2/cmb2/includes/CMB2_Field_Display.php\";s:32:\"da27fccb5056a86671367d007ad636e6\";s:41:\"vendor/cmb2/cmb2/includes/CMB2_Hookup.php\";s:32:\"600db5c06e38444251c00307915fdf76\";s:46:\"vendor/cmb2/cmb2/includes/CMB2_Hookup_Base.php\";s:32:\"fd1e863ceb0f4a59d2a51e269fadf7e5\";s:47:\"vendor/cmb2/cmb2/includes/CMB2_Hookup_Field.php\";s:32:\"0b01be7ebb1bba9c07edc286fb0faa6c\";s:37:\"vendor/cmb2/cmb2/includes/CMB2_JS.php\";s:32:\"fc13fdc0cd31f3f47dc27161432f6bd2\";s:42:\"vendor/cmb2/cmb2/includes/CMB2_Options.php\";s:32:\"03541a4356ec13dca83d582cf2de1467\";s:49:\"vendor/cmb2/cmb2/includes/CMB2_Options_Hookup.php\";s:32:\"fe082368984d90ba181fb8ba1c662015\";s:43:\"vendor/cmb2/cmb2/includes/CMB2_Sanitize.php\";s:32:\"4199618f214d9ae2e2ca75beb2d622f1\";s:47:\"vendor/cmb2/cmb2/includes/CMB2_Show_Filters.php\";s:32:\"bd770f24aa5ab0723c956edc72437fa0\";s:40:\"vendor/cmb2/cmb2/includes/CMB2_Types.php\";s:32:\"45081f22915fda436e53bc5c39b7d8b0\";s:40:\"vendor/cmb2/cmb2/includes/CMB2_Utils.php\";s:32:\"3c76ed039f27049b6a5b20b4794cbedf\";s:46:\"vendor/cmb2/cmb2/includes/helper-functions.php\";s:32:\"b607176b1c24bc68c614049411213064\";s:35:\"vendor/cmb2/cmb2/includes/index.php\";s:32:\"691196b33d9fed0013a58c215cd5dfff\";s:48:\"vendor/cmb2/cmb2/includes/rest-api/CMB2_REST.php\";s:32:\"d0023055eacb247fbf2fe3ee33073977\";s:59:\"vendor/cmb2/cmb2/includes/rest-api/CMB2_REST_Controller.php\";s:32:\"8219d99e1249d91f461a1411950c1a27\";s:65:\"vendor/cmb2/cmb2/includes/rest-api/CMB2_REST_Controller_Boxes.php\";s:32:\"367fc3aba43fdeaed5c7ac6068782462\";s:66:\"vendor/cmb2/cmb2/includes/rest-api/CMB2_REST_Controller_Fields.php\";s:32:\"e24a87bf7a8a8e879df36b020e22f924\";s:53:\"vendor/cmb2/cmb2/includes/shim/WP_REST_Controller.php\";s:32:\"f47bb809eb1399cc6ea7c8c507a36177\";s:50:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Base.php\";s:32:\"0495e3089268f6d6e75f8d3e942e5199\";s:54:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Checkbox.php\";s:32:\"c0a997ba27adb049c0e81a73927455f3\";s:57:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Colorpicker.php\";s:32:\"f11975a9f3943ed195c4d3c3d83a6310\";s:58:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Counter_Base.php\";s:32:\"541847de0ab17941bf87a10824e72e12\";s:50:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_File.php\";s:32:\"1426195e59afc7194faef150ee299a58\";s:55:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_File_Base.php\";s:32:\"2009e5db437bc01cf390eaa8f7f83144\";s:55:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_File_List.php\";s:32:\"fd0b6cf467e8a44715a9c52ae141366a\";s:56:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Multi_Base.php\";s:32:\"fbcf80e807108046e837573b4425ebdc\";s:56:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Multicheck.php\";s:32:\"23f3f0d94e647cd4adbad74956034e97\";s:52:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Oembed.php\";s:32:\"24f612850ca8debb2965a05225af1631\";s:57:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Picker_Base.php\";s:32:\"0013e29cc4dda228172eb39236aea6be\";s:51:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Radio.php\";s:32:\"14c16a4858cd2ebb6c8530032f3934b2\";s:52:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Select.php\";s:32:\"5bb485543a91400ac4f95aac826a03be\";s:61:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Select_Timezone.php\";s:32:\"3457f629a5d94b938128ef8ce324dc7d\";s:59:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Taxonomy_Base.php\";s:32:\"543bd0027bb4fecffde3749f89392a4d\";s:65:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Taxonomy_Multicheck.php\";s:32:\"032e97abbb3e4baeeeef879e76f7e940\";s:78:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Taxonomy_Multicheck_Hierarchical.php\";s:32:\"8d3b29f8e8b7f23e2969ed31125fdf1a\";s:60:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Taxonomy_Radio.php\";s:32:\"b074dea141569fccc4afd6a8d7f55335\";s:73:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Taxonomy_Radio_Hierarchical.php\";s:32:\"74bc575d086b78ec50fee0c5f6d8bcd8\";s:61:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Taxonomy_Select.php\";s:32:\"739ff2b7ba98e891edd45d0352250d28\";s:74:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Taxonomy_Select_Hierarchical.php\";s:32:\"2f8024d8ec203eeef6a4d825210c254e\";s:50:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Text.php\";s:32:\"ad4848d8b54a527f3ba25a2ed3e83c3a\";s:55:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Text_Date.php\";s:32:\"e5fcc56f1542de4d44889d296d9314a4\";s:69:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Text_Datetime_Timestamp.php\";s:32:\"1be83fe7f4d14e7aab658e454dfa4507\";s:78:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Text_Datetime_Timestamp_Timezone.php\";s:32:\"e53148cd9f8495f426f0940380461d42\";s:55:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Text_Time.php\";s:32:\"ce28e6bfbe02fa06ff203ab1f3269c70\";s:54:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Textarea.php\";s:32:\"fa64b98f6c01b3e7fc52fd9d9fb6cf42\";s:59:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Textarea_Code.php\";s:32:\"2122506baa70f6b2b9b1d32e3d15fd45\";s:51:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Title.php\";s:32:\"0272c16fe546b615e32fbea620cd99d5\";s:53:\"vendor/cmb2/cmb2/includes/types/CMB2_Type_Wysiwyg.php\";s:32:\"e5d724eb618f68cd77c9cbc10f21817f\";s:26:\"vendor/cmb2/cmb2/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:25:\"vendor/cmb2/cmb2/init.php\";s:32:\"780ba0b80fc1d8a3cbbc0cf472582052\";s:27:\"vendor/cmb2/cmb2/js/cmb2.js\";s:32:\"0983fe1ffc8c263e909d4b841572d120\";s:31:\"vendor/cmb2/cmb2/js/cmb2.min.js\";s:32:\"4eddc81c96a8d243d8e251c5592b4947\";s:29:\"vendor/cmb2/cmb2/js/index.php\";s:32:\"691196b33d9fed0013a58c215cd5dfff\";s:53:\"vendor/cmb2/cmb2/js/jquery-ui-timepicker-addon.min.js\";s:32:\"b3c1ffcc03c309e77225afe81c62da6a\";s:31:\"vendor/composer/ClassLoader.php\";s:32:\"c02be6d96671f88d28aad3ffa134c8ae\";s:37:\"vendor/composer/InstalledVersions.php\";s:32:\"182d5924ff0b528f008a83d1f5809d02\";s:23:\"vendor/composer/LICENSE\";s:32:\"955d5fe58c231244f6b49000f383b5e2\";s:37:\"vendor/composer/autoload_classmap.php\";s:32:\"99d0486fe5c1d66ccca342831aee66ce\";s:34:\"vendor/composer/autoload_files.php\";s:32:\"3e37ffe0b13a2bab30c5dcf1151cdf5d\";s:39:\"vendor/composer/autoload_namespaces.php\";s:32:\"224007c97efb82c7b45b0e92f240af41\";s:33:\"vendor/composer/autoload_psr4.php\";s:32:\"ffe7dc5af51f17bf2666705381cec160\";s:33:\"vendor/composer/autoload_real.php\";s:32:\"f845721784818300d4bc7e2de370ed67\";s:35:\"vendor/composer/autoload_static.php\";s:32:\"e2aaa799ebbeb778542cd8498ab16bba\";s:30:\"vendor/composer/installed.json\";s:32:\"5f6eaeb08f885b3729c3dbb7ddbde17a\";s:29:\"vendor/composer/installed.php\";s:32:\"1d97b78f1902a4b6810a613b15f2fbf2\";s:34:\"vendor/composer/platform_check.php\";s:32:\"9a240242a18e7e3f558aaa85f70505f9\";s:55:\"vendor/donatj/phpuseragentparser/.helpers/constants.php\";s:32:\"dcdae7f87513b666d546fff9dd78aa90\";s:43:\"vendor/donatj/phpuseragentparser/.mddoc.xml\";s:32:\"15b2e6a31d0526fc8b520fef3b0dbb09\";s:43:\"vendor/donatj/phpuseragentparser/LICENSE.md\";s:32:\"47a43e5af37ed819320486921a6b9095\";s:41:\"vendor/donatj/phpuseragentparser/Makefile\";s:32:\"7b5ef4d6a57644f46083e11da0b57a97\";s:61:\"vendor/donatj/phpuseragentparser/examples/object-oriented.php\";s:32:\"b64998e90e3579c3951c889ca0906936\";s:56:\"vendor/donatj/phpuseragentparser/examples/procedural.php\";s:32:\"722761880e0a0208889f9fb7a477eb6d\";s:59:\"vendor/donatj/phpuseragentparser/src/UserAgent/Browsers.php\";s:32:\"f141d113bc9a7fa7424e4c54a1b3a8ea\";s:60:\"vendor/donatj/phpuseragentparser/src/UserAgent/Platforms.php\";s:32:\"4bfb0139ee43251169829da11aae78bf\";s:60:\"vendor/donatj/phpuseragentparser/src/UserAgent/UserAgent.php\";s:32:\"3405b10aa6af25d299b1890549efd3f1\";s:69:\"vendor/donatj/phpuseragentparser/src/UserAgent/UserAgentInterface.php\";s:32:\"35f1dd63984e07c8fa872cdd6fd6a17e\";s:66:\"vendor/donatj/phpuseragentparser/src/UserAgent/UserAgentParser.php\";s:32:\"45673452a5101497afae2b3404fb283e\";s:56:\"vendor/donatj/phpuseragentparser/src/UserAgentParser.php\";s:32:\"2080bc95cc98f8f48d7cd0690aaeed18\";s:48:\"vendor/mythemeshop/wordpress-helpers/LICENSE.txt\";s:32:\"dd372c0983ac4afa875709b30d4a2a23\";s:67:\"vendor/mythemeshop/wordpress-helpers/src/admin/class-list-table.php\";s:32:\"d684a1c25a4ac591e87fd38862c0c842\";s:61:\"vendor/mythemeshop/wordpress-helpers/src/admin/class-page.php\";s:32:\"48849a7fda2bf10254e59aa882af0e42\";s:56:\"vendor/mythemeshop/wordpress-helpers/src/admin/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:63:\"vendor/mythemeshop/wordpress-helpers/src/class-json-manager.php\";s:32:\"94456935960343b1cd7f3a4f35ba8869\";s:70:\"vendor/mythemeshop/wordpress-helpers/src/class-notification-center.php\";s:32:\"4d5de8b9a52556f4806105c314d3886e\";s:63:\"vendor/mythemeshop/wordpress-helpers/src/class-notification.php\";s:32:\"be01d2049fb85087d15e122b15c915a7\";s:67:\"vendor/mythemeshop/wordpress-helpers/src/database/class-clauses.php\";s:32:\"bd50e02aec302645c57ea38c3d13a9d9\";s:68:\"vendor/mythemeshop/wordpress-helpers/src/database/class-database.php\";s:32:\"5ae7ce4fe9e746586c2bfa5ea201736e\";s:66:\"vendor/mythemeshop/wordpress-helpers/src/database/class-escape.php\";s:32:\"636f931dccff7fb40fa6d57d872aff29\";s:67:\"vendor/mythemeshop/wordpress-helpers/src/database/class-groupby.php\";s:32:\"4a07ede049e8d802fa0758d5fb8a0e2b\";s:65:\"vendor/mythemeshop/wordpress-helpers/src/database/class-joins.php\";s:32:\"5da60bc96cce637710493f5f685fe7d6\";s:67:\"vendor/mythemeshop/wordpress-helpers/src/database/class-orderby.php\";s:32:\"4abce168335d01998be09dbb4ae94a20\";s:73:\"vendor/mythemeshop/wordpress-helpers/src/database/class-query-builder.php\";s:32:\"4a6211378db2b5e5953528b392806440\";s:66:\"vendor/mythemeshop/wordpress-helpers/src/database/class-select.php\";s:32:\"f06b856471791ef3c73bee3e3468c76b\";s:69:\"vendor/mythemeshop/wordpress-helpers/src/database/class-translate.php\";s:32:\"c8b53c602dbbd6853350d6e1796ec96e\";s:65:\"vendor/mythemeshop/wordpress-helpers/src/database/class-where.php\";s:32:\"cfceb33c084caadd8b928f10aeaf310d\";s:59:\"vendor/mythemeshop/wordpress-helpers/src/database/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:62:\"vendor/mythemeshop/wordpress-helpers/src/helpers/class-arr.php\";s:32:\"4b4d3bf4f2238ce360f5ce189f74a9a1\";s:69:\"vendor/mythemeshop/wordpress-helpers/src/helpers/class-attachment.php\";s:32:\"7d35b2fccbc98e6e708eb477a55e1271\";s:70:\"vendor/mythemeshop/wordpress-helpers/src/helpers/class-conditional.php\";s:32:\"8f68ba6a34c2868ddd18c741a34dcff3\";s:61:\"vendor/mythemeshop/wordpress-helpers/src/helpers/class-db.php\";s:32:\"2e5f07de7c39d175e8cc07b980fd24a0\";s:63:\"vendor/mythemeshop/wordpress-helpers/src/helpers/class-html.php\";s:32:\"fb2e537218f62fcc360995958d955dba\";s:64:\"vendor/mythemeshop/wordpress-helpers/src/helpers/class-param.php\";s:32:\"6116c26a42de913ad18fec535d46714b\";s:62:\"vendor/mythemeshop/wordpress-helpers/src/helpers/class-str.php\";s:32:\"4ce5901b19f713f999bd3baf409ae8e3\";s:62:\"vendor/mythemeshop/wordpress-helpers/src/helpers/class-url.php\";s:32:\"9f0f3917a6ea48595b019e6605ffda3b\";s:68:\"vendor/mythemeshop/wordpress-helpers/src/helpers/class-wordpress.php\";s:32:\"1b19ff4c5eafef0b77123981d73821c1\";s:58:\"vendor/mythemeshop/wordpress-helpers/src/helpers/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:50:\"vendor/mythemeshop/wordpress-helpers/src/index.php\";s:32:\"8e8ad6ca6156bc03fb71954dc0c1179e\";s:56:\"vendor/mythemeshop/wordpress-helpers/vendor/autoload.php\";s:32:\"1d1e3c1ce54d9eda0a54d8948ac18f83\";s:68:\"vendor/mythemeshop/wordpress-helpers/vendor/composer/ClassLoader.php\";s:32:\"e056765dcc4c8f20c2d1fd26695076e6\";s:74:\"vendor/mythemeshop/wordpress-helpers/vendor/composer/InstalledVersions.php\";s:32:\"dd8eec067bd319fde742fd870c022b7b\";s:60:\"vendor/mythemeshop/wordpress-helpers/vendor/composer/LICENSE\";s:32:\"955d5fe58c231244f6b49000f383b5e2\";s:74:\"vendor/mythemeshop/wordpress-helpers/vendor/composer/autoload_classmap.php\";s:32:\"d9c6dd6974856ac83225475e5ba97d14\";s:76:\"vendor/mythemeshop/wordpress-helpers/vendor/composer/autoload_namespaces.php\";s:32:\"35e12c7d76c4a81633bcf547c0e229a9\";s:70:\"vendor/mythemeshop/wordpress-helpers/vendor/composer/autoload_psr4.php\";s:32:\"5c93d9a14f0f89e2d2cb89701daa7757\";s:70:\"vendor/mythemeshop/wordpress-helpers/vendor/composer/autoload_real.php\";s:32:\"ec98d4da0192ebb524d424b82d615e97\";s:72:\"vendor/mythemeshop/wordpress-helpers/vendor/composer/autoload_static.php\";s:32:\"10316911e992330f05f13dccaf75a0dc\";s:67:\"vendor/mythemeshop/wordpress-helpers/vendor/composer/installed.json\";s:32:\"8948689ddd6765cb530a40c2b32b5e40\";s:66:\"vendor/mythemeshop/wordpress-helpers/vendor/composer/installed.php\";s:32:\"8ab42bca45f059194ce0ac66bdafa5a9\";s:71:\"vendor/mythemeshop/wordpress-helpers/vendor/composer/platform_check.php\";s:32:\"15e1efff88933be3dd5740e3c9530478\";s:58:\"vendor/mythemeshop/wordpress-helpers/wordpress-helpers.php\";s:32:\"545cc494952b49d5961f51574cbf9227\";s:56:\"vendor/woocommerce/action-scheduler/action-scheduler.php\";s:32:\"61ec80bd3ec26c54b17c4bd266f8c1c1\";s:75:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_ActionClaim.php\";s:32:\"5486218425490cdf51afafa31a49e663\";s:77:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_ActionFactory.php\";s:32:\"a94d646c27f93da7127d40129928444b\";s:73:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_AdminView.php\";s:32:\"436f3bd7111580687f937341ffe3f8ae\";s:88:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_AsyncRequest_QueueRunner.php\";s:32:\"594d1375e847f202dcffa80c6179d556\";s:77:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_Compatibility.php\";s:32:\"1ebc25ad15f4902ed6dce28a98702ea0\";s:78:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_DataController.php\";s:32:\"5a868c0d40c42a1dd39b14a6e5b35cf9\";s:72:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_DateTime.php\";s:32:\"08a9e9666705d7298cd53b50e0b614ab\";s:73:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_Exception.php\";s:32:\"f9263ccbdcec7768e02c557b4f01fdaa\";s:81:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_FatalErrorMonitor.php\";s:32:\"c858bbfb80284cb51b3c2fecea871936\";s:86:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_InvalidActionException.php\";s:32:\"cbbe7f2453feed35105d4c077cc26e1c\";s:73:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_ListTable.php\";s:32:\"ddcdd20cba147b8a4b222d0003b4260c\";s:72:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_LogEntry.php\";s:32:\"c628db719f95cacdd76135258fc985e7\";s:76:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_NullLogEntry.php\";s:32:\"79632ef858a5999d07fb55f26dfb9aa5\";s:74:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_OptionLock.php\";s:32:\"2d8994a9368c9eae2c521252c0f5efbf\";s:76:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_QueueCleaner.php\";s:32:\"9fdce54cef171df443387379fd7b12db\";s:75:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_QueueRunner.php\";s:32:\"6a1312e8a21df456b338dd46ff94fb09\";s:72:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_Versions.php\";s:32:\"60b2d11eebcbf0602da64ea26624c718\";s:80:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_WPCommentCleaner.php\";s:32:\"e4b9ea43d9310743ab9fb2010157ab21\";s:78:\"vendor/woocommerce/action-scheduler/classes/ActionScheduler_wcSystemStatus.php\";s:32:\"777b4539d2be97cc7ef09291e9ecaf58\";s:90:\"vendor/woocommerce/action-scheduler/classes/WP_CLI/ActionScheduler_WPCLI_Clean_Command.php\";s:32:\"29104eebe0d26475604db2c56796a26f\";s:88:\"vendor/woocommerce/action-scheduler/classes/WP_CLI/ActionScheduler_WPCLI_QueueRunner.php\";s:32:\"4f9995a3a04540ae75ae71cd51de412a\";s:94:\"vendor/woocommerce/action-scheduler/classes/WP_CLI/ActionScheduler_WPCLI_Scheduler_command.php\";s:32:\"38f9bebc06095390fd0f6350d405da43\";s:72:\"vendor/woocommerce/action-scheduler/classes/WP_CLI/Migration_Command.php\";s:32:\"9b2736139f64fbe81074e0d3bb05ad2b\";s:66:\"vendor/woocommerce/action-scheduler/classes/WP_CLI/ProgressBar.php\";s:32:\"364257ee2b0ba3447aef1aee7085491c\";s:73:\"vendor/woocommerce/action-scheduler/classes/abstracts/ActionScheduler.php\";s:32:\"07597aa5de1c04f055409b1fe3da1b4c\";s:92:\"vendor/woocommerce/action-scheduler/classes/abstracts/ActionScheduler_Abstract_ListTable.php\";s:32:\"b6f43c519150483f56e266357822e777\";s:94:\"vendor/woocommerce/action-scheduler/classes/abstracts/ActionScheduler_Abstract_QueueRunner.php\";s:32:\"840f869bbfd8472705d7d739bdb60548\";s:100:\"vendor/woocommerce/action-scheduler/classes/abstracts/ActionScheduler_Abstract_RecurringSchedule.php\";s:32:\"d12ebb506e6f818d678992b452d4e50e\";s:91:\"vendor/woocommerce/action-scheduler/classes/abstracts/ActionScheduler_Abstract_Schedule.php\";s:32:\"201ce0df489ec23196e7de5e41ebbd3c\";s:89:\"vendor/woocommerce/action-scheduler/classes/abstracts/ActionScheduler_Abstract_Schema.php\";s:32:\"3c9b0d1b9e6b57a4a3c967e134fcc69d\";s:78:\"vendor/woocommerce/action-scheduler/classes/abstracts/ActionScheduler_Lock.php\";s:32:\"f514d256de1439c24e768d76ba5b6b71\";s:80:\"vendor/woocommerce/action-scheduler/classes/abstracts/ActionScheduler_Logger.php\";s:32:\"c0a67f4e6981a1a9c11a374c3227b07a\";s:79:\"vendor/woocommerce/action-scheduler/classes/abstracts/ActionScheduler_Store.php\";s:32:\"f4916419212e2350e8997a8272b5a842\";s:88:\"vendor/woocommerce/action-scheduler/classes/abstracts/ActionScheduler_TimezoneHelper.php\";s:32:\"a66f1647eb3e2ecd0d87e44f6f3cd1d4\";s:78:\"vendor/woocommerce/action-scheduler/classes/actions/ActionScheduler_Action.php\";s:32:\"f6afa217f4828e57fa807c2b9cbd367e\";s:86:\"vendor/woocommerce/action-scheduler/classes/actions/ActionScheduler_CanceledAction.php\";s:32:\"d50b60c3a0ee4a2fb54cfaeb0c705173\";s:86:\"vendor/woocommerce/action-scheduler/classes/actions/ActionScheduler_FinishedAction.php\";s:32:\"d5b7035b68a9aa16a4620ff254d68939\";s:82:\"vendor/woocommerce/action-scheduler/classes/actions/ActionScheduler_NullAction.php\";s:32:\"3eba6e12f05caf0fb41314ff42a41835\";s:84:\"vendor/woocommerce/action-scheduler/classes/data-stores/ActionScheduler_DBLogger.php\";s:32:\"cf0602d82a512ff947789a0124c18ccd\";s:83:\"vendor/woocommerce/action-scheduler/classes/data-stores/ActionScheduler_DBStore.php\";s:32:\"b44d015931824ebb65757dc52e4b5237\";s:87:\"vendor/woocommerce/action-scheduler/classes/data-stores/ActionScheduler_HybridStore.php\";s:32:\"566a4a97d588731e3fc20f75a442793f\";s:91:\"vendor/woocommerce/action-scheduler/classes/data-stores/ActionScheduler_wpCommentLogger.php\";s:32:\"28cb6dfe0c3d31356b049936e1544558\";s:87:\"vendor/woocommerce/action-scheduler/classes/data-stores/ActionScheduler_wpPostStore.php\";s:32:\"6984fc172bd3bd6ab7d594ca05081df5\";s:107:\"vendor/woocommerce/action-scheduler/classes/data-stores/ActionScheduler_wpPostStore_PostStatusRegistrar.php\";s:32:\"380474748e779616d83bef67b359a1db\";s:105:\"vendor/woocommerce/action-scheduler/classes/data-stores/ActionScheduler_wpPostStore_PostTypeRegistrar.php\";s:32:\"55c55ef1634512060ea0b6feac97ad9e\";s:105:\"vendor/woocommerce/action-scheduler/classes/data-stores/ActionScheduler_wpPostStore_TaxonomyRegistrar.php\";s:32:\"2192a2b49cbaa6255ba58e4a902a1e30\";s:72:\"vendor/woocommerce/action-scheduler/classes/migration/ActionMigrator.php\";s:32:\"75b50ced0cce348a7323df471073b04e\";s:89:\"vendor/woocommerce/action-scheduler/classes/migration/ActionScheduler_DBStoreMigrator.php\";s:32:\"ed3e9274683d0bea76c2e5bfa71a990a\";s:70:\"vendor/woocommerce/action-scheduler/classes/migration/BatchFetcher.php\";s:32:\"a6810008095dd34f896a83aa20d4cebd\";s:64:\"vendor/woocommerce/action-scheduler/classes/migration/Config.php\";s:32:\"978f9c5a8fa7c2a367f5b8e4181401c8\";s:68:\"vendor/woocommerce/action-scheduler/classes/migration/Controller.php\";s:32:\"c49941e37d691e1226db88c4bc098cb8\";s:79:\"vendor/woocommerce/action-scheduler/classes/migration/DryRun_ActionMigrator.php\";s:32:\"971521b2546ec97560273353d7978488\";s:76:\"vendor/woocommerce/action-scheduler/classes/migration/DryRun_LogMigrator.php\";s:32:\"958a0de9190d87516a4d2031f367fb44\";s:69:\"vendor/woocommerce/action-scheduler/classes/migration/LogMigrator.php\";s:32:\"d9bbfd780464afece4ac9669e3fbf13b\";s:64:\"vendor/woocommerce/action-scheduler/classes/migration/Runner.php\";s:32:\"72f2a5381c50502bb7438ea3edc13189\";s:67:\"vendor/woocommerce/action-scheduler/classes/migration/Scheduler.php\";s:32:\"1cac3b75206e1cbb3fea9f336b2d4877\";s:90:\"vendor/woocommerce/action-scheduler/classes/schedules/ActionScheduler_CanceledSchedule.php\";s:32:\"3aa7603b367206884abf086502af4a15\";s:86:\"vendor/woocommerce/action-scheduler/classes/schedules/ActionScheduler_CronSchedule.php\";s:32:\"c437a67f13a9a5ffd63c17d72b3eab57\";s:90:\"vendor/woocommerce/action-scheduler/classes/schedules/ActionScheduler_IntervalSchedule.php\";s:32:\"aee8c2f89d3945448e1e8f588a10af0d\";s:86:\"vendor/woocommerce/action-scheduler/classes/schedules/ActionScheduler_NullSchedule.php\";s:32:\"dcea675af380fc9a1d5d48d864b8563b\";s:82:\"vendor/woocommerce/action-scheduler/classes/schedules/ActionScheduler_Schedule.php\";s:32:\"d85b6ea7df1f05cde569089b1518327e\";s:88:\"vendor/woocommerce/action-scheduler/classes/schedules/ActionScheduler_SimpleSchedule.php\";s:32:\"c0306bc0450615b7c14ad42c9911c4b6\";s:83:\"vendor/woocommerce/action-scheduler/classes/schema/ActionScheduler_LoggerSchema.php\";s:32:\"971bcd6e62215c96d36fb305249b4e99\";s:82:\"vendor/woocommerce/action-scheduler/classes/schema/ActionScheduler_StoreSchema.php\";s:32:\"3b802586dfc2573f5338a09a003b1ff9\";s:98:\"vendor/woocommerce/action-scheduler/deprecated/ActionScheduler_Abstract_QueueRunner_Deprecated.php\";s:32:\"22e1cde9b082677e2e44f7622306c0a9\";s:87:\"vendor/woocommerce/action-scheduler/deprecated/ActionScheduler_AdminView_Deprecated.php\";s:32:\"58d22757b2adecfb5bcfbb1058ef9bcc\";s:86:\"vendor/woocommerce/action-scheduler/deprecated/ActionScheduler_Schedule_Deprecated.php\";s:32:\"cdc466c0b5b1c89e824c419a9d232874\";s:83:\"vendor/woocommerce/action-scheduler/deprecated/ActionScheduler_Store_Deprecated.php\";s:32:\"37d23a8c3a580746c69d8f3027a60e50\";s:60:\"vendor/woocommerce/action-scheduler/deprecated/functions.php\";s:32:\"8d42278bf7e698297b625cc8d1742100\";s:49:\"vendor/woocommerce/action-scheduler/functions.php\";s:32:\"88cd926203102c12b0479343186e6879\";s:60:\"vendor/woocommerce/action-scheduler/lib/WP_Async_Request.php\";s:32:\"45fc1d47bf7a1bb2d693e974d930c05a\";s:74:\"vendor/woocommerce/action-scheduler/lib/cron-expression/CronExpression.php\";s:32:\"a7da8127a2f768d52faa3b1bbf0dc0c9\";s:88:\"vendor/woocommerce/action-scheduler/lib/cron-expression/CronExpression_AbstractField.php\";s:32:\"57c6581fe6fa76d3766c58ad38859ace\";s:90:\"vendor/woocommerce/action-scheduler/lib/cron-expression/CronExpression_DayOfMonthField.php\";s:32:\"198169d64ffcd48262bc741e1434d25c\";s:89:\"vendor/woocommerce/action-scheduler/lib/cron-expression/CronExpression_DayOfWeekField.php\";s:32:\"746c00cf65b0ef262e19640a66f0c467\";s:87:\"vendor/woocommerce/action-scheduler/lib/cron-expression/CronExpression_FieldFactory.php\";s:32:\"b7cbae8659f1aabb9bd2790a876e38f4\";s:89:\"vendor/woocommerce/action-scheduler/lib/cron-expression/CronExpression_FieldInterface.php\";s:32:\"3bfbe747d44aafa7c0e2dd593370aecb\";s:85:\"vendor/woocommerce/action-scheduler/lib/cron-expression/CronExpression_HoursField.php\";s:32:\"d42f315cd035559fd6963f910cb3d3db\";s:87:\"vendor/woocommerce/action-scheduler/lib/cron-expression/CronExpression_MinutesField.php\";s:32:\"066298116be1abe7a751bd0c32d3f6b7\";s:85:\"vendor/woocommerce/action-scheduler/lib/cron-expression/CronExpression_MonthField.php\";s:32:\"c562fc24bddf20e97db05b84d1e8cef7\";s:84:\"vendor/woocommerce/action-scheduler/lib/cron-expression/CronExpression_YearField.php\";s:32:\"df34440666f3df70ee54b68578f0b392\";s:63:\"vendor/woocommerce/action-scheduler/lib/cron-expression/LICENSE\";s:32:\"b070323e0fb8fc39cad2959f107bac2b\";s:47:\"vendor/woocommerce/action-scheduler/license.txt\";s:32:\"1ebbd3e34237af26da5dc08a4e440464\";s:15:\"wpml-config.xml\";s:32:\"0afae267f73a47afd09ae1d322c41735\";}s:10:\"checked_at\";i:1730467589;}}s:14:\"contact-form-7\";a:1:{s:5:\"5.9.8\";a:2:{s:6:\"hashes\";a:143:{s:15:\"admin/admin.php\";s:32:\"80399985b1aa76ff9588f98ca13e6ec2\";s:24:\"admin/css/styles-rtl.css\";s:32:\"22ae3b95f01cf02648e4c4777058581b\";s:20:\"admin/css/styles.css\";s:32:\"0083f1bc1d9cad1fd34268b5c0233859\";s:27:\"admin/edit-contact-form.php\";s:32:\"8204b0ec7c43c4acccb105e085c25440\";s:34:\"admin/includes/admin-functions.php\";s:32:\"e1b95ef72bea05ac879b5176d5fdc291\";s:49:\"admin/includes/class-contact-forms-list-table.php\";s:32:\"09e8f514630c49ffa4ac34f780cd2425\";s:35:\"admin/includes/config-validator.php\";s:32:\"3b6dba98733342460aae3194fe4ee2ef\";s:25:\"admin/includes/editor.php\";s:32:\"a0dd4cc3088cdb92aba3da2e66731364\";s:28:\"admin/includes/help-tabs.php\";s:32:\"2fee352d2041917f77358c2b07b144c5\";s:32:\"admin/includes/tag-generator.php\";s:32:\"deb4a98c5a782f2150a080d6a261b4f7\";s:32:\"admin/includes/welcome-panel.php\";s:32:\"088392c085abf49bcff22b62fdd97fda\";s:19:\"admin/js/scripts.js\";s:32:\"2da5ea07503c7c382ff591d8f52e445f\";s:25:\"admin/js/tag-generator.js\";s:32:\"f803747959a240d578a82cf4522ec03b\";s:15:\"assets/icon.png\";s:32:\"2fe6cbd0a32180c8990b1ff0e1dd2f9c\";s:15:\"assets/icon.svg\";s:32:\"7e39d3cb4efccab65f63df19b15fec19\";s:38:\"includes/block-editor/block-editor.php\";s:32:\"f1a338f91c3106dd7bdb0f04d187224f\";s:32:\"includes/block-editor/block.json\";s:32:\"05b9cfc317de0191141e6276fd359c82\";s:37:\"includes/block-editor/index.asset.php\";s:32:\"a4de32f9092913ce41c8b5245c2e6a5c\";s:30:\"includes/block-editor/index.js\";s:32:\"e0bf8136ad52f294dcd9718d20098e4a\";s:25:\"includes/capabilities.php\";s:32:\"999946fece8c36f1428f4d4da2db9fb1\";s:37:\"includes/config-validator/actions.php\";s:32:\"627e4eec22674e119c7aef18e75a44a2\";s:49:\"includes/config-validator/additional-settings.php\";s:32:\"ce591970042c2b2f46d6e3098a1aa822\";s:34:\"includes/config-validator/form.php\";s:32:\"bc08465de91ae1090644bd2b42629d4a\";s:34:\"includes/config-validator/mail.php\";s:32:\"41578f91a918c5b19a26119aae76cd5d\";s:38:\"includes/config-validator/messages.php\";s:32:\"6c2018d58fa379044bfbf7b88d00453a\";s:39:\"includes/config-validator/validator.php\";s:32:\"e53a3780cb8f58e9d9f5067a0bae27ff\";s:35:\"includes/contact-form-functions.php\";s:32:\"9d343ad449892d11367d25638c33bbe4\";s:34:\"includes/contact-form-template.php\";s:32:\"20f16cce043da46eab213db553acbe89\";s:25:\"includes/contact-form.php\";s:32:\"35c8ba55cde1bcb03e6cd838e71af396\";s:23:\"includes/controller.php\";s:32:\"3600c920c6b98540bd743829daa12c5c\";s:27:\"includes/css/styles-rtl.css\";s:32:\"3ae045c00f92fc31d3585fe7f975412d\";s:23:\"includes/css/styles.css\";s:32:\"3fd2afa98866679439097f4ab102fe0a\";s:17:\"includes/file.php\";s:32:\"16e5f8055fe7ae5928defd381b015c54\";s:21:\"includes/form-tag.php\";s:32:\"53967a6026a2bcff64fc833381e009ad\";s:30:\"includes/form-tags-manager.php\";s:32:\"d4fad726f65ee7dab36dee0024439338\";s:23:\"includes/formatting.php\";s:32:\"4cf4724822a0c4b1df16993bbcad3476\";s:22:\"includes/functions.php\";s:32:\"ab4761b50b878ab72bff8dd90e76e0ac\";s:27:\"includes/html-formatter.php\";s:32:\"38d191afb21e574f3899d2787a458bcf\";s:24:\"includes/integration.php\";s:32:\"fda9e62fca87aa9cceeb1f55d1c4edac\";s:29:\"includes/js/html5-fallback.js\";s:32:\"cb2abb3dd64fb76ec45da76719f37ad1\";s:27:\"includes/js/index.asset.php\";s:32:\"ddfc38160b268bb8d4c86ba1658bab91\";s:20:\"includes/js/index.js\";s:32:\"0b1719adf5fa7231cb1a1b54cf11a50e\";s:78:\"includes/js/jquery-ui/themes/smoothness/images/ui-bg_glass_55_fbf9ee_1x400.png\";s:32:\"daaed3cf88e742a2d3820b4c8c55f3de\";s:78:\"includes/js/jquery-ui/themes/smoothness/images/ui-bg_glass_65_ffffff_1x400.png\";s:32:\"ed31481b45167e6f49fdcb1499911bf3\";s:78:\"includes/js/jquery-ui/themes/smoothness/images/ui-bg_glass_75_dadada_1x400.png\";s:32:\"9b9f1106e912005670402c03bf82f170\";s:78:\"includes/js/jquery-ui/themes/smoothness/images/ui-bg_glass_75_e6e6e6_1x400.png\";s:32:\"ddd65fff8a75a609b421b4e3237ef807\";s:78:\"includes/js/jquery-ui/themes/smoothness/images/ui-bg_glass_95_fef1ec_1x400.png\";s:32:\"d699723af8436eba22b885328314bd55\";s:87:\"includes/js/jquery-ui/themes/smoothness/images/ui-bg_highlight-soft_75_cccccc_1x100.png\";s:32:\"5e93533bf9087857a8369c2d27467633\";s:74:\"includes/js/jquery-ui/themes/smoothness/images/ui-icons_222222_256x240.png\";s:32:\"23aca9c182696db96ff9ee5bf9601461\";s:74:\"includes/js/jquery-ui/themes/smoothness/images/ui-icons_2e83ff_256x240.png\";s:32:\"db3b908bd060c6f278fde9e11b3b94e3\";s:74:\"includes/js/jquery-ui/themes/smoothness/images/ui-icons_454545_256x240.png\";s:32:\"5c3ba680cc34cd9b30855c180474a152\";s:74:\"includes/js/jquery-ui/themes/smoothness/images/ui-icons_888888_256x240.png\";s:32:\"cf9c28612e00f36e9c312da7689ab3b0\";s:74:\"includes/js/jquery-ui/themes/smoothness/images/ui-icons_cd0a0a_256x240.png\";s:32:\"a6a39c47239fcdbbe6e1d5bfaa7adac3\";s:53:\"includes/js/jquery-ui/themes/smoothness/jquery-ui.css\";s:32:\"bf051f24690699bc2665ef6e4d7487a7\";s:57:\"includes/js/jquery-ui/themes/smoothness/jquery-ui.min.css\";s:32:\"3c2a865c832a1322285c55c6ed99abb2\";s:49:\"includes/js/jquery-ui/themes/smoothness/theme.css\";s:32:\"e4327912458100faa111dbe7bd75f4d9\";s:17:\"includes/l10n.php\";s:32:\"ca3ab669fa438096cff305594f0f01e7\";s:21:\"includes/mail-tag.php\";s:32:\"ff0186ec9d94aa7525f7eae444d97b73\";s:17:\"includes/mail.php\";s:32:\"cdccbe8c01361afdce8a7f9a1a32df51\";s:17:\"includes/pipe.php\";s:32:\"fa03edb267c9b611dd909f011471293f\";s:26:\"includes/pocket-holder.php\";s:32:\"72104a7ab3b002fd4423f728dc201685\";s:21:\"includes/rest-api.php\";s:32:\"d5e967513ad186133b22b7a0706e91da\";s:23:\"includes/shortcodes.php\";s:32:\"3b54e1fddc5a79593e34d04da072e856\";s:30:\"includes/special-mail-tags.php\";s:32:\"42cb0455f0603cc5bedc3a8c026abc69\";s:23:\"includes/submission.php\";s:32:\"3ff66d2d944fb828e98b94ff9a18e459\";s:31:\"includes/swv/js/index.asset.php\";s:32:\"ab7137bfa351c9f4256b218f71e0188a\";s:24:\"includes/swv/js/index.js\";s:32:\"efc27e253fae1b7b891fb5a40e687768\";s:35:\"includes/swv/php/abstract-rules.php\";s:32:\"7eea15695b740894dfcea90c0a182638\";s:30:\"includes/swv/php/rules/all.php\";s:32:\"81a129bf6b8222d48cb92510b78be0d4\";s:30:\"includes/swv/php/rules/any.php\";s:32:\"31016c690274633ff88ea702538f0a46\";s:31:\"includes/swv/php/rules/date.php\";s:32:\"f0accfb3c8cf6c79f1fa75065c5ee32c\";s:36:\"includes/swv/php/rules/dayofweek.php\";s:32:\"fcafaab0dea704aaf207693f2770bdd7\";s:32:\"includes/swv/php/rules/email.php\";s:32:\"e51972f8752574bf5cfc73167358e2cb\";s:31:\"includes/swv/php/rules/enum.php\";s:32:\"28cbae6ac926e5160901d99c001a9960\";s:31:\"includes/swv/php/rules/file.php\";s:32:\"dd5befc2c6d7806cc81f057acca0a292\";s:34:\"includes/swv/php/rules/maxdate.php\";s:32:\"54f624e45f73803e1d68ed220d70cc7a\";s:38:\"includes/swv/php/rules/maxfilesize.php\";s:32:\"2165c055a0d115d8c57f4a24abc6227a\";s:35:\"includes/swv/php/rules/maxitems.php\";s:32:\"00ed1546b3b46f3d0a93e203876ddcf5\";s:36:\"includes/swv/php/rules/maxlength.php\";s:32:\"23a67b3a5b5019aa7e5931eb85c27b7f\";s:36:\"includes/swv/php/rules/maxnumber.php\";s:32:\"e6682a0ff172adac78b082346980a44c\";s:34:\"includes/swv/php/rules/mindate.php\";s:32:\"7305079c8c2e135dd2484c90941dbed4\";s:38:\"includes/swv/php/rules/minfilesize.php\";s:32:\"0ed7a71243e055eec1ab44bb028dc552\";s:35:\"includes/swv/php/rules/minitems.php\";s:32:\"4a1576a1ad4a699daf2f67455bd86eb3\";s:36:\"includes/swv/php/rules/minlength.php\";s:32:\"2dde234a521417af487e2f33a2196b28\";s:36:\"includes/swv/php/rules/minnumber.php\";s:32:\"b3702ede673e11e6b83f0dd9b2944b9b\";s:33:\"includes/swv/php/rules/number.php\";s:32:\"0ce8bc3d014a79820e14877cdda7d159\";s:35:\"includes/swv/php/rules/required.php\";s:32:\"d1fb5d7b58d1c695d613415cea5bddf5\";s:39:\"includes/swv/php/rules/requiredfile.php\";s:32:\"89eebb6dd40fc8bb6bc17cca520f51f1\";s:30:\"includes/swv/php/rules/tel.php\";s:32:\"09c180601778a9725572065187221ae6\";s:31:\"includes/swv/php/rules/time.php\";s:32:\"6fd12e8f5c95f7caf53306554671538d\";s:30:\"includes/swv/php/rules/url.php\";s:32:\"91e9850cf97ec3e4f9927d8e1577c3ea\";s:30:\"includes/swv/schema-holder.php\";s:32:\"ac33a91736a7645d22b08551f0e899d8\";s:30:\"includes/swv/script-loader.php\";s:32:\"0134fc5c336537675fabd211a026f41b\";s:20:\"includes/swv/swv.php\";s:32:\"20261285fd36f6ea436a2b03caed733b\";s:20:\"includes/upgrade.php\";s:32:\"d7ce58360de85b89d6b33b9afa5739c9\";s:33:\"includes/validation-functions.php\";s:32:\"eb01a6e5da22936e7c8dfe78df22680d\";s:23:\"includes/validation.php\";s:32:\"d55e08a56b555b50ff85d3a5ee83714c\";s:20:\"languages/readme.txt\";s:32:\"085954261a986f5e4705d4a8a3c8f47d\";s:11:\"license.txt\";s:32:\"effc2d468b68786f2935805deefa1ad9\";s:8:\"load.php\";s:32:\"f5fafdde4955c6cdf902754760ba6412\";s:22:\"modules/acceptance.php\";s:32:\"9890ec1385eb31edaead845e33687913\";s:27:\"modules/akismet/akismet.php\";s:32:\"77d5c83f3ed0dee7e97b03e1a59dd8d7\";s:27:\"modules/akismet/service.php\";s:32:\"2445de7071d2165568cbbd3c87facb05\";s:20:\"modules/checkbox.php\";s:32:\"4c064d47bf6f4d0b1306bfe9be22c32b\";s:45:\"modules/constant-contact/constant-contact.php\";s:32:\"87d4d1621511ebda774c09843b92b0ea\";s:52:\"modules/constant-contact/contact-form-properties.php\";s:32:\"c4d18714eaad66407114b36bb9ce4e7e\";s:49:\"modules/constant-contact/contact-post-request.php\";s:32:\"3235692f85df2b3a0af12bf822ef15a0\";s:32:\"modules/constant-contact/doi.php\";s:32:\"54150609e9f41915090ba476def8d8bc\";s:36:\"modules/constant-contact/service.php\";s:32:\"b263c34f23ca5b09e083e07713289a3d\";s:17:\"modules/count.php\";s:32:\"344f45ac4eb130c882edb5959ff9299a\";s:16:\"modules/date.php\";s:32:\"8a701946994b12bd4f18016960511b32\";s:27:\"modules/disallowed-list.php\";s:32:\"c14ebcfdf5be22340743e21c4e85d627\";s:22:\"modules/doi-helper.php\";s:32:\"d18854132bca414f076b116cfcd0aa55\";s:16:\"modules/file.php\";s:32:\"eaa25644cd319b6359066dcce6905570\";s:20:\"modules/flamingo.php\";s:32:\"737f091e577499e2faea3f615a5b4123\";s:18:\"modules/hidden.php\";s:32:\"d9d941387c19293661fa62d7d8dd0c0d\";s:17:\"modules/listo.php\";s:32:\"d6987c5a045823386ed4dcb0ed2f6740\";s:18:\"modules/number.php\";s:32:\"57177eba421d848b8e8e1d67ac8466e2\";s:16:\"modules/quiz.php\";s:32:\"ae3a50330f8948efbdcb73a28189fcd3\";s:33:\"modules/really-simple-captcha.php\";s:32:\"78145a38279da9c89c6aacac2e78e585\";s:33:\"modules/recaptcha/index.asset.php\";s:32:\"ab7137bfa351c9f4256b218f71e0188a\";s:26:\"modules/recaptcha/index.js\";s:32:\"ec0187677793456f98473f49d9e9b95f\";s:31:\"modules/recaptcha/recaptcha.php\";s:32:\"1a133779b7ffc6c1aa55fb1e86170f96\";s:29:\"modules/recaptcha/service.php\";s:32:\"669b92909e2f131b85e8f5f021734772\";s:22:\"modules/reflection.php\";s:32:\"b03111bcdf37baa6e25e6b0a16e907d4\";s:20:\"modules/response.php\";s:32:\"61d9a48d40eff7572be9582acf31a9f4\";s:18:\"modules/select.php\";s:32:\"23fb1120e4caba499cc30dbb55c25ab7\";s:46:\"modules/sendinblue/contact-form-properties.php\";s:32:\"fa19e8393be78963f90fe41c9a118927\";s:26:\"modules/sendinblue/doi.php\";s:32:\"1b4add560d9584614d8b228ef19a8a4b\";s:33:\"modules/sendinblue/sendinblue.php\";s:32:\"2c62c67b12e4decc260769a2aed87e24\";s:30:\"modules/sendinblue/service.php\";s:32:\"98da57c2d16350bbbefe78cdb3c600e2\";s:22:\"modules/stripe/api.php\";s:32:\"50db6d85d42202e2f0d1c039b17d06bc\";s:30:\"modules/stripe/index.asset.php\";s:32:\"ab7137bfa351c9f4256b218f71e0188a\";s:23:\"modules/stripe/index.js\";s:32:\"2dea7bec98383ccf26b12178ff23cb27\";s:26:\"modules/stripe/service.php\";s:32:\"f0bb29116b0111084e1108e287283fc3\";s:25:\"modules/stripe/stripe.php\";s:32:\"afe2d52985d8b7ed1300d802152a0c4d\";s:24:\"modules/stripe/style.css\";s:32:\"f6e4fa8d13745ebcdea70e338ac9eb4d\";s:18:\"modules/submit.php\";s:32:\"89d475dfae73d4461fe15791fb01cc4b\";s:16:\"modules/text.php\";s:32:\"456aed137d66056660ef555b8a3e07e7\";s:20:\"modules/textarea.php\";s:32:\"c6ad8b5b5d98acc79e00a691ec6a7ef9\";s:10:\"readme.txt\";s:32:\"13eb78cb0e694d690ae57ea921d4af55\";s:13:\"uninstall.php\";s:32:\"c4d603e0048dda783296fbf17630c90d\";s:21:\"wp-contact-form-7.php\";s:32:\"e3e78a2b148001fca280707edbd91955\";}s:10:\"checked_at\";i:1730467867;}}s:12:\"wp-smush-pro\";a:1:{s:6:\"3.16.8\";a:2:{s:6:\"hashes\";a:0:{}s:10:\"checked_at\";i:1730468014;}}s:27:\"admin-site-enhancements-pro\";a:1:{s:5:\"7.4.8\";a:2:{s:6:\"hashes\";a:0:{}s:10:\"checked_at\";i:1730468753;}}}}","off"),
("1275","itsec_vm_wp_releases","a:2:{s:7:\"expires\";i:1730553567;s:5:\"dates\";a:757:{s:4:\"0.70\";i:1054018800;s:4:\"0.71\";i:1055142000;s:4:\"0.72\";i:1065855600;s:5:\"0.711\";i:1056524400;s:3:\"1.0\";i:1073116800;s:5:\"1.0.1\";i:1075017600;s:5:\"1.0.2\";i:1078992000;s:3:\"1.2\";i:1085209200;s:5:\"1.2.1\";i:1097046000;s:5:\"1.2.2\";i:1103097600;s:3:\"1.5\";i:1113859357;s:5:\"1.5.1\";i:1115735328;s:7:\"1.5.1.1\";i:1116604699;s:7:\"1.5.1.2\";i:1118112479;s:7:\"1.5.1.3\";i:1120324814;s:5:\"1.5.2\";i:1124508646;s:3:\"2.0\";i:1135632922;s:5:\"2.0.1\";i:1138831877;s:5:\"2.0.2\";i:1149270205;s:5:\"2.0.3\";i:1149270289;s:5:\"2.0.4\";i:1154139919;s:5:\"2.0.5\";i:1161988921;s:5:\"2.0.6\";i:1168057481;s:5:\"2.0.7\";i:1168894288;s:5:\"2.0.8\";i:1170715370;s:5:\"2.0.9\";i:1172001465;s:6:\"2.0.10\";i:1175624092;s:6:\"2.0.11\";i:1186292608;s:3:\"2.1\";i:1169519000;s:5:\"2.1.1\";i:1172001487;s:5:\"2.1.2\";i:1172906639;s:5:\"2.1.3\";i:1175624112;s:3:\"2.2\";i:1179267170;s:5:\"2.2.1\";i:1182401665;s:5:\"2.2.2\";i:1186292591;s:5:\"2.2.3\";i:1189196519;s:3:\"2.3\";i:1191658326;s:5:\"2.3.1\";i:1193415008;s:5:\"2.3.2\";i:1198964368;s:5:\"2.3.3\";i:1202186673;s:3:\"2.5\";i:1206807543;s:5:\"2.5.1\";i:1209138128;s:3:\"2.6\";i:1216091476;s:5:\"2.6.1\";i:1218769779;s:5:\"2.6.2\";i:1220901127;s:5:\"2.6.3\";i:1224802155;s:5:\"2.6.5\";i:1227632172;s:3:\"2.7\";i:1228949328;s:5:\"2.7.1\";i:1234294760;s:3:\"2.8\";i:1244695363;s:5:\"2.8.1\";i:1247165630;s:5:\"2.8.2\";i:1248064511;s:5:\"2.8.3\";i:1249313203;s:5:\"2.8.4\";i:1250038821;s:5:\"2.8.5\";i:1256079527;s:5:\"2.8.6\";i:1258049170;s:3:\"2.9\";i:1261178300;s:5:\"2.9.1\";i:1262656797;s:5:\"2.9.2\";i:1266255539;s:3:\"3.0\";i:1276791854;s:5:\"3.0.1\";i:1280440646;s:5:\"3.0.2\";i:1291831998;s:5:\"3.0.3\";i:1291832141;s:5:\"3.0.4\";i:1293657069;s:5:\"3.0.5\";i:1297120365;s:5:\"3.0.6\";i:1303843197;s:3:\"3.1\";i:1298472579;s:5:\"3.1.1\";i:1301931877;s:5:\"3.1.2\";i:1303843240;s:5:\"3.1.3\";i:1306347267;s:5:\"3.1.4\";i:1309372729;s:3:\"3.2\";i:1309811102;s:5:\"3.2.1\";i:1310495472;s:3:\"3.3\";i:1323728758;s:5:\"3.3.1\";i:1325623803;s:5:\"3.3.2\";i:1334933591;s:5:\"3.3.3\";i:1340825609;s:3:\"3.4\";i:1339611068;s:5:\"3.4.1\";i:1340825623;s:5:\"3.4.2\";i:1346960566;s:3:\"3.5\";i:1355241983;s:5:\"3.5.1\";i:1359060776;s:5:\"3.5.2\";i:1371843156;s:3:\"3.6\";i:1375389816;s:5:\"3.6.1\";i:1378928120;s:3:\"3.7\";i:1382654850;s:5:\"3.7.1\";i:1383084609;s:5:\"3.7.2\";i:1396984652;s:5:\"3.7.3\";i:1397505265;s:5:\"3.7.4\";i:1407355819;s:5:\"3.7.5\";i:1416513513;s:5:\"3.7.6\";i:1429632769;s:5:\"3.7.7\";i:1429828770;s:5:\"3.7.8\";i:1430968880;s:5:\"3.7.9\";i:1437653639;s:6:\"3.7.10\";i:1438692566;s:6:\"3.7.11\";i:1442334431;s:6:\"3.7.12\";i:1452123726;s:6:\"3.7.13\";i:1454443093;s:6:\"3.7.14\";i:1462563966;s:6:\"3.7.15\";i:1466531950;s:6:\"3.7.16\";i:1473267870;s:6:\"3.7.17\";i:1484169487;s:6:\"3.7.18\";i:1485461407;s:6:\"3.7.19\";i:1488824234;s:6:\"3.7.20\";i:1492714347;s:6:\"3.7.21\";i:1494975067;s:6:\"3.7.22\";i:1505859793;s:6:\"3.7.23\";i:1509465194;s:6:\"3.7.24\";i:1511993180;s:6:\"3.7.25\";i:1516146787;s:6:\"3.7.26\";i:1522795384;s:6:\"3.7.27\";i:1530814586;s:6:\"3.7.28\";i:1544672129;s:6:\"3.7.29\";i:1552446856;s:6:\"3.7.30\";i:1567640302;s:6:\"3.7.31\";i:1571085425;s:6:\"3.7.32\";i:1576191815;s:6:\"3.7.33\";i:1588186625;s:6:\"3.7.34\";i:1591825394;s:6:\"3.7.35\";i:1604001131;s:6:\"3.7.36\";i:1620863584;s:6:\"3.7.37\";i:1641501952;s:6:\"3.7.38\";i:1646959089;s:6:\"3.7.39\";i:1661881750;s:6:\"3.7.40\";i:1666044065;s:6:\"3.7.41\";i:1669768144;s:3:\"3.8\";i:1386870239;s:5:\"3.8.1\";i:1390513948;s:5:\"3.8.2\";i:1396984643;s:5:\"3.8.3\";i:1397505258;s:5:\"3.8.4\";i:1407355744;s:5:\"3.8.5\";i:1416513498;s:5:\"3.8.6\";i:1429632732;s:5:\"3.8.7\";i:1429828745;s:5:\"3.8.8\";i:1430968852;s:5:\"3.8.9\";i:1437653635;s:6:\"3.8.10\";i:1438692560;s:6:\"3.8.11\";i:1442334383;s:6:\"3.8.12\";i:1452123667;s:6:\"3.8.13\";i:1454443087;s:6:\"3.8.14\";i:1462563934;s:6:\"3.8.15\";i:1466531950;s:6:\"3.8.16\";i:1473267859;s:6:\"3.8.17\";i:1484169370;s:6:\"3.8.18\";i:1485461228;s:6:\"3.8.19\";i:1488824227;s:6:\"3.8.20\";i:1492714341;s:6:\"3.8.21\";i:1494974827;s:6:\"3.8.22\";i:1505859787;s:6:\"3.8.23\";i:1509465187;s:6:\"3.8.24\";i:1511993174;s:6:\"3.8.25\";i:1516146607;s:6:\"3.8.26\";i:1522795376;s:6:\"3.8.27\";i:1530814575;s:6:\"3.8.28\";i:1544672120;s:6:\"3.8.29\";i:1552446680;s:6:\"3.8.30\";i:1567640296;s:6:\"3.8.31\";i:1571085306;s:6:\"3.8.32\";i:1576191809;s:6:\"3.8.33\";i:1588186566;s:6:\"3.8.34\";i:1591825454;s:6:\"3.8.35\";i:1604001126;s:6:\"3.8.36\";i:1620863544;s:6:\"3.8.37\";i:1641501915;s:6:\"3.8.38\";i:1646959084;s:6:\"3.8.39\";i:1661881745;s:6:\"3.8.40\";i:1666043944;s:6:\"3.8.41\";i:1669768089;s:3:\"3.9\";i:1397674420;s:5:\"3.9.1\";i:1399575077;s:5:\"3.9.2\";i:1407355721;s:5:\"3.9.3\";i:1416513428;s:5:\"3.9.4\";i:1429632713;s:5:\"3.9.5\";i:1429828708;s:5:\"3.9.6\";i:1430968816;s:5:\"3.9.7\";i:1437653631;s:5:\"3.9.8\";i:1438692553;s:5:\"3.9.9\";i:1442334372;s:6:\"3.9.10\";i:1452123610;s:6:\"3.9.11\";i:1454443049;s:6:\"3.9.12\";i:1462563928;s:6:\"3.9.13\";i:1466531950;s:6:\"3.9.14\";i:1473267849;s:6:\"3.9.15\";i:1484169248;s:6:\"3.9.16\";i:1485461108;s:6:\"3.9.17\";i:1488824167;s:6:\"3.9.18\";i:1492714334;s:6:\"3.9.19\";i:1494974588;s:6:\"3.9.20\";i:1505859770;s:6:\"3.9.21\";i:1509465134;s:6:\"3.9.22\";i:1511993168;s:6:\"3.9.23\";i:1516146307;s:6:\"3.9.24\";i:1522795367;s:6:\"3.9.25\";i:1530814564;s:6:\"3.9.26\";i:1544672111;s:6:\"3.9.27\";i:1552446323;s:6:\"3.9.28\";i:1567640290;s:6:\"3.9.29\";i:1571085011;s:6:\"3.9.30\";i:1576191803;s:6:\"3.9.31\";i:1588186513;s:6:\"3.9.32\";i:1591825505;s:6:\"3.9.33\";i:1604001065;s:6:\"3.9.34\";i:1620863540;s:6:\"3.9.35\";i:1641501910;s:6:\"3.9.36\";i:1646959025;s:6:\"3.9.37\";i:1661881690;s:6:\"3.9.39\";i:1666045685;s:6:\"3.9.40\";i:1669768084;s:3:\"4.0\";i:1409850847;s:5:\"4.0.1\";i:1416513365;s:5:\"4.0.2\";i:1429632696;s:5:\"4.0.3\";i:1429828657;s:5:\"4.0.4\";i:1430161003;s:5:\"4.0.5\";i:1430968781;s:5:\"4.0.6\";i:1437653627;s:5:\"4.0.7\";i:1438692547;s:5:\"4.0.8\";i:1442334341;s:5:\"4.0.9\";i:1452123489;s:6:\"4.0.10\";i:1454443042;s:6:\"4.0.11\";i:1462563922;s:6:\"4.0.12\";i:1466531950;s:6:\"4.0.13\";i:1473267816;s:6:\"4.0.14\";i:1484169010;s:6:\"4.0.15\";i:1485461048;s:6:\"4.0.16\";i:1488824115;s:6:\"4.0.17\";i:1492714328;s:6:\"4.0.18\";i:1494974467;s:6:\"4.0.19\";i:1505859764;s:6:\"4.0.20\";i:1509465128;s:6:\"4.0.21\";i:1511993147;s:6:\"4.0.22\";i:1516146067;s:6:\"4.0.23\";i:1522795358;s:6:\"4.0.24\";i:1530814549;s:6:\"4.0.25\";i:1544672061;s:6:\"4.0.26\";i:1552442316;s:6:\"4.0.27\";i:1567640284;s:6:\"4.0.28\";i:1571085005;s:6:\"4.0.29\";i:1576191797;s:6:\"4.0.30\";i:1588186506;s:6:\"4.0.31\";i:1591825510;s:6:\"4.0.32\";i:1604001012;s:6:\"4.0.33\";i:1620863535;s:6:\"4.0.34\";i:1641501920;s:6:\"4.0.35\";i:1646958969;s:6:\"4.0.36\";i:1661881685;s:6:\"4.0.37\";i:1666038845;s:6:\"4.0.38\";i:1669768026;s:3:\"4.1\";i:1418927630;s:5:\"4.1.1\";i:1424302482;s:5:\"4.1.2\";i:1429632013;s:5:\"4.1.3\";i:1429828556;s:5:\"4.1.4\";i:1430160896;s:5:\"4.1.5\";i:1430968735;s:5:\"4.1.6\";i:1437653623;s:5:\"4.1.7\";i:1438692488;s:5:\"4.1.8\";i:1442334326;s:5:\"4.1.9\";i:1452123248;s:6:\"4.1.10\";i:1454443035;s:6:\"4.1.11\";i:1462563915;s:6:\"4.1.12\";i:1466531950;s:6:\"4.1.13\";i:1473267807;s:6:\"4.1.14\";i:1484168828;s:6:\"4.1.15\";i:1485460929;s:6:\"4.1.16\";i:1488824108;s:6:\"4.1.17\";i:1492714298;s:6:\"4.1.18\";i:1494974407;s:6:\"4.1.19\";i:1505859758;s:6:\"4.1.20\";i:1509465075;s:6:\"4.1.21\";i:1511993139;s:6:\"4.1.22\";i:1516145767;s:6:\"4.1.23\";i:1522795349;s:6:\"4.1.24\";i:1530814535;s:6:\"4.1.25\";i:1544672050;s:6:\"4.1.26\";i:1552441812;s:6:\"4.1.27\";i:1567640278;s:6:\"4.1.28\";i:1571084951;s:6:\"4.1.29\";i:1576191791;s:6:\"4.1.30\";i:1588186445;s:6:\"4.1.31\";i:1591825565;s:6:\"4.1.32\";i:1604001006;s:6:\"4.1.33\";i:1620863530;s:6:\"4.1.34\";i:1641497285;s:6:\"4.1.35\";i:1646958964;s:6:\"4.1.36\";i:1661881631;s:6:\"4.1.37\";i:1666038785;s:6:\"4.1.38\";i:1684259405;s:6:\"4.1.39\";i:1697137868;s:6:\"4.1.40\";i:1706643905;s:6:\"4.1.41\";i:1719249263;s:3:\"4.2\";i:1429819680;s:5:\"4.2.1\";i:1430160772;s:5:\"4.2.2\";i:1430968620;s:5:\"4.2.3\";i:1437653462;s:5:\"4.2.4\";i:1438692248;s:5:\"4.2.5\";i:1442334313;s:5:\"4.2.6\";i:1452123068;s:5:\"4.2.7\";i:1454443028;s:5:\"4.2.8\";i:1462563908;s:5:\"4.2.9\";i:1466531950;s:6:\"4.2.10\";i:1473267799;s:6:\"4.2.11\";i:1484168768;s:6:\"4.2.12\";i:1485460868;s:6:\"4.2.13\";i:1488824053;s:6:\"4.2.14\";i:1492714291;s:6:\"4.2.15\";i:1494974288;s:6:\"4.2.16\";i:1505859751;s:6:\"4.2.17\";i:1509465068;s:6:\"4.2.18\";i:1511993132;s:6:\"4.2.19\";i:1516145468;s:6:\"4.2.20\";i:1522795340;s:6:\"4.2.21\";i:1530814517;s:6:\"4.2.22\";i:1544672013;s:6:\"4.2.23\";i:1552441411;s:6:\"4.2.24\";i:1567640272;s:6:\"4.2.25\";i:1571084945;s:6:\"4.2.26\";i:1576191785;s:6:\"4.2.27\";i:1588186392;s:6:\"4.2.28\";i:1591825571;s:6:\"4.2.29\";i:1604000952;s:6:\"4.2.30\";i:1620863525;s:6:\"4.2.31\";i:1641497050;s:6:\"4.2.32\";i:1646958910;s:6:\"4.2.33\";i:1661881625;s:6:\"4.2.34\";i:1666038725;s:6:\"4.2.35\";i:1684259345;s:6:\"4.2.36\";i:1697137862;s:6:\"4.2.37\";i:1706643911;s:6:\"4.2.38\";i:1719249257;s:3:\"4.3\";i:1439926088;s:5:\"4.3.1\";i:1442334073;s:5:\"4.3.2\";i:1452122710;s:5:\"4.3.3\";i:1454442969;s:5:\"4.3.4\";i:1462563848;s:5:\"4.3.5\";i:1466531950;s:5:\"4.3.6\";i:1473267790;s:5:\"4.3.7\";i:1484167688;s:5:\"4.3.8\";i:1485460568;s:5:\"4.3.9\";i:1488823995;s:6:\"4.3.10\";i:1492714284;s:6:\"4.3.11\";i:1494974236;s:6:\"4.3.12\";i:1505859744;s:6:\"4.3.13\";i:1509465008;s:6:\"4.3.14\";i:1511993124;s:6:\"4.3.15\";i:1516145168;s:6:\"4.3.16\";i:1522795331;s:6:\"4.3.17\";i:1530814460;s:6:\"4.3.18\";i:1544672002;s:6:\"4.3.19\";i:1552441048;s:6:\"4.3.20\";i:1567640266;s:6:\"4.3.21\";i:1571084898;s:6:\"4.3.22\";i:1576185432;s:6:\"4.3.23\";i:1588186386;s:6:\"4.3.24\";i:1591825591;s:6:\"4.3.25\";i:1604000946;s:6:\"4.3.26\";i:1620863489;s:6:\"4.3.27\";i:1641497045;s:6:\"4.3.28\";i:1646958905;s:6:\"4.3.29\";i:1661881570;s:6:\"4.3.30\";i:1666038671;s:6:\"4.3.31\";i:1684259285;s:6:\"4.3.32\";i:1697137856;s:6:\"4.3.33\";i:1706643965;s:6:\"4.3.34\";i:1719249251;s:3:\"4.4\";i:1449623169;s:5:\"4.4.1\";i:1452122589;s:5:\"4.4.2\";i:1454442851;s:5:\"4.4.3\";i:1462563668;s:5:\"4.4.4\";i:1466531950;s:5:\"4.4.5\";i:1473267740;s:5:\"4.4.6\";i:1484167569;s:5:\"4.4.7\";i:1485460328;s:5:\"4.4.8\";i:1488823988;s:5:\"4.4.9\";i:1492714277;s:6:\"4.4.10\";i:1494974229;s:6:\"4.4.11\";i:1505859737;s:6:\"4.4.12\";i:1509464597;s:6:\"4.4.13\";i:1511993117;s:6:\"4.4.14\";i:1516144928;s:6:\"4.4.15\";i:1522795278;s:6:\"4.4.16\";i:1530814439;s:6:\"4.4.17\";i:1544671991;s:6:\"4.4.18\";i:1552440692;s:6:\"4.4.19\";i:1567640260;s:6:\"4.4.20\";i:1571084892;s:6:\"4.4.21\";i:1576185426;s:6:\"4.4.22\";i:1588186327;s:6:\"4.4.23\";i:1591825626;s:6:\"4.4.24\";i:1604000893;s:6:\"4.4.25\";i:1620863484;s:6:\"4.4.26\";i:1641496985;s:6:\"4.4.27\";i:1646958845;s:6:\"4.4.28\";i:1661881565;s:6:\"4.4.29\";i:1666038665;s:6:\"4.4.30\";i:1684259225;s:6:\"4.4.31\";i:1697137850;s:6:\"4.4.32\";i:1706644027;s:6:\"4.4.33\";i:1719249245;s:3:\"4.5\";i:1460490730;s:5:\"4.5.1\";i:1461702009;s:5:\"4.5.2\";i:1462563549;s:5:\"4.5.3\";i:1466531950;s:5:\"4.5.4\";i:1473267731;s:5:\"4.5.5\";i:1484167449;s:5:\"4.5.6\";i:1485460269;s:5:\"4.5.7\";i:1488823929;s:5:\"4.5.8\";i:1492714269;s:5:\"4.5.9\";i:1494974117;s:6:\"4.5.10\";i:1505859729;s:6:\"4.5.11\";i:1509464589;s:6:\"4.5.12\";i:1511993109;s:6:\"4.5.13\";i:1516144688;s:6:\"4.5.14\";i:1522795254;s:6:\"4.5.15\";i:1530814420;s:6:\"4.5.16\";i:1544671954;s:6:\"4.5.17\";i:1552440330;s:6:\"4.5.18\";i:1567640254;s:6:\"4.5.19\";i:1571084886;s:6:\"4.5.20\";i:1576185187;s:6:\"4.5.21\";i:1588186267;s:6:\"4.5.22\";i:1591825686;s:6:\"4.5.23\";i:1604000887;s:6:\"4.5.24\";i:1620863478;s:6:\"4.5.25\";i:1641496931;s:6:\"4.5.26\";i:1646958792;s:6:\"4.5.27\";i:1661881505;s:6:\"4.5.28\";i:1666038605;s:6:\"4.5.29\";i:1684259165;s:6:\"4.5.30\";i:1697137844;s:6:\"4.5.31\";i:1706644085;s:6:\"4.5.32\";i:1719249198;s:3:\"4.6\";i:1471379770;s:5:\"4.6.1\";i:1473267672;s:5:\"4.6.2\";i:1484167149;s:5:\"4.6.3\";i:1485460029;s:5:\"4.6.4\";i:1488823869;s:5:\"4.6.5\";i:1492714219;s:5:\"4.6.6\";i:1494974109;s:5:\"4.6.7\";i:1505859688;s:5:\"4.6.8\";i:1509464530;s:5:\"4.6.9\";i:1511993059;s:6:\"4.6.10\";i:1516144510;s:6:\"4.6.11\";i:1522795226;s:6:\"4.6.12\";i:1530814401;s:6:\"4.6.13\";i:1544671943;s:6:\"4.6.14\";i:1552439952;s:6:\"4.6.15\";i:1567640247;s:6:\"4.6.16\";i:1571084834;s:6:\"4.6.17\";i:1576185127;s:6:\"4.6.18\";i:1588186214;s:6:\"4.6.19\";i:1591825633;s:6:\"4.6.20\";i:1604000835;s:6:\"4.6.21\";i:1620863472;s:6:\"4.6.22\";i:1641496925;s:6:\"4.6.23\";i:1646958786;s:6:\"4.6.24\";i:1661881452;s:6:\"4.6.25\";i:1666038545;s:6:\"4.6.26\";i:1684258505;s:6:\"4.6.27\";i:1697137838;s:6:\"4.6.28\";i:1706644145;s:6:\"4.6.29\";i:1719249192;s:3:\"4.7\";i:1481053992;s:5:\"4.7.1\";i:1484166490;s:5:\"4.7.2\";i:1485459731;s:5:\"4.7.3\";i:1488823750;s:5:\"4.7.4\";i:1492714211;s:5:\"4.7.5\";i:1494973689;s:5:\"4.7.6\";i:1505859680;s:5:\"4.7.7\";i:1509464410;s:5:\"4.7.8\";i:1511993051;s:5:\"4.7.9\";i:1516144269;s:6:\"4.7.10\";i:1522795199;s:6:\"4.7.11\";i:1530814382;s:6:\"4.7.12\";i:1544671931;s:6:\"4.7.13\";i:1552439652;s:6:\"4.7.14\";i:1567640241;s:6:\"4.7.15\";i:1571084827;s:6:\"4.7.16\";i:1576185067;s:6:\"4.7.17\";i:1588186207;s:6:\"4.7.18\";i:1591825585;s:6:\"4.7.19\";i:1604000828;s:6:\"4.7.20\";i:1618452552;s:6:\"4.7.21\";i:1620863466;s:6:\"4.7.22\";i:1641496872;s:6:\"4.7.23\";i:1646958733;s:6:\"4.7.24\";i:1661881446;s:6:\"4.7.25\";i:1666038486;s:6:\"4.7.26\";i:1684258446;s:6:\"4.7.27\";i:1697137831;s:6:\"4.7.28\";i:1706644152;s:6:\"4.7.29\";i:1719249186;s:3:\"4.8\";i:1496940099;s:5:\"4.8.1\";i:1501709471;s:5:\"4.8.2\";i:1505859670;s:5:\"4.8.3\";i:1509464350;s:5:\"4.8.4\";i:1511992991;s:5:\"4.8.5\";i:1516144031;s:5:\"4.8.6\";i:1522795170;s:5:\"4.8.7\";i:1530814364;s:5:\"4.8.8\";i:1544671884;s:5:\"4.8.9\";i:1552439132;s:6:\"4.8.10\";i:1567640235;s:6:\"4.8.11\";i:1571084775;s:6:\"4.8.12\";i:1576185007;s:6:\"4.8.13\";i:1588186163;s:6:\"4.8.14\";i:1591825578;s:6:\"4.8.15\";i:1604000707;s:6:\"4.8.16\";i:1618452546;s:6:\"4.8.17\";i:1620863433;s:6:\"4.8.18\";i:1641496866;s:6:\"4.8.19\";i:1646958726;s:6:\"4.8.20\";i:1661881386;s:6:\"4.8.21\";i:1666038431;s:6:\"4.8.22\";i:1684258386;s:6:\"4.8.23\";i:1697137825;s:6:\"4.8.24\";i:1706644206;s:6:\"4.8.25\";i:1719249133;s:3:\"4.9\";i:1510795212;s:5:\"4.9.1\";i:1511992032;s:5:\"4.9.2\";i:1516143851;s:5:\"4.9.3\";i:1517867473;s:5:\"4.9.4\";i:1517935332;s:5:\"4.9.5\";i:1522795092;s:5:\"4.9.6\";i:1526586677;s:5:\"4.9.7\";i:1530814343;s:5:\"4.9.8\";i:1533245593;s:5:\"4.9.9\";i:1544671872;s:6:\"4.9.10\";i:1552438753;s:6:\"4.9.11\";i:1567640227;s:6:\"4.9.12\";i:1571084767;s:6:\"4.9.13\";i:1576184947;s:6:\"4.9.14\";i:1588186155;s:6:\"4.9.15\";i:1591825517;s:6:\"4.9.16\";i:1604000675;s:6:\"4.9.17\";i:1618452523;s:6:\"4.9.18\";i:1620863427;s:6:\"4.9.19\";i:1641496806;s:6:\"4.9.20\";i:1646958666;s:6:\"4.9.21\";i:1661881340;s:6:\"4.9.22\";i:1666038425;s:6:\"4.9.23\";i:1684258266;s:6:\"4.9.24\";i:1697137818;s:6:\"4.9.25\";i:1706644213;s:6:\"4.9.26\";i:1719249126;s:3:\"5.0\";i:1544123596;s:5:\"5.0.1\";i:1544671814;s:5:\"5.0.2\";i:1545262393;s:5:\"5.0.3\";i:1547057838;s:5:\"5.0.4\";i:1552437974;s:5:\"5.0.5\";i:1552437359;s:5:\"5.0.6\";i:1567641428;s:5:\"5.0.7\";i:1571084707;s:5:\"5.0.8\";i:1576184888;s:5:\"5.0.9\";i:1588186148;s:6:\"5.0.10\";i:1591825462;s:6:\"5.0.11\";i:1604000667;s:6:\"5.0.12\";i:1618452517;s:6:\"5.0.13\";i:1620863421;s:6:\"5.0.14\";i:1632245226;s:6:\"5.0.15\";i:1641496746;s:6:\"5.0.16\";i:1646958614;s:6:\"5.0.17\";i:1661881334;s:6:\"5.0.18\";i:1666038367;s:6:\"5.0.19\";i:1684257608;s:6:\"5.0.20\";i:1697137811;s:6:\"5.0.21\";i:1706644266;s:6:\"5.0.22\";i:1719249093;s:3:\"5.1\";i:1550786905;s:5:\"5.1.1\";i:1552436284;s:5:\"5.1.2\";i:1567634974;s:5:\"5.1.3\";i:1571084657;s:5:\"5.1.4\";i:1576184048;s:5:\"5.1.5\";i:1588186087;s:5:\"5.1.6\";i:1591825448;s:5:\"5.1.7\";i:1604000657;s:5:\"5.1.8\";i:1604090468;s:5:\"5.1.9\";i:1618452510;s:6:\"5.1.10\";i:1620863414;s:6:\"5.1.11\";i:1632245167;s:6:\"5.1.12\";i:1641496694;s:6:\"5.1.13\";i:1646958607;s:6:\"5.1.14\";i:1661881326;s:6:\"5.1.15\";i:1666038306;s:6:\"5.1.16\";i:1684257547;s:6:\"5.1.17\";i:1697137803;s:6:\"5.1.18\";i:1706644327;s:6:\"5.1.19\";i:1719249085;s:3:\"5.2\";i:1557260487;s:5:\"5.2.1\";i:1558462843;s:5:\"5.2.2\";i:1560880106;s:5:\"5.2.3\";i:1567634966;s:5:\"5.2.4\";i:1571084649;s:5:\"5.2.5\";i:1576183868;s:5:\"5.2.6\";i:1588186037;s:5:\"5.2.7\";i:1591825388;s:5:\"5.2.8\";i:1604000649;s:5:\"5.2.9\";i:1604090408;s:6:\"5.2.10\";i:1618452503;s:6:\"5.2.11\";i:1620863407;s:6:\"5.2.12\";i:1631154007;s:6:\"5.2.13\";i:1636564754;s:6:\"5.2.14\";i:1641496687;s:6:\"5.2.15\";i:1646958547;s:6:\"5.2.16\";i:1661881283;s:6:\"5.2.17\";i:1666038247;s:6:\"5.2.18\";i:1684257487;s:6:\"5.2.19\";i:1697137794;s:6:\"5.2.20\";i:1706644334;s:6:\"5.2.21\";i:1719249077;s:3:\"5.3\";i:1573590610;s:5:\"5.3.1\";i:1576183749;s:5:\"5.3.2\";i:1576707369;s:5:\"5.3.3\";i:1588186029;s:5:\"5.3.4\";i:1591825278;s:5:\"5.3.5\";i:1604000625;s:5:\"5.3.6\";i:1604090358;s:5:\"5.3.7\";i:1618452495;s:5:\"5.3.8\";i:1620863381;s:5:\"5.3.9\";i:1631321588;s:6:\"5.3.10\";i:1636564747;s:6:\"5.3.11\";i:1641496627;s:6:\"5.3.12\";i:1646958495;s:6:\"5.3.13\";i:1661881275;s:6:\"5.3.14\";i:1666038187;s:6:\"5.3.15\";i:1684257248;s:6:\"5.3.16\";i:1697137786;s:6:\"5.3.17\";i:1706644387;s:6:\"5.3.18\";i:1719249068;s:3:\"5.4\";i:1585684929;s:5:\"5.4.1\";i:1588185968;s:5:\"5.4.2\";i:1591825269;s:5:\"5.4.3\";i:1604000616;s:5:\"5.4.4\";i:1604090349;s:5:\"5.4.5\";i:1618452487;s:5:\"5.4.6\";i:1620863373;s:5:\"5.4.7\";i:1631153955;s:5:\"5.4.8\";i:1636564696;s:5:\"5.4.9\";i:1641496575;s:6:\"5.4.10\";i:1646958487;s:6:\"5.4.11\";i:1661881267;s:6:\"5.4.12\";i:1666038127;s:6:\"5.4.13\";i:1684256648;s:6:\"5.4.14\";i:1697137777;s:6:\"5.4.15\";i:1706644395;s:6:\"5.4.16\";i:1719249037;s:3:\"5.5\";i:1597171450;s:5:\"5.5.1\";i:1598986389;s:5:\"5.5.2\";i:1604001789;s:5:\"5.5.3\";i:1604090232;s:5:\"5.5.4\";i:1618452445;s:5:\"5.5.5\";i:1620863365;s:5:\"5.5.6\";i:1631153947;s:5:\"5.5.7\";i:1636564688;s:5:\"5.5.8\";i:1641496567;s:5:\"5.5.9\";i:1646958436;s:6:\"5.5.10\";i:1661881259;s:6:\"5.5.11\";i:1666044073;s:6:\"5.5.12\";i:1684256588;s:6:\"5.5.13\";i:1697137768;s:6:\"5.5.14\";i:1706644448;s:6:\"5.5.15\";i:1719249028;s:3:\"5.6\";i:1607465531;s:5:\"5.6.1\";i:1612386670;s:5:\"5.6.2\";i:1614006488;s:5:\"5.6.3\";i:1618452437;s:5:\"5.6.4\";i:1620863357;s:5:\"5.6.5\";i:1631153905;s:5:\"5.6.6\";i:1636564575;s:5:\"5.6.7\";i:1641496508;s:5:\"5.6.8\";i:1646958428;s:5:\"5.6.9\";i:1661881250;s:6:\"5.6.10\";i:1666038008;s:6:\"5.6.11\";i:1684256469;s:6:\"5.6.12\";i:1697137759;s:6:\"5.6.13\";i:1706644508;s:6:\"5.6.14\";i:1719249019;s:3:\"5.7\";i:1615321089;s:5:\"5.7.1\";i:1618452429;s:5:\"5.7.2\";i:1620863349;s:5:\"5.7.3\";i:1631153897;s:5:\"5.7.4\";i:1636564567;s:5:\"5.7.5\";i:1641496448;s:5:\"5.7.6\";i:1646958308;s:5:\"5.7.7\";i:1661881241;s:5:\"5.7.8\";i:1666037947;s:5:\"5.7.9\";i:1684256348;s:6:\"5.7.10\";i:1697137750;s:6:\"5.7.11\";i:1706644568;s:6:\"5.7.12\";i:1719249009;s:3:\"5.8\";i:1626798010;s:5:\"5.8.1\";i:1631153889;s:5:\"5.8.2\";i:1636564510;s:5:\"5.8.3\";i:1641496391;s:5:\"5.8.4\";i:1646958248;s:5:\"5.8.5\";i:1661881233;s:5:\"5.8.6\";i:1666037888;s:5:\"5.8.7\";i:1684255930;s:5:\"5.8.8\";i:1697137741;s:5:\"5.8.9\";i:1706644577;s:6:\"5.8.10\";i:1719248982;s:3:\"5.9\";i:1643140150;s:5:\"5.9.1\";i:1645543090;s:5:\"5.9.2\";i:1646958190;s:5:\"5.9.3\";i:1649185931;s:5:\"5.9.4\";i:1661881222;s:5:\"5.9.5\";i:1666037828;s:5:\"5.9.6\";i:1684255809;s:5:\"5.9.7\";i:1684557009;s:5:\"5.9.8\";i:1697137731;s:5:\"5.9.9\";i:1706644630;s:6:\"5.9.10\";i:1719248972;s:3:\"6.0\";i:1653418872;s:5:\"6.0.1\";i:1657642513;s:5:\"6.0.2\";i:1661881212;s:5:\"6.0.3\";i:1666037710;s:5:\"6.0.4\";i:1684255690;s:5:\"6.0.5\";i:1684556959;s:5:\"6.0.6\";i:1697137722;s:5:\"6.0.7\";i:1706644640;s:5:\"6.0.8\";i:1712779274;s:5:\"6.0.9\";i:1719248962;s:3:\"6.1\";i:1667347511;s:5:\"6.1.1\";i:1668538931;s:5:\"6.1.2\";i:1684255451;s:5:\"6.1.3\";i:1684556949;s:5:\"6.1.4\";i:1697137711;s:5:\"6.1.5\";i:1706644689;s:5:\"6.1.6\";i:1712693450;s:5:\"6.1.7\";i:1719248951;s:3:\"6.2\";i:1680112030;s:5:\"6.2.1\";i:1684255272;s:5:\"6.2.2\";i:1684556893;s:5:\"6.2.3\";i:1697137700;s:5:\"6.2.4\";i:1706644700;s:5:\"6.2.5\";i:1712693439;s:5:\"6.2.6\";i:1719248919;s:3:\"6.3\";i:1691523015;s:5:\"6.3.1\";i:1693318452;s:5:\"6.3.2\";i:1697136387;s:5:\"6.3.3\";i:1706644751;s:5:\"6.3.4\";i:1712693426;s:5:\"6.3.5\";i:1719248906;s:3:\"6.4\";i:1699385052;s:5:\"6.4.1\";i:1699490655;s:5:\"6.4.2\";i:1701879852;s:5:\"6.4.3\";i:1706642773;s:5:\"6.4.4\";i:1712693413;s:5:\"6.4.5\";i:1719248893;s:3:\"6.5\";i:1712081473;s:5:\"6.5.1\";i:1712693350;s:5:\"6.5.2\";i:1712697016;s:5:\"6.5.3\";i:1715097075;s:5:\"6.5.4\";i:1717600935;s:5:\"6.5.5\";i:1719248835;s:3:\"6.6\";i:1721146875;s:5:\"6.6.1\";i:1721747655;s:5:\"6.6.2\";i:1725981736;}}","off"),
("1280","rank_math_registration_skip","1","auto"),
("1291","rank_math_known_post_types","a:3:{s:4:\"post\";s:4:\"post\";s:4:\"page\";s:4:\"page\";s:10:\"attachment\";s:10:\"attachment\";}","auto"),
("1292","rank_math_modules","a:13:{i:0;s:12:\"link-counter\";i:1;s:9:\"analytics\";i:2;s:12:\"seo-analysis\";i:3;s:7:\"sitemap\";i:4;s:12:\"rich-snippet\";i:5;s:11:\"woocommerce\";i:6;s:10:\"buddypress\";i:7;s:7:\"bbpress\";i:8;s:3:\"acf\";i:9;s:11:\"web-stories\";i:10;s:10:\"content-ai\";i:11;s:16:\"instant-indexing\";i:12;s:12:\"role-manager\";}","auto"),
("1293","rank-math-options-general","a:52:{s:19:\"strip_category_base\";s:3:\"off\";s:24:\"attachment_redirect_urls\";s:2:\"on\";s:27:\"attachment_redirect_default\";s:46:\"http://192.168.100.112:8012/duplicator-creaweb\";s:23:\"nofollow_external_links\";s:3:\"off\";s:20:\"nofollow_image_links\";s:3:\"off\";s:25:\"new_window_external_links\";s:2:\"on\";s:11:\"add_img_alt\";s:3:\"off\";s:14:\"img_alt_format\";s:11:\" %filename%\";s:13:\"add_img_title\";s:3:\"off\";s:16:\"img_title_format\";s:22:\"%title% %count(title)%\";s:11:\"breadcrumbs\";s:3:\"off\";s:21:\"breadcrumbs_separator\";s:1:\"-\";s:16:\"breadcrumbs_home\";s:2:\"on\";s:22:\"breadcrumbs_home_label\";s:4:\"Home\";s:26:\"breadcrumbs_archive_format\";s:15:\"Archives for %s\";s:25:\"breadcrumbs_search_format\";s:14:\"Results for %s\";s:21:\"breadcrumbs_404_label\";s:25:\"404 Error: page not found\";s:31:\"breadcrumbs_ancestor_categories\";s:3:\"off\";s:21:\"breadcrumbs_blog_page\";s:3:\"off\";s:16:\"404_monitor_mode\";s:6:\"simple\";s:17:\"404_monitor_limit\";i:100;s:35:\"404_monitor_ignore_query_parameters\";s:2:\"on\";s:24:\"redirections_header_code\";s:3:\"301\";s:18:\"redirections_debug\";s:3:\"off\";s:23:\"console_caching_control\";s:2:\"90\";s:21:\"console_email_reports\";s:2:\"on\";s:23:\"console_email_frequency\";s:7:\"monthly\";s:27:\"link_builder_links_per_page\";s:1:\"7\";s:29:\"link_builder_links_per_target\";s:1:\"1\";s:22:\"wc_remove_product_base\";s:3:\"off\";s:23:\"wc_remove_category_base\";s:3:\"off\";s:31:\"wc_remove_category_parent_slugs\";s:3:\"off\";s:18:\"rss_before_content\";s:0:\"\";s:17:\"rss_after_content\";s:0:\"\";s:19:\"wc_remove_generator\";s:2:\"on\";s:24:\"remove_shop_snippet_data\";s:2:\"on\";s:18:\"frontend_seo_score\";s:3:\"off\";s:29:\"frontend_seo_score_post_types\";a:1:{i:0;s:4:\"post\";}s:27:\"frontend_seo_score_position\";s:3:\"top\";s:10:\"setup_mode\";s:8:\"advanced\";s:21:\"content_ai_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:18:\"content_ai_country\";s:3:\"all\";s:15:\"content_ai_tone\";s:6:\"Formal\";s:19:\"content_ai_audience\";s:16:\"General Audience\";s:19:\"content_ai_language\";s:6:\"French\";s:15:\"analytics_stats\";s:2:\"on\";s:15:\"toc_block_title\";s:17:\"Table of Contents\";s:20:\"toc_block_list_style\";s:2:\"ul\";s:14:\"google_updates\";s:2:\"on\";s:13:\"podcast_title\";s:10:\"%sitename%\";s:19:\"podcast_description\";s:10:\"%sitedesc%\";s:29:\"podcast_tipodcast_explicittle\";s:3:\"off\";}","auto"),
("1294","rank-math-options-titles","a:105:{s:24:\"noindex_empty_taxonomies\";s:2:\"on\";s:15:\"title_separator\";s:1:\"-\";s:17:\"capitalize_titles\";s:3:\"off\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:19:\"knowledgegraph_type\";s:6:\"person\";s:19:\"knowledgegraph_name\";s:10:\"CREAWEB.MA\";s:12:\"website_name\";s:10:\"CREAWEB.MA\";s:19:\"local_business_type\";s:12:\"Organization\";s:20:\"local_address_format\";s:43:\"{address} {locality}, {region} {postalcode}\";s:13:\"opening_hours\";a:7:{i:0;a:2:{s:3:\"day\";s:6:\"Monday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:1;a:2:{s:3:\"day\";s:7:\"Tuesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:2;a:2:{s:3:\"day\";s:9:\"Wednesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:3;a:2:{s:3:\"day\";s:8:\"Thursday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:4;a:2:{s:3:\"day\";s:6:\"Friday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:5;a:2:{s:3:\"day\";s:8:\"Saturday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:6;a:2:{s:3:\"day\";s:6:\"Sunday\";s:4:\"time\";s:11:\"09:00-17:00\";}}s:20:\"opening_hours_format\";s:3:\"off\";s:14:\"homepage_title\";s:34:\"%sitename% %page% %sep% %sitedesc%\";s:20:\"homepage_description\";s:0:\"\";s:22:\"homepage_custom_robots\";s:3:\"off\";s:23:\"disable_author_archives\";s:3:\"off\";s:15:\"url_author_base\";s:6:\"author\";s:20:\"author_custom_robots\";s:2:\"on\";s:13:\"author_robots\";a:1:{i:0;s:7:\"noindex\";}s:20:\"author_archive_title\";s:30:\"%name% %sep% %sitename% %page%\";s:19:\"author_add_meta_box\";s:2:\"on\";s:21:\"disable_date_archives\";s:2:\"on\";s:18:\"date_archive_title\";s:30:\"%date% %page% %sep% %sitename%\";s:12:\"search_title\";s:38:\"%search_query% %page% %sep% %sitename%\";s:9:\"404_title\";s:31:\"Page Not Found %sep% %sitename%\";s:19:\"date_archive_robots\";a:1:{i:0;s:7:\"noindex\";}s:14:\"noindex_search\";s:2:\"on\";s:24:\"noindex_archive_subpages\";s:3:\"off\";s:26:\"noindex_password_protected\";s:3:\"off\";s:32:\"pt_download_default_rich_snippet\";s:7:\"product\";s:29:\"author_slack_enhanced_sharing\";s:2:\"on\";s:13:\"pt_post_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_post_description\";s:9:\"%excerpt%\";s:14:\"pt_post_robots\";a:0:{}s:21:\"pt_post_custom_robots\";s:3:\"off\";s:28:\"pt_post_default_rich_snippet\";s:7:\"article\";s:28:\"pt_post_default_article_type\";s:11:\"BlogPosting\";s:28:\"pt_post_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_post_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_post_slack_enhanced_sharing\";s:2:\"on\";s:17:\"pt_post_ls_use_fk\";s:6:\"titles\";s:20:\"pt_post_add_meta_box\";s:2:\"on\";s:20:\"pt_post_bulk_editing\";s:7:\"editing\";s:24:\"pt_post_link_suggestions\";s:2:\"on\";s:24:\"pt_post_primary_taxonomy\";s:8:\"category\";s:13:\"pt_page_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_page_description\";s:9:\"%excerpt%\";s:14:\"pt_page_robots\";a:0:{}s:21:\"pt_page_custom_robots\";s:3:\"off\";s:28:\"pt_page_default_rich_snippet\";s:7:\"article\";s:28:\"pt_page_default_article_type\";s:7:\"Article\";s:28:\"pt_page_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_page_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_page_slack_enhanced_sharing\";s:2:\"on\";s:17:\"pt_page_ls_use_fk\";s:6:\"titles\";s:20:\"pt_page_add_meta_box\";s:2:\"on\";s:20:\"pt_page_bulk_editing\";s:7:\"editing\";s:24:\"pt_page_link_suggestions\";s:2:\"on\";s:19:\"pt_attachment_title\";s:24:\"%title% %sep% %sitename%\";s:25:\"pt_attachment_description\";s:9:\"%excerpt%\";s:20:\"pt_attachment_robots\";a:1:{i:0;s:7:\"noindex\";}s:27:\"pt_attachment_custom_robots\";s:2:\"on\";s:34:\"pt_attachment_default_rich_snippet\";s:3:\"off\";s:34:\"pt_attachment_default_article_type\";s:7:\"Article\";s:34:\"pt_attachment_default_snippet_name\";s:11:\"%seo_title%\";s:34:\"pt_attachment_default_snippet_desc\";s:17:\"%seo_description%\";s:36:\"pt_attachment_slack_enhanced_sharing\";s:3:\"off\";s:26:\"pt_attachment_add_meta_box\";s:3:\"off\";s:16:\"pt_product_title\";s:24:\"%title% %sep% %sitename%\";s:22:\"pt_product_description\";s:9:\"%excerpt%\";s:17:\"pt_product_robots\";a:0:{}s:24:\"pt_product_custom_robots\";s:3:\"off\";s:31:\"pt_product_default_rich_snippet\";s:7:\"product\";s:31:\"pt_product_default_article_type\";s:7:\"Article\";s:31:\"pt_product_default_snippet_name\";s:11:\"%seo_title%\";s:31:\"pt_product_default_snippet_desc\";s:17:\"%seo_description%\";s:33:\"pt_product_slack_enhanced_sharing\";s:2:\"on\";s:20:\"pt_product_ls_use_fk\";s:6:\"titles\";s:23:\"pt_product_add_meta_box\";s:2:\"on\";s:23:\"pt_product_bulk_editing\";s:7:\"editing\";s:27:\"pt_product_link_suggestions\";s:2:\"on\";s:27:\"pt_product_primary_taxonomy\";s:11:\"product_cat\";s:18:\"pt_web-story_title\";s:24:\"%title% %sep% %sitename%\";s:24:\"pt_web-story_description\";s:9:\"%excerpt%\";s:19:\"pt_web-story_robots\";a:0:{}s:26:\"pt_web-story_custom_robots\";s:3:\"off\";s:33:\"pt_web-story_default_rich_snippet\";s:7:\"article\";s:33:\"pt_web-story_default_article_type\";s:7:\"Article\";s:33:\"pt_web-story_default_snippet_name\";s:11:\"%seo_title%\";s:33:\"pt_web-story_default_snippet_desc\";s:17:\"%seo_description%\";s:35:\"pt_web-story_slack_enhanced_sharing\";s:3:\"off\";s:25:\"pt_web-story_add_meta_box\";s:3:\"off\";s:18:\"tax_category_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_category_robots\";a:0:{}s:25:\"tax_category_add_meta_box\";s:2:\"on\";s:26:\"tax_category_custom_robots\";s:3:\"off\";s:24:\"tax_category_description\";s:18:\"%term_description%\";s:35:\"tax_category_slack_enhanced_sharing\";s:2:\"on\";s:18:\"tax_post_tag_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_post_tag_robots\";a:1:{i:0;s:7:\"noindex\";}s:25:\"tax_post_tag_add_meta_box\";s:3:\"off\";s:26:\"tax_post_tag_custom_robots\";s:2:\"on\";s:24:\"tax_post_tag_description\";s:18:\"%term_description%\";s:35:\"tax_post_tag_slack_enhanced_sharing\";s:2:\"on\";s:31:\"remove_product_cat_snippet_data\";s:2:\"on\";s:31:\"remove_product_tag_snippet_data\";s:2:\"on\";}","auto"),
("1295","rank-math-options-sitemap","a:16:{s:14:\"items_per_page\";i:200;s:14:\"include_images\";s:2:\"on\";s:22:\"include_featured_image\";s:3:\"off\";s:13:\"exclude_roles\";a:2:{i:0;s:11:\"contributor\";i:1;s:10:\"subscriber\";}s:12:\"html_sitemap\";s:2:\"on\";s:20:\"html_sitemap_display\";s:9:\"shortcode\";s:17:\"html_sitemap_sort\";s:9:\"published\";s:23:\"html_sitemap_seo_titles\";s:6:\"titles\";s:15:\"authors_sitemap\";s:2:\"on\";s:15:\"pt_post_sitemap\";s:2:\"on\";s:15:\"pt_page_sitemap\";s:2:\"on\";s:21:\"pt_attachment_sitemap\";s:3:\"off\";s:18:\"pt_product_sitemap\";s:2:\"on\";s:20:\"pt_web-story_sitemap\";s:3:\"off\";s:20:\"tax_category_sitemap\";s:2:\"on\";s:20:\"tax_post_tag_sitemap\";s:3:\"off\";}","auto"),
("1296","rank-math-options-instant-indexing","a:2:{s:15:\"bing_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:16:\"indexnow_api_key\";s:32:\"dfc628c34ce545e58958ef51f6963a45\";}","auto"),
("1297","_transient_timeout__rank_math_activation_redirect","1730467209","off"),
("1298","_transient__rank_math_activation_redirect","1","off"),
("1299","rank_math_version","1.0.231","auto"),
("1300","rank_math_db_version","1","auto"),
("1301","rank_math_install_date","1730467179","auto"),
("1305","rank_math_notifications","a:1:{i:0;a:2:{s:7:\"message\";s:241:\"<strong>SEO Notice</strong>: Your site is set to No Index and will not appear in search engines. You can change the Search engine visibility <a href=\"http://192.168.100.112:8012/duplicator-creaweb/wp-admin/options-reading.php\">from here</a>.\";s:7:\"options\";a:5:{s:2:\"id\";s:24:\"search_engine_visibility\";s:7:\"classes\";s:31:\"is-dismissible rank-math-notice\";s:4:\"type\";s:7:\"warning\";s:6:\"screen\";s:3:\"any\";s:10:\"capability\";s:0:\"\";}}}","auto"),
("1306","rank_math_review_notice_date","1731676780","off"),
("1309","rank_math_review_posts_converted","1","auto"),
("1311","_transient_rank_math_first_submenu_id","rank-math","on"),
("1314","rank_math_pro_version","3.0.74","auto"),
("1318","rank_math_viewed_seo_analyer","1","off"),
("1320","rank_math_pro_notice_date","1731331217","off"),
("1336","wp_rocket_no_licence","0","auto"),
("1337","wp_rocket_settings","a:64:{s:12:\"consumer_key\";s:8:\"********\";s:14:\"consumer_email\";s:17:\"noreply@gmail.com\";s:10:\"secret_key\";s:8:\"c1171a5c\";s:7:\"version\";s:6:\"3.17.1\";s:16:\"previous_version\";s:0:\"\";s:17:\"cache_logged_user\";i:0;s:9:\"cache_ssl\";i:0;s:12:\"cache_mobile\";i:0;s:23:\"do_caching_mobile_files\";i:0;s:19:\"minify_google_fonts\";i:0;s:10:\"minify_css\";i:0;s:9:\"minify_js\";i:0;s:21:\"minify_concatenate_js\";i:0;s:12:\"defer_all_js\";i:0;s:16:\"exclude_defer_js\";a:0:{}s:5:\"emoji\";i:0;s:8:\"lazyload\";i:0;s:16:\"lazyload_iframes\";i:0;s:16:\"lazyload_youtube\";i:0;s:19:\"purge_cron_interval\";s:0:\"\";s:15:\"purge_cron_unit\";s:0:\"\";s:12:\"dns_prefetch\";a:0:{}s:17:\"cache_purge_pages\";a:0:{}s:16:\"cache_reject_uri\";a:0:{}s:20:\"cache_reject_cookies\";a:0:{}s:19:\"cache_query_strings\";a:0:{}s:15:\"cache_reject_ua\";a:0:{}s:11:\"exclude_css\";a:0:{}s:10:\"exclude_js\";a:0:{}s:17:\"exclude_inline_js\";a:0:{}s:9:\"async_css\";i:0;s:12:\"critical_css\";s:0:\"\";s:18:\"database_revisions\";i:0;s:20:\"database_auto_drafts\";i:0;s:22:\"database_trashed_posts\";i:0;s:22:\"database_spam_comments\";i:0;s:25:\"database_trashed_comments\";i:0;s:23:\"database_all_transients\";i:0;s:24:\"database_optimize_tables\";i:0;s:26:\"schedule_automatic_cleanup\";i:0;s:27:\"automatic_cleanup_frequency\";s:0:\"\";s:14:\"manual_preload\";i:0;s:13:\"preload_fonts\";a:0:{}s:21:\"sucury_waf_cache_sync\";i:0;s:18:\"sucury_waf_api_key\";s:0:\"\";s:17:\"control_heartbeat\";i:0;s:23:\"heartbeat_site_behavior\";s:0:\"\";s:24:\"heartbeat_admin_behavior\";s:0:\"\";s:25:\"heartbeat_editor_behavior\";s:0:\"\";s:3:\"cdn\";i:0;s:10:\"cdn_cnames\";a:0:{}s:8:\"cdn_zone\";a:0:{}s:16:\"cdn_reject_files\";a:0:{}s:18:\"varnish_auto_purge\";i:0;s:16:\"image_dimensions\";i:0;s:16:\"exclude_lazyload\";a:0:{}s:20:\"preload_excluded_uri\";a:0:{}s:8:\"delay_js\";i:0;s:19:\"delay_js_exclusions\";a:0:{}s:28:\"delay_js_exclusions_selected\";a:0:{}s:39:\"delay_js_exclusions_selected_exclusions\";a:0:{}s:17:\"remove_unused_css\";i:0;s:26:\"remove_unused_css_safelist\";a:0:{}s:13:\"minify_js_key\";s:22:\"6724d639742be158082893\";}","auto"),
("1338","_transient_timeout_wp_rocket_pricing","1730510579","off"),
("1339","_transient_wp_rocket_pricing","O:8:\"stdClass\":3:{s:8:\"licenses\";O:8:\"stdClass\":3:{s:6:\"single\";O:8:\"stdClass\":2:{s:6:\"prices\";O:8:\"stdClass\":3:{s:7:\"regular\";i:59;s:4:\"sale\";d:44.25;s:7:\"renewal\";O:8:\"stdClass\":4:{s:14:\"is_grandfather\";d:47.2;s:14:\"is_grandmother\";i:59;s:15:\"not_grandfather\";i:59;s:10:\"is_expired\";i:59;}}s:8:\"websites\";i:1;}s:4:\"plus\";O:8:\"stdClass\":2:{s:6:\"prices\";O:8:\"stdClass\":4:{s:7:\"regular\";i:119;s:4:\"sale\";d:89.25;s:11:\"from_single\";O:8:\"stdClass\":2:{s:7:\"regular\";i:60;s:4:\"sale\";i:45;}s:7:\"renewal\";O:8:\"stdClass\":4:{s:14:\"is_grandfather\";d:95.2;s:14:\"is_grandmother\";i:119;s:15:\"not_grandfather\";i:119;s:10:\"is_expired\";i:119;}}s:8:\"websites\";i:3;}s:8:\"infinite\";O:8:\"stdClass\":2:{s:6:\"prices\";O:8:\"stdClass\":5:{s:7:\"regular\";i:299;s:4:\"sale\";d:224.25;s:11:\"from_single\";O:8:\"stdClass\":2:{s:7:\"regular\";i:240;s:4:\"sale\";i:180;}s:9:\"from_plus\";O:8:\"stdClass\":2:{s:7:\"regular\";i:180;s:4:\"sale\";i:135;}s:7:\"renewal\";O:8:\"stdClass\":4:{s:14:\"is_grandfather\";d:239.2;s:14:\"is_grandmother\";i:299;s:15:\"not_grandfather\";i:299;s:10:\"is_expired\";i:299;}}s:8:\"websites\";s:9:\"unlimited\";}}s:8:\"renewals\";O:8:\"stdClass\":4:{s:10:\"extra_days\";i:15;s:16:\"grandfather_date\";i:1640995200;s:16:\"grandmother_date\";i:315532800;s:16:\"discount_percent\";O:8:\"stdClass\":3:{s:14:\"is_grandfather\";i:20;s:15:\"not_grandfather\";i:0;s:10:\"is_expired\";i:0;}}s:5:\"promo\";O:8:\"stdClass\":4:{s:4:\"name\";s:11:\"Anniversary\";s:16:\"discount_percent\";i:25;s:10:\"start_date\";i:1719273600;s:8:\"end_date\";i:1719964799;}}","off"),
("1340","_transient_timeout_wp_rocket_customer_data","1730553779","off"),
("1341","_transient_wp_rocket_customer_data","O:8:\"stdClass\":3:{s:15:\"licence_account\";s:2:\"-1\";s:18:\"licence_expiration\";i:1893456000;s:19:\"has_one-com_account\";b:0;}","off"),
("1344","wpr_rocket_cache_version","20220927","auto"),
("1345","_transient_timeout_rocket_preload_previous_requests_durations","1730467682","off"),
("1346","_transient_rocket_preload_previous_requests_durations","1.449285030365","off"),
("1347","_transient_timeout_rocket_preload_check_duration","1730467442","off"),
("1348","_transient_rocket_preload_check_duration","1.449285030365","off"),
("1350","wpr_rucss_used_css_version","20231031","auto"),
("1351","wpr_above_the_fold_version","20240313","auto"),
("1352","wpr_lazy_render_content_version","20240812","auto"),
("1354","wp_rocket_last_base_url","aHR0cDovLzE5Mi4xNjguMTAwLjExMjo4MDEyL2R1cGxpY2F0b3ItY3JlYXdlYi8=","on"),
("1355","wp_rocket_debug","a:1:{s:20:\"last_rucss_job_added\";s:0:\"\";}","auto"),
("1356","_transient_timeout_wpr_dynamic_lists_delayjs","1731072191","off"),
("1357","_transient_wpr_dynamic_lists_delayjs","O:8:\"stdClass\":3:{s:7:\"plugins\";O:8:\"stdClass\":230:{s:36:\"ffc21030-519a-4853-8cea-49f959e82731\";O:8:\"stdClass\":9:{s:5:\"title\";s:51:\"Additional Variation Images Gallery for WooCommerce\";s:9:\"condition\";s:47:\"woo-variation-gallery/woo-variation-gallery.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:45:\"/woo-variation-gallery/assets/js/slick.min.js\";i:3;s:48:\"/woo-variation-gallery/assets/js/frontend.min.js\";i:4;s:33:\"/wp-includes/js/underscore.min.js\";i:5;s:23:\"variation_custom_fields\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:48:\"Prevents delay in the loading of product images.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:def67a2c1ddd6df2353e4772b6fd4e5b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724424735;}s:36:\"0e7dc253-acd0-4421-877f-a7101d848717\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"Advanced Ads\";s:9:\"condition\";s:29:\"advanced-ads/advanced-ads.php\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:16:\"/uploads/(.*).js\";i:3;s:18:\"advanced_ads_ready\";i:4;s:14:\"advadsCfpQueue\";i:5;s:11:\"adsbygoogle\";i:6;s:16:\"adservice.google\";i:7;s:17:\"/advanced-ads(.*)\";i:8;s:12:\"advads_items\";i:9;s:19:\"advads_tracking_ads\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:189:\"The latest versions of Advanced Ads include automatic compatibility with Delay JS. So please update them first: Advanced Ads 1.27.0, Advanced Ads Pro 2.13.0, and Advanced Ads Tracking 2.1.0\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:4b82cc7379d46c6272f5d556bb264eec\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724424826;}s:36:\"a4d5c058-9120-47ee-977c-f30f83fb1a75\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:a076fbb79772f497349a76ee74a7f708\";s:5:\"title\";s:52:\"All-in-one Compliance for GDPR / CCPA Cookie Consent\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:13:\"iubenda_cs.js\";i:1;s:8:\"var _iub\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:55:\"iubenda-cookie-law-solution/iubenda_cookie_solution.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"88457e92-0f24-458e-b7b5-bab59074ebef\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"Amelia\";s:9:\"condition\";s:31:\"ameliabooking/ameliabooking.php\";s:10:\"exclusions\";a:2:{i:0;s:41:\"/wp-content/plugins/ameliabooking/(.*).js\";i:1;s:18:\"var hasAmeliaEvent\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:49:\"Display booking options without user interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:93ea6597c3cbd06e93a46b9f5368732d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724425057;}s:36:\"79a5082f-821a-4a4b-a0e3-caaf22cf3f75\";O:8:\"stdClass\":9:{s:5:\"title\";s:17:\"AMO Team Showcase\";s:9:\"condition\";s:39:\"amo-team-showcase/amo-team-showcase.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:40:\"/amo-team-showcase/public/js/wookmark.js\";i:3;s:56:\"/amo-team-showcase/public/js/amo-team-showcase-public.js\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:11:\"amoTeamVars\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:24:\"To display team members.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:9bdceaa1bb89135730a3b2aa4db94c22\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724425072;}s:36:\"90c7fd90-3adf-4cb7-8a92-845bdbd95d27\";O:8:\"stdClass\":9:{s:5:\"title\";s:46:\"Anti-Spam by CleanTalk - Prevent console error\";s:9:\"condition\";s:36:\"cleantalk-spam-protect/cleantalk.php\";s:10:\"exclusions\";a:2:{i:0;s:17:\"ctPublicFunctions\";i:1;s:8:\"ctPublic\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:21:\"Prevent console error\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ed2ade77cd44e21b1703b093c002a903\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724425107;}s:36:\"e054f840-700a-4549-bbba-485473a53f71\";O:8:\"stdClass\":9:{s:5:\"title\";s:39:\"AnWP Football Leagues - Calendar Widget\";s:9:\"condition\";s:53:\"football-leagues-by-anwppro/anwp-football-leagues.php\";s:10:\"exclusions\";a:6:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:33:\"/football-leagues-by-anwppro/(.*)\";i:2;s:49:\"/football-leagues-by-anwppro-premium-premium/(.*)\";i:3;s:16:\"window.AnWPFLPro\";i:4;s:22:\"window.AnWPFLTabulator\";i:5;s:48:\"/elementor/assets/lib/flatpickr/flatpickr.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:26:\"Display FL Calendar Widget\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e7581089f33fdf0a970d5c5deb16ff50\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724425139;}s:36:\"1d058cae-4460-4354-bab3-a96445650bd8\";O:8:\"stdClass\":9:{s:5:\"title\";s:22:\"AnyWhere Elementor Pro\";s:9:\"condition\";s:49:\"anywhere-elementor-pro/anywhere-elementor-pro.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:38:\"/anywhere-elementor-pro/build/index.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:20:\"Make links clickable\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b739df50f3f5bf400075f17dca652517\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724425158;}s:36:\"8a1614c7-55b1-4b6d-88e5-6e8ddc630dae\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:46741e77eaf4d13a0c80be6b86379758\";s:5:\"title\";s:17:\"Astra - Pro Addon\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:32:\"/astra-addon/astra-addon-(.*).js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"astra-addon/astra-addon.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"37d96403-f9ea-4481-b2f8-374d7c93e61a\";O:8:\"stdClass\":9:{s:5:\"title\";s:14:\"Beaver Builder\";s:9:\"condition\";s:42:\"beaver-builder-lite-version/fl-builder.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/uploads/bb-plugin/\";i:3;s:25:\"/bb-plugin/js/yui3.min.js\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:33:\"/bb-plugin/js/fl-slideshow.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:80:\"To show parallax background, slideshow background and some animations instantly.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ccd87807930a1856717fd276c336db9a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427769;}s:36:\"f83dbf3b-783e-4ef9-9b18-8a469ca7102d\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"Bloom\";s:9:\"condition\";s:15:\"bloom/bloom.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:7:\"/bloom/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e57cdfbc09f4e0f7445c279d9f580bdd\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1685189070;}s:36:\"135aadd2-cd4a-44ae-8dcf-801f3f2316c0\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:055ef01accbad6378e3d1a4965600964\";s:5:\"title\";s:6:\"Booked\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:8:\"/booked/\";i:1;s:31:\"/js/jquery/ui/datepicker.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:17:\"booked/booked.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"ddfee9b0-e5a9-4d3f-8c21-b999cbb61c33\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"Bookly\";s:9:\"condition\";s:51:\"bookly-responsive-appointment-booking-tool/main.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:53:\"/bookly-responsive-appointment-booking-tool/frontend/\";i:3;s:13:\"window.bookly\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:38:\"To load the booking form on page load.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:492f9b0d55f3bf07c68e915ea1dfb72a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427886;}s:36:\"7a013fd6-0881-4dbe-8e93-33edefe7f717\";O:8:\"stdClass\":8:{s:5:\"title\";s:14:\"Borlabs Cookie\";s:9:\"condition\";s:33:\"borlabs-cookie/borlabs-cookie.php\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"borlabsCookieConfig\";i:3;s:21:\"borlabs-cookie.min.js\";i:4;s:27:\"borlabsCookieContentBlocker\";i:5;s:16:\"BorlabsCookieBox\";i:6;s:12:\"allFbWidgets\";i:7;s:34:\"/borlabs-cookie/assets/javascript/\";i:8;s:21:\"borlabs-cookie-config\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e1ec2daca513de476bd3dae79366e9ab\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1702497952;}s:36:\"3999e680-4049-4494-945c-768cecc1a2c4\";O:8:\"stdClass\":9:{s:5:\"title\";s:5:\"Brizy\";s:9:\"condition\";s:15:\"brizy/brizy.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:58:\"/brizy/public/editor-build/(.*)-wp/editor/js/group-(.*).js\";i:3;s:55:\"/brizy/public/editor-build/(.*)-wp/editor/js/preview.js\";i:4;s:10:\"Brizy.emit\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:38:\"Prevents partially loading the slider.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:43019d66af7b41e65bb602c01e10c6a0\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428007;}s:36:\"af4d9357-3def-42a1-86b7-419553444b4d\";O:8:\"stdClass\":9:{s:5:\"title\";s:52:\"Carousel Upsells and Related Product for WooCommerce\";s:9:\"condition\";s:91:\"carousel-upsells-and-related-product-for-woocommerce/ffxf-woo-glide-related-and-upsells.php\";s:10:\"exclusions\";a:2:{i:0;s:76:\"/carousel-upsells-and-related-product-for-woocommerce/assets/js/glide.min.js\";i:1;s:22:\"carusel_poduct_related\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:75:\"To load the carousel products with the correct spacing without interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5c317f9f244597d8f236ecb7d8e41752\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428163;}s:36:\"1d866d90-5451-43ba-a4d1-75b64f9235e1\";O:8:\"stdClass\":9:{s:5:\"title\";s:26:\"clickskeks.at Cookiebanner\";s:9:\"condition\";s:20:\"clickskeks/index.php\";s:10:\"exclusions\";a:1:{i:0;s:10:\"clickskeks\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:43:\"Load the cookie banner without interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:0a3a29603ebac8fe0808f64f5c8edbb2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428285;}s:36:\"c09695cc-2387-4416-881a-c0b392188a26\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"Complianz\";s:9:\"condition\";s:33:\"complianz-gdpr/complianz-gpdr.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"complianz\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:a766f95208154cd69a3e15150a42f325\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1685188788;}s:36:\"bfb36984-e2a1-40ba-a8cd-f29b0b6f720f\";O:8:\"stdClass\":8:{s:5:\"title\";s:17:\"Complianz Premium\";s:9:\"condition\";s:49:\"complianz-gdpr-premium/complianz-gpdr-premium.php\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:9:\"complianz\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:89d54385816dd2d5ae92cfda9d95bbfd\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1712163685;}s:36:\"b5e146fc-0b7c-4c6c-a631-8da246d3bd89\";O:8:\"stdClass\":9:{s:5:\"title\";s:36:\"Conerstone Builder - Fix mobile menu\";s:9:\"condition\";s:27:\"cornerstone/cornerstone.php\";s:10:\"exclusions\";a:2:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:46:\"/cornerstone/assets/js/site/cs-classic.(.*).js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:104:\"Fix the issue with the hamburger menu, when Delay JavaScript execution is enabled the menu doesn\'t open.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:f8f8c81535b5e0073aa3c56b6dd3df5b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428497;}s:36:\"368bc394-b74e-4b62-b359-cd967f78c6ea\";O:8:\"stdClass\":9:{s:5:\"title\";s:54:\"ConsentMagic Pro - Show popup without user interaction\";s:9:\"condition\";s:39:\"consent-magic-pro/consent-magic-pro.php\";s:10:\"exclusions\";a:3:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:57:\"/wp-content/plugins/consent-magic-pro/js/cs-public.min.js\";i:2;s:42:\"/wp-content/plugins/pixelyoursite-pro/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:48:\"Load the consent popup without user interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:9e0701a214f49a057f17b00e39df2e7e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428306;}s:36:\"7e551e3b-fbe4-4235-87a9-b476bc9e2020\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"Content Egg\";s:9:\"condition\";s:27:\"content-egg/content-egg.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:42:\"/content-egg/res/js/morrisjs/morris.min.js\";i:3;s:43:\"/content-egg/res/js/morrisjs/raphael.min.js\";i:4;s:11:\"Morris.Area\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:25:\"Show charts on page load.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:949b1b923d51d10a2fb67a2a39d166b3\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428456;}s:36:\"7fbca6c5-9239-4550-a755-6f041f867a57\";O:8:\"stdClass\":9:{s:5:\"title\";s:42:\"Cookie Notice & Compliance for GDPR / CCPA\";s:9:\"condition\";s:31:\"cookie-notice/cookie-notice.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:15:\"/cookie-notice/\";i:3;s:10:\"var cnArgs\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:38:\"Loads the cookie notice on the screen.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:213d0f883ae27aefb3a7937656bbd11e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428382;}s:36:\"26722567-fe35-44b5-a5a7-fb0f3a38c3f2\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"Cookiebot CMP\";s:9:\"condition\";s:23:\"cookiebot/cookiebot.php\";s:10:\"exclusions\";a:1:{i:0;s:21:\"consent.cookiebot.com\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:46:\"Resolves issue with links not being clickable.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1d10ad30bbcf0fd4b26e9625a07abcfc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428418;}s:36:\"1547249a-ce0c-40e4-91f6-148a5f9652d7\";O:8:\"stdClass\":8:{s:5:\"title\";s:34:\"CookieYes Lite - Show on page load\";s:9:\"condition\";s:35:\"cookie-law-info/cookie-law-info.php\";s:10:\"exclusions\";a:1:{i:0;s:47:\"/cookie-law-info/lite/frontend/js/script.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:29d4d4ccd077232b111581043bbd8d81\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1721422981;}s:36:\"74110e36-89e5-440d-bec3-7133da3277c2\";O:8:\"stdClass\":9:{s:5:\"title\";s:23:\"Coupon Referral Program\";s:9:\"condition\";s:51:\"coupon-referral-program/coupon-referral-program.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:25:\"/coupon-referral-program/\";i:3;s:42:\"/wp-includes/js/jquery/ui/draggable.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:133:\"Fixes non-breaking dependency error.\r\n\r\nAlso requires excluding the following from JavaScript deferring:\r\n\r\n/coupon-referral-program/\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:edcf103293ceab711e999d419d038ca1\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428687;}s:36:\"408fa396-20f2-4b1f-820d-52882af281cc\";O:8:\"stdClass\":9:{s:5:\"title\";s:37:\"CozyStay Core - Fix background images\";s:9:\"condition\";s:31:\"cozystay-core/cozystay-core.php\";s:10:\"exclusions\";a:2:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:58:\"/cozystay-core/assets/scripts/front/parallax-bundle.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:32:\"Fixes background images loading.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:872b5eef05c1fc3b00cda07ee966938d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428721;}s:36:\"ed63e02f-d6c5-481a-bcb9-aae15f72aa21\";O:8:\"stdClass\":9:{s:5:\"title\";s:29:\"Crisp - Live Chat and Chatbot\";s:9:\"condition\";s:15:\"crisp/crisp.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:20:\"CRISP_RUNTIME_CONFIG\";i:3;s:4:\"l.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:36:\"Allow the chat icon to be displayed.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:c3e26264dcfd25802805b4fd1a2a449c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428819;}s:36:\"a8eb622b-279c-4f84-86e0-785e9497add7\";O:8:\"stdClass\":9:{s:5:\"title\";s:24:\"Custom Twitter Feeds pro\";s:9:\"condition\";s:48:\"custom-twitter-feeds-pro/custom-twitter-feed.php\";s:10:\"exclusions\";a:1:{i:0;s:47:\"/custom-twitter-feeds-pro/js/ctf-scripts.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:48:\"Allow Twitter feed pro to display a Twitter feed\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:6e4bf949e12f0bebfefb48f6c316102a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428839;}s:36:\"1624ef15-e25b-406d-bdf9-d4b78d7a59e7\";O:8:\"stdClass\":8:{s:5:\"title\";s:39:\"Customer Reviews for WooCommerce Plugin\";s:9:\"condition\";s:38:\"customer-reviews-woocommerce/ivole.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:43:\"/customer-reviews-woocommerce/js/colcade.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1f893b343e72ce55e6c9013fbda172fa\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704734788;}s:36:\"b0614843-afed-4377-9d8d-e869221be331\";O:8:\"stdClass\":8:{s:5:\"title\";s:15:\"Depicter Slider\";s:9:\"condition\";s:21:\"depicter/depicter.php\";s:10:\"exclusions\";a:1:{i:0;s:10:\"/depicter/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:77c42a041f1c40d128f4bb3714a6d20d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1713878881;}s:36:\"396cc03a-8946-4ee8-ab15-7e48261df79a\";O:8:\"stdClass\":8:{s:5:\"title\";s:26:\"Divi - Carousel Module 2.0\";s:9:\"condition\";s:16:\"dg-divi-carousel\";s:10:\"exclusions\";a:2:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:37:\"/wp-content/plugins/dg-divi-carousel/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:fcd789b7d02699f89720aa5ff3627912\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1709126476;}s:36:\"c15fe3b3-0eaa-48f9-bf04-0e778b1f8c63\";O:8:\"stdClass\":8:{s:5:\"title\";s:14:\"Divi - Supreme\";s:9:\"condition\";s:53:\"supreme-modules-for-divi/supreme-modules-for-divi.php\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\".dipi_preloader_wrapper_outer\";i:3;s:23:\"/Divi/js/scripts.min.js\";i:4;s:26:\"/Divi/js/custom.unified.js\";i:5;s:21:\"/js/magnific-popup.js\";i:6;s:8:\"var DIVI\";i:7;s:26:\"/supreme-modules-for-divi/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b5489ae4d8b949f536d6dd2e5b0c1a95\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738701;}s:36:\"dd31451b-989a-4517-b02a-e2c2e2023366\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"Divi Den Pro\";s:9:\"condition\";s:15:\"ddpro/ddpro.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:54:\"/ddpro/build/freddie/js/freddieScriptPageTransition.js\";i:3;s:48:\"/ddpro/build/freddie/js/freddieScriptsHeaders.js\";i:4;s:49:\"/ddpro/build/freddie/js/freddieScriptsContents.js\";i:5;s:40:\"/ddpro/build/freddie/js/gsap/gsap.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:55:\"Fires animations and content created with Divi Den Pro.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5caed322df984bbfd3ecb506cf12b688\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429225;}s:36:\"2b006370-cc90-42c1-9656-a30fbfbc91c6\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"Divi Mobile\";s:9:\"condition\";s:27:\"divi-mobile/divi-mobile.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"divi-menu\";i:3;s:6:\"dm_nav\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:46:\"Avoid double click when using the mobile menu.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:402d9b241b04934dd30f32e7ba490e63\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429325;}s:36:\"666bbed9-7ce3-457c-ad6e-b5e056d05010\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"Divi Overlays\";s:9:\"condition\";s:31:\"divi-overlays/divi-overlays.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\".dipi_preloader_wrapper_outer\";i:3;s:23:\"/Divi/js/scripts.min.js\";i:4;s:26:\"/Divi/js/custom.unified.js\";i:5;s:8:\"var DIVI\";i:6;s:15:\"/divi-overlays/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:39:\"Enable modals to be displayed on screen\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1c828c93d87298d2a27c76e13d0880ba\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429242;}s:36:\"42a404af-7792-44be-9baa-565dc3baf25d\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"Divi Pixel\";s:9:\"condition\";s:25:\"divi-pixel/divi-pixel.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\".dipi_preloader_wrapper_outer\";i:3;s:43:\"/divi-pixel/dist/public/js/hamburger.min.js\";i:4;s:42:\"/divi-pixel/dist/vendor/js/easypiechart.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:14:\"Page Preloader\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:dd2494945a487a6cc74d3ab1b2137ccb\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429347;}s:36:\"85f5c099-c481-4c38-bbb9-8b76113bdfd5\";O:8:\"stdClass\":9:{s:5:\"title\";s:16:\"Divi Supreme Pro\";s:9:\"condition\";s:61:\"supreme-modules-pro-for-divi/supreme-modules-pro-for-divi.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:17:\"elm.style.display\";i:3;s:76:\"/supreme-modules-pro-for-divi/includes/modules/ImageCarousel/frontend.min.js\";i:4;s:60:\"/supreme-modules-pro-for-divi/public/js/swiper-bundle.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:42:\"Avoid white screen before user interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3d5f0ae7751702fd1bb490fcf991a334\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429378;}s:36:\"0b78d762-c7be-45de-9aae-0c5078ec0619\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:b5fc0101608d0b0627268dc49e3e1f8f\";s:5:\"title\";s:12:\"Divi Toolbox\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:20:\"jQuery(\'.preloader\')\";i:3;s:42:\"/divi-toolbox/assets/js/toolbox-scripts.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:29:\"divi-toolbox/divi-toolbox.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"31a34440-1383-40c4-8920-effcf99f2165\";O:8:\"stdClass\":9:{s:5:\"title\";s:17:\"Dracula Dark Mode\";s:9:\"condition\";s:36:\"dracula-dark-mode-premium/plugin.php\";s:10:\"exclusions\";a:9:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:68:\"/wp-content/plugins/dracula-dark-mode-premium/assets/js/dark-mode.js\";i:2;s:67:\"/wp-content/plugins/dracula-dark-mode-premium/assets/js/frontend.js\";i:3;s:44:\"/wp-includes/js/dist/vendor/react-dom.min.js\";i:4;s:40:\"/wp-includes/js/dist/vendor/react.min.js\";i:5;s:37:\"/wp-includes/js/dist/api-fetch.min.js\";i:6;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:7;s:32:\"/wp-includes/js/dist/i18n.min.js\";i:8;s:15:\"draculaDarkMode\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:90:\"Show dark mode toggle button and apply styles without need for user interaction with page.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5e8a5d8d3830136d84d0f3676f1bf5a5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429514;}s:36:\"8baba0f8-4449-47d8-a87d-9b6a116e7684\";O:8:\"stdClass\":8:{s:5:\"title\";s:48:\"Dynamic Pricing & Discounts Lite for WooCommerce\";s:9:\"condition\";s:85:\"woo-dynamic-pricing-discounts-lite/dynamic-pricing-discounts-lite-for-woocommerce.php\";s:10:\"exclusions\";a:3:{i:0;s:79:\"/woo-dynamic-pricing-discounts-lite/assets/OwlCarousel/dist/owl.carousel.min.js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:185062bf08db42515488e1853d1f4917\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677857247;}s:36:\"0fa129f2-5869-4db7-9bf0-69e4b3549ee2\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:27478327aa44075a86176fad95640d76\";s:5:\"title\";s:39:\"Dynamic Product Gallery for WooCommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\"/woocommerce-dynamic-gallery/\";i:3;s:21:\"a3revWCDynamicGallery\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:62:\"woocommerce-dynamic-gallery/wc_dynamic_gallery_woocommerce.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"9958c6be-2f67-4791-95c3-a7ad96d599c0\";O:8:\"stdClass\":9:{s:5:\"title\";s:47:\"Dynamic Product Gallery Premium for WooCommerce\";s:9:\"condition\";s:66:\"woocommerce-dynamic-gallery-pro/wc_dynamic_gallery_woocommerce.php\";s:10:\"exclusions\";a:5:{i:0;s:55:\"/jquery-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:1;s:55:\"/jquery-migrate(.*)(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:2;s:74:\"/woocommerce-dynamic-gallery-pro/assets/js/mygallery/jquery.a3-dgallery.js\";i:3;s:18:\"settings_defaults_\";i:4;s:21:\"a3revWCDynamicGallery\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:50:\"Load the gallery content without user interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:11dc02a76019f00422f4ac85f47f5135\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429541;}s:36:\"ce26ed21-1be5-481f-80d4-31edfac6d890\";O:8:\"stdClass\":9:{s:5:\"title\";s:43:\"Dynamic.ooo - Dynamic Content for Elementor\";s:9:\"condition\";s:63:\"dynamic-content-for-elementor/dynamic-content-for-elementor.php\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:26:\"ElementorProFrontendConfig\";i:6;s:23:\"elementorFrontendConfig\";i:7;s:38:\"/dynamic-content-for-elementor/assets/\";i:8;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:9;s:32:\"/wp-includes/js/dist/i18n.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:20:\"Show dynamic content\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:d2bd5b348abe016bdc722acce7755062\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429557;}s:36:\"6a3161a6-1a6f-457a-a9ee-54b376981927\";O:8:\"stdClass\":9:{s:5:\"title\";s:22:\"Easy Table of Contents\";s:9:\"condition\";s:49:\"easy-table-of-contents/easy-table-of-contents.php\";s:10:\"exclusions\";a:1:{i:0;s:46:\"/easy-table-of-contents/assets/js/front.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:69:\"Avoid the Easy Table of Contents to briefly open when the page loads.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ee1dec033c6481a77fe88de5bef1a02d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429629;}s:36:\"25a534a0-2c1f-4cf4-9e19-7941bc032b3a\";O:8:\"stdClass\":8:{s:5:\"title\";s:29:\"Ecwid Ecommerce Shopping Cart\";s:9:\"condition\";s:43:\"ecwid-shopping-cart/ecwid-shopping-cart.php\";s:10:\"exclusions\";a:11:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:23:\"app.ecwid.com/script.js\";i:3;s:35:\"/ecwid-shopping-cart/js/frontend.js\";i:4;s:38:\"/ecwid-shopping-cart/js/static-page.js\";i:5;s:20:\"ecwidParamswindow.ec\";i:6;s:13:\"jQuery.mobile\";i:7;s:7:\"xSearch\";i:8;s:13:\"xCategoriesV2\";i:9;s:15:\"xProductBrowser\";i:10;s:10:\"Ecwid.init\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:41c8f5f0ab00cb39654aedd783d194e0\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704734846;}s:36:\"a0d681db-991a-4220-8f05-c54a4857aa42\";O:8:\"stdClass\":9:{s:5:\"title\";s:16:\"Element Pack Pro\";s:9:\"condition\";s:47:\"bdthemes-element-pack/bdthemes-element-pack.php\";s:10:\"exclusions\";a:10:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:66:\"/bdthemes-element-pack/assets/js/modules/ep-static-carousel.min.js\";i:2;s:66:\"/bdthemes-element-pack/assets/js/modules/ep-custom-carousel.min.js\";i:3;s:60:\"/bdthemes-element-pack/assets/js/modules/ep-slideshow.min.js\";i:4;s:67:\"/bdthemes-element-pack/assets/js/modules/ep-product-carousel.min.js\";i:5;s:58:\"/bdthemes-element-pack/assets/js/modules/ep-stacker.min.js\";i:6;s:49:\"/bdthemes-element-pack/assets/js/bdt-uikit.min.js\";i:7;s:53:\"/bdthemes-element-pack/assets/js/common/helper.min.js\";i:8;s:60:\"/bdthemes-element-pack/assets/vendor/js/ScrollTrigger.min.js\";i:9;s:51:\"/bdthemes-element-pack/assets/vendor/js/gsap.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:46:\"Fix issues with gallery and product carousels.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ced76c4da718a667537dc6c9d5e0244d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429901;}s:36:\"40464325-5bae-4a20-bc97-553499e09a73\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"Elementor\";s:9:\"condition\";s:23:\"elementor/elementor.php\";s:10:\"exclusions\";a:13:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:26:\"ElementorProFrontendConfig\";i:6;s:23:\"elementorFrontendConfig\";i:7;s:28:\"/happy-elementor-addons-pro/\";i:8;s:43:\"/header-footer-elementor/inc/js/frontend.js\";i:9;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:10;s:37:\"/wp-includes/js/dist/api-fetch.min.js\";i:11;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:12;s:32:\"/wp-includes/js/dist/i18n.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1d15783218a3137bec4ee8df5353e218\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1694425872;}s:36:\"ac86b64c-c80a-4053-894d-6caa8b4fdce8\";O:8:\"stdClass\":8:{s:5:\"title\";s:25:\"Elementor  Loop Carrousel\";s:9:\"condition\";s:23:\"elementor/elementor.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:3;s:37:\"/wp-includes/js/dist/api-fetch.min.js\";i:4;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:5;s:32:\"/wp-includes/js/dist/i18n.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:0eb8d0bbd1c7ca05ac133ea634f676b7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1694442056;}s:36:\"a8fc9fd1-f6d3-41eb-abe9-ef176de6d7e2\";O:8:\"stdClass\":9:{s:5:\"title\";s:39:\"Elementor - Lazy Load Background Images\";s:9:\"condition\";s:23:\"elementor/elementor.php\";s:10:\"exclusions\";a:1:{i:0;s:19:\"lazyloadRunObserver\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:48:\"Start background images so they load immediately\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:bf248cb2876558452a566c5dd89262b8\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724430300;}s:36:\"1948aff5-7850-4979-91fa-0ce181484508\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"Elementor Custom Skin\";s:9:\"condition\";s:35:\"ele-custom-skin/ele-custom-skin.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:31:\"/ele-custom-skin(.*)/assets/js/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:55:\"Fixes console error when Elementor scripts are excluded\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:de658ae6c2d05a5a4a947efecf5e0c16\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429916;}s:36:\"25708299-c596-4416-8ad8-740aee0f2752\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"Elementor Pro\";s:9:\"condition\";s:31:\"elementor-pro/elementor-pro.php\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:26:\"ElementorProFrontendConfig\";i:6;s:23:\"elementorFrontendConfig\";i:7;s:28:\"/happy-elementor-addons-pro/\";i:8;s:43:\"/header-footer-elementor/inc/js/frontend.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:336:\"Show elements, galleries, and start animations. \r\n\r\nWhen User Cache is active the following exclusions will resolve console errors:\r\n\r\n/wp-includes/js/underscore.min.js\r\n/wp-includes/js/jquery/ui/core.min.js\r\n/wp-includes/js/backbone.min.js\r\nelementorAdminBarConfig\r\nelementorCommonConfig\r\nelementorWebCliConfig\r\nelementorDevToolsConfig\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:030ad23e3851ed7adfa7b9b6c13cf5a6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724430189;}s:36:\"f34dd874-4b34-41e6-a31c-ece3c1efbffc\";O:8:\"stdClass\":9:{s:5:\"title\";s:26:\"Elementor Pro - SmartMenus\";s:9:\"condition\";s:31:\"elementor-pro/elementor-pro.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:61:\"/elementor-pro/assets/lib/smartmenus/jquery.smartmenus.min.js\";i:3;s:59:\"/elementor-pro/assets/js/preloaded-elements-handlers.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:21:\"Fixes the mobile menu\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:305581ad4294a30eeb1247982f626005\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724430219;}s:36:\"111cc8b2-0be9-438b-9aa3-7f1e301a5697\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5ae9f5d99224d5ebc7d0c0bbf5b99787\";s:5:\"title\";s:26:\"Elementor Pro - User Cache\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:7:{i:0;s:33:\"/wp-includes/js/underscore.min.js\";i:1;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:2;s:31:\"/wp-includes/js/backbone.min.js\";i:3;s:23:\"elementorAdminBarConfig\";i:4;s:21:\"elementorCommonConfig\";i:5;s:21:\"elementorWebCliConfig\";i:6;s:23:\"elementorDevToolsConfig\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:31:\"elementor-pro/elementor-pro.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"c1713bf8-e0c3-4cb5-8b3f-841b06aa87ed\";O:8:\"stdClass\":8:{s:5:\"title\";s:27:\"ElementsKit Lite - Megamenu\";s:9:\"condition\";s:37:\"elementskit-lite/elementskit-lite.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:17:\"/elementskit(.*)/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b91fed2fc4478dbb7067742c1ee4691b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1683270249;}s:36:\"236c2a9e-9668-4a80-9b66-d2222d812dd6\";O:8:\"stdClass\":9:{s:5:\"title\";s:18:\"Elfsight Slider CC\";s:9:\"condition\";s:41:\"elfsight-slider-cc/elfsight-slider-cc.php\";s:10:\"exclusions\";a:1:{i:0;s:45:\"/elfsight-slider-cc/assets/elfsight-slider.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:27:\"Load slider on page loading\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b0e259c84df5e120d6113dd0eef9da4b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724430233;}s:36:\"706ff35d-8e33-4b04-a986-346faff704e9\";O:8:\"stdClass\":9:{s:5:\"title\";s:30:\"Essential Addons for Elementor\";s:9:\"condition\";s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:55:\"/essential-addons(-for)?-elementor(-lite)?/.*(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:31:\"Start the carousel on page load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:417192424139d89fb2a5b1ee1f2b9613\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724430272;}s:36:\"b38556dc-2bc4-430f-9c55-7191cf7773db\";O:8:\"stdClass\":9:{s:5:\"title\";s:34:\"Essential Addons for Elementor Pro\";s:9:\"condition\";s:56:\"essential-addons-elementor/essential_adons_elementor.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:55:\"/essential-addons(-for)?-elementor(-lite)?/.*(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:31:\"Start the carousel on page load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:057757d0593ad9d2dc58124f0077a5df\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724430280;}s:36:\"719b988f-0d60-40c2-ba46-88f943119cb1\";O:8:\"stdClass\":9:{s:5:\"title\";s:14:\"Essential Grid\";s:9:\"condition\";s:33:\"essential-grid/essential-grid.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:16:\"/essential-grid/\";i:3;s:15:\"lightboxOptions\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:30:\"Load grid without interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:c8e6c490f6438f566ade600c33531a85\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724430960;}s:36:\"47d3d2ab-160d-4b07-ac25-8250b9e6a951\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"EventON Lite\";s:9:\"condition\";s:24:\"eventon-lite/eventon.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:28:\"/eventon-lite/assets/js/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:37:\"Load the events calendar on page load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:dafd19fa48a1fef890dc4348052fcb75\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724430313;}s:36:\"219968d7-cf1f-4ee0-917a-db35dcc93a3e\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:49ff465628fc3cb6d7f23ff81d9b8339\";s:5:\"title\";s:7:\"FacetWP\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:36:\"/facetwp/assets/js/dist/front.min.js\";i:1;s:11:\"window.FWP_\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:17:\"facetwp/index.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"acce5701-5917-48d5-83ab-3e626aa420c5\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:78a1c88a56fa957c802074b6418c6fac\";s:5:\"title\";s:21:\"FacetWP - Flyout menu\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:34:\"/facetwp-flyout/assets/js/front.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:33:\"facetwp-flyout/facetwp-flyout.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"081461cf-dbd0-42f3-9557-10cdc16cf145\";O:8:\"stdClass\":9:{s:5:\"title\";s:19:\"FiboFilters Premium\";s:9:\"condition\";s:31:\"fibofilters-pro/fibofilters.php\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:41:\"/fibofilters-pro/build/front-pro/front.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:49:\"Display filter without need for user interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:d9f62725f1470d35c3f220645bc2e473\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431277;}s:36:\"f2a5b95f-1a22-46d2-8b72-42a53e46ae3f\";O:8:\"stdClass\":9:{s:5:\"title\";s:40:\"FiboSearch - Ajax Search for WooCommerce\";s:9:\"condition\";s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";s:10:\"exclusions\";a:3:{i:0;s:32:\"/wp-includes/js/jquery/jquery.js\";i:1;s:40:\"/wp-includes/js/jquery/jquery-migrate.js\";i:2;s:56:\"/ajax-search-for-woocommerce-premium/assets/js/search.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:77:\"Avoid search modals moving to the top when adding keyword in the input field.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5d7555892a3a9968fde3fa3a335fc3d8\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431295;}s:36:\"7d1404e9-be76-449c-87aa-919557abe82d\";O:8:\"stdClass\":9:{s:5:\"title\";s:9:\"FlexBlock\";s:9:\"condition\";s:37:\"flo-flex-builder/flo-flex-builder.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:41:\"/flo-flex-builder/dist/flex-public.min.js\";i:2;s:9:\"flexDebug\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:44:\"Fire animations and show images on pageload.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ad46179e8b0584abaf52056b846da227\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431336;}s:36:\"b9c6a2dc-b226-4e2c-b85e-29ee55b8f751\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"Fluent Forms\";s:9:\"condition\";s:25:\"fluentform/fluentform.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:29:\"/fluentform/public/js/(.*).js\";i:2;s:32:\"/fluentformpro/public/js/(.*).js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:89:\"Fixes files upload field.\r\n\r\n*Requires exlcuding jQuery from JavaScript deferring as well\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:567a2b15db30ef6bd4904e4317139aac\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431366;}s:36:\"10874f8a-2855-4e80-bc46-e484589b76a8\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"Flying Images\";s:9:\"condition\";s:27:\"nazy-load/flying-images.php\";s:10:\"exclusions\";a:1:{i:0;s:12:\"flyingImages\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:61:\"Fixes images not being loaded until there is user interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e78c153103f698b2b34892332d6b3b62\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431386;}s:36:\"53958499-dacd-41d6-93bc-1534fe7d9eda\";O:8:\"stdClass\":9:{s:5:\"title\";s:18:\"FooGallery Premium\";s:9:\"condition\";s:33:\"foogallery-premium/foogallery.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:57:\"/plugins/foobox-image-lightbox/free/js/foobox.free.min.js\";i:3;s:88:\"/plugins/foogallery-premium/pro/extensions/default-templates/shared/js/foogallery.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:48:\"Prevents delay in the loading of product images.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5a0e40a6c5783856893b803189de1404\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431261;}s:36:\"7870d704-2024-4622-838c-fad37d5c6753\";O:8:\"stdClass\":9:{s:5:\"title\";s:16:\"Formidable Forms\";s:9:\"condition\";s:25:\"formidable/formidable.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:7:\"frmSigs\";i:3;s:45:\"/formidable-signature/js/frm.signature.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:76:\"Prevent the delay of the function and the file that processes the signature.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ebb5efb57b19ae60e734e456ca2df3f8\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431311;}s:36:\"3f24f9b3-e59e-400f-a784-999f93f60fab\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"Forminator\";s:9:\"condition\";s:25:\"forminator/forminator.php\";s:10:\"exclusions\";a:9:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:15:\"forminatorFront\";i:3;s:42:\"/forminator/build/front/front.multi.min.js\";i:4;s:52:\"/forminator/assets/js/library/jquery.validate.min.js\";i:5;s:58:\"/forminator/assets/forminator-ui/js/forminator-form.min.js\";i:6;s:55:\"/forminator/assets/forminator-ui/js/select2.full.min.js\";i:7;s:43:\"/wp-includes/js/jquery/ui/datepicker.min.js\";i:8;s:41:\"/wp-includes/js/dist/vendor/moment.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:32:\"Display form without interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:0b08523445b8869a67ca40e777704692\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431402;}s:36:\"3a600ded-3454-48fb-9811-46afa2ab3c05\";O:8:\"stdClass\":9:{s:5:\"title\";s:22:\"GDPR Cookie Compliance\";s:9:\"condition\";s:37:\"gdpr-cookie-compliance/moove-gdpr.php\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:44:\"/gdpr-cookie-compliance/dist/scripts/main.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:37:\"Show the consent banner on page load.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5759bf0d47ac3457485314b381a9b528\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431440;}s:36:\"e21aaa5e-7354-471d-ab86-85f99f48830c\";O:8:\"stdClass\":9:{s:5:\"title\";s:19:\"GDPR Cookie Consent\";s:9:\"condition\";s:49:\"webtoffee-gdpr-cookie-consent/cookie-law-info.php\";s:10:\"exclusions\";a:4:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:36:\"/public/js/cookie-law-info-public.js\";i:3;s:8:\"Cli_Data\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:37:\"Show the consent banner on page load.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ffb40036ab0583218561de7c28c6bd9b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431421;}s:36:\"1f8bdec1-9c4c-4080-8ac0-5f8b49967047\";O:8:\"stdClass\":9:{s:5:\"title\";s:28:\"GetPaid - Fix console errors\";s:9:\"condition\";s:23:\"invoicing/invoicing.php\";s:10:\"exclusions\";a:3:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:64:\"/invoicing/vendor/ayecode/wp-ayecode-ui/assets/js/select2.min.js\";i:2;s:73:\"/invoicing/vendor/ayecode/wp-ayecode-ui/assets/js/bootstrap.bundle.min.js\";}s:7:\"summary\";s:58:\"It fixes some errors with jQuery in the browser\'s console.\";s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:6756935a144cf0a74b252db5f8229ee9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1728404861;}s:36:\"c11ca4ea-1a23-49ee-9a6b-1e549de50ea2\";O:8:\"stdClass\":9:{s:5:\"title\";s:25:\"Getwid - Gutenberg Blocks\";s:9:\"condition\";s:17:\"getwid/getwid.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:37:\"/wp-includes/js/jquery/ui/tabs.min.js\";i:3;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:67:\"Fixes tabs when jQuery is excluded from Delay JavaScript Execution.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3877953c5ec1e66db92ad844ae8ebafc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431639;}s:36:\"79b33eb9-bc92-4d8a-afd8-1c61e70bed8f\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"GiveWP\";s:9:\"condition\";s:13:\"give/give.php\";s:10:\"exclusions\";a:5:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:28:\"/give/assets/dist/js/give.js\";i:2;s:37:\"/wp-includes/js/dist/api-fetch.min.js\";i:3;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:4;s:32:\"/wp-includes/js/dist/i18n.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:21:\"Closes the preloader.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:0fb3af06fc5c710a670220b054c292c5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431653;}s:36:\"3773bb33-b168-4f68-9963-512da24ac4da\";O:8:\"stdClass\":8:{s:5:\"title\";s:15:\"GoodLayers Core\";s:9:\"condition\";s:35:\"goodlayers-core/goodlayers-core.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:34:\"/goodlayers-core/plugins/script.js\";i:3;s:43:\"/goodlayers-core/include/js/page-builder.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5f124509a56ca2e0644246919ec70434\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704734904;}s:36:\"2adabe9b-6e03-4a67-959f-492813d40f69\";O:8:\"stdClass\":9:{s:5:\"title\";s:38:\"Google Tag Manager for WooCommerce PRO\";s:9:\"condition\";s:47:\"gtm-ecommerce-woo-pro/gtm-ecommerce-woo-pro.php\";s:10:\"exclusions\";a:1:{i:0;s:54:\"/gtm-ecommerce-woo-pro/assets/gtm-ecommerce-woo-pro.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:26:\"Fire tracker on page load.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e54fd4313007b6fedf8ab4df0e05277a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431759;}s:36:\"7bf261ac-89d4-492f-8a3d-1c5809b9579a\";O:8:\"stdClass\":8:{s:5:\"title\";s:13:\"Gravity Forms\";s:9:\"condition\";s:29:\"gravityforms/gravityforms.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:14:\"/gravityforms/\";i:2;s:5:\"gform\";i:3;s:9:\"recaptcha\";i:4;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:5;s:40:\"/wp-includes/js/plupload/plupload.min.js\";i:6;s:37:\"/wp-includes/js/plupload/moxie.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:7a1c1606d094f6bff83c0ee155908367\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1694457903;}s:36:\"fbaf4a19-f675-441a-b75c-7fd748a59827\";O:8:\"stdClass\":9:{s:5:\"title\";s:30:\"Gravity Forms Page Transitions\";s:9:\"condition\";s:43:\"gp-page-transitions/gp-page-transitions.php\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:32:\"/plugins/gp-page-transitions/js/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:96:\"To load the form without interaction - Gravity Forms one-click exclusion should also be checked.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:53ef8d0ee1f9fdf0bbf87676e449eef5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432081;}s:36:\"12340193-5c35-4b0d-b0bc-bea690cf1cae\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"Green Forms\";s:9:\"condition\";s:27:\"green-forms/green-forms.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:13:\"leform.min.js\";i:2;s:24:\"leform_customjs_handlers\";i:3;s:15:\"leform_ajax_url\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:28:\"Load forms without any delay\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:2f3112dd98c39aeb6bde618c9026a29f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432097;}s:36:\"4d20b427-47cf-4cdf-91c7-ff53602d3b2a\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:0eb769dddc58f998e913345841b1d0b3\";s:5:\"title\";s:6:\"GTM4WP\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:9:\"dataLayer\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:81:\"duracelltomi-google-tag-manager/duracelltomi-google-tag-manager-for-wordpress.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"a2b3c237-728c-49d6-882a-e3885444e9b4\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"GTranslate\";s:9:\"condition\";s:25:\"gtranslate/gtranslate.php\";s:10:\"exclusions\";a:2:{i:0;s:20:\"translate.google.com\";i:1;s:26:\"googleTranslateElementInit\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:68:\"To enable immediate translation on the page without user interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3b085ccda851ccf129d9506462f0cd65\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432146;}s:36:\"79dfc946-6b96-4b6d-bcaf-8cae6330581a\";O:8:\"stdClass\":9:{s:5:\"title\";s:48:\"GTranslate - Show language switcher on page load\";s:9:\"condition\";s:25:\"gtranslate/gtranslate.php\";s:10:\"exclusions\";a:2:{i:0;s:25:\"window.gtranslateSettings\";i:1;s:40:\"/wp-content/plugins/gtranslate/js/dwf.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:39:\"To show language switcher on page load.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:0aedfaa0f543c47c4b0fcf57307c6691\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432128;}s:36:\"40cd9336-e73f-4a61-a7f6-27ec1ca6892c\";O:8:\"stdClass\":9:{s:5:\"title\";s:5:\"HBook\";s:9:\"condition\";s:15:\"hbook/hbook.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:7:\"/hbook/\";i:3;s:20:\"hb_booking_form_data\";i:4;s:11:\"hb_max_date\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:29:\"Render the form on page load.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e1f17c1eac230219e6fec3ac07406a0d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432162;}s:36:\"192224c7-df72-4e3d-8f13-3206ac5b2e90\";O:8:\"stdClass\":9:{s:5:\"title\";s:37:\"Helper - OpenAI Chatbot for WordPress\";s:9:\"condition\";s:17:\"/helper/index.php\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:24:\"/helper/js/helper.min.js\";i:2;s:9:\"mdpHelper\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:53:\"Allow for chatbot icon load without user interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:07311d992a8a9d6af91e4766d2cb9ac9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433592;}s:36:\"99cfbb2e-5678-42c2-928f-5cb09d7e43da\";O:8:\"stdClass\":9:{s:5:\"title\";s:39:\"HUSKY - Products Filter for WooCommerce\";s:9:\"condition\";s:37:\"woocommerce-products-filter/index.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:33:\"/woocommerce-products-filter/(.*)\";i:3;s:4:\"woof\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:60:\"Avoid console error (no impact on the functionality of WOOF)\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:269c5766fba124a838ac012a4b5a1a13\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432177;}s:36:\"3a964eac-4aeb-49a7-9fd6-4c31b2645dee\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:d457acfec0f86aac6733f1446f4fc94f\";s:5:\"title\";s:18:\"Instagram Feed Pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:41:\"/instagram-feed-pro/js/sbi-scripts.min.js\";i:3;s:23:\"sb_instagram_js_options\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:37:\"instagram-feed-pro/instagram-feed.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"8f9f4788-1b8d-468b-b291-1fcbd48618b9\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:513b0c0ec8e12130af9b4bbbb17d7275\";s:5:\"title\";s:20:\"Interactive Geo Maps\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:66:\"/interactive-geo-maps-premium/assets/public/map-service/app.min.js\";i:3;s:54:\"/interactive-geo-maps/assets/public/map-service/app.js\";i:4;s:9:\"iMapsData\";i:5;s:21:\"cdn.amcharts.com/lib/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:45:\"interactive-geo-maps/interactive-geo-maps.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"cf650ca3-afa0-4a13-9e4f-f7cca19abac6\";O:8:\"stdClass\":8:{s:5:\"title\";s:12:\"Ivory Search\";s:9:\"condition\";s:41:\"add-search-to-menu/add-search-to-menu.php\";s:10:\"exclusions\";a:2:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:49:\"/add-search-to-menu/public/js/ivory-search.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:7430e9d2c985ae0a3339a7b7e1acc318\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677852711;}s:36:\"17a5dd54-1f5e-4d57-a56d-a8a970651954\";O:8:\"stdClass\":9:{s:5:\"title\";s:9:\"JetBlocks\";s:9:\"condition\";s:25:\"jet-blocks/jet-blocks.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:39:\"/jet-blocks/assets/js/jet-blocks.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:68:\"Enable dropdown on hover on the Cart and enable Mobile Sticky Header\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1c8a1e1ba89a601f88654f094139b469\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432217;}s:36:\"b6f78c90-9823-459a-8dc1-1257e5f0d4e3\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"JetBlog\";s:9:\"condition\";s:21:\"jet-blog/jet-blog.php\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:15:\"/elementor-pro/\";i:3;s:11:\"/elementor/\";i:4;s:10:\"/jet-blog/\";i:5;s:26:\"ElementorProFrontendConfig\";i:6;s:23:\"elementorFrontendConfig\";i:7;s:18:\"hasJetBlogPlaylist\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:74:\"News ticker to work on pageload (in addition to any other Jet exclusions).\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:dac9ec782180f33d0fcc7c4e0e569b9d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432242;}s:36:\"e17173d8-6ef8-4e27-ba0f-379c9aea7eda\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"JetElements\";s:9:\"condition\";s:29:\"jet-elements/jet-elements.php\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:14:\"/jet-elements/\";i:7;s:18:\"hasJetBlogPlaylist\";i:8;s:11:\"jetElements\";i:9;s:26:\"/wp-includes/js/jquery/ui/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:30:\"Load JetElements on page load.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:0fe8895d1da5247b73a5d0b482df4ac4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432253;}s:36:\"cfd77501-9c9e-4f11-b994-0178a592fc08\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"JetEngine\";s:9:\"condition\";s:25:\"jet-engine/jet-engine.php\";s:10:\"exclusions\";a:1:{i:0;s:12:\"/jet-engine/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:bc998e71546860c8c7f70c45a6c18972\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1686208296;}s:36:\"f320c661-4a2b-4299-bada-110f9e931e3c\";O:8:\"stdClass\":9:{s:5:\"title\";s:41:\"JetFormBuilder - Load without interaction\";s:9:\"condition\";s:35:\"jetformbuilder/jet-form-builder.php\";s:10:\"exclusions\";a:11:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:16:\"/jetformbuilder/\";i:2;s:26:\"var JetFormBuilderSettings\";i:3;s:32:\"/wp-includes/js/dist/i18n.min.js\";i:4;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:5;s:27:\"/jet-plugins/jet-plugins.js\";i:6;s:11:\"/elementor/\";i:7;s:15:\"/elementor-pro/\";i:8;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:9;s:26:\"ElementorProFrontendConfig\";i:10;s:23:\"elementorFrontendConfig\";}s:7:\"summary\";s:75:\"The form is loaded without interaction, and styles are applied immediately.\";s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5ad00a39ed79f888daca19429bc59989\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1730300985;}s:36:\"36fed829-a2d9-41b5-94f6-2c3b9f07a94e\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"JetMenu\";s:9:\"condition\";s:21:\"jet-menu/jet-menu.php\";s:10:\"exclusions\";a:13:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:15:\"/elementor-pro/\";i:3;s:11:\"/elementor/\";i:4;s:42:\"/jet-blog/assets/js/lib/slick/slick.min.js\";i:5;s:14:\"/jet-elements/\";i:6;s:10:\"/jet-menu/\";i:7;s:23:\"elementorFrontendConfig\";i:8;s:26:\"ElementorProFrontendConfig\";i:9;s:18:\"hasJetBlogPlaylist\";i:10;s:17:\"JetEngineSettings\";i:11;s:21:\"jetMenuPublicSettings\";i:12;s:37:\"/jet-reviews/assets/js/lib/vue.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:33:\"Mobile menu to show on page load.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:433a3173f2d06f7d02c7b91c06ed215d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432268;}s:36:\"580cfed7-f034-4e39-bc7a-cdd01923ce87\";O:8:\"stdClass\":9:{s:5:\"title\";s:8:\"JetPopup\";s:9:\"condition\";s:23:\"jet-popup/jet-popup.php\";s:10:\"exclusions\";a:4:{i:0;s:46:\"/jet-popup/assets/js/lib/anime-js/anime.min.js\";i:1;s:42:\"/jet-popup/assets/js/jet-popup-frontend.js\";i:2;s:17:\"/jet-woo-builder/\";i:3;s:16:\"var jetPopupData\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:18:\"To show the pop up\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:51714cfdb43f231a1c93e7cffb1007ab\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432311;}s:36:\"d9cd2730-12e2-42d7-a082-6f0efcd466cc\";O:8:\"stdClass\":9:{s:5:\"title\";s:17:\"JetProductGallery\";s:9:\"condition\";s:51:\"jet-woo-product-gallery/jet-woo-product-gallery.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:56:\"/jet-woo-product-gallery/assets/lib/swiper/swiper.min.js\";i:3;s:65:\"/jet-woo-product-gallery/assets/js/jet-woo-product-gallery.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:60:\"To avoid issues with the product gallery on the product page\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:df3bc4b6a8a9f28a5ba24cb7496bbc72\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432327;}s:36:\"544aa37b-4d52-4182-99e8-abe23585da14\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"JetReviews\";s:9:\"condition\";s:27:\"jet-reviews/jet-reviews.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:46:\"/jet-reviews/assets/js/jet-reviews-frontend.js\";i:3;s:37:\"/jet-reviews/assets/js/lib/vue.min.js\";i:4;s:16:\"jetReviewsWidget\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:39:\"To show the reviews on the product page\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5921fc95965ac7fccb7296957bd9abff\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432349;}s:36:\"963c7804-eede-4570-bd63-67066588b758\";O:8:\"stdClass\":9:{s:5:\"title\";s:32:\"JetSearch - Search results popup\";s:9:\"condition\";s:25:\"jet-search/jet-search.php\";s:10:\"exclusions\";a:4:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:50:\"/jet-search/assets/lib/chosen/chosen.jquery.min.js\";i:2;s:35:\"/jet-search/assets/js/jet-search.js\";i:3;s:49:\"/jet-search/assets/lib/jet-plugins/jet-plugins.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:57:\"To display the list of results when using the search box.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:13e8760379022187de982df2226a5be4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432367;}s:36:\"a8460089-34b4-4f8f-8694-5d92fa48aa82\";O:8:\"stdClass\":8:{s:5:\"title\";s:15:\"JetSmartFilters\";s:9:\"condition\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:10:\"exclusions\";a:1:{i:0;s:23:\"jetOffcanvasInitialized\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:0cd63a514de1f1acb88e2bde65c4bc8d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1694447256;}s:36:\"fe3c4915-6f8b-49b7-aa9c-c97b264d9f12\";O:8:\"stdClass\":9:{s:5:\"title\";s:9:\"JetSticky\";s:9:\"condition\";s:51:\"jetsticky-for-elementor/jetsticky-for-elementor.php\";s:10:\"exclusions\";a:1:{i:0;s:25:\"/jetsticky-for-elementor/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:46:\"Allows sticky menu and sidebar to be displayed\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:a346b60514ef52afeffc6e2ef2793da3\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432399;}s:36:\"853479dc-fff5-47cf-9a60-bf9b00f71fc4\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"JetTabs for Elementor\";s:9:\"condition\";s:21:\"jet-tabs/jet-tabs.php\";s:10:\"exclusions\";a:7:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:11:\"/elementor/\";i:2;s:15:\"/elementor-pro/\";i:3;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:63:\"/wp-content/plugins/jet-tabs/assets/js/jet-tabs-frontend.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:45:\"To make the tab functionality work correctly.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:d887a6ffea25d759e8aecdb6b78917f7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432416;}s:36:\"b7f89562-230c-4f63-8360-7aad6df31e02\";O:8:\"stdClass\":9:{s:5:\"title\";s:9:\"JetTricks\";s:9:\"condition\";s:25:\"jet-tricks/jet-tricks.php\";s:10:\"exclusions\";a:1:{i:0;s:12:\"/jet-tricks/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:22:\"To display animations.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:829272546b040d5aaeeeaf976b6cd4ec\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432431;}s:36:\"90451e2a-553a-4496-9fa4-cffedbe69d43\";O:8:\"stdClass\":9:{s:5:\"title\";s:28:\"JetWoo Widgets For Elementor\";s:9:\"condition\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:58:\"/jetwoo-widgets-for-elementor/assets/js/jet-woo-widgets.js\";i:7;s:49:\"/jet-woo-builder/assets/js/jet-woo-builder.min.js\";i:8;s:42:\"/jet-woo-builder/assets/js/frontend.min.js\";i:9;s:35:\"/wp-includes/js/imagesloaded.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:34:\"Load JetWoo carousel on page load.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:f44f3dbd09149f57db370e4132b057db\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432447;}s:36:\"944718c2-48c6-4f53-aaa2-460d07e033cc\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"JetWooBuilder\";s:9:\"condition\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:10:\"exclusions\";a:11:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:3;s:32:\"/wp-includes/js/dist/i18n.min.js\";i:4;s:15:\"/elementor-pro/\";i:5;s:11:\"/elementor/\";i:6;s:23:\"elementorFrontendConfig\";i:7;s:26:\"ElementorProFrontendConfig\";i:8;s:17:\"JetEngineSettings\";i:9;s:17:\"/jet-woo-builder/\";i:10;s:65:\"/jet-woo-builder-custom-quantity-selectors-main/assets/js/main.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:36:\"Add quantity buttons to add to cart.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ed318a971f8a047bed5b02ad546a9c18\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432462;}s:36:\"b7807939-54f8-4d5c-8363-a42a154d9592\";O:8:\"stdClass\":9:{s:5:\"title\";s:8:\"Joinchat\";s:9:\"condition\";s:31:\"creame-whatsapp-me/joinchat.php\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:45:\"/creame-whatsapp-me/public/js/joinchat.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:131:\"When Delay JavaScript Execution is enabled, the icon to open new chat does not display for mobile unless we apply these exclusions.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1c3ec728d37052f3a3055d415618342f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1727103514;}s:36:\"f5b62f59-1dae-4cdf-ac3f-f5e846fc9918\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:9562e253cd4ac2b1e1f70e32cb4e32dc\";s:5:\"title\";s:12:\"Layer Slider\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:62:\"/LayerSlider/assets/static/layerslider/js/layerslider.utils.js\";i:3;s:77:\"/LayerSlider/assets/static/layerslider/js/layerslider.kreaturamedia.jquery.js\";i:4;s:68:\"/LayerSlider/assets/static/layerslider/js/layerslider.transitions.js\";i:5;s:15:\"initLayerSlider\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"LayerSlider/layerslider.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"e2be718d-83a2-4fa0-bc98-f0df52be3dc1\";O:8:\"stdClass\":9:{s:5:\"title\";s:14:\"LoftLoader Pro\";s:9:\"condition\";s:33:\"loftloader-pro/loftloader-pro.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:17:\"loftloader.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:101:\"Prevent the page from getting stuck in the loader and load the page content without user interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1425e2735306796fe1539d9184a77e10\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432664;}s:36:\"cfa18552-656e-453c-9e14-c07522dc6598\";O:8:\"stdClass\":9:{s:5:\"title\";s:20:\"MailUp for WordPress\";s:9:\"condition\";s:56:\"mailup-email-and-newsletter-subscription-form/mailup.php\";s:10:\"exclusions\";a:2:{i:0;s:73:\"/mailup-email-and-newsletter-subscription-form/public/js/mailup-public.js\";i:1;s:15:\"mailup-js-extra\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:41:\"Enables subscription from to be submitted\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:0bf67b8ba84771e1a367fe24590ef09c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433004;}s:36:\"c5330c66-ba7b-45b1-87e4-ce590ab005dd\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"Maintenance\";s:9:\"condition\";s:27:\"maintenance/maintenance.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:13:\"/maintenance/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:48:\"Removes the preload spinner without interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:10d0de28911c5f66463b9c8783f8148a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433020;}s:36:\"62f6663a-a15f-4bca-b9b5-79f1770e2c5a\";O:8:\"stdClass\":9:{s:5:\"title\";s:33:\"MapifyLite- Show map on page load\";s:9:\"condition\";s:26:\"mapifylite/mapify_lite.php\";s:10:\"exclusions\";a:7:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:58:\"/plugins/mapifylite/assets/vendor/leaflet-1.7.1/leaflet.js\";i:2;s:80:\"/plugins/mapifylite/assets/vendor/leaflet/markercluster/leaflet.markercluster.js\";i:3;s:79:\"/plugins/mapifylite/assets/vendor/leaflet/locatecontrol/L.Control.Locate.min.js\";i:4;s:44:\"/plugins/mapifylite/assets/vendor/tooltip.js\";i:5;s:44:\"/plugins/mapifylite/assets/js/dist/bundle.js\";i:6;s:7:\"var map\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:21:\"Load map on pageload.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:48c30c0f37b64accf88126d4ef58e17b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432876;}s:36:\"267aef71-afa0-4848-b6f8-3e1ca15c3a23\";O:8:\"stdClass\":9:{s:5:\"title\";s:15:\"Maps Marker Pro\";s:9:\"condition\";s:35:\"maps-marker-pro/maps-marker-pro.php\";s:10:\"exclusions\";a:2:{i:0;s:36:\"/maps-marker-pro/js/mapsmarkerpro.js\";i:1;s:17:\"var mapsMarkerPro\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:21:\"Load map on pageload.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:9460789bdfe77425c895f130991a4cb4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432891;}s:36:\"b5a88b63-e906-49b3-8134-420139915ea6\";O:8:\"stdClass\":8:{s:5:\"title\";s:13:\"Master Popups\";s:9:\"condition\";s:31:\"master-popups/master-popups.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:65:\"/plugins/master-popups/assets/public/js/master-popups-libs.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:8fd7bd2c8b0a33e62798573abd12be63\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681305305;}s:36:\"4be41549-bf4d-4c49-8346-0f8a3b88fdba\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"Master Slider\";s:9:\"condition\";s:31:\"master-slider/master-slider.php\";s:10:\"exclusions\";a:1:{i:0;s:12:\"masterslider\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:45:\"Prevents Master Slider to be initially hidden\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:de888634cc4bd51576eed319d5a528fd\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432981;}s:36:\"087bee18-7cd1-4c10-8acc-19e1b7c4f4cd\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"Max Mega Menu\";s:9:\"condition\";s:21:\"megamenu/megamenu.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:34:\"/wp-includes/js/hoverIntent.min.js\";i:3;s:27:\"/megamenu/js/maxmegamenu.js\";i:4;s:12:\"var megamenu\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:92:\"For the Pro version this file may need to be excluded too:\r\n\r\n/megamenu-pro/assets/public.js\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b71309a89bf3c8b558b6fca5d6531919\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433045;}s:36:\"cf22f0b9-01f4-409e-8a93-ad6743095abd\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"Meta Slider\";s:9:\"condition\";s:23:\"ml-slider/ml-slider.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/ml-slider/\";i:3;s:14:\"var metaslider\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:29:\"Shows the slider on page load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:94a7bae84ef2816494be4af66c577bfc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433102;}s:36:\"bb2cbc0d-20da-415e-8218-c17f1db53579\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"Monarch\";s:9:\"condition\";s:19:\"monarch/monarch.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:22:\"dt-place-monarch-icons\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b7335d6d6d5c5134ea10ac2d9b04226c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677853476;}s:36:\"a98d6a80-4610-4ede-bd33-c3e15bed0a95\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:4f8651262425ef6d7c223c68a2ec2063\";s:5:\"title\";s:16:\"Monster Insights\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:13:\"__gtagTracker\";i:1;s:24:\"monsterinsights_frontend\";i:2;s:62:\"/google-analytics-for-wordpress/assets/js/frontend-gtag.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:50:\"google-analytics-for-wordpress/googleanalytics.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"26e1a36e-7a03-449e-8ecc-e42c41ca291c\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"Motion.page\";s:9:\"condition\";s:25:\"motionpage/motionpage.php\";s:10:\"exclusions\";a:4:{i:0;s:40:\"/motionpage/core/includes/assets/js/(.*)\";i:1;s:45:\"/motionpage/core/includes/assets/js/gsap/(.*)\";i:2;s:26:\"/motionpage/assets/js/(.*)\";i:3;s:31:\"/motionpage/assets/js/gsap/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:43:\"Fixes any issue with Motion.page animations\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:f8fc66b302dec2327bdec0434a3b275b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433236;}s:36:\"459fd663-7f80-45fd-8308-d3484981e161\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"Ninja Forms\";s:9:\"condition\";s:27:\"ninja-forms/ninja-forms.php\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:33:\"/wp-includes/js/underscore.min.js\";i:3;s:31:\"/wp-includes/js/backbone.min.js\";i:4;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:5;s:44:\"/ninja-forms/assets/js/min/front-end-deps.js\";i:6;s:39:\"/ninja-forms/assets/js/min/front-end.js\";i:7;s:3:\"nf-\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:25:\"Show the form on pageload\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1d3ae9c1a96d5062616968b81eef319d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433463;}s:36:\"c97440dd-7592-40e7-8c98-dac20d39808f\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"Ninja Tables\";s:9:\"condition\";s:29:\"ninja-tables/ninja-tables.php\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:25:\"/ninja-tables(.*)/assets/\";i:3;s:25:\"/ninja-tables(.*)/public/\";i:4;s:41:\"/wp-includes/js/dist/vendor/moment.min.js\";i:5;s:21:\"ninja_table_instance_\";i:6;s:13:\"ninja_filter_\";i:7;s:31:\"ninja_table_ready_init_table_id\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:26:\"Show the table on pageload\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:723a588dcd49285ea9f7404e2379b47f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433481;}s:36:\"ebc01f06-8c35-47fa-9c63-8959c5cbd915\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"NotificationX\";s:9:\"condition\";s:31:\"notificationx/notificationx.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:39:\"/notificationx/assets/public/js/(.*).js\";i:3;s:16:\"notificationXArr\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:28:\"Show the pop-up notification\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:f41a52ab1dd50a81cd3a5e341af0007c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433494;}s:36:\"3aaf4a1b-591a-48b7-8d60-e6d65c0f94c9\";O:8:\"stdClass\":9:{s:5:\"title\";s:23:\"Ocean Elementor Widgets\";s:9:\"condition\";s:51:\"ocean-elementor-widgets/ocean-elementor-widgets.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:25:\"/ocean-elementor-widgets/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:66:\"Avoid console errors (Elements added with this plugin should work)\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:be8fc72a8b8e8eb5958be13737cff47c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433526;}s:36:\"f053a7d3-62b0-4312-b0ca-6ff63380eb0b\";O:8:\"stdClass\":9:{s:5:\"title\";s:23:\"One Click Accessibility\";s:9:\"condition\";s:41:\"pojo-accessibility/pojo-accessibility.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:40:\"/pojo-accessibility/assets/js/app.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:50:\"Allow One Click Accessibility to work on all pages\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1a14afe852fefe7b22ccad3893672a29\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433541;}s:36:\"61e11800-48a9-4354-8a4c-ac9a2b4b033a\";O:8:\"stdClass\":9:{s:5:\"title\";s:30:\"OoohBoi Steroids for Elementor\";s:9:\"condition\";s:51:\"ooohboi-steroids-for-elementor/ooohboi-steroids.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:32:\"/ooohboi-steroids-for-elementor/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:37:\"Display OohhBoi elements on page load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b9ed0fe6f2cdbd305691a6b857f4b3dc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433511;}s:36:\"560b78a2-f051-490b-9dc6-a602dece0d81\";O:8:\"stdClass\":9:{s:5:\"title\";s:8:\"Optimole\";s:9:\"condition\";s:27:\"optimole-wp/optimole-wp.php\";s:10:\"exclusions\";a:1:{i:0;s:12:\"optimoleData\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:65:\"To fire excluded JavaScript files served through the Optimole CDN\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:f1ff18a3e04c4e0995fca9cabffe57a7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433610;}s:36:\"b0fda458-4bf2-41e9-a159-60d4bb6102a6\";O:8:\"stdClass\":9:{s:5:\"title\";s:19:\"OSM - OpenStreetMap\";s:9:\"condition\";s:11:\"osm/osm.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/osm/js/OL/\";i:3;s:28:\"/osm/js/osm-v3-plugin-lib.js\";i:4;s:7:\"vectorM\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:41:\"Display the map and avoid console errors.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:48ec18bd3f59772d98f85dddab75e305\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433624;}s:36:\"3743ed67-e0d1-4243-bb1f-ee48a445dd10\";O:8:\"stdClass\":9:{s:5:\"title\";s:9:\"OxyExtras\";s:9:\"condition\";s:20:\"oxyextras/plugin.php\";s:10:\"exclusions\";a:2:{i:0;s:4:\"vime\";i:1;s:11:\"vime.esm.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:27:\"When using Pro Media Player\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:9eacf0b76484af0259cd788f4923f20c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433698;}s:36:\"52a21e27-af5b-4476-8d6d-54c323fd1443\";O:8:\"stdClass\":9:{s:5:\"title\";s:14:\"Oxygen Builder\";s:9:\"condition\";s:20:\"oxygen/functions.php\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:38:\"/component-framework/vendor/aos/aos.js\";i:3;s:8:\"AOS.init\";i:4;s:20:\"oxygen_init_pro_menu\";i:5;s:26:\"oxy-pro-menu-show-dropdown\";i:6;s:17:\"oxy-shape-divider\";i:7;s:21:\"oxygenVSBInitToggleJs\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:153:\"When using the \"Pro Menu\" element.\r\nPrevents incorrect positioning of the Shape Divider on page load\r\nAllow tabs toggles to be closed when the page loads\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e852555c4b4789d78a96d76f503b3262\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433680;}s:36:\"ebd282b9-e175-4b83-90a2-fe12389ccd11\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:6f9419e58ec86c94e7698aaaaf9dc715\";s:5:\"title\";s:21:\"PageLoader by Bonfire\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:36:\"/pageloader-by-bonfire/pageloader.js\";i:3;s:26:\"bonfire-pageloader-overlay\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:47:\"pageloader-by-bonfire/pageloader-by-bonfire.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"0baf6353-aa70-41a9-a3bc-d89870a5839b\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"PDF Embedder\";s:9:\"condition\";s:29:\"pdf-embedder/pdf_embedder.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:24:\"/pdf-embedder/js/(.*).js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:158:\"Load the PDF\'s without user interaction.\r\nPlease note that if Defer Javascript Execution is enabled, you also need to exclude these files from being deferred.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3a4c4518eb0f60108ab4934fab27d335\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433747;}s:36:\"cba51ec1-87cc-44eb-b12b-d652e3446507\";O:8:\"stdClass\":9:{s:5:\"title\";s:30:\"Perfect Brands for WooCommerce\";s:9:\"condition\";s:57:\"perfect-woocommerce-brands/perfect-woocommerce-brands.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:57:\"/perfect-woocommerce-brands/assets/lib/slick/slick.min.js\";i:3;s:63:\"/perfect-woocommerce-brands/assets/js/functions-frontend.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:27:\"Show the slider on pageload\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:4f90aca5957cccbf623e3bbc31afa204\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433762;}s:36:\"808e7a4e-025c-4fae-bf82-de3716e5eb0d\";O:8:\"stdClass\":9:{s:5:\"title\";s:8:\"Photonic\";s:9:\"condition\";s:21:\"photonic/photonic.php\";s:10:\"exclusions\";a:1:{i:0;s:65:\"/photonic/include/js/front-end/module/photonic-baguettebox.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:45:\"Display the gallery without user interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:84fe214646388d7c021dda25003ac165\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434241;}s:36:\"936aff7d-a8ac-4473-a7b5-4b1611b6c557\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"Pixel Caffein\";s:9:\"condition\";s:33:\"pixel-caffeine/pixel-caffeine.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:33:\"/pixel-caffeine/build/frontend.js\";i:2;s:10:\"aepc_pixel\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:29:\"Fire the tracker on pageload.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:6838be282f853f71be282783cb1c162b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434253;}s:36:\"ab3a4ef5-2732-4b46-a7c3-17b4e9405cd1\";O:8:\"stdClass\":9:{s:5:\"title\";s:29:\"Pixel Manager for WooCommerce\";s:9:\"condition\";s:59:\"woocommerce-pixel-manager-pro/woocommerce-pixel-manager.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:41:\"/woocommerce-pixel-manager-pro/js/public/\";i:2;s:3:\"wpm\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:29:\"Fire the tracker on pageload.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:afe0eb7c64d4556a7111c56dd8c4d307\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434270;}s:36:\"2774f964-50b2-425e-8a30-0a02f421b7e4\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"Popup Builder\";s:9:\"condition\";s:31:\"popup-builder/popup-builder.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:32:\"/popup-builder/public/js/(.*).js\";i:3;s:57:\"/popupbuilder-exit-intent/public/javascript/ExitIntent.js\";i:4;s:17:\"var sgpbPublicUrl\";i:5;s:17:\"SGPB_POPUP_PARAMS\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:18:\"Show popup on exit\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:38d4b2986868f543639cd1ebc3e510aa\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433776;}s:36:\"82dbb1e5-31f9-43d7-b522-52819aa49ba5\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"Popup Maker\";s:9:\"condition\";s:27:\"popup-maker/popup-maker.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:3;s:24:\"/pum/pum-site-scripts.js\";i:4;s:3:\"pum\";i:5;s:42:\"/plugins/popup-maker/assets/js/site.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:23:\"Show popup on one click\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:786717922362642f34a7ff58e919bd95\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433839;}s:36:\"48e08305-1f1c-4ef4-9f13-24af1b155abc\";O:8:\"stdClass\":9:{s:5:\"title\";s:30:\"PowerPack Addons for Elementor\";s:9:\"condition\";s:57:\"powerpack-lite-for-elementor/powerpack-lite-elementor.php\";s:10:\"exclusions\";a:1:{i:0;s:59:\"/powerpack-lite-for-elementor/assets/js/min/frontend.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:15:\"Show animations\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:17831cbb64e469c7f66224c8c63d0a58\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433893;}s:36:\"e037ae2f-e36b-4f1a-ada8-eb8fde6746f2\";O:8:\"stdClass\":9:{s:5:\"title\";s:14:\"Preloader Plus\";s:9:\"condition\";s:33:\"preloader-plus/preloader-plus.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:20:\"/preloader-plus/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:70:\"Prevents the preloader from being stuck until there\'s user interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:80e1283ea1afead3ca904fad792643c5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434032;}s:36:\"90fed478-e89a-455c-8371-836bee58fb81\";O:8:\"stdClass\":9:{s:5:\"title\";s:28:\"Premium Addons for Elementor\";s:9:\"condition\";s:61:\"premium-addons-for-elementor/premium-addons-for-elementor.php\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:74:\"/premium-addons-for-elementor/assets/frontend/min-js/premium-addons.min.js\";i:3;s:67:\"/premium-addons-for-elementor/assets/frontend/min-js/isotope.min.js\";i:4;s:49:\"/premium-addons-elementor/pa-frontend-(.*).min.js\";i:5;s:65:\"/premium-addons-for-elementor/assets/frontend/min-js/slick.min.js\";i:6;s:61:\"/premium-addons-pro/assets/frontend/min-js/tooltipster.min.js\";i:7;s:19:\"window.scopes_array\";i:8;s:13:\"lottie.min.js\";i:9;s:76:\"/premium-addons-for-elementor/assets/frontend/min-js/premium-nav-menu.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:141:\"The above will cover:\r\n\r\n- Make equal height work\r\n- Make filters work\r\n- Make lottie animations work\r\n- Make the testimonials\' carousel work\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:debbfbbcbdf9ffb465bbc40008d99f02\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434100;}s:36:\"7e43c261-77be-48fc-b25a-8953a654ae85\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"Presto Player\";s:9:\"condition\";s:31:\"presto-player/presto-player.php\";s:10:\"exclusions\";a:7:{i:0;s:54:\"/wp-includes/js/dist/vendor/regenerator-runtime.min.js\";i:1;s:67:\"/presto-player/dist/components/web-components/web-components.esm.js\";i:2;s:42:\"/presto-player/src/player/player-static.js\";i:3;s:10:\"var player\";i:4;s:37:\"/wp-includes/js/dist/api-fetch.min.js\";i:5;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:6;s:32:\"/wp-includes/js/dist/i18n.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:21:\"Load the video player\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:100a0382fcf3d1b6b22da928bce46ea8\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434113;}s:36:\"3d6f509f-d040-4279-9a2f-a4e6eae1e9df\";O:8:\"stdClass\":9:{s:5:\"title\";s:42:\"Price Based on Country for WooCommerce Pro\";s:9:\"condition\";s:87:\"woocommerce-price-based-country-pro-addon/woocommerce-price-based-country-pro-addon.php\";s:10:\"exclusions\";a:4:{i:0;s:79:\"/woocommerce-product-price-based-on-countries/assets/js/ajax-geolocation.min.js\";i:1;s:77:\"/woocommerce-price-based-country-pro-addon/assets/js/currency-switcher.min.js\";i:2;s:18:\"add-to-cart.min.js\";i:3;s:21:\"cart-fragments.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:60:\"To load the prices and currency switcher without interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:c0fce700121492b566517e68301db382\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434128;}s:36:\"b970bc8a-bcbe-4d08-8ac0-a6853ab3f036\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"Prime Slider\";s:9:\"condition\";s:52:\"bdthemes-prime-slider-lite/bdthemes-prime-slider.php\";s:10:\"exclusions\";a:1:{i:0;s:62:\"/plugins/bdthemes-prime-slider-lite/assets/js/bdt-uikit.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:34:\"Display slider without interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:f1ecfe258440b371124999ca3bfbfff3\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434141;}s:36:\"e5458963-f167-4b68-88e4-77dd39af2842\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"PRO Elements\";s:9:\"condition\";s:29:\"pro-elements/pro-elements.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"/pro-elements/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:69:\"Fixes functions execution when the jQuery library is already excluded\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:29ea8f4dd72f5a5c5927917fb0665a05\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434176;}s:36:\"b119ad72-f498-4576-bb71-9e6d8c37b68f\";O:8:\"stdClass\":9:{s:5:\"title\";s:39:\"Product Filter by WBW (for WooCommerce)\";s:9:\"condition\";s:41:\"woo-product-filter/woo-product-filter.php\";s:10:\"exclusions\";a:6:{i:0;s:55:\"/jquery-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:1;s:55:\"/jquery-migrate(.*)(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:2;s:83:\"/wp-content/plugins/woo-product-filter/modules/woofilters/js/frontend.woofilters.js\";i:3;s:38:\"/wp-includes/js/jquery/ui/mouse.min.js\";i:4;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:5;s:39:\"/wp-includes/js/jquery/ui/slider.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:136:\"Resolves issue where the product filter won\'t load on the page, there\'s a \'loading\' gif stuck in its place, and there\'s a console error.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e57ad91e0d94fab011353af544873743\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434285;}s:36:\"7b779aca-e497-4da3-8e51-fa12837d15ab\";O:8:\"stdClass\":9:{s:5:\"title\";s:31:\"Product Filters for WooCommerce\";s:9:\"condition\";s:59:\"woocommerce-product-filters/woocommerce-product-filters.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\"/woocommerce-product-filters/\";i:3;s:51:\"/woocommerce/assets/js/accounting/accounting.min.js\";i:4;s:26:\"/wp-includes/js/jquery/ui/\";i:5;s:17:\"wcpf-load-project\";i:6;s:8:\"WCPFData\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:21:\"Make the filters work\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:719469f1c977f7109d3d6ee21ecd5a16\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434226;}s:36:\"2b2a51f2-bd47-4591-92d8-4a690bce5d99\";O:8:\"stdClass\":9:{s:5:\"title\";s:38:\"Product Gallery Slider for WooCommerce\";s:9:\"condition\";s:15:\"twist/twist.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\"/twist/assets/js/slick.min.js\";i:3;s:20:\"wpgs-public-js-after\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:27:\"Show the slider on pageload\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:a898898b2b0ea2cd82e20a6d3a3aa47b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434162;}s:36:\"062c5be3-e5ea-4958-9619-44e3410f237e\";O:8:\"stdClass\":8:{s:5:\"title\";s:37:\"Product Video Gallery for Woocommerce\";s:9:\"condition\";s:93:\"product-video-gallery-slider-for-woocommerce/product-video-gallery-slider-for-woocommerce.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:70:\"/product-video-gallery-slider-for-woocommerce/public/js/nickx.front.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:bbc653a91f0635cd2edb0b741aa62b85\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1693512477;}s:36:\"34d225a4-688c-476b-846b-420774160d6b\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:e0b123d324c6fc85b8682660c34f8829\";s:5:\"title\";s:13:\"Rank Math SEO\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:11:\"local_ga_js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:30:\"seo-by-rank-math/rank-math.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"02305ca0-2c2a-4eef-a802-b8a942771ecc\";O:8:\"stdClass\":9:{s:5:\"title\";s:9:\"Retainful\";s:9:\"condition\";s:91:\"retainful-next-order-coupon-for-woocommerce/retainful-next-order-coupon-for-woocommerce.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:83:\"/retainful-next-order-coupon-for-woocommerce/src/premium/assets/js/atc-popup.min.js\";i:3;s:87:\"/retainful-next-order-coupon-for-woocommerce/src/premium/assets/js/exit-intent-popup.js\";i:4;s:13:\"retainful.com\";i:5;s:26:\"rnoc-add-to-cart-js-before\";i:6;s:26:\"rnoc_redirect_coupon_popup\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:15:\"Show the pop-up\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:f9fdee19ba6aed961d96d86e1521a761\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434370;}s:36:\"b4055250-5813-400f-b663-d390fee989e4\";O:8:\"stdClass\":9:{s:5:\"title\";s:17:\"Revolution Slider\";s:9:\"condition\";s:23:\"revslider/revslider.php\";s:10:\"exclusions\";a:12:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:28:\"/revslider/public/assets/js/\";i:3;s:25:\"/revslider/sr6/assets/js/\";i:4;s:22:\"/revslider-(.*)-addon/\";i:5;s:15:\"setREVStartSize\";i:6;s:11:\"rev_slider_\";i:7;s:10:\"revslider_\";i:8;s:17:\"window.RS_MODULES\";i:9;s:36:\"/revslider/public/js/libs/tptools.js\";i:10;s:27:\"/revslider/public/js/sr7.js\";i:11;s:3:\"SR7\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:28:\"Show the slider on page load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:d6a4d07d1b4022d886df52322dcd8a6f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434385;}s:36:\"0b4e061a-b366-4d5a-a00e-bded4b107133\";O:8:\"stdClass\":9:{s:5:\"title\";s:22:\"Royal Elementor Addons\";s:9:\"condition\";s:37:\"royal-elementor-addons/wpr-addons.php\";s:10:\"exclusions\";a:3:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:49:\"/royal-elementor-addons/assets/js/frontend.min.js\";i:2;s:62:\"/royal-elementor-addons/assets/js/lib/jarallax/jarallax.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:29:\"Fixes mobile menu not opening\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:c4b464373716d7ac8e3cfb019aaa6102\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434411;}s:36:\"1b19ec89-171a-4f85-8c4b-b1bcfc6b1433\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5e3f85d8c82cc184b945415d1a862601\";s:5:\"title\";s:18:\"Sassy Social Share\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:58:\"/sassy-social-share/public/js/sassy-social-share-public.js\";i:3;s:19:\"heateorSssLoadEvent\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:41:\"sassy-social-share/sassy-social-share.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"f5899925-2ab7-43b6-abc4-51b76d664ca6\";O:8:\"stdClass\":9:{s:5:\"title\";s:14:\"Scrollsequence\";s:9:\"condition\";s:41:\"scrollsequence-pro/scrollsequence-pro.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:51:\"/scrollsequence-pro/public/js/gsap__premium_only.js\";i:3;s:65:\"/scrollsequence-pro/public/js/gsap-scrolltrigger__premium_only.js\";i:4;s:54:\"/scrollsequence-pro/public/js/ssq-lib__premium_only.js\";i:5;s:27:\"scrollsequence-input-script\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:37:\"Show images and animation on pageload\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3df51830b6b80668fc342c8dcea495cf\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434606;}s:36:\"043827fc-3df8-45d6-9cd2-14fbe962987a\";O:8:\"stdClass\":9:{s:5:\"title\";s:37:\"ShiftNav Pro - Responsive Mobile Menu\";s:9:\"condition\";s:25:\"shiftnav-pro/shiftnav.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:39:\"/shiftnav-pro/assets/js/shiftnav(.*).js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:29:\"Displays without interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:9d60b5d2de4d828b78c7b088024377d6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434657;}s:36:\"bcbaf240-e76f-4620-b7d5-4852c46d4be7\";O:8:\"stdClass\":9:{s:5:\"title\";s:35:\"ShiftNav – Responsive Mobile Menu\";s:9:\"condition\";s:67:\"shiftnav-responsive-mobile-menu/shiftnav-responsive-mobile-menu.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:33:\"/shiftnav-responsive-mobile-menu/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:29:\"Displays without interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:56279bd768c8f27ad1972b6774738bcf\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434651;}s:36:\"bbe0543b-b5af-467b-a90d-e2975d892d8d\";O:8:\"stdClass\":8:{s:5:\"title\";s:26:\"Short Pixel Adaptive Image\";s:9:\"condition\";s:45:\"shortpixel-adaptive-images/short-pixel-ai.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:51:\"/shortpixel-adaptive-images/assets/js/ai(.*).min.js\";i:3;s:13:\"spai_settings\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1bc7ac87d8ab2301a1b904919dc7a798\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704734942;}s:36:\"543ab43a-6bd3-4948-a09e-3b95e7c9209d\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"Showcase IDX\";s:9:\"condition\";s:28:\"showcase-idx/showcaseidx.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:4:\"SIDX\";i:3;s:37:\"search.showcaseidx.com/js/app-(.*).js\";i:4;s:17:\"cdn.shortpixel.ai\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:172:\"Prevents requiring double click on iOS to use filters.\r\n\r\nExclusion when the option New AI engine is enabled (You don\'t need the above, only this one):\r\n\r\ncdn.shortpixel.ai\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ce4dea8ddc3caa8d00e95cec3202d32a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434768;}s:36:\"a16bcab7-1169-46b9-a425-b091478d8312\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"Side Cart WooCommerce\";s:9:\"condition\";s:38:\"side-cart-woocommerce/xoo-wsc-main.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:61:\"/plugins/woocommerce/assets/js/frontend/cart-fragments.min.js\";i:3;s:58:\"/plugins/woocommerce/assets/js/frontend/add-to-cart.min.js\";i:4;s:67:\"/plugins/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min.js\";i:5;s:57:\"/plugins/woocommerce/assets/js/js-cookie/js.cookie.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:47:\"Makes cart icon work to slide in the cart menu.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3ea7d9f75ad03620b0bce2517bd5b8d1\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434681;}s:36:\"521f748e-cf09-4019-bd28-b52daef5f16f\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"Simple Banner\";s:9:\"condition\";s:31:\"simple-banner/simple-banner.php\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:15:\"/simple-banner/\";i:2;s:24:\"simpleBannerScriptParams\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:28:\"Show the banner on pageload.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:7843983bf90dbae16c6e889382c71b23\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434695;}s:36:\"76026e82-d9cf-482c-b480-55c57693a184\";O:8:\"stdClass\":9:{s:5:\"title\";s:18:\"Site Kit by Google\";s:9:\"condition\";s:35:\"google-site-kit/google-site-kit.php\";s:10:\"exclusions\";a:6:{i:0;s:33:\"google-analytics.com/analytics.js\";i:1;s:6:\"ga\\( \'\";i:2;s:5:\"ga\\(\'\";i:3;s:8:\"/gtag/js\";i:4;s:6:\"gtag\\(\";i:5;s:7:\"/gtm.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:35:\"Fixes issues with Google Analytics.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b6825f971d35a5515d095564a2e40936\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434707;}s:36:\"4f9be7dd-fa19-401c-a5a5-81654990f9c4\";O:8:\"stdClass\":9:{s:5:\"title\";s:39:\"SiteOrigin Widgets Bundle - Load images\";s:9:\"condition\";s:39:\"so-widgets-bundle/so-widgets-bundle.php\";s:10:\"exclusions\";a:9:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:49:\"/so-widgets-bundle/js/slider/jquery.slider.min.js\";i:2;s:41:\"/so-widgets-bundle/js/jquery.cycle.min.js\";i:3;s:47:\"/so-widgets-bundle/js/jquery.cycle.swipe.min.js\";i:4;s:47:\"/so-widgets-bundle/js/sow.jquery.fittext.min.js\";i:5;s:47:\"/so-widgets-bundle/js/lib/jquery.fitvids.min.js\";i:6;s:36:\"/siteorigin-panels/js/styling.min.js\";i:7;s:27:\"siteorigin-panels-before-js\";i:8;s:7:\"page_id\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:33:\"Load the images on the page load.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3968480c93d7f92ed1cb78a54b47fc9f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434720;}s:36:\"79c458d7-f7f7-4072-919d-ad337bde6ae3\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"Slick Menu\";s:9:\"condition\";s:25:\"slick-menu/slick-menu.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:12:\"/slick-menu/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:21:\"Show menu on pageload\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5ce5dfecdc9d3292c69a1413bbd17d3c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434809;}s:36:\"99cf4942-49ea-4687-b156-405ed1ce1cfa\";O:8:\"stdClass\":9:{s:5:\"title\";s:14:\"Slide Anything\";s:9:\"condition\";s:33:\"slide-anything/slide-anything.php\";s:10:\"exclusions\";a:3:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:48:\"/slide-anything/owl-carousel/owl.carousel.min.js\";i:2;s:16:\"owl_goto.trigger\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:36:\"Show slider without user interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:fff874cc48b80940210228c975df395c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434788;}s:36:\"dd0ea584-0c99-4c30-b46d-da35b94c9f0a\";O:8:\"stdClass\":9:{s:5:\"title\";s:19:\"Slider by Soliloquy\";s:9:\"condition\";s:33:\"soliloquy-lite/soliloquy-lite.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:16:\"soliloquy-min.js\";i:3;s:16:\"soliloquy_slider\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:27:\"Show the slider on pageload\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ffb5f8cc0ea17886dbd05f601ca3eec0\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434937;}s:36:\"ecb2fffc-d289-4f68-ae94-71131f17deee\";O:8:\"stdClass\":9:{s:5:\"title\";s:14:\"Smart Slider 3\";s:9:\"condition\";s:33:\"smart-slider-3/smart-slider-3.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:23:\"/smart-slider-3/(.*).js\";i:3;s:3:\"_N2\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:27:\"Show the slider on pageload\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:2f373822dceb191c31c8ad2183d51869\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434826;}s:36:\"284ede43-bf80-419e-8414-46c26cb746f0\";O:8:\"stdClass\":9:{s:5:\"title\";s:18:\"Smart Slider 3 Pro\";s:9:\"condition\";s:55:\"nextend-smart-slider3-pro/nextend-smart-slider3-pro.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:21:\"/SmartSlider3/(.*).js\";i:3;s:3:\"_N2\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:27:\"Show the slider on pageload\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:720ec9fbbd8a52ce525959a68a5310b3\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434836;}s:36:\"be70034f-def5-4771-9b3f-662eb218da2a\";O:8:\"stdClass\":9:{s:5:\"title\";s:28:\"Spectra - Show Slider Images\";s:9:\"condition\";s:63:\"ultimate-addons-for-gutenberg/ultimate-addons-for-gutenberg.php\";s:10:\"exclusions\";a:7:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:66:\"/ultimate-addons-for-gutenberg/assets/js/spectra-animations.min.js\";i:2;s:52:\"/ultimate-addons-for-gutenberg/assets/js/post.min.js\";i:3;s:51:\"/ultimate-addons-for-gutenberg/assets/js/aos.min.js\";i:4;s:13:\"/slick.min.js\";i:5;s:20:\"/imagesloaded.min.js\";i:6;s:16:\"UAGBPostCarousel\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:27:\"Show the slider on pageload\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:af16af31f83a874b9d0a9570d9c15ff7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434960;}s:36:\"c3334c29-4160-42df-a1ce-f8aeeaee8668\";O:8:\"stdClass\":8:{s:5:\"title\";s:16:\"Super Socializer\";s:9:\"condition\";s:37:\"super-socializer/super_socializer.php\";s:10:\"exclusions\";a:3:{i:0;s:8:\"theChamp\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:660defe26748470c3a47366cd4012579\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677853633;}s:36:\"f18b4242-fe3f-4e2b-bfc9-ac2fb3939a90\";O:8:\"stdClass\":8:{s:5:\"title\";s:13:\"Superfly Menu\";s:9:\"condition\";s:22:\"superfly-menu/main.php\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:33:\"/jquery-migrate((.*?)(.min?)?).js\";i:2;s:67:\"/superfly-menu/includes/vendor/looks_awesome/icon_manager/js/md5.js\";i:3;s:68:\"/superfly-menu/includes/vendor/looks_awesome/icon_manager/js/util.js\";i:4;s:31:\"/superfly-menu/js/public.min.js\";i:5;s:20:\"window.SFM_is_mobile\";i:6;s:21:\"var SFM_skew_disabled\";i:7;s:16:\"var SFM_template\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ccb15175093bc6c437b78797f0698a7b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1684301673;}s:36:\"1a05c00a-8562-45bc-80e8-987a4574b1c9\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"Symplr Ads\";s:9:\"condition\";s:28:\"symplr-ads/symplr-plugin.php\";s:10:\"exclusions\";a:2:{i:0;s:12:\"/symplr-ads/\";i:1;s:14:\"cdns.symplr.de\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:20:\"Loads Ads right away\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3b6d39e28a87e86c4659491e2368ff61\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724442756;}s:36:\"858d2d7f-bdac-4d27-ba26-baa9ace96ba4\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"Tabby Responsive Tabs\";s:9:\"condition\";s:47:\"tabby-responsive-tabs/tabby-responsive-tabs.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:34:\"/tabby-responsive-tabs/js/tabby.js\";i:3;s:12:\"RESPONSIVEUI\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:23:\"Load tabs without delay\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:7d93008296bb5c7c43d4cba185ed2632\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724442869;}s:36:\"e44a5c93-bb77-4624-a121-d846905137ea\";O:8:\"stdClass\":9:{s:5:\"title\";s:29:\"The Plus Addons for Elementor\";s:9:\"condition\";s:70:\"the-plus-addons-for-elementor-page-builder/theplus_elementor_addon.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:20:\"/theplus-addons/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:29:\"Start animations on page load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:2f563bbb7e92363ec3fb2989a1c7dffe\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724442902;}s:36:\"2bbac961-b000-4802-ae97-d52472ec6750\";O:8:\"stdClass\":9:{s:5:\"title\";s:37:\"The Plus Addons for Elementor Premium\";s:9:\"condition\";s:51:\"theplus_elementor_addon/theplus_elementor_addon.php\";s:10:\"exclusions\";a:7:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:44:\"/wp-content/plugins/theplus_elementor_addon/\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:26:\"ElementorProFrontendConfig\";i:6;s:23:\"elementorFrontendConfig\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:34:\"Solve issues with sliders and tabs\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:6e127deaaeefbe57ff945b1f9e274518\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724442911;}s:36:\"c3b5d7fd-a1e0-4aca-a0b6-405018a37266\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"The Post Grid\";s:9:\"condition\";s:14:\"the-post-grid/\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:13:\"the-post-grid\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:54:\"Makes the content of single post appearing immediately\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:93c3354976453458cf67f8ec0fdfce5a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724442928;}s:36:\"666b45e8-749c-4140-bd17-e1cd589e03ee\";O:8:\"stdClass\":9:{s:5:\"title\";s:15:\"ThemeREX Addons\";s:9:\"condition\";s:25:\"trx_addons/trx_addons.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:32:\"/trx_addons/js/__scripts-full.js\";i:3;s:67:\"/trx_addons/components/cpt/layouts/shortcodes/menu/superfish.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:48:\"Hide the page preloader without user interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b9c418b47c986935a1151ab9b42f8971\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443103;}s:36:\"a750cada-eb58-4df4-9966-21c8a69332ba\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:75af9efe22c5cc776636266feb55adf1\";s:5:\"title\";s:16:\"Thrive Architect\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:45:\"thrive-visual-editor/thrive-visual-editor.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"13714cde-680e-4ca4-8607-c35952d6a5f2\";O:8:\"stdClass\":8:{s:5:\"title\";s:15:\"Thrive Comments\";s:9:\"condition\";s:35:\"thrive-comments/thrive-comments.php\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"/thrive-leads/\";i:3;s:15:\"window.TL_Const\";i:4;s:7:\"var ml=\";i:5;s:27:\"/thrive-comments/assets/js/\";i:6;s:14:\"ThriveComments\";i:7;s:33:\"/wp-includes/js/underscore.min.js\";i:8;s:31:\"/wp-includes/js/backbone.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:6a72d06ca2f6a888b0d9d5ea93af2edc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677852974;}s:36:\"aa7ca898-499f-4f04-b419-3de199996969\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"Thrive Leads\";s:9:\"condition\";s:29:\"thrive-leads/thrive-leads.php\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"/thrive-leads/\";i:3;s:15:\"window.TL_Const\";i:4;s:7:\"var ml=\";i:5;s:27:\"/thrive-comments/assets/js/\";i:6;s:14:\"ThriveComments\";i:7;s:33:\"/wp-includes/js/underscore.min.js\";i:8;s:31:\"/wp-includes/js/backbone.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:55:\"Show the form on pageload & Fix comment box not showing\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b84d82c02cade64ade00712b9c5652aa\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443176;}s:36:\"9eee297a-8241-4ef2-af97-46074bd0898c\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5bb61b0559b0a3fd578315b553451327\";s:5:\"title\";s:19:\"Thrive Quiz Builder\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:43:\"thrive-quiz-builder/thrive-quiz-builder.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"c2f3ec2a-5b09-4845-aa95-84841783fbfc\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:a7f3e5206abff19ca7cf142260181738\";s:5:\"title\";s:16:\"Thrive Ultimatum\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:18:\"/thrive-ultimatum/\";i:3;s:12:\"var TVE_Ult_\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:37:\"thrive-ultimatum/thrive-ultimatum.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"d48b8d2f-e071-4a30-840a-306154a115a0\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"Tidio Chat\";s:9:\"condition\";s:34:\"tidio-live-chat/tidio-elements.php\";s:10:\"exclusions\";a:1:{i:0;s:22:\"document.tidioChatCode\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:22:\"Display the chat icon.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:f57be2014b6a489d053f8367fa6c0f9f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724442883;}s:36:\"cb6d33ed-7eb4-4ff9-9ad0-7fc54fbecf6f\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:c9e0485ec256d4a6a8d92a98c18d76fc\";s:5:\"title\";s:14:\"Toolset Blocks\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:26:\"toolsetCommonEs.fontToHead\";i:3;s:27:\"toolsetCommonEs.styleToHead\";i:4;s:59:\"/toolset-blocks/vendor/toolset/blocks/public/js/frontend.js\";i:5;s:77:\"/toolset-blocks/vendor/toolset/common-es/public/toolset-common-es-frontend.js\";i:6;s:43:\"/toolset-blocks/public/js/views-frontend.js\";i:7;s:33:\"/wp-includes/js/underscore.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"toolset-blocks/wp-views.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"4bac6350-0925-49fb-904a-372f22fd6baf\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"Top Bar Pro\";s:9:\"condition\";s:25:\"topbar-pro/topbar_pro.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:40:\"/plugins/topbar-pro/js/tpbr_front.min.js\";i:3;s:39:\"/plugins/topbar-pro/js/jquery.cookie.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:62:\"To prevent top bar from getting overlapped with other content.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:71beda322b37f7fc7d456822493cb972\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443222;}s:36:\"033486e7-0ddc-4915-a848-31504d00448e\";O:8:\"stdClass\":8:{s:5:\"title\";s:27:\"Twenty20 Image Before-After\";s:9:\"condition\";s:20:\"twenty20/ttwenty.php\";s:10:\"exclusions\";a:4:{i:0;s:27:\"/twenty20/assets/js/(.*).js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";i:3;s:22:\"twentytwenty-container\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:23441bba9d3602bc932d697c7cb8aa1f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677858089;}s:36:\"bef2147e-2d0b-431d-ac29-5e8430c0d809\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"Typing Effect\";s:9:\"condition\";s:39:\"animated-typing-effect/typingeffect.php\";s:10:\"exclusions\";a:3:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:50:\"/plugins/animated-typing-effect/assets/js/typed.js\";i:2;s:53:\"/plugins/animated-typing-effect/assets/js/typed.fe.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:44:\"Show the animated typing effect on page load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e4e1a3e63d09a28dcb20577efbcb5a48\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443336;}s:36:\"7675a34d-006e-4672-99d5-a81e1b8e47f9\";O:8:\"stdClass\":9:{s:5:\"title\";s:8:\"UberMenu\";s:9:\"condition\";s:21:\"ubermenu/ubermenu.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:35:\"/ubermenu/assets/js/ubermenu.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:71:\"To make mobile menu responsive immediately without any user interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3d59cc34167a7f8123e66b627148e0b7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443357;}s:36:\"8233178a-e7b3-43ce-b193-bd0d9c960933\";O:8:\"stdClass\":9:{s:5:\"title\";s:29:\"Ultimate Addons for Elementor\";s:9:\"condition\";s:41:\"ultimate-elementor/ultimate-elementor.php\";s:10:\"exclusions\";a:17:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:49:\"/ultimate-elementor/assets/lib/slick/slick.min.js\";i:3;s:54:\"/ultimate-elementor/assets/min-js/uael-frontend.min.js\";i:4;s:53:\"/ultimate-elementor/assets/lib/isotope/isotope.min.js\";i:5;s:73:\"/ultimate-elementor/assets/lib/jquery-element-resize/jquery_resize.min.js\";i:6;s:62:\"/ultimate-elementor/assets/lib/fancybox/jquery_fancybox.min.js\";i:7;s:71:\"/ultimate-elementor/assets/lib/justifiedgallery/justifiedgallery.min.js\";i:8;s:40:\"/elementor-pro/assets/js/frontend.min.js\";i:9;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:10;s:52:\"/js_composer/assets/js/dist/js_composer_front.min.js\";i:11;s:42:\"/elementor/assets/lib/swiper/swiper.min.js\";i:12;s:44:\"/nasa-core/assets/js/min/jquery.slick.min.js\";i:13;s:11:\"/elementor/\";i:14;s:15:\"/elementor-pro/\";i:15;s:26:\"ElementorProFrontendConfig\";i:16;s:23:\"elementorFrontendConfig\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:57:\"To make header slider be displayed correctly on page load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:86424c46157c1c7e2e1571055813beee\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443382;}s:36:\"8bddf484-6c78-4147-a4e6-d3039904e5f6\";O:8:\"stdClass\":9:{s:5:\"title\";s:43:\"Ultimate Addons for Elementor - Mobile Menu\";s:9:\"condition\";s:41:\"ultimate-elementor/ultimate-elementor.php\";s:10:\"exclusions\";a:4:{i:0;s:55:\"/jquery-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:1;s:55:\"/jquery-migrate(.*)(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:2;s:46:\"/ultimate-elementor/assets/js/uael-nav-menu.js\";i:3;s:54:\"/ultimate-elementor/assets/min-js/uael-nav-menu.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:45:\"To make the mobile menu icon work as expected\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:70cfade3a7adbb54196f6acccc5a176f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443394;}s:36:\"028504f7-b1cd-4318-8a6d-ce186197e89d\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:0f0a91f0c454021a5ff9fc25c3ed419f\";s:5:\"title\";s:41:\"Ultimate Addons for WPBakery Page Builder\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:27:\"/Ultimate_VC_Addons/assets/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"5754af3d-a6af-49eb-b731-bdd82f26dc4e\";O:8:\"stdClass\":9:{s:5:\"title\";s:32:\"Ultimate Responsive Image Slider\";s:9:\"condition\";s:69:\"ultimate-responsive-image-slider/ultimate-responsive-image-slider.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"sliderPro\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:47:\"To load the slider without any user interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:34db8636812bad84c8aea037c2ddc8c2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443418;}s:36:\"78ae882d-ae31-4179-b677-8893814938c7\";O:8:\"stdClass\":8:{s:5:\"title\";s:49:\"Unlimited Elements for Elementor Premium - Slider\";s:9:\"condition\";s:67:\"unlimited-elements-for-elementor-premium/unlimited-elements-pro.php\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:42:\"/unlimited-elements-for-elementor-premium/\";i:7;s:3:\"uc_\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:17260bc347b8c29bee0010e9ec164184\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1683270377;}s:36:\"051cbfbb-7ad2-4f06-a493-3cf423a80904\";O:8:\"stdClass\":9:{s:5:\"title\";s:34:\"Variation Swatches for WooCommerce\";s:9:\"condition\";s:49:\"woo-variation-swatches/woo-variation-swatches.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/jquery/ui/\";i:3;s:24:\"/woo-variation-swatches/\";i:4;s:28:\"/woo-variation-swatches-pro/\";i:5;s:17:\"underscore.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:26:\"Make some elements to load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:6717ef5673a956bc08ca4a5117065d53\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443437;}s:36:\"6879caba-7224-4eca-bcb2-370785b495ea\";O:8:\"stdClass\":9:{s:5:\"title\";s:30:\"Web Accessibility By accessiBe\";s:9:\"condition\";s:24:\"accessibe/accessiebe.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/accessibe/\";i:3;s:6:\"acsbJS\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:39:\"To preserve the functions of the plugin\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:57597b7683e01892932083413f085134\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443688;}s:36:\"bd6732fe-4c2b-40a1-9035-8464057e2da5\";O:8:\"stdClass\":8:{s:5:\"title\";s:28:\"WooCommerce - Cart Fragments\";s:9:\"condition\";s:27:\"woocommerce/woocommerce.php\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:53:\"/woocommerce/assets/js/frontend/cart-fragments.min.js\";i:2;s:49:\"/woocommerce/assets/js/js-cookie/js.cookie.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:201de694c6fc28c8d580a3b2ca484218\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1680937567;}s:36:\"d044900d-07e1-4533-9516-33106efcb259\";O:8:\"stdClass\":8:{s:5:\"title\";s:33:\"WooCommerce - Product description\";s:9:\"condition\";s:27:\"woocommerce/woocommerce.php\";s:10:\"exclusions\";a:3:{i:0;s:61:\"/plugins/woocommerce/assets/js/frontend/single-product.min.js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:a82644b4c9417ea3a240939a73344700\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679309756;}s:36:\"bff953b1-2213-4666-8112-76a84a3cc207\";O:8:\"stdClass\":8:{s:5:\"title\";s:29:\"WooCommerce - Product Gallery\";s:9:\"condition\";s:27:\"woocommerce/woocommerce.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:55:\"/woocommerce/?(.*)/assets/js/zoom/jquery.zoom(.min)?.js\";i:3;s:40:\"/woocommerce/?(.*)/assets/js/photoswipe/\";i:4;s:67:\"/woocommerce/?(.*)/assets/js/flexslider/jquery.flexslider(.min)?.js\";i:5;s:62:\"/woocommerce/?(.*)/assets/js/frontend/single-product(.min)?.js\";i:6;s:24:\"wc_single_product_params\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:7665868ff97c265628f376523a4f9ecc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1686579689;}s:36:\"016e6ddf-c6e7-49ec-bd3f-2585d9e45895\";O:8:\"stdClass\":8:{s:5:\"title\";s:29:\"WooCommerce - Select2 library\";s:9:\"condition\";s:27:\"woocommerce/woocommerce.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:45:\"/woocommerce/assets/js/select2/select2(.*).js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:4bca670bd5d55dd24b17fb0193b0891e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681459540;}s:36:\"b9b2c6d7-944f-4ae3-ae04-c9e2204b9dab\";O:8:\"stdClass\":9:{s:5:\"title\";s:30:\"WooCommerce Attribute Swatches\";s:9:\"condition\";s:71:\"iconic-woo-attribute-swatches-premium/iconic-woo-attribute-swatches.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:69:\"/iconic-woo-attribute-swatches-premium/assets/frontend/js/main.min.js\";i:3;s:82:\"/iconic-woo-attribute-swatches-premium/assets/vendor/flickity/flickity.pkgd.min.js\";i:4;s:15:\"iconic_was_vars\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:53:\"Makes using attribute swatches not require two clicks\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:9165c768e978d6ad3f696db8c78ccbb2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443452;}s:36:\"4506c5e9-7349-44c9-9967-34370c83facb\";O:8:\"stdClass\":9:{s:5:\"title\";s:20:\"WooCommerce Bookings\";s:9:\"condition\";s:45:\"woocommerce-bookings/woocommerce-bookings.php\";s:10:\"exclusions\";a:9:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:38:\"/woocommerce-bookings/dist/frontend.js\";i:3;s:32:\"/wp-includes/js/dist/date.min.js\";i:4;s:41:\"/wp-includes/js/dist/vendor/moment.min.js\";i:5;s:43:\"/wp-includes/js/jquery/ui/datepicker.min.js\";i:6;s:33:\"/wp-includes/js/underscore.min.js\";i:7;s:59:\"/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min.js\";i:8;s:33:\"/wp-includes/js/dist/hooks.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:45:\"Make sure the calendar is displayed correctly\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:14dec6d289b9977fa3a74116feecebcc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443469;}s:36:\"fec9cd04-c358-45da-a1a8-1668b964016b\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:456f3b849ba3b6647246aca9d7cdaed5\";s:5:\"title\";s:31:\"WooCommerce Product Reviews Pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:22:\"wc_product_reviews_pro\";i:3;s:90:\"/woocommerce-product-reviews-pro/assets/js/frontend/wc-product-reviews-pro-frontend.min.js\";i:4;s:57:\"/woocommerce/assets/js/jquery-tiptip/jquery.tipTip.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:67:\"woocommerce-product-reviews-pro/woocommerce-product-reviews-pro.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"551a9399-627f-4978-9bae-5cc8e0aefc82\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:c8577e74eef3b082fb6403760d53f68c\";s:5:\"title\";s:36:\"WooCommerce TM Extra Product Options\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:10:{i:0;s:58:\"/woocommerce-tm-extra-product-options/assets/js/epo.min.js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";i:3;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:4;s:38:\"/wp-includes/js/jquery/ui/mouse.min.js\";i:5;s:39:\"/wp-includes/js/jquery/ui/slider.min.js\";i:6;s:33:\"/wp-includes/js/underscore.min.js\";i:7;s:30:\"/wp-includes/js/wp-util.min.js\";i:8;s:29:\"/wp-includes/js/dist/hooks.js\";i:9;s:28:\"/wp-includes/js/dist/i18n.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:69:\"woocommerce-tm-extra-product-options/tm-woo-extra-product-options.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"3cac4650-6a52-448e-8e48-e99a772a59a2\";O:8:\"stdClass\":9:{s:5:\"title\";s:9:\"WooLentor\";s:9:\"condition\";s:47:\"woolentor-addons/woolentor_addons_elementor.php\";s:10:\"exclusions\";a:3:{i:0;s:50:\"/woolementor/assets/third-party/slick/slick.min.js\";i:1;s:17:\"/woolentor-addons\";i:2;s:16:\"woolentor_addons\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:41:\"Display the carousel without interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:c6e6cab8c80fa3fe57d609f72d2d5c56\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443648;}s:36:\"21af073d-d2ec-4d46-bbda-2c69f87f3f98\";O:8:\"stdClass\":9:{s:5:\"title\";s:31:\"Woolentor - Fix product gallery\";s:9:\"condition\";s:47:\"woolentor-addons/woolentor_addons_elementor.php\";s:10:\"exclusions\";a:4:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:20:\".woolentor-learg-img\";i:2;s:40:\"/woolentor-addons/assets/js/slick.min.js\";i:3;s:48:\"/woolentor-addons-pro/assets/lib/js/tippy.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:48:\"Display the product gallery without interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:c5315e06dfc353cd57f85a60abe4e320\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443660;}s:36:\"67aeb4cb-1a00-4d10-a00c-34888b4c0dba\";O:8:\"stdClass\":9:{s:5:\"title\";s:25:\"WooThumbs for WooCommerce\";s:9:\"condition\";s:39:\"woothumbs-premium/woothumbs-premium.php\";s:10:\"exclusions\";a:5:{i:0;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:1;s:33:\"/wp-includes/js/underscore.min.js\";i:2;s:31:\"/wp-includes/js/wp-embed.min.js\";i:3;s:30:\"/wp-includes/js/wp-util.min.js\";i:4;s:23:\"/woothumbs-premium/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:51:\"To preserve the display of product variation images\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b97b1d3f627769e1dd8305aa25af993c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443675;}s:36:\"c7a14763-88d0-4344-a6af-e0a8dc5fa8d5\";O:8:\"stdClass\":9:{s:5:\"title\";s:32:\"WordPress Mega Menu – QuadMenu\";s:9:\"condition\";s:21:\"quadmenu/quadmenu.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"/quadmenu\";i:3;s:13:\"#private-menu\";i:4;s:12:\"#public-menu\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:25:\"Show the menu on pageload\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:31b9e812a025e5750a6ef0980ee7d2db\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443871;}s:36:\"f699fdbd-84a7-4f24-b729-3e4a4f83a4dd\";O:8:\"stdClass\":9:{s:5:\"title\";s:9:\"WP Armour\";s:9:\"condition\";s:41:\"wp-armour-extended/wp-armour-extended.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:28:\"/honeypot/includes/js/wpa.js\";i:3;s:39:\"/wp-armour-extended/includes/js/wpae.js\";i:4;s:16:\"wpa_hidden_field\";i:5;s:12:\"wpa_add_test\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:47:\"To prevent marking all product reviews as spam.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:601f8fc7d10cad1c2ec2949c0d9b1651\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443705;}s:36:\"697239fe-74f5-42a4-a504-97ee85bf43ff\";O:8:\"stdClass\":8:{s:5:\"title\";s:19:\"WP Booking Calendar\";s:9:\"condition\";s:25:\"booking/wpdev-booking.php\";s:10:\"exclusions\";a:11:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:58:\"/wp-content/plugins/booking(.*)/_dist/all/_out/wpbc_all.js\";i:2;s:71:\"/wp-content/plugins/booking(.*)/js/datepick/jquery.datepick.wpbc.9.0.js\";i:3;s:56:\"/wp-content/plugins/booking(.*)/js/wpbc_time-selector.js\";i:4;s:52:\"/wp-content/plugins/booking(.*)/assets/libs/tippy.js\";i:5;s:60:\"/wp-content/plugins/booking(.*)/assets/libs/popper/popper.js\";i:6;s:15:\"wpbc_init__head\";i:7;s:13:\"wpbc_url_ajax\";i:8;s:31:\"booking_max_monthes_in_calendar\";i:9;s:25:\"wpbc_define_tippy_popover\";i:10;s:21:\"flex_tl_table_loading\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:fdaf786c076fa0f17eec1e321fee0b3f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1720571754;}s:36:\"6a28aae5-ef91-43fc-8204-92e3a25642b4\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5728f3b9856dfe37a36ab15b0a637198\";s:5:\"title\";s:10:\"WP Go Maps\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"maps.googleapis.com\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:31:\"wp-google-maps/wpGoogleMaps.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"c9b991d1-a653-404b-be85-e276b1814e7d\";O:8:\"stdClass\":8:{s:5:\"title\";s:17:\"WP Google Map Pro\";s:9:\"condition\";s:41:\"wp-google-map-gold/wp-google-map-gold.php\";s:10:\"exclusions\";a:5:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:27:\"maps.google.com/maps/api/js\";i:3;s:30:\"/wp-includes/js/masonry.min.js\";i:4;s:24:\"/wp-google-map-gold/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:dc12a9b7b9c4c7ce3c532b6b377739f2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677858391;}s:36:\"1f8f9fbf-fbf0-4e3a-b77c-af0fa47e950d\";O:8:\"stdClass\":9:{s:5:\"title\";s:18:\"WP Google Maps Pro\";s:9:\"condition\";s:41:\"wp-google-maps-pro/wp-google-maps-pro.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/wp-google-maps(.*)\";i:3;s:19:\"maps.googleapis.com\";i:4;s:4:\"mgl_\";i:5;s:6:\"wpgmza\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:73:\"Loads map on page load and fixes map not displayed after user interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:87f572f5f0ec143a8fceba77d0616197\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444593;}s:36:\"41e4b98c-e63f-4800-a478-02592562322b\";O:8:\"stdClass\":9:{s:5:\"title\";s:20:\"WP iCal Availability\";s:9:\"condition\";s:45:\"wp-ical-availability/wp-ical-availability.php\";s:10:\"exclusions\";a:4:{i:0;s:41:\"/wp-ical-availability/js/custom-select.js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";i:3;s:22:\"/wp-ical-availability/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:85:\"Fixes error when jQuery is already excluded, & Fully render the calendar on page load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3735ca768ede98b25795f4cb057ff4ed\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444622;}s:36:\"2b06c5b8-dc32-4bb0-8504-3a9f1c3a1ec0\";O:8:\"stdClass\":9:{s:5:\"title\";s:8:\"WP MapIt\";s:9:\"condition\";s:21:\"wp-mapit/wp_mapit.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:32:\"/wp-mapit/wp_mapit/js/leaflet.js\";i:3;s:42:\"/wp-mapit/wp_mapit/js/wp_mapit_multipin.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:28:\"Display the map on page load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ba8d1c7f294a3f5b593556eb3b0bc7d9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443719;}s:36:\"2039eafd-1c11-4e21-a61b-30857f291ae3\";O:8:\"stdClass\":9:{s:5:\"title\";s:18:\"WP Responsive Menu\";s:9:\"condition\";s:41:\"wp-responsive-menu/wp-responsive-menu.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:24:\"/wp-responsive-menu/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:28:\"Render the menu on page load\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:927b8bf7806f2d287559b86a0b455a59\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443736;}s:36:\"e06be942-cccd-4b2d-a268-06dc78f0b820\";O:8:\"stdClass\":9:{s:5:\"title\";s:22:\"WP Search with Algolia\";s:9:\"condition\";s:34:\"wp-search-with-algolia/algolia.php\";s:10:\"exclusions\";a:4:{i:0;s:71:\"/wp-search-with-algolia/js/algoliasearch/dist/algoliasearch-lite.umd.js\";i:1;s:53:\"/wp-search-with-algolia/js/autocomplete-noconflict.js\";i:2;s:67:\"/wp-search-with-algolia/js/autocomplete.js/dist/autocomplete.min.js\";i:3;s:11:\"var algolia\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:57:\"Fixes the search function and its related console errors.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:43267e659d599fbb6b42c719b49bb7a7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443749;}s:36:\"4fc2a7ae-b9e6-410e-93cf-e6d1962add6a\";O:8:\"stdClass\":9:{s:5:\"title\";s:18:\"WP Smart Preloader\";s:9:\"condition\";s:35:\"wp-smart-preloader/wp-preloader.php\";s:10:\"exclusions\";a:2:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:55:\"/wp-smart-preloader/assets/js/wsp-main-script(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:101:\"Allows the preloader to work without user interaction, and resolves GTMetrix/PageSpeed Insights test.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:4fb90fc73fc2b5d1e37ea2dadfd3cef3\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443814;}s:36:\"7ecf40ce-2bcd-412c-bb01-9e71fecf6be8\";O:8:\"stdClass\":9:{s:5:\"title\";s:16:\"WP Store Locator\";s:9:\"condition\";s:37:\"wp-store-locator/wp-store-locator.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:18:\"/wp-store-locator/\";i:3;s:33:\"/wp-includes/js/underscore.min.js\";i:4;s:15:\"maps.google.com\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:26:\"Show the map on page load.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:d37bb5054a24471ca1675d9ab49d01b0\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443828;}s:36:\"7a1d19a2-3a48-40ab-8051-f642fc63ce2d\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"WP Ultimate Post Grid\";s:9:\"condition\";s:47:\"wp-ultimate-post-grid/wp-ultimate-post-grid.php\";s:10:\"exclusions\";a:4:{i:0;s:67:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:1;s:37:\"/wp-ultimate-post-grid/dist/public.js\";i:2;s:53:\"/wp-ultimate-post-grid-premium/dist/public-premium.js\";i:3;s:15:\"wpupg_grid_args\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:40:\"Show the dropdown selector/filter option\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e24341fef49bd64b89682d583218c108\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443858;}s:36:\"76c86163-ddf3-4113-b620-de9d5058f505\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"WPBakery Page Builder\";s:9:\"condition\";s:27:\"js_composer/js_composer.php\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:52:\"/js_composer/assets/js/dist/js_composer_front.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:79:\"Fire sliders, animations, full-width elements resizing without user interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:517d7d24da9a7072ed389d0fb30374a0\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444340;}s:36:\"0b8ff2c0-c3cd-4ec1-b7f5-c7751de6101b\";O:8:\"stdClass\":9:{s:5:\"title\";s:32:\"WPBakery Page Builder - Carousel\";s:9:\"condition\";s:27:\"js_composer/js_composer.php\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:57:\"/js_composer/assets/lib/vc_carousel/js/vc_carousel.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:40:\"Fire carousels without user interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:76336ed3f04df091e669f89d908ef2ed\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444319;}s:36:\"4f5e5b98-c326-4b9f-9ada-3b257862132c\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:1ec7138c950c355e7af60d49c81139fc\";s:5:\"title\";s:12:\"wpDataTables\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"/wpdatatables/\";i:3;s:10:\"highcharts\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:29:\"wpdatatables/wpdatatables.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"18be1b8c-0bc4-4a01-abc6-a127aff380c6\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"WPForms\";s:9:\"condition\";s:19:\"wpforms/wpforms.php\";s:10:\"exclusions\";a:3:{i:0;s:61:\"/wpforms-offline-forms/assets/js/wpforms-offline-forms.min.js\";i:1;s:30:\"wpforms-offline-forms-js-extra\";i:2;s:20:\"wpformsRecaptchaLoad\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:48:\"Prevents issues with redirect to Thank you page.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:c62ca58ea081c1271de8dadfa7daac69\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444513;}s:36:\"138b2894-25d2-47ce-b33d-cbf1256d8f45\";O:8:\"stdClass\":9:{s:5:\"title\";s:20:\"WPForms - Loader GIF\";s:9:\"condition\";s:19:\"wpforms/wpforms.php\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:71:\"/wpforms-conversational-forms/assets/js/conversational-forms.es5.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:88:\"When Delay JavaScript Execution is enabled, the loader GIF stays until user interaction.\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:03dc6ae2848dd60e1d4f4f86015c22f0\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444364;}s:36:\"8a3cacb6-81bd-456a-a1cc-a4025f8e5234\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:0992ac952c0a05bb35e18b1d5744d346\";s:5:\"title\";s:12:\"WPForms Lite\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:20:\"wpformsRecaptchaLoad\";i:1;s:61:\"/wpforms-offline-forms/assets/js/wpforms-offline-forms.min.js\";i:2;s:30:\"wpforms-offline-forms-js-extra\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:24:\"wpforms-lite/wpforms.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"98bbd410-5b01-4244-a8eb-715765180328\";O:8:\"stdClass\":8:{s:5:\"title\";s:29:\"XL WooCommerce Sales Triggers\";s:9:\"condition\";s:63:\"xl-woocommerce-sales-triggers/xl-woocommerce-sales-triggers.php\";s:10:\"exclusions\";a:3:{i:0;s:61:\"/xl-woocommerce-sales-triggers/assets/js/wcst_combined.min.js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ba9e526ddb0157e69757530c6b18b714\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677856813;}s:36:\"bf9f9620-dd0e-4e6f-9a45-4eb78a148f42\";O:8:\"stdClass\":9:{s:5:\"title\";s:36:\"YITH WooCommerce Ajax Product Filter\";s:9:\"condition\";s:41:\"yith-woocommerce-ajax-navigation/init.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:71:\"/yith-woocommerce-ajax-navigation/assets/js/yith-wcan-shortcodes.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:53:\"Display product filters on mobile without interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:58663fc781232169e865f6fe7cf1afaa\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444671;}s:36:\"b053279d-e07c-438c-bb3e-3a1f4f5d7c5e\";O:8:\"stdClass\":9:{s:5:\"title\";s:44:\"YITH WooCommerce AJAX Product Filter Premium\";s:9:\"condition\";s:53:\"yith-woocommerce-ajax-product-filter-premium/init.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:83:\"/yith-woocommerce-ajax-product-filter-premium/assets/js/yith-wcan-shortcodes.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:53:\"Display product filters on mobile without interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:68b637fd247e40c8e135e4771d739b07\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444677;}s:36:\"62056165-8bd9-4ff0-b21f-e4ed0ae45fae\";O:8:\"stdClass\":9:{s:5:\"title\";s:35:\"YITH WooCommerce Points and Rewards\";s:9:\"condition\";s:52:\"yith-woocommerce-points-and-rewards-premium/init.php\";s:10:\"exclusions\";a:3:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:70:\"/yith-woocommerce-points-and-rewards-premium/assets/js/frontend.min.js\";i:2;s:66:\"/woo-variation-swatches-pro/assets/js/add-to-cart-variation.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:55:\"Display rewards points notification without interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:4acc87d4eb72c86cdea76d180b61a098\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444693;}s:36:\"d94dbbf3-bcab-4e47-9fbb-6b3a7cf92787\";O:8:\"stdClass\":8:{s:5:\"title\";s:36:\"Yotpo Social Reviews for Woocommerce\";s:9:\"condition\";s:49:\"yotpo-social-reviews-for-woocommerce/wc_yotpo.php\";s:10:\"exclusions\";a:1:{i:0;s:63:\"/yotpo-social-reviews-for-woocommerce/assets/js/headerScript.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:45ab742b3fccbd04d7bc973c8582be87\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1680686421;}s:36:\"51dccf53-5cc7-4283-9ab1-01d34c6cce22\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"Zoho SalesIQ\";s:9:\"condition\";s:22:\"zoho-salesiq/index.php\";s:10:\"exclusions\";a:1:{i:0;s:12:\"zoho.salesiq\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:32:\"Display chat without interaction\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b96c3865575068aac82c973eb3e3c52a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444708;}}s:6:\"themes\";O:8:\"stdClass\":135:{s:36:\"9aeea459-91d3-44b6-8a26-b883dca8b402\";O:8:\"stdClass\":9:{s:5:\"title\";s:43:\"Agensy - Load page without User Interaction\";s:9:\"condition\";s:6:\"agensy\";s:10:\"exclusions\";a:8:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:28:\"/themes/agensy/js/scripts.js\";i:2;s:35:\"/themes/agensy/js/scripts-single.js\";i:3;s:28:\"/themes/agensy/js/wow.min.js\";i:4;s:33:\"/themes/agensy/js/TweenMax.min.js\";i:5;s:31:\"/themes/agensy/js/swiper.min.js\";i:6;s:73:\"/plugins/visualcomposer/assets/lib/bower/isotope/dist/isotope.pkgd.min.js\";i:7;s:35:\"/wp-includes/js/imagesloaded.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:35:\"Load page without user interaction.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:7ab7dfeb0db9c0c74c020be318c2e6d9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724424755;}s:36:\"9c623554-5834-4669-9e96-1b894c1939b2\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"Andaman\";s:9:\"condition\";s:7:\"andaman\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/andaman/assets/js/\";i:3;s:41:\"/wp-andaman-plugins/shortcodes/vc_extend/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:67:\"Unstuck the page loader (only use when jQuery is already excluded).\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:0193ea55fce2ada93b262f2824008c0f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724424778;}s:36:\"7374c5a5-69f8-460f-b44f-dee884a824cd\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"Artale\";s:9:\"condition\";s:6:\"artale\";s:10:\"exclusions\";a:6:{i:0;s:40:\"/artale-elementor/assets/js/modulobox.js\";i:1;s:47:\"/artale-elementor/assets/js/artale-elementor.js\";i:2;s:28:\"/artale/js/jquery-stellar.js\";i:3;s:33:\"/artale/js/core/artale-plugins.js\";i:4;s:32:\"/artale/js/core/artale-custom.js\";i:5;s:10:\"var loader\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:62:\"Fixes the page loader (not closing) and display the main menu.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:24cbda63f1b898ade5562ab4ec6d97a5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724424807;}s:36:\"23b01203-2a70-4394-9326-d59824def2d7\";O:8:\"stdClass\":9:{s:5:\"title\";s:16:\"Ashe Pro Premium\";s:9:\"condition\";s:16:\"ashe-pro-premium\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:18:\"/ashe-pro-premium/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:46:\"Display mobile header without user interaction\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:4791da3cbbd1ed86253a087f0287aeb4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724426464;}s:36:\"03a9cc62-c167-447d-beb2-65c76c96b056\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"Astra\";s:9:\"condition\";s:5:\"astra\";s:10:\"exclusions\";a:2:{i:0;s:41:\"/astra/assets/js/minified/frontend.min.js\";i:1;s:29:\"replace\\(/woocommerce-no-js/,\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:3cce5f3eaf76e098ba8e28f7bbba3f92\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1712608792;}s:36:\"2a2b54cb-8e1d-49d2-bfca-93eee231e470\";O:8:\"stdClass\":9:{s:5:\"title\";s:16:\"Astra - Carousel\";s:9:\"condition\";s:5:\"astra\";s:10:\"exclusions\";a:2:{i:0;s:9:\"var astra\";i:1;s:38:\"/astra/assets/js/minified/style.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:13:\"Load carousel\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:72a8d63e59c10bdf512a62b862d143a7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724426844;}s:36:\"7783361f-66fc-4d95-a054-4e9545bb5b48\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"Auteur\";s:9:\"condition\";s:13:\"g5plus-auteur\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:36:\"/g5plus-auteur/assets/js/core.min.js\";i:3;s:30:\"/g5plus-auteur/assets/vendors/\";i:4;s:106:\"/auteur-framework/libs/smart-framework/assets/vendors/perfect-scrollbar/js/perfect-scrollbar.jquery.min.js\";i:5;s:35:\"/wp-includes/js/imagesloaded.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:27:\"Fire the slider on pageload\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:6207fe478e269e7547bda70a46607a49\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427467;}s:36:\"4c618038-8fc7-4d48-8d41-a32da14e5c1e\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"AutoTrader\";s:9:\"condition\";s:10:\"autotrader\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/autotrader/(.*).js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:046dfeee2b77390c53e0e7f93b6a3792\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679736741;}s:36:\"18f04f23-35a0-4c45-8cb6-a91d57ca1790\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:835da12f43373029659f766920e81b47\";s:5:\"title\";s:44:\"Avada - Animations & mobile-specific actions\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:31:\"/uploads/fusion-scripts/(.*).js\";i:3;s:18:\"window.off_canvas_\";i:4;s:24:\"/plugins/fusion-builder/\";i:5;s:21:\"/plugins/fusion-core/\";i:6;s:16:\"/Avada/includes/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:5:\"Avada\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"90135867-1b95-498b-80d6-f5dbf2f6b318\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"Avada - FAQ shortcode\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:41:\"/plugins/fusion-core/js/min/avada-faqs.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:47:\"Displays content created with the FAQ shortcode\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b084708c80d8582546e5430219aa4670\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427150;}s:36:\"d23b5bb1-1d7f-4109-bf69-b20a2be2d337\";O:8:\"stdClass\":9:{s:5:\"title\";s:23:\"Avada - Fusion carousel\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:58:\"/includes/lib/assets/min/js/library/jquery.carouFredSel.js\";i:3;s:54:\"/includes/lib/assets/min/js/general/fusion-carousel.js\";i:4;s:18:\"fusionCarouselVars\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:28:\"Display carousel on pageload\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:5e7a2248e1a53d9bb27b187deb541248\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427016;}s:36:\"98dfa8c1-e72a-4cef-a0b2-8f0c322490fc\";O:8:\"stdClass\":9:{s:5:\"title\";s:19:\"Avada - Fusion form\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:52:\"/fusion-builder/assets/js/min/general/fusion-form.js\";i:3;s:59:\"/fusion-builder/assets/js/min/general/fusion-form-logics.js\";i:4;s:44:\"/includes/lib/assets/min/js/library/cssua.js\";i:5;s:45:\"/includes/lib/assets/min/js/general/fusion.js\";i:6;s:48:\"/includes/lib/assets/min/js/library/modernizr.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:25:\"To allow submitting forms\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:f16fb109027f4994a7649a8b1663e6f7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427132;}s:36:\"026801fa-af67-47ba-b966-347693f0585f\";O:8:\"stdClass\":9:{s:5:\"title\";s:27:\"Avada - Fusion grid gallery\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:55:\"/fusion-builder/assets/js/min/general/fusion-gallery.js\";i:3;s:51:\"/includes/lib/assets/min/js/library/imagesLoaded.js\";i:4;s:46:\"/includes/lib/assets/min/js/library/isotope.js\";i:5;s:46:\"/includes/lib/assets/min/js/library/packery.js\";i:6;s:48:\"/includes/lib/assets/min/js/library/lazysizes.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:41:\"Display fusion grid gallery without delay\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:33f50696d353d8bd4eb59ff6e8f44c97\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724426998;}s:36:\"c8349314-15a3-481e-973b-e4d936e4420e\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"Avada - Fusion slider\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:42:\"/fusion-core/js/min/avada-fusion-slider.js\";i:3;s:16:\"/Avada/includes/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:35:\"Display fusion slider without delay\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:56fa9993a573540c83eda9c49fae5e3c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724426978;}s:36:\"7a04bc85-0fec-4487-ae05-bb2e5d8d0420\";O:8:\"stdClass\":9:{s:5:\"title\";s:34:\"Avada - Load Portfolio on pageload\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/library/packery.js\";i:3;s:19:\"/library/isotope.js\";i:4;s:24:\"/library/imagesLoaded.js\";i:5;s:27:\"/general/fusion-lightbox.js\";i:6;s:38:\"/fusion-core/js/min/avada-portfolio.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:26:\"Load Portfolio on pageload\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c3f0ed4d94499b68c77d95db37d1d399\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427228;}s:36:\"55bd510c-78aa-49d5-8304-8be2ee2ab0da\";O:8:\"stdClass\":9:{s:5:\"title\";s:19:\"Avada - Mobile menu\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:36:\"/assets/min/js/general/avada-menu.js\";i:3;s:48:\"/includes/lib/assets/min/js/library/modernizr.js\";i:4;s:52:\"/includes/lib/assets/min/js/library/jquery.easing.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:40:\"Load mobile menu scripts without a delay\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:2189c1c769d65cfc2182e4822847071b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427273;}s:36:\"ddf00672-c35c-4b68-aeca-925e68bf12b2\";O:8:\"stdClass\":9:{s:5:\"title\";s:17:\"Avada - OffCanvas\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:35:\"/uploads/fusion-scripts/(.*).min.js\";i:3;s:18:\"window.off_canvas_\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:48:\"Load Off Canvas pop-ups without user interaction\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:97a185f08af70c39c7e221faab0f73eb\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427179;}s:36:\"17544cc3-9d3a-4611-bc5d-44d04e2786fa\";O:8:\"stdClass\":8:{s:5:\"title\";s:44:\"Avada - Show the Portfolio grid on page load\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:51:\"/includes/lib/assets/min/js/library/imagesLoaded.js\";i:3;s:46:\"/includes/lib/assets/min/js/library/isotope.js\";i:4;s:48:\"/includes/lib/assets/min/js/library/lazysizes.js\";i:5;s:48:\"/includes/lib/assets/min/js/library/modernizr.js\";i:6;s:46:\"/includes/lib/assets/min/js/library/packery.js\";i:7;s:38:\"/fusion-core/js/min/avada-portfolio.js\";i:8;s:18:\"avadaPortfolioVars\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:9d1a9b0c2ca20fca764a82f197b962fd\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1696601823;}s:36:\"c6c3347c-14e0-4766-afa5-df33a47f5a5a\";O:8:\"stdClass\":9:{s:5:\"title\";s:19:\"Avada - Sticky menu\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:42:\"/Avada/assets/min/js/general/avada-menu.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:15:\"Fix sticky menu\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:3ff44421b404c5efffa25e78e479e4ea\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427248;}s:36:\"232596c1-6a6a-4fe8-a5c3-a60fa74a9456\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:0d727d80bb132f17c737e55883fe4be0\";s:5:\"title\";s:35:\"Avada - WooCommerce product gallery\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:50:\"/assets/min/js/general/avada-woo-product-images.js\";i:3;s:56:\"/includes/lib/assets/min/js/library/jquery.flexslider.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:5:\"Avada\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"95ece7e4-3b19-45e5-aa28-14f833c9afca\";O:8:\"stdClass\":9:{s:5:\"title\";s:5:\"Avesa\";s:9:\"condition\";s:5:\"avesa\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:17:\"/avesa/js/main.js\";i:3;s:20:\"/avesa/js/isotope.js\";i:4;s:24:\"/sw_core/js/slick.min.js\";i:5;s:41:\"/avesa/js/bootstrap-datetimepicker.min.js\";i:6;s:26:\"/avesa/js/bootstrap.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:32:\"Display images on product pages.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:aad8bfcc594eec02e3b0d635198dee5e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427449;}s:36:\"f2bfe477-4e45-4e52-a7d9-4d0ba3a92258\";O:8:\"stdClass\":9:{s:5:\"title\";s:4:\"Besa\";s:9:\"condition\";s:4:\"besa\";s:10:\"exclusions\";a:2:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:9:\"/besa/js/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:67:\"Trigger animations and makes the mobile menu immediately responsive\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c238e89523c46ca28b08e401f42f6ccc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427619;}s:36:\"bd94908c-8138-4995-986b-47ec66494bdd\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"BeTheme\";s:9:\"condition\";s:7:\"betheme\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:9:\"/betheme/\";i:2;s:3:\"mfn\";i:3;s:37:\"/wp-includes/js/jquery/ui/tabs.min.js\";i:4;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:67:\"Trigger animations and makes the mobile menu immediately responsive\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b99156eb9eeb357c0a70bd3bda6861cc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427590;}s:36:\"190d2f1a-72a6-40ca-b08a-5c7ee7b0a6a5\";O:8:\"stdClass\":9:{s:5:\"title\";s:54:\"Bosa Online Education - Fixes animations and preloader\";s:9:\"condition\";s:21:\"bosa-online-education\";s:10:\"exclusions\";a:6:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:38:\"/bosa/assets/js/jquery.slicknav.min.js\";i:2;s:31:\"/bosa/assets/slick/slick.min.js\";i:3;s:29:\"/bosa/assets/js/navigation.js\";i:4;s:29:\"/bosa/assets/js/custom.min.js\";i:5;s:43:\"/bosa/assets/js/theia-sticky-sidebar.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:57:\"Fix for the loading animation and displaying mobile menu.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:5430bf7b83c83a3687b3b7b437e961b0\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427748;}s:36:\"6fb2b9d7-6ecc-4260-999c-938fbebdbf01\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:de8504b73ea228d0ea9bbce69752092e\";s:5:\"title\";s:6:\"Bridge\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:27:\"/bridge-creative/bridge/js/\";i:2;s:16:\"/wp-includes/js/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:6:\"bridge\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"1dd63427-b4c9-4596-b952-ac711e3637f9\";O:8:\"stdClass\":8:{s:5:\"title\";s:47:\"Bridge - Load elements without user interaction\";s:9:\"condition\";s:6:\"bridge\";s:10:\"exclusions\";a:5:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:43:\"/wp-content/themes/bridge/js/default.min.js\";i:2;s:39:\"/wp-content/themes/bridge/js/plugins.js\";i:3;s:47:\"/wp-content/themes/bridge/js/default_dynamic.js\";i:4;s:53:\"/wp-content/themes/bridge/js/jquery.touchSwipe.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:ad9b810efd365ad9a27987d2912b94cd\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1710252260;}s:36:\"65698b6b-85dd-41ef-8fd7-718f1e983dba\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"Car Dealer\";s:9:\"condition\";s:9:\"cardealer\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:27:\"/wp-includes/js/jquery/(.*)\";i:3;s:18:\"/cardealer/js/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:34:\"Fix slider and form console errors\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b1111424fff61af8d1e152dcdd6810f6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428045;}s:36:\"3927d724-5a0a-402b-a838-858d30b54ea9\";O:8:\"stdClass\":9:{s:5:\"title\";s:34:\"Cardea - Show Page Content on Load\";s:9:\"condition\";s:9:\"cardea-wp\";s:10:\"exclusions\";a:5:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:28:\"/themes/cardea-wp/js/main.js\";i:2;s:37:\"/themes/cardea-wp/js/jquery.sticky.js\";i:3;s:38:\"/themes/cardea-wp/js/jquery.fitvids.js\";i:4;s:45:\"/themes/cardea-wp/js/jquery.smartmenus.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:25:\"Show content on page load\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d65d1a8303b0c7508278884520e4bec7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428028;}s:36:\"087fb457-a09d-4140-84bd-c9bc1e8195b7\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"CheerUp\";s:9:\"condition\";s:7:\"cheerup\";s:10:\"exclusions\";a:9:{i:0;s:36:\"/cheerup/js/jquery.sticky-sidebar.js\";i:1;s:32:\"/cheerup/js/object-fit-images.js\";i:2;s:29:\"/cheerup/js/jquery.fitvids.js\";i:3;s:34:\"/cheerup/js/jquery.mfp-lightbox.js\";i:4;s:27:\"/cheerup/js/ie-polyfills.js\";i:5;s:20:\"/cheerup/js/theme.js\";i:6;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:7;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:8;s:36:\"/wp-includes/js/jquery/jquery.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:40:\"Fix an issue with the links in the menu.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:13bcf562f45afb245dc4f76fecfba6d6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428063;}s:36:\"eb86aedb-91e6-480c-b76c-756ac1da41be\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"Clover\";s:9:\"condition\";s:12:\"clover-theme\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"/clover-theme/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:24:\"Load the hamburger menu.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:89372f3d9321ae09c94488592084da29\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428083;}s:36:\"6e90b649-5736-497f-9bc6-515900cfea8a\";O:8:\"stdClass\":8:{s:5:\"title\";s:17:\"Divi - Animations\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\".dipi_preloader_wrapper_outer\";i:3;s:23:\"/Divi/js/scripts.min.js\";i:4;s:26:\"/Divi/js/custom.unified.js\";i:5;s:21:\"/js/magnific-popup.js\";i:6;s:8:\"var DIVI\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c0abf30dba4ff13db836d1b01685953a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737389;}s:36:\"70916c43-4e02-4932-b6aa-91a1815bc755\";O:8:\"stdClass\":9:{s:5:\"title\";s:23:\"Divi - Background video\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:22:\"/jquery-migrate.min.js\";i:2;s:26:\"/Divi/js/custom.unified.js\";i:3;s:21:\"/js/mediaelement/(.*)\";i:4;s:4:\"mejs\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:34:\"Play video background on page load\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c7edea41ae6716291e2d32a2ab429209\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428928;}s:36:\"08531785-9818-4e30-903e-564637a2ad7a\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"Divi - Counter module\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\".dipi_preloader_wrapper_outer\";i:3;s:23:\"/Divi/js/scripts.min.js\";i:4;s:26:\"/Divi/js/custom.unified.js\";i:5;s:21:\"/js/magnific-popup.js\";i:6;s:8:\"var DIVI\";i:7;s:71:\"/Divi/includes/builder/feature/dynamic-assets/assets/js/easypiechart.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:44:\"Compatibility with the Number Counter module\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:2c46b9f5a770f260c3f7115bb330b2d5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429005;}s:36:\"1d63dd7c-7bc7-4629-b03d-0437e177af32\";O:8:\"stdClass\":8:{s:5:\"title\";s:42:\"Divi - Load Animated Elements on Page Load\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:4:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:23:\"/Divi/js/scripts.min.js\";i:2;s:71:\"/Divi/includes/builder/feature/dynamic-assets/assets/js/easypiechart.js\";i:3;s:69:\"/Divi/includes/builder/feature/dynamic-assets/assets/js/salvattore.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:5df38c80278da90f725c16d68ea25aa1\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1719498170;}s:36:\"b996762a-84ef-440d-a089-73a187936fbf\";O:8:\"stdClass\":9:{s:5:\"title\";s:18:\"Divi - Mobile menu\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:22:\"/jquery-migrate.min.js\";i:2;s:23:\"/Divi/js/scripts.min.js\";i:3;s:26:\"/Divi/js/custom.unified.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:43:\"Avoids a double tap to open the mobile menu\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b9116994f4e4b9b9fa574440c00d2f0d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428978;}s:36:\"ae096e1e-9c36-46ad-a3d1-c26ea507276b\";O:8:\"stdClass\":9:{s:5:\"title\";s:22:\"Divi - Sticky elements\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\".dipi_preloader_wrapper_outer\";i:3;s:23:\"/Divi/js/scripts.min.js\";i:4;s:74:\"/Divi/includes/builder/feature/dynamic-assets/assets/js/sticky-elements.js\";i:5;s:8:\"var DIVI\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:36:\"Enable sticky elements on page load.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:8b62db03c90245f3e690335b079b05dc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724428907;}s:36:\"349f31f0-dd10-41d3-b0a4-9c5df64879f8\";O:8:\"stdClass\":9:{s:5:\"title\";s:18:\"Divi - Sticky menu\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:32:\"/js/jquery/jquery-migrate.min.js\";i:2;s:23:\"/Divi/js/scripts.min.js\";i:3;s:73:\"/Divi/includes/builder/feature/dynamic-assets/assets/js/magnific-popup.js\";i:4;s:12:\"jqueryParams\";i:5;s:11:\"firstHeader\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:127:\"Hide sticky menu on page load.\r\n\r\nAvoid white flash when using this trick to prevent Divi\'s own flashing: \r\n\r\nelm.style.display\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b7b84aca0f0dc6a1ced31d38626c50ea\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429206;}s:36:\"59563458-5f04-4959-b3e2-53e49e169d67\";O:8:\"stdClass\":8:{s:5:\"title\";s:40:\"Divi - WooCommerce Single Product Images\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:1:{i:0;s:23:\"/Divi/js/scripts.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:f9c5bdba8b39fc877b41dea00fa756f9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1684342262;}s:36:\"6426539e-4e43-4fef-ab5a-3eb7b2a8b057\";O:8:\"stdClass\":9:{s:5:\"title\";s:5:\"Eikra\";s:9:\"condition\";s:5:\"eikra\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:22:\"/jquery-migrate.min.js\";i:2;s:17:\"/eikra/assets/js/\";i:3;s:8:\"EikraObj\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:28:\"Fixes preloader not closing.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:55d2581ad975eb6325bc97fc3d3b0cb8\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429672;}s:36:\"59020bd6-069f-4f2d-afa2-fbdefa03211c\";O:8:\"stdClass\":9:{s:5:\"title\";s:4:\"Ekko\";s:9:\"condition\";s:4:\"ekko\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:6:\"/ekko/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:41:\"Fixes preloader (blank page) not closing.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:2c06f4a1949f8ba4e77042a47674fd9e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724429886;}s:36:\"d82f5cdd-c5d3-4596-94dc-1e25aaff2083\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Elessi\";s:9:\"condition\";s:12:\"elessi-theme\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:44:\"/elessi-theme/assets/js/min/functions.min.js\";i:3;s:39:\"/elessi-theme/assets/js/min/main.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d5d2b7fda7b8a2b5b91d430f7602e230\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737773;}s:36:\"f0587c21-54d0-429d-8efe-18a93dacb18d\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:5fc04cc678cb54567aedb51027933002\";s:5:\"title\";s:6:\"Enfold\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:41:\"/dynamic_avia/avia-footer-scripts-(.*).js\";i:3;s:18:\"var avia_is_mobile\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:6:\"enfold\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"c93ee1ee-3956-4278-9ee9-1a0968753e86\";O:8:\"stdClass\":8:{s:5:\"title\";s:27:\"Enfold - Fix hamburger menu\";s:9:\"condition\";s:6:\"enfold\";s:10:\"exclusions\";a:5:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:41:\"/enfold/js/avia-snippet-hamburger-menu.js\";i:2;s:18:\"/enfold/js/avia.js\";i:3;s:24:\"/enfold/js/shortcodes.js\";i:4;s:33:\"/enfold/js/waypoints/waypoints.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:2b0c22c5169b94c2eabb125d18915246\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1715090218;}s:36:\"cc0550cb-918e-419d-b4f2-1809cf666dbb\";O:8:\"stdClass\":9:{s:5:\"title\";s:20:\"Enfold - LayerSlider\";s:9:\"condition\";s:6:\"enfold\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"layerslider\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:88:\"Loads the slider without user interaction when using Enfold\'s Layerslider implementation\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:eb759a03d0ca292c948f09d004a2963f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724430516;}s:36:\"ec883654-4f63-4fae-a3ef-923dcbc2426d\";O:8:\"stdClass\":8:{s:5:\"title\";s:19:\"Enfold - Shortcodes\";s:9:\"condition\";s:6:\"enfold\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:25:\"/enfold/js/avia(.min)?.js\";i:3;s:31:\"/enfold/js/shortcodes(.min)?.js\";i:4;s:47:\"/enfold/config-templatebuilder/avia-shortcodes/\";i:5;s:32:\"/enfold/js/avia-compat(.min)?.js\";i:6;s:37:\"/enfold/js/waypoints/waypoints.min.js\";i:7;s:31:\"/enfold/js/avia-snippet-(.*).js\";i:8;s:28:\"/enfold/js/avia-js(.min)?.js\";i:9;s:52:\"/enfold/js/aviapopup/jquery.magnific-popup(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:072fc4077d7071791d774d6ddbf5dc2a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1712954619;}s:36:\"fe3546f0-be3e-4173-8992-a7f6f203b82f\";O:8:\"stdClass\":8:{s:5:\"title\";s:8:\"Envision\";s:9:\"condition\";s:8:\"envision\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:27:\"/envision/lib/js/app.min.js\";i:3;s:13:\"var CloudFwOp\";}s:10:\"is_default\";i:1;s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:fc5f7d69b646ed95835badc0fc23bc11\";s:10:\"created_at\";i:1679737494;}s:36:\"d997b942-19de-4710-9c81-79d3c65cbd76\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"Ewebot\";s:9:\"condition\";s:6:\"ewebot\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:17:\"/gt3-themes-core/\";i:3;s:27:\"/uploads/gt3-assets/js/(.*)\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:195:\"Fire animations on pageload.\r\n\r\nAllow the page to load without interaction.\r\n\r\n/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\r\n/jquery-migrate(.min)?.js\r\n/wp-content/themes/ewebot/dist/js/theme.js\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:047f009f2a1f4cdf2088c46be47e385b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724430887;}s:36:\"53d29aec-8ae4-4273-b748-f5bd52dfe177\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"Farvis\";s:9:\"condition\";s:6:\"farvis\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:8:\"/farvis/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:49:\"Fire animations and layout rendering on pageload.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:26bff2f3a6ff6347d35edf5c77a35687\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724430981;}s:36:\"fb01246b-a5f8-4021-b514-c02cf55e80bd\";O:8:\"stdClass\":9:{s:5:\"title\";s:8:\"Flatsome\";s:9:\"condition\";s:8:\"flatsome\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:31:\"/flatsome/assets/js/flatsome.js\";i:3;s:41:\"/flatsome/assets/libs/packery.pkgd.min.js\";i:4;s:34:\"/flatsome/assets/js/woocommerce.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:69:\"Avoid homepage slider delay. Allow zoom on the product image gallery.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:26fb1cf80f074ca199d8a7e94c5fc796\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431063;}s:36:\"4d65dc12-9ce7-4171-94a7-9821fd95240e\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"Flatsome - Google map\";s:9:\"condition\";s:8:\"flatsome\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"maps.googleapis.com\";i:3;s:18:\"google.maps.LatLng\";i:4;s:34:\"/wp-includes/js/hoverIntent.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:28:\"Show Google Map on page load\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:28a6f8b3319c107a34603be0f01a4bcf\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431100;}s:36:\"890e15b6-c66b-4a9e-9b7d-55417df94916\";O:8:\"stdClass\":9:{s:5:\"title\";s:17:\"Flatsome - Images\";s:9:\"condition\";s:8:\"flatsome\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:58:\"/flatsome/inc/integrations/wp-rocket/flatsome-wp-rocket.js\";i:3;s:31:\"/flatsome/assets/js/flatsome.js\";i:4;s:65:\"/flatsome/inc/extensions/flatsome-lazy-load/flatsome-lazy-load.js\";i:5;s:34:\"/wp-includes/js/hoverIntent.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:33:\"Allow images to load immediately.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:f2d60aad9f2f5395e3e145cf8f8ab165\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1725978870;}s:36:\"ee1a892b-c906-4e35-8684-827919f64bef\";O:8:\"stdClass\":9:{s:5:\"title\";s:19:\"Foxiz - Load Slider\";s:9:\"condition\";s:5:\"foxiz\";s:10:\"exclusions\";a:5:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:39:\"/themes/foxiz/assets/js/rbswiper.min.js\";i:2;s:34:\"/plugins/foxiz-core/assets/core.js\";i:3;s:33:\"/themes/foxiz/assets/js/global.js\";i:4;s:46:\"/themes/foxiz/assets/js/jquery.ui.totop.min.js\";}s:7:\"summary\";s:153:\"When Delay JavaScript Execution is enabled, the slider doesn\'t load until there is a user interaction. These exclusions make the slider load immediately.\";s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:ee6e7f08495a961a7bcbfe4e0a283b6e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1725039417;}s:36:\"cb54d070-8ee0-4c35-9fa9-b2bac73ccf39\";O:8:\"stdClass\":9:{s:5:\"title\";s:5:\"Frida\";s:9:\"condition\";s:5:\"frida\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:7:\"/frida/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:82:\"Display images without user interaction and avoid issues with simpleLighbox images\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:109ddf56796a5133e12279f3daa5ff62\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431195;}s:36:\"435fe79f-47ba-422e-aca6-cea566f6b8a1\";O:8:\"stdClass\":9:{s:5:\"title\";s:13:\"Gardena Theme\";s:9:\"condition\";s:7:\"gardena\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:9:\"/gardena/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:98:\"Fixes the error message for Largest contentful paint in PageSpeed report, when feature is enabled.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:993e6f0fc44b9e55c0a565b84a449340\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431464;}s:36:\"9e78539a-03d9-442b-ab94-dd3b7a9658e4\";O:8:\"stdClass\":9:{s:5:\"title\";s:27:\"GeneratePress - Mobile menu\";s:9:\"condition\";s:13:\"generatepress\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/generatepress/assets/js/menu.min.js\";i:1;s:17:\"generatepressMenu\";i:2;s:49:\"/gp-premium/menu-plus/functions/js/offside.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:128:\"Fixes the mobile menu requiring a double touch, if touching the mobile menu is the first interaction of a visitor with the page.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:80a330247d61d729fcd78dc01de6ed2f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431524;}s:36:\"7d2a6472-83d4-4620-8b9e-ff8872b98c1c\";O:8:\"stdClass\":9:{s:5:\"title\";s:14:\"Genesis sample\";s:9:\"condition\";s:22:\"genesis-sample-develop\";s:10:\"exclusions\";a:7:{i:0;s:21:\"/jquery/jquery.min.js\";i:1;s:29:\"/jquery/jquery-migrate.min.js\";i:2;s:22:\"/js/hoverIntent.min.js\";i:3;s:21:\"/genesis/lib/js/menu/\";i:4;s:33:\"/genesis/lib/js/skip-links.min.js\";i:5;s:28:\"/custom-genesis/js/custom.js\";i:6;s:31:\"var c = document.body.classList\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:117:\"https://github.com/wp-media/delay-javascript-loading/issues/33#issuecomment-1201266660 , display mobile menu with DJS\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:7c14d7a05ad7f4f39b719e015a4723ff\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1727089078;}s:36:\"02d47d01-56f5-4801-b319-cff1707dd59d\";O:8:\"stdClass\":9:{s:5:\"title\";s:37:\"Harmuny - Modern WordPress Blog Theme\";s:9:\"condition\";s:7:\"harmuny\";s:10:\"exclusions\";a:2:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:9:\"/harmuny/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:40:\"Load slideshow without user interaction.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:1ff9662c2a3e3221052cbe229feed18c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724427976;}s:36:\"6373bbb2-877c-4075-b6e4-7c58d686b25c\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"HealthFirst\";s:9:\"condition\";s:11:\"healthfirst\";s:10:\"exclusions\";a:7:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:34:\"/wp-includes/js/hoverIntent.min.js\";i:2;s:70:\"/wp-content/plugins/healthfirst-core/assets/js/healthfirst-core.min.js\";i:3;s:74:\"/wp-content/plugins/healthfirst-core/assets/plugins/modernizr/modernizr.js\";i:4;s:101:\"/wp-content/plugins/healthfirst-core/assets/plugins/perfect-scrollbar/perfect-scrollbar.jquery.min.js\";i:5;s:52:\"/wp-content/themes/healthfirst/assets/js/main.min.js\";i:6;s:83:\"/wp-content/themes/healthfirst/assets/plugins/waitforimages/jquery.waitforimages.js\";}s:7:\"summary\";s:69:\"When Delay JavaScript Execution is enabled, there are console errors.\";s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:882ee30ccc8ed2b36e93c7b6e2c4b98e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431542;}s:36:\"2c72e7e6-cb77-44e9-af87-d5c42ae6db52\";O:8:\"stdClass\":9:{s:5:\"title\";s:20:\"Honor - WPBakery fix\";s:9:\"condition\";s:5:\"honor\";s:10:\"exclusions\";a:3:{i:0;s:22:\"/honor/js/__scripts.js\";i:1;s:13:\"HONOR_STORAGE\";i:2;s:13:\"/js_composer/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:74:\"Only required if used with WPBakery plugin to fix some dependencies issues\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:9f228373ff4d172655dbf5cb3b1bc23a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431564;}s:36:\"9309d1d3-1035-4a2c-8ced-075bc3ff9957\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"HotelMaster\";s:9:\"condition\";s:11:\"hotelmaster\";s:10:\"exclusions\";a:7:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:38:\"/hotelmaster/javascript/gdlr-script.js\";i:3;s:48:\"/hotelmaster/plugins/dl-menu/modernizr.custom.js\";i:4;s:45:\"/hotelmaster/plugins/dl-menu/jquery.dlmenu.js\";i:5;s:46:\"/hotelmaster/plugins/superfish/js/superfish.js\";i:6;s:37:\"/hotelmaster/plugins/jquery.easing.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:54:\"Fixes double touch required to use the menu on mobile.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:978eaddad3b1047e479407b6d92197aa\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431621;}s:36:\"4a09f745-cbb1-47c8-b50a-c8014d5d1335\";O:8:\"stdClass\":9:{s:5:\"title\";s:18:\"HotelMaster - Blog\";s:9:\"condition\";s:11:\"hotelmaster\";s:10:\"exclusions\";a:3:{i:0;s:30:\"/wp-includes/js/masonry.min.js\";i:1;s:44:\"/gp-premium/blog/functions/js/scripts.min.js\";i:2;s:35:\"/wp-includes/js/imagesloaded.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:14:\"Loads the blog\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:e813a548bceac6765a1cdf2316f1a6ab\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431587;}s:36:\"f2d8f704-ec68-4278-9ca2-885daa0c1ce5\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"HotelMaster - Masonry\";s:9:\"condition\";s:11:\"hotelmaster\";s:10:\"exclusions\";a:2:{i:0;s:49:\"/gp-premium/menu-plus/functions/js/offside.min.js\";i:1;s:7:\"offSide\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:72:\"Display blog archive posts in a masonry layout without user interaction.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:398a264e302e42640553681e8759cd07\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431607;}s:36:\"92b2e258-1f44-41c1-b1bd-f117f61ee49d\";O:8:\"stdClass\":9:{s:5:\"title\";s:31:\"Jannah Theme - Fix masonry grid\";s:9:\"condition\";s:6:\"jannah\";s:10:\"exclusions\";a:4:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:30:\"/wp-includes/js/masonry.min.js\";i:2;s:44:\"/wp-includes/js/jquery/jquery.masonry.min.js\";i:3;s:4:\"tie-\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:16:\"Fix masonry grid\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:35f7f183089309f52046377ca65e905a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432477;}s:36:\"df52436c-53d6-461a-b81a-cd0b21680524\";O:8:\"stdClass\":9:{s:5:\"title\";s:5:\"JNews\";s:9:\"condition\";s:5:\"jnews\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:22:\"/jquery-migrate.min.js\";i:2;s:17:\"/jnews/assets/js/\";i:3;s:5:\"jnews\";i:4;s:4:\"jfla\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:108:\"Toggle the search box on mobile.\r\n\r\nLoad images without interaction:\r\n\r\n/jnews/assets/js/modernizr-custom.js\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:5d90e451984f9d894b1aabb0d00f30a2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432551;}s:36:\"87ed69a2-3295-4fad-a82e-eeb02925a5dc\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"Jobify\";s:9:\"condition\";s:6:\"jobify\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:24:\"/jobify/js/jobify.min.js\";i:3;s:30:\"/jobify/js/select2.full.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:64:\"Prevent white space on the mobile header before user interaction\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:592006aa4562a6915e344e5e2a09e5ee\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432575;}s:36:\"28a0b1ea-8d2f-4931-a48a-166b8df8a773\";O:8:\"stdClass\":9:{s:5:\"title\";s:4:\"JOYN\";s:9:\"condition\";s:4:\"joyn\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:81:\"/swift-framework/includes/page-builder/frontend-assets/js/lib/modernizr-custom.js\";i:3;s:78:\"/swift-framework/includes/page-builder/frontend-assets/js/spb-functions.min.js\";i:4;s:68:\"/swift-framework/includes/swift-slider/assets/js/swift-slider.min.js\";i:5;s:55:\"/swift-framework/public/js/lib/imagesloaded.pkgd.min.js\";i:6;s:28:\"/joyn/js/owl.carousel.min.js\";i:7;s:25:\"/joyn/js/theme-scripts.js\";i:8;s:21:\"/joyn/js/functions.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:51:\"Prevent the page from not loading on mobile devices\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c395470ad2d4d681836cd942bbb03120\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432590;}s:36:\"542be60a-2346-4740-9a41-8a580c4f013c\";O:8:\"stdClass\":9:{s:5:\"title\";s:9:\"Juno Toys\";s:9:\"condition\";s:8:\"junotoys\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:22:\"/jquery-migrate.min.js\";i:2;s:28:\"/junotoys/fw/js/core.init.js\";i:3;s:29:\"/junotoys/fw/js/core.utils.js\";i:4;s:28:\"/junotoys/fw/js/superfish.js\";i:5;s:32:\"/junotoys/fw/js/swiper/swiper.js\";i:6;s:41:\"/trx_utils/shortcodes/theme.shortcodes.js\";i:7;s:30:\"/wp-includes/js/jquery/ui/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:36:\"Display the swiper/carousel products\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:2acab38e8356d36355bb81d931e7fba4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432608;}s:36:\"06167710-10c7-446e-a08b-ce676e444102\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"Jupiter\";s:9:\"condition\";s:7:\"jupiter\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"/jupiter/\";i:3;s:33:\"/wp-includes/js/underscore.min.js\";i:4;s:12:\"WebFont.load\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:89c5c30498c2989611f9044be006197c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738430;}s:36:\"5d042e1f-7e62-4ec4-ba31-30d396004522\";O:8:\"stdClass\":8:{s:5:\"title\";s:8:\"JupiterX\";s:9:\"condition\";s:8:\"jupiterx\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:17:\"/jupiterx/(.*).js\";i:3;s:33:\"/wp-includes/js/underscore.min.js\";i:4;s:12:\"WebFont.load\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b06632962a4948d4944fd8d79ffbfceb\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737312;}s:36:\"c4b030ea-66a1-4729-85bf-a484e373a316\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"Kadence\";s:9:\"condition\";s:7:\"kadence\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/kadence/assets/js/navigation.min.js\";i:1;s:22:\"mobile_menu_breakpoint\";i:2;s:13:\"kadenceConfig\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:56:\"Avoid double click to open mobile menu and search button\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:4b7907ee68218db279648da9bf7102d1\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432769;}s:36:\"20c605b4-3e3a-4bb0-a5e5-a08e2cb0f31f\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"Kalium\";s:9:\"condition\";s:6:\"kalium\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\"/kalium/assets/js/main.min.js\";i:3;s:22:\"mobile_menu_breakpoint\";i:4;s:6:\"var _k\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:25:\"Fixes the hamburger menu.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:1fcb99a1ab06e1e36635365ed3e59ce5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432784;}s:36:\"e1e04a7d-635a-4e28-83d9-e345ce40e354\";O:8:\"stdClass\":9:{s:5:\"title\";s:4:\"Kava\";s:9:\"condition\";s:4:\"kava\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:31:\"/kava/assets/js/theme-script.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:29:\"Fixes the header color issue.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:359d67efbf530c998245225dd3245a88\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432796;}s:36:\"e833c36e-ee89-4924-b608-3f28327c2f85\";O:8:\"stdClass\":9:{s:5:\"title\";s:3:\"Lay\";s:9:\"condition\";s:3:\"lay\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:31:\"/wp-includes/js/backbone.min.js\";i:2;s:33:\"/wp-includes/js/underscore.min.js\";i:3;s:5:\"/lay/\";i:4;s:19:\"/laytheme-carousel/\";i:5;s:15:\"window.laytheme\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:34:\"Start showing content on pageload.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:7c718c6da874ea6e4b27c6d70bc4e7e8\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432836;}s:36:\"2df2ef47-a833-4711-ba54-48dc62586f37\";O:8:\"stdClass\":9:{s:5:\"title\";s:8:\"LazaNews\";s:9:\"condition\";s:8:\"lazanews\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:17:\"/jquery.custom.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:79:\"Prevents the page preloading animation from being stuck until user interaction.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:85d9922ac61ed833fd047a67029df8e5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432810;}s:36:\"9443304a-34e9-4700-a03a-5f8f62f83ed1\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"Listeo\";s:9:\"condition\";s:6:\"listeo\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/listeo/js/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:27:\"Render the page on pageload\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:db7da585545001f5ae614a2810f08f3a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432849;}s:36:\"77afa73c-c4a8-42a8-aaee-43f6a761364e\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"ListingPro\";s:9:\"condition\";s:10:\"listingpro\";s:10:\"exclusions\";a:13:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:62:\"/listingpro/assets/lib/jquerym.menu/js/jquery.mmenu.min.all.js\";i:3;s:73:\"/listingpro/assets/lib/Magnific-Popup-master/jquery.magnific-popup.min.js\";i:4;s:41:\"/listingpro/assets/js/select2.full.min.js\";i:5;s:49:\"/listingpro/assets/js/jquery.city-autocomplete.js\";i:6;s:42:\"/listingpro/assets/js/chosen.jquery.min.js\";i:7;s:55:\"/listingpro/assets/lib/bootstrap/js/bootstrap-slider.js\";i:8;s:34:\"/listingpro/assets/js/jquery-ui.js\";i:9;s:31:\"/listingpro/assets/js/mapbox.js\";i:10;s:29:\"/listingpro/assets/js/main.js\";i:11;s:46:\"/listingpro/assets/js/leaflet.markercluster.js\";i:12;s:4:\"maps\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:41:\"Display the map and avoid console errors.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:0b365e43dfc65d2b1b70fac6510c7c9c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432862;}s:36:\"01b369b5-b578-4314-8e95-40b67a41d75a\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"Master Study\";s:9:\"condition\";s:11:\"masterstudy\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:32:\"/masterstudy/assets/js/custom.js\";i:3;s:50:\"/masterstudy/assets/vendors/jquery.fancybox.min.js\";i:4;s:42:\"/masterstudy/assets/js/select2.full.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:79:\"Prevents the page preloading animation from being stuck until user interaction.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:0ee224c20e4ef7d546733d933db598f2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432905;}s:36:\"6b000cc7-d33b-4109-9c39-6119a5d81cde\";O:8:\"stdClass\":9:{s:5:\"title\";s:4:\"Maya\";s:9:\"condition\";s:4:\"maya\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\"/maya/js/jquery.mobilemenu.js\";i:3;s:25:\"/maya/js/jquery.custom.js\";i:4;s:38:\"/maya/core/includes/js/jquery.tipsy.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:88:\"Convert the mobile menu into a selector form on mobile devices without user interaction.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:719fe28004fcdd81a820602924aa8074\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432964;}s:36:\"ef3c76d6-1041-473d-81ea-a5a6e8c86735\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"MH Magazine\";s:9:\"condition\";s:11:\"mh-magazine\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:13:\"/mh-magazine/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:27:\"Display menus on page load.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:2a0cd6efc2f46be69de61712729a2ec9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433164;}s:36:\"9cbb2777-5524-43b8-af36-692b27452c0d\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"Minimog\";s:9:\"condition\";s:7:\"minimog\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"/minimog/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:27:\"Display menus on page load.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:61c0c235042359ee7d2a9035e79a7da2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433180;}s:36:\"7eb81c74-8062-4a6c-bf66-b7c5bc160141\";O:8:\"stdClass\":9:{s:5:\"title\";s:15:\"Moozo Elementor\";s:9:\"condition\";s:15:\"moozo-elementor\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:39:\"/moozo-elementor/assets/js/countdown.js\";i:3;s:57:\"/moozo-elementor/assets/vendor/countdown/countdown.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:48:\"Display the countdown timer without interaction.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:2ddb538c8e6b6c766fffd0d5c861fd82\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433254;}s:36:\"e90b7bfa-9ff6-4e1a-bf29-6207d55fdd39\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"Motor\";s:9:\"condition\";s:5:\"motor\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:10:\"/motor/js/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b33538179f5661a86cbe327a1793e199\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1683973354;}s:36:\"445e625a-f955-41fa-84de-65d9ea19be07\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"My Listing\";s:9:\"condition\";s:10:\"my-listing\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/my-listing/assets/\";i:3;s:41:\"/wp-includes/js/dist/vendor/moment.min.js\";i:4;s:19:\"maps.googleapis.com\";i:5;s:9:\"MyListing\";i:6;s:17:\"_Explore_Settings\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:30:\"Show the content on page load:\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:afacb777229ddf5cabceacc64948057d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433267;}s:36:\"677d9967-ca17-4602-8f63-4c3937f7a5c2\";O:8:\"stdClass\":9:{s:5:\"title\";s:28:\"Nature One PRO - Nivo Slider\";s:9:\"condition\";s:13:\"natureone-pro\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:10:\"nivoSlider\";}s:7:\"summary\";s:96:\"When Delay JavaScript Execution is enabled, the Nivo Slider doesn\'t load until user interaction.\";s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:53ae74a161c1588f5539b6883825d3ee\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1729860774;}s:36:\"00b8cd2d-2781-4fbb-ac5d-00750ba94ac9\";O:8:\"stdClass\":9:{s:5:\"title\";s:18:\"Neve - Mobile menu\";s:9:\"condition\";s:4:\"neve\";s:10:\"exclusions\";a:1:{i:0;s:40:\"/neve/assets/js/build/modern/frontend.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:54:\"Prevents the need for a double tap on the mobile menu.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:5ae731cc06dd9284f8172675a6fe81ab\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432677;}s:36:\"483abc54-f1fc-47dc-bfc1-a269c7d1c849\";O:8:\"stdClass\":9:{s:5:\"title\";s:18:\"Newspaper - Images\";s:9:\"condition\";s:9:\"Newspaper\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"tagdiv_theme.min.js\";i:3;s:13:\"tdBlocksArray\";i:4;s:33:\"/wp-includes/js/underscore.min.js\";i:5;s:28:\"/td-cloud-library/assets/js/\";i:6;s:44:\"/npm/slick-carousel@1.8.1/slick/slick.min.js\";i:7;s:16:\"tdb-gallery-wrap\";i:8;s:13:\"tdBlocksArray\";i:9;s:4:\"tdb_\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:26:\"Loads images without delay\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:649ff22527bac2b1c8e0115cd3851d53\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432710;}s:36:\"50db8d14-d421-4237-be14-a6f7b5c11ec5\";O:8:\"stdClass\":9:{s:5:\"title\";s:28:\"Newspaper - Slider & YouTube\";s:9:\"condition\";s:9:\"Newspaper\";s:10:\"exclusions\";a:14:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"tagdiv_theme.min.js\";i:3;s:13:\"tdBlocksArray\";i:4;s:11:\"tdb_globals\";i:5;s:19:\"td_youtube_list_ids\";i:6;s:9:\"iosSlider\";i:7;s:53:\"/td-cloud-library/assets/js/js_files_for_front.min.js\";i:8;s:33:\"/wp-includes/js/underscore.min.js\";i:9;s:28:\"/td-cloud-library/assets/js/\";i:10;s:44:\"/npm/slick-carousel@1.8.1/slick/slick.min.js\";i:11;s:16:\"tdb-gallery-wrap\";i:12;s:13:\"tdBlocksArray\";i:13;s:4:\"tdb_\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:48:\"Render the slider and Youtube videos on pageload\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:7e2eeee57ae458c5959342eda6526bf1\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432700;}s:36:\"514f4c30-2b67-4648-960e-dfe1cc401ca5\";O:8:\"stdClass\":9:{s:5:\"title\";s:4:\"Niva\";s:9:\"condition\";s:4:\"niva\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"/niva/js/\";i:3;s:26:\"/sweetthemes-framework/js/\";i:4;s:8:\"mt_typed\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:42:\"Trigger the page loader and the typewriter\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c4838f73a344b829ed626635e210dcf4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432724;}s:36:\"e67ee504-c3b1-455e-88ab-1fae8c830652\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"OceanWP\";s:9:\"condition\";s:7:\"oceanwp\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"/oceanwp/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:56:\"Fixes some non-function breaking browser console errors.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:db37af4b7d12695d37d9256313a5f37a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432755;}s:36:\"e44e240a-8765-4f4f-b67e-d54e4b727506\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"OceanWP - Mobile menu\";s:9:\"condition\";s:7:\"oceanwp\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:45:\"/ocean-side-panel/assets/js/side-panel.min.js\";i:3;s:39:\"/oceanwp/assets/js/theme.vanilla.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:32:\"Avoids double tap on mobile menu\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:9babbcd52b2ce558d299a06cd1130a11\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724432740;}s:36:\"897b0100-958d-4a02-b6b2-1e753e9869f4\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"PenNews\";s:9:\"condition\";s:7:\"pennews\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:25:\"/pennews/js/script.min.js\";i:3;s:29:\"/pennews/js/script.lib.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:85:\"When the theme\'s lazyload functionality is used, lazyload images without interaction.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:02811fa00bc1471bb5be0457ce0ee005\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724433732;}s:36:\"edd3ba03-e0fd-4b6e-911b-60b29f3471bf\";O:8:\"stdClass\":9:{s:5:\"title\";s:15:\"Pharmacy Mentor\";s:9:\"condition\";s:14:\"pharmacymentor\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:16:\"/pharmacymentor/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:39:\"Load slider and animations on pageload.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:3188aaf1ef2c39937450f2a14ebb1174\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724442943;}s:36:\"725415ff-cc76-45cc-a131-3170e5aa30fc\";O:8:\"stdClass\":9:{s:5:\"title\";s:5:\"Porto\";s:9:\"condition\";s:5:\"porto\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:26:\"/wp-includes/js/jquery/ui/\";i:3;s:18:\"/porto/js/theme.js\";i:4;s:22:\"/porto/js/theme.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:15:\"Load animations\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:8493f398f200c8dffe60d46439dd3360\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724442964;}s:36:\"2c19bcec-f3ff-4873-bfd7-db6bc0f6433c\";O:8:\"stdClass\":9:{s:5:\"title\";s:20:\"Porto - Owl Carousel\";s:9:\"condition\";s:5:\"porto\";s:10:\"exclusions\";a:6:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:26:\"/wp-includes/js/jquery/ui/\";i:2;s:25:\"/porto/js/theme(|.min).js\";i:3;s:37:\"/porto/js/libs/owl.carousel(|.min).js\";i:4;s:31:\"/porto/js/theme-async(|.min).js\";i:5;s:41:\"/prettyPhoto/jquery.prettyPhoto(|.min).js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:37:\"Load Owl Carousel without interaction\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:f34f5199fb7fca78852cd3fb7758f178\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724442974;}s:36:\"5b11ec89-1cb2-4793-8b77-79e917e810a0\";O:8:\"stdClass\":9:{s:5:\"title\";s:35:\"Pro Theme - Fix menu and accordions\";s:9:\"condition\";s:3:\"pro\";s:10:\"exclusions\";a:2:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:50:\"/pro/cornerstone/assets/js/site/cs-classic.(.*).js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:23:\"Fix menu and accordions\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:8f30d70dd2d9a0386445aef8fdd534a9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443035;}s:36:\"31347ccb-f69e-4cd3-bd47-b80ce14ac76e\";O:8:\"stdClass\":9:{s:5:\"title\";s:8:\"ProPhoto\";s:9:\"condition\";s:9:\"prophoto7\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:29:\"/prophoto7/js/bundle.front.js\";i:2;s:33:\"/wp-includes/js/underscore.min.js\";i:3;s:8:\"PROPHOTO\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:15:\"Fire animations\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:a5836a56c4472fade4dc6ebfe2281554\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443049;}s:36:\"a8208c04-865c-49aa-ab96-41e378d391c8\";O:8:\"stdClass\":9:{s:5:\"title\";s:9:\"Publisher\";s:9:\"condition\";s:9:\"publisher\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:14:\"/publisher/js/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:91:\"Make the mobile menu expend from the first click and the cookie notice to show on pageload.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:32c73be0cb175da278c8e2af0811b0d1\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443063;}s:36:\"a0d69f3d-1356-4a1d-a600-2f2f788b8a9a\";O:8:\"stdClass\":9:{s:5:\"title\";s:5:\"REHub\";s:9:\"condition\";s:11:\"rehub-theme\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:36:\"/rehub-theme/js/custom_floatpanel.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:19:\"Fix the sticky menu\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:321af1febb74f488cf911380893739b2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434339;}s:36:\"8b74bbe5-7f32-42df-908f-78c99a8cad82\";O:8:\"stdClass\":9:{s:5:\"title\";s:3:\"Rey\";s:9:\"condition\";s:3:\"rey\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:20:\"/rey/scripts-(.*).js\";i:3;s:20:\"/rey-core/assets/js/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:44:\"Fix the sticky menu on mobile and animations\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:e46567cd0f3ec9b37e7230dc87eac367\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434354;}s:36:\"5c9115d3-bcbd-49d6-8feb-4880d2b82bfe\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"Rife Free\";s:9:\"condition\";s:9:\"rife-free\";s:10:\"exclusions\";a:5:{i:0;s:27:\"/rife-free/js/script.min.js\";i:1;s:33:\"/rife-free/js/isotope.pkgd.min.js\";i:2;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:3;s:25:\"/jquery-migrate(.min)?.js\";i:4;s:8:\"var reJS\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:74a449954de79625eccc6750e87af8f6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738107;}s:36:\"6542b2fd-1f91-4862-aa18-11eecc02faaf\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Roisin\";s:9:\"condition\";s:6:\"roisin\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:36:\"/themes/roisin/assets/js/main.min.js\";i:3;s:49:\"/plugins/roisin-core/assets/js/roisin-core.min.js\";i:4;s:34:\"/wp-includes/js/hoverIntent.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:8f38fe58034772931110930b91cb6797\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1685964523;}s:36:\"5a192ad9-d150-4aa0-8efc-d68131cb7a37\";O:8:\"stdClass\":9:{s:5:\"title\";s:20:\"Sahifa - Mobile Menu\";s:9:\"condition\";s:6:\"sahifa\";s:10:\"exclusions\";a:3:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:37:\"/themes/sahifa/js/ilightbox.packed.js\";i:2;s:23:\"/translate_a/element.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:52:\"Allow mobile menu slideout to work for Safari mobile\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:06ebe49f4c1e5b04cece831f8bb198a3\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434427;}s:36:\"7ae9d978-d63c-4a58-beb3-418bebb5b23c\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"Salient\";s:9:\"condition\";s:7:\"salient\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"/salient/\";i:3;s:12:\"winW > bodyW\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:85:\"Close mobile menu when using anchor links & Show the menu and animations on page load\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b3e12d57ac23897be1bb2c673e3fc761\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434525;}s:36:\"35aaa6c5-4a37-4161-b504-fb3ebc4b1148\";O:8:\"stdClass\":9:{s:5:\"title\";s:23:\"Salient - Nectar slider\";s:9:\"condition\";s:7:\"salient\";s:10:\"exclusions\";a:3:{i:0;s:42:\"/salient-nectar-slider/js/nectar-slider.js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:35:\"load the images without interaction\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d612db1dd8dc76faa6a36a9ebfd336dc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434498;}s:36:\"84c95206-3e59-4eb3-a0c9-e2231a1c0a48\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"SEO Lounge\";s:9:\"condition\";s:9:\"seolounge\";s:10:\"exclusions\";a:4:{i:0;s:67:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:1;s:52:\"/js_composer/assets/js/dist/js_composer_front.min.js\";i:2;s:37:\"/seolounge/js/radiantthemes-custom.js\";i:3;s:39:\"/seolounge/js/radiantthemes-core.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:84:\"Avoid the loader being delayed so the page can be displayed before user interaction.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:3d72b779d9c4ba6b51cc5b245b141433\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434624;}s:36:\"cd44aa56-088a-40dd-bf1e-f835efa68626\";O:8:\"stdClass\":9:{s:5:\"title\";s:11:\"Shoptimizer\";s:9:\"condition\";s:11:\"shoptimizer\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:37:\"/shoptimizer/assets/js/lazyload-bg.js\";i:3;s:34:\"/shoptimizer/assets/js/main.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:61:\"Shows background images and fix the double tap on mobile menu\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:6c32b43f4da639e5901574fac6b7d387\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434579;}s:36:\"d2c48a48-430a-4eea-bc05-99b66f1f6a7b\";O:8:\"stdClass\":9:{s:5:\"title\";s:8:\"SmartMag\";s:9:\"condition\";s:9:\"smart-mag\";s:10:\"exclusions\";a:1:{i:0;s:25:\"/smart-mag/js/lazyload.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:69:\"Fixes the images not being displayed because of the theme\'s Lazyload.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:23d6b7878bd0087addb067db3fa39864\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434887;}s:36:\"dd0d9133-ef17-4dac-b174-9f25d535838f\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"Soledad\";s:9:\"condition\";s:7:\"soledad\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/soledad/js/main.js\";i:3;s:24:\"/soledad/js/more-post.js\";i:4;s:30:\"/soledad/js/libs-script.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:69:\"Fixes the images not being displayed because of the theme\'s Lazyload.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d3f78b26c2d11c99230171cc6378d06e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434902;}s:36:\"3b85dd6e-9534-477e-9b15-940d0e155c8d\";O:8:\"stdClass\":9:{s:5:\"title\";s:22:\"Spacious - Mobile Menu\";s:9:\"condition\";s:8:\"spacious\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:26:\"/spacious/js/navigation.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:32:\"Fixes mobile menu functionality.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d423c1f002b10b8682ee24d616b19c9c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434916;}s:36:\"d657dc56-5c04-439a-8987-401f89a65bf9\";O:8:\"stdClass\":9:{s:5:\"title\";s:9:\"Stockholm\";s:9:\"condition\";s:9:\"stockholm\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"/stockholm/js/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:46:\"To show the logo and prevent JavaScript errors\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:fcfff492e00727b63cf5dff9f59bc2a4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443889;}s:36:\"121f9b1b-d3cd-4dde-915e-0b348abf6687\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"Storefront\";s:9:\"condition\";s:10:\"storefront\";s:10:\"exclusions\";a:1:{i:0;s:39:\"/storefront/assets/js/navigation.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:144:\"Reveals menu from the first click.\r\n\r\nSome elements on the page (Link sliders) are showed on page load:\r\n\r\n/storefront/assets/js/homepage.min.js\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:f0dca7e4eaedf573d4664be249845942\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443926;}s:36:\"41cfc83f-ff02-4a35-a3b7-e92db213b224\";O:8:\"stdClass\":9:{s:5:\"title\";s:10:\"StreamTube\";s:9:\"condition\";s:10:\"streamtube\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:12:\"/streamtube/\";i:3;s:17:\"/streamtube-core/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:52:\"Fixes the display video error on the mobile version.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:9772ccddd470688f6bc6aee86e34d29b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444002;}s:36:\"c31366fe-9045-4767-a405-52a11e08b82e\";O:8:\"stdClass\":9:{s:5:\"title\";s:35:\"Sydney - Load elements on page load\";s:9:\"condition\";s:13:\"sydney-pro-ii\";s:10:\"exclusions\";a:6:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:46:\"/wp-content/themes/sydney-pro-ii/js/scripts.js\";i:2;s:52:\"/wp-content/themes/sydney-pro-ii/js/functions.min.js\";i:3;s:48:\"/wp-content/themes/sydney-pro-ii/js/elementor.js\";i:4;s:50:\"/wp-content/themes/sydney-pro-ii/js/hero-slider.js\";i:5;s:45:\"/wp-content/plugins/sydney-toolbox/js/main.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:47:\"Load elements on pages without user interaction\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:1fb15693856451537e331adeaf2c7d6f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724442744;}s:36:\"aec0a548-4c6b-400a-80ed-19a49e0faef0\";O:8:\"stdClass\":9:{s:5:\"title\";s:4:\"The7\";s:9:\"condition\";s:7:\"dt-the7\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:14:\"loader-removed\";i:3;s:34:\"/Ultimate_VC_Addons/assets/min-js/\";i:4;s:9:\"/dt-the7/\";i:5;s:13:\"/js_composer/\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:37:\"Remove the loader and fire animations\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:7934c689fd20e30b6bfc69bb9d46cb63\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443079;}s:36:\"538354ff-d69f-40be-b0cc-df3790599dd2\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"TheGem\";s:9:\"condition\";s:6:\"thegem\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/thegem/js/\";i:3;s:11:\"gemSettings\";i:4;s:15:\"thegemSlideshow\";i:5;s:19:\"tgpLazyItemsOptions\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:66:\"To show the logo, slider, animations and prevent JavaScript errors\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:153c54fe73897da838ce39152b1db5a8\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444019;}s:36:\"84d95a79-270c-4223-b459-bb49c6acfaf1\";O:8:\"stdClass\":8:{s:5:\"title\";s:29:\"Theme Electiman - Mobile Menu\";s:9:\"condition\";s:9:\"electiman\";s:10:\"exclusions\";a:8:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:41:\"/themes/electiman/assets/js/navigation.js\";i:2;s:45:\"/themes/electiman/assets/js/theme-pluginjs.js\";i:3;s:36:\"/themes/electiman/assets/js/theme.js\";i:4;s:40:\"/themes/electiman/assets/js/slick.min.js\";i:5;s:40:\"/themes/electiman/venobox/venobox.min.js\";i:6;s:47:\"/themes/electiman/assets/js/owl.carousel.min.js\";i:7;s:35:\"/wp-includes/js/imagesloaded.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:a59c888391c869ed4f3417c02d71fe15\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1702923332;}s:36:\"3a59bf59-4fe5-4690-8ab7-33e6a976e2e3\";O:8:\"stdClass\":8:{s:5:\"title\";s:20:\"Thrive Theme Builder\";s:9:\"condition\";s:12:\"thrive-theme\";s:10:\"exclusions\";a:12:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:52:\"/thrive-visual-editor/editor/js/dist/modules/(.*).js\";i:3;s:38:\"TVE_Event_Manager_Registered_Callbacks\";i:4;s:12:\"ThriveGlobal\";i:5;s:9:\"TCB_Front\";i:6;s:8:\"TL_Front\";i:7;s:7:\"TVE_Ult\";i:8;s:7:\"thrive-\";i:9;s:7:\"thrive_\";i:10;s:4:\"tve_\";i:11;s:4:\"tve-\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:7492fc8f8a90ad7ef680d9c560da2b0f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1710767440;}s:36:\"68f2de3b-e2b8-4edf-b82f-93fd7834c65f\";O:8:\"stdClass\":9:{s:5:\"title\";s:5:\"Total\";s:9:\"condition\";s:5:\"Total\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\"/Total/assets/js/total.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:24:\"Allow the search to work\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:96b0141273eabab320119c467cdcaf17\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444033;}s:36:\"6dc1cb35-6b50-4da0-9834-dddf169edaa6\";O:8:\"stdClass\":9:{s:5:\"title\";s:7:\"Townhub\";s:9:\"condition\";s:7:\"townhub\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:31:\"/townhub-add-ons/assets/js/(.*)\";i:3;s:36:\"/wp-includes/js/dist/vendor/react.js\";i:4;s:40:\"/wp-includes/js/dist/vendor/react-dom.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:38:\"Prevent add-ons from breaking the site\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:7c37c885d7fecf788f635734f99e8610\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444055;}s:36:\"f484f86b-e316-4871-9322-dee3925349fe\";O:8:\"stdClass\":9:{s:5:\"title\";s:29:\"Travel Monster - Owl Carousel\";s:9:\"condition\";s:14:\"travel-monster\";s:10:\"exclusions\";a:3:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:87:\"/wp-content/plugins/wp-travel-engine/assets/lib/owl-carousel(.*)/owl.carousel(|.min).js\";i:2;s:9:\"var isRtl\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:49:\"Load Owl Carousel Slider without user interaction\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d3e8da87b3affd399205438fbc8a4f05\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444075;}s:36:\"3ec96c3f-a6bf-4748-9b7e-78864bd24add\";O:8:\"stdClass\":9:{s:5:\"title\";s:21:\"uDesign - Mobile Menu\";s:9:\"condition\";s:8:\"u-design\";s:10:\"exclusions\";a:4:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:50:\"/wp-content/themes/u-design/assets/js/theme.min.js\";i:2;s:64:\"/wp-content/themes/u-design/framework/assets/js/framework.min.js\";i:3;s:70:\"/wp-content/themes/u-design/framework/assets/js/framework-async.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:38:\"Keep the mobile menu working properly.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:31ce70b0a02f8720a86d993816676943\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444158;}s:36:\"cb523239-27cc-461e-973d-c984a83223ac\";O:8:\"stdClass\":9:{s:5:\"title\";s:35:\"uDesign - Show Page Content on Load\";s:9:\"condition\";s:8:\"u-design\";s:10:\"exclusions\";a:3:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:50:\"/wp-content/themes/u-design/assets/js/theme.min.js\";i:2;s:64:\"/wp-content/themes/u-design/framework/assets/js/framework.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:54:\"Display page content on load without user interaction.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c55edd40ad3f9321da577dad70bb130c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444147;}s:36:\"14cb0a85-8bee-491e-99d7-5f20a07f4bdd\";O:8:\"stdClass\":9:{s:5:\"title\";s:6:\"Uncode\";s:9:\"condition\";s:6:\"uncode\";s:10:\"exclusions\";a:11:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:33:\"/uncode/library/js/init(.min)?.js\";i:3;s:36:\"/uncode/library/js/plugins(.min)?.js\";i:4;s:32:\"/uncode/library/js/app(.min)?.js\";i:5;s:47:\"/uncode/library/js/woocommerce-uncode(.min)?.js\";i:6;s:59:\"/wp-includes/js/mediaelement/mediaelement-and-player.min.js\";i:7;s:10:\"initHeader\";i:8;s:7:\"initBox\";i:9;s:13:\"fixMenuHeight\";i:10;s:7:\"initRow\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:50:\"Hides Uncode\'s preloader without user interaction.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:18ba19b98aefbb6c0fde6c6bf92e9cfc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444172;}s:36:\"96aa49eb-6372-4b4c-b70d-f29dede8a8f2\";O:8:\"stdClass\":9:{s:5:\"title\";s:31:\"Utouch - Load menu on page load\";s:9:\"condition\";s:6:\"utouch\";s:10:\"exclusions\";a:7:{i:0;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:1;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:2;s:18:\"/utouch/js/main.js\";i:3;s:31:\"/utouch/js/swiper.jquery.min.js\";i:4;s:21:\"/utouch/js/fitvids.js\";i:5;s:27:\"/utouch/js/theme-plugins.js\";i:6;s:28:\"/utouch/js/crum-mega-menu.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:26:\"Display menu on page load.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:18284bf26abf49a1d5d60b3fb34e4c2d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444186;}s:36:\"a1fbf155-720a-4704-9794-d6749ad6df59\";O:8:\"stdClass\":9:{s:5:\"title\";s:27:\"Vivo theme - Fix blank page\";s:9:\"condition\";s:4:\"vivo\";s:10:\"exclusions\";a:2:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:46:\"/vivo/framework/assets/js/bt_framework_misc.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:19:\"Fixes a blank page.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:a140e640fed504586e24e7c0df30376b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444202;}s:36:\"5acb5d19-caa6-4deb-b7db-0051df4c3c3b\";O:8:\"stdClass\":8:{s:5:\"title\";s:11:\"Voxel Theme\";s:9:\"condition\";s:5:\"voxel\";s:10:\"exclusions\";a:7:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:7:\"/voxel/\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:26:\"ElementorProFrontendConfig\";i:6;s:23:\"elementorFrontendConfig\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:240a2be0a2b66b01f83abdcd83da7c7c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1720444241;}s:36:\"88e96479-1aa2-4adc-8f07-20bc0368a63f\";O:8:\"stdClass\":9:{s:5:\"title\";s:9:\"Werkstatt\";s:9:\"condition\";s:9:\"werkstatt\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:21:\"/js/underscore.min.js\";i:3;s:34:\"/werkstatt/assets/js/vendor.min.js\";i:4;s:38:\"/werkstatt/assets/js/fullscreen.min.js\";i:5;s:31:\"/werkstatt/assets/js/app.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:36:\"Show animated elements on page load.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:38faa29db5a07b8fef6aee9cc11cafec\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444798;}s:36:\"60c4110b-a960-4d44-b619-6d79514dbf75\";O:8:\"stdClass\":9:{s:5:\"title\";s:8:\"Woodmart\";s:9:\"condition\";s:8:\"woodmart\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:3;s:24:\"/woodmart/js/scripts/wc/\";i:4;s:28:\"/woodmart/js/scripts/global/\";i:5;s:37:\"/woodmart/js/libs/owl.carousel.min.js\";i:6;s:33:\"/woodmart/js/libs/owl.carousel.js\";i:7;s:26:\"/woodmart/js/libs/slick.js\";i:8;s:37:\"/woodmart/js/libs/autocomplete.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:68:\"Show WooCommerce thumbnails on pageload & Show product image gallery\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:06338f13cb89e5309ad2eb7e4d457be4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444297;}s:36:\"a4547b5b-10ab-407c-969c-269fddec07b8\";O:8:\"stdClass\":9:{s:5:\"title\";s:25:\"Woodmart - Cart Fragments\";s:9:\"condition\";s:8:\"woodmart\";s:10:\"exclusions\";a:4:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:53:\"/woocommerce/assets/js/frontend/cart-fragments.min.js\";i:2;s:49:\"/woocommerce/assets/js/js-cookie/js.cookie.min.js\";i:3;s:49:\"/woodmart/js/scripts/wc/updateCartFragmentsFix.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:51:\"Fix problem with the quantity icon of the mini cart\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:591f4f1b2e86b1e987cd8789df3ffce3\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444280;}s:36:\"c385fdb6-ac41-4b00-a350-1e2e82445e22\";O:8:\"stdClass\":9:{s:5:\"title\";s:15:\"Woodmart - Menu\";s:9:\"condition\";s:8:\"woodmart\";s:10:\"exclusions\";a:4:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:49:\"/themes/woodmart/js/scripts/global/helpers.min.js\";i:2;s:51:\"/themes/woodmart/js/scripts/menu/menuOffsets.min.js\";i:3;s:38:\"/themes/woodmart/js/libs/swiper.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:200:\"When Delay JavaScript Execution is enabled, menu dropdowns won\'t work consistently when clicked (seems to happen if page is refreshed and no user interaction happens until after page is fully loaded).\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d8453e5704ad631dd785e452ce75c9f6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1729535544;}s:36:\"97066e39-027a-4cd6-9152-7b6b53f365f5\";O:8:\"stdClass\":9:{s:5:\"title\";s:22:\"Woodmart - Mobile Menu\";s:9:\"condition\";s:8:\"woodmart\";s:10:\"exclusions\";a:3:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:56:\"/themes/woodmart/js/scripts/menu/mobileNavigation.min.js\";i:2;s:49:\"/themes/woodmart/js/scripts/global/helpers.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:46:\"Allow mobile menu to work with just one click.\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d79a3941e2f12fb93ffc980ebeb1d7f4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444264;}s:36:\"b654d55b-8094-40a6-b145-48572d2c396d\";O:8:\"stdClass\":9:{s:5:\"title\";s:24:\"Woodmart - Sticky Header\";s:9:\"condition\";s:8:\"woodmart\";s:10:\"exclusions\";a:3:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:49:\"/themes/woodmart/js/scripts/global/helpers.min.js\";i:2;s:55:\"/themes/woodmart/js/scripts/header/headerBuilder.min.js\";}s:7:\"summary\";s:104:\"When Delay JavaScript Execution is enabled, the header is no longer sticky when scrolling down the page.\";s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:aa0d7919216f3bb2e405069d206dfda4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1729604626;}s:36:\"119ebd1c-6b46-4f07-8d6a-3498d9c8814f\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"XStore\";s:9:\"condition\";s:6:\"xstore\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/xstore/js/\";i:3;s:66:\"/et-core-plugin/packages/st-woo-swatches/public/js/frontend.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:3de9d9ba385200548f177d9c704ae92a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738190;}s:36:\"9a7a548c-07a1-4dff-93fc-6e8230b67853\";O:8:\"stdClass\":9:{s:5:\"title\";s:12:\"YOOtheme Pro\";s:9:\"condition\";s:8:\"yootheme\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:12:\"uikit.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:65:\"Show animations and image in header on page load.\r\n\r\n\r\n/yootheme/\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:119d329456073aa10969d7cbd9760f28\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444774;}s:36:\"f74c499e-b7d9-4590-8671-379f51f468c8\";O:8:\"stdClass\":9:{s:5:\"title\";s:4:\"Zeen\";s:9:\"condition\";s:4:\"zeen\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:16:\"/zeen/assets/js/\";i:3;s:17:\"/js.cookie.min.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:29:\"Starts animations on pageload\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:acb52844f996627788836366404a3245\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444815;}}s:7:\"scripts\";O:8:\"stdClass\":17:{s:36:\"dd0c5a5b-ec56-49f9-9aa4-89e1e3a6a28a\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"Amazon Ads\";s:10:\"exclusions\";a:1:{i:0;s:19:\"amazon-adsystem.com\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:15:\"To show the ads\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:b82a5936d8ea0745016caeb71629ae5d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724424847;}s:36:\"980edf32-c64b-4370-bf23-c62b079e71c3\";O:8:\"stdClass\":7:{s:5:\"title\";s:14:\"Google AdSense\";s:10:\"exclusions\";a:1:{i:0;s:11:\"adsbygoogle\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:0206e6040c8ff64b8d6ee5fef2ce1c90\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681377840;}s:36:\"2499bb90-0753-4b2b-9bd4-1525f94c7437\";O:8:\"stdClass\":7:{s:5:\"title\";s:16:\"Google Analytics\";s:10:\"exclusions\";a:3:{i:0;s:33:\"google-analytics.com/analytics.js\";i:1;s:6:\"ga\\( \'\";i:2;s:5:\"ga\\(\'\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:d86cf69a8b82547a94ca3f6a307cf9a6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681388311;}s:36:\"6f460036-3106-4b8c-9951-d32de9b1258f\";O:8:\"stdClass\":7:{s:5:\"title\";s:11:\"Google Maps\";s:10:\"exclusions\";a:2:{i:0;s:19:\"maps.googleapis.com\";i:1;s:15:\"maps.google.com\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:4d60ab2c6d11d753267484006c23e54c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681390259;}s:36:\"ac2d5720-9418-468c-80a0-3874ee743c0f\";O:8:\"stdClass\":8:{s:5:\"title\";s:15:\"Google Optimize\";s:10:\"exclusions\";a:3:{i:0;s:17:\"a,s,y,n,c,h,i,d,e\";i:1;s:30:\"googleoptimize.com/optimize.js\";i:2;s:10:\"async-hide\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:34:\"Prevent a flicker or blank screen.\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:031a0cece38c4739df67f910dcabf1bd\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431722;}s:36:\"122e6ebb-51fd-477f-97fb-559593f1a48b\";O:8:\"stdClass\":8:{s:5:\"title\";s:16:\"Google Recaptcha\";s:10:\"exclusions\";a:1:{i:0;s:9:\"recaptcha\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:51:\"Fixes dependency issues related to Google Recaptcha\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:032cb16577cbf07bc7c02bac83bd936d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431739;}s:36:\"219277ae-b2ac-4d42-913d-eaea40985295\";O:8:\"stdClass\":7:{s:5:\"title\";s:18:\"Google Tag Manager\";s:10:\"exclusions\";a:4:{i:0;s:8:\"/gtag/js\";i:1;s:6:\"gtag\\(\";i:2;s:7:\"/gtm.js\";i:3;s:10:\"async-hide\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:1d3c65b2b03ef35e14df6b163ea3a1f6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681390266;}s:36:\"f632e3f4-20e6-471e-a78d-86afbea63586\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"HubSpot\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:18:\"js(.*).hsforms.net\";i:3;s:18:\"hbspt.forms.create\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:16:\"Display the form\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:de4bd8ef4675ebb85a055955de76d0ee\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724431936;}s:36:\"5d606add-ffb8-4a06-b295-5f722710fbfd\";O:8:\"stdClass\":7:{s:5:\"title\";s:6:\"Refari\";s:10:\"exclusions\";a:2:{i:0;s:16:\"widget.refari.co\";i:1;s:6:\"refari\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:a705e197b13b47e72a105c923e044358\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1683797056;}s:36:\"742ec14a-27a1-4789-b9c8-a9c3a3cf7042\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"Reviews.io\";s:10:\"exclusions\";a:2:{i:0;s:35:\"/carousel-inline-iframeless/dist.js\";i:1;s:20:\"carouselInlineWidget\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:33:\"Prevents the widget from breaking\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:4df445c576f45889506ba175a4c39fdc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724442776;}s:36:\"05d3eb78-f574-49be-95e1-3f11714005d1\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Stripe\";s:10:\"exclusions\";a:1:{i:0;s:13:\"js.stripe.com\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:43:\"Fixes ReferenceError: Stripe is not defined\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:ce7566d1d08cc094b74cf283cf9c56a5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724434974;}s:36:\"0a37e528-8718-49f7-a26d-059aa29f867d\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"Trustindex\";s:10:\"exclusions\";a:2:{i:0;s:27:\"cdn.trustindex.io/loader.js\";i:1;s:32:\"cdn.trustindex.io/loader-cert.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:39:\"Trustindex element is shown immediately\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:1d38d6195597e8bb81966870f0a4f939\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724442852;}s:36:\"ce9a3865-9efa-4e98-ae10-4f842a4ecc22\";O:8:\"stdClass\":8:{s:5:\"title\";s:8:\"Typeform\";s:10:\"exclusions\";a:1:{i:0;s:14:\"/next/embed.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:34:\"Load Typeforms without interaction\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:cd3889ae3b96f891186ae270dbbcc9bb\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443247;}s:36:\"b56bf06c-2f8c-4757-b536-a689fb0e75f9\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"Typekit\";s:10:\"exclusions\";a:1:{i:0;s:7:\"typekit\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:31:\"Load Typekit fonts on page load\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:7815e38b93e3b500a632681bd594bd61\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724443267;}s:36:\"49c38c0a-43b9-4237-88cb-57ddd519f0ad\";O:8:\"stdClass\":8:{s:5:\"title\";s:13:\"Venatus Media\";s:10:\"exclusions\";a:2:{i:0;s:18:\"/ad-manager.min.js\";i:1;s:8:\"__vm_add\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:22:\"Show ads on page load.\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:abe11528732aed9a19a97e73b242faa5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444833;}s:36:\"2c1d0998-8ab5-478c-8eb9-9e375b46363e\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Wistia\";s:10:\"exclusions\";a:2:{i:0;s:15:\"fast.wistia.com\";i:1;s:24:\"/assets/external/E-v1.js\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:23:\"Show video on page load\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:9a0111f8c3186c1cb3113587c660c041\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444846;}s:36:\"0627fe24-7e9d-400f-b064-d98bec2ba85e\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"Yandex Ads\";s:10:\"exclusions\";a:2:{i:0;s:9:\"yandex.ru\";i:1;s:18:\"window.yaContextCb\";}s:8:\"icon_url\";s:0:\"\";s:7:\"summary\";s:31:\"Display Ads without interaction\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:dbd1875130c71eb4b2ef768ad18d820c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1724444653;}}}","off");

INSERT IGNORE INTO `ee3j5m0_options` VALUES 
("1358","_transient_timeout_wpr_dynamic_lists","1731072191","off"),
("1359","_transient_wpr_dynamic_lists","O:8:\"stdClass\":14:{s:28:\"rucss_inline_atts_exclusions\";a:18:{i:0;s:26:\"rocket-lazyload-inline-css\";i:1;s:35:\"divi-style-parent-inline-inline-css\";i:2;s:14:\"gsf-custom-css\";i:3;s:29:\"extra-style-inline-inline-css\";i:4;s:30:\"woodmart-inline-css-inline-css\";i:5;s:30:\"woodmart_shortcodes-custom-css\";i:6;s:29:\"rs-plugin-settings-inline-css\";i:7;s:28:\"divi-style-inline-inline-css\";i:8;s:27:\"tcb-post-list-dynamic-style\";i:9;s:6:\"n2-ss-\";i:10;s:6:\"wpcf7-\";i:11;s:32:\"siteorigin-panels-layouts-footer\";i:12;s:28:\"xstore-inline-css-inline-css\";i:13;s:17:\"assets.reviews.io\";i:14;s:8:\"ezoicCSS\";i:15;s:4:\"stk-\";i:16;s:28:\"rocket-lazyrender-inline-css\";i:17;s:13:\"umsMapStyles_\";}s:31:\"rucss_inline_content_exclusions\";a:48:{i:0;s:14:\".wp-container-\";i:1;s:13:\".wp-elements-\";i:2;s:16:\"#wpv-expandable-\";i:3;s:16:\".custom-content-\";i:4;s:5:\"#thb-\";i:5;s:16:\".et_pb_text_dap_\";i:6;s:24:\"#gdlr-core-shape-divider\";i:7;s:8:\"#ultib3-\";i:8;s:10:\".uvc-wrap-\";i:9;s:26:\".jet-listing-dynamic-post-\";i:10;s:6:\".vcex_\";i:11;s:20:\".wprm-advanced-list-\";i:12;s:9:\".adsslot_\";i:13;s:7:\".jnews_\";i:14;s:21:\".cp-info-bar.content-\";i:15;s:16:\"#stockie-custom-\";i:16;s:13:\"#ohio-custom-\";i:17;s:5:\".uid-\";i:18;s:15:\"#wpfMainWrapper\";i:19;s:7:\"#penci_\";i:20;s:7:\"#penci-\";i:21;s:7:\".wpbs_s\";i:22;s:8:\"#apcore_\";i:23;s:8:\"#apress_\";i:24;s:6:\"#zolo_\";i:25;s:30:\".extended-products-grid#style-\";i:26;s:27:\".preloader#style-preloader-\";i:27;s:16:\".thegem-heading-\";i:28;s:15:\".thegem-button-\";i:29;s:15:\".thegem-custom-\";i:30;s:14:\".thegem-popup-\";i:31;s:9:\"#pattern-\";i:32;s:20:\"#thegem-video-frame-\";i:33;s:8:\"#thegem-\";i:34;s:14:\".qwery_inline_\";i:35;s:19:\".dcgd_submit_button\";i:36;s:8:\".irs-bar\";i:37;s:14:\".gallery-grid-\";i:38;s:13:\".cmplz-hidden\";i:39;s:13:\"#sqbquizouter\";i:40;s:19:\"#start_sqbquizouter\";i:41;s:13:\".flo-header--\";i:42;s:19:\".trx_addons_inline_\";i:43;s:21:\".wpp-cardview-compact\";i:44;s:13:\".e-loop-item-\";i:45;s:26:\".tiered-pricing-plain-text\";i:46;s:26:\".vc_cta3_content-container\";i:47;s:21:\".vc_btn-gradient-btn-\";}s:26:\"defer_js_inline_exclusions\";a:10:{i:0;s:16:\"DOMContentLoaded\";i:1;s:14:\"document.write\";i:2;s:22:\"window.lazyLoadOptions\";i:3;s:5:\"N.N2_\";i:4;s:18:\"rev_slider_wrapper\";i:5;s:18:\"FB3D_CLIENT_LOCALE\";i:6;s:19:\"ewww_webp_supported\";i:7;s:21:\"anr_captcha_field_div\";i:8;s:24:\"renderInvisibleReCaptcha\";i:9;s:17:\"bookingInProgress\";}s:28:\"defer_js_external_exclusions\";a:37:{i:0;s:15:\"gist.github.com\";i:1;s:22:\"content.jwplatform.com\";i:2;s:14:\"js.hsforms.net\";i:3;s:16:\"www.uplaunch.com\";i:4;s:20:\"google.com/recaptcha\";i:5;s:20:\"widget.reviews.co.uk\";i:6;s:29:\"verify.authorize.net/anetseal\";i:7;s:43:\"lib/admin/assets/lib/webfont/webfont.min.js\";i:8;s:18:\"app.mailerlite.com\";i:9;s:17:\"widget.reviews.io\";i:10;s:35:\"simplybook.(.*)/v2/widget/widget.js\";i:11;s:32:\"/wp-includes/js/dist/i18n.min.js\";i:12;s:79:\"/wp-content/plugins/wpfront-notification-bar/js/wpfront-notification-bar(.*).js\";i:13;s:64:\"/wp-content/plugins/oxygen/component-framework/vendor/aos/aos.js\";i:14;s:70:\"/wp-content/plugins/ewww-image-optimizer/includes/check-webp(.min)?.js\";i:15;s:34:\"static.mailerlite.com/data/(.*).js\";i:16;s:37:\"cdn.voxpow.com/static/libs/v1/(.*).js\";i:17;s:40:\"cdn.voxpow.com/media/trackers/js/(.*).js\";i:18;s:15:\"use.typekit.net\";i:19;s:15:\"www.idxhome.com\";i:20;s:44:\"/wp-includes/js/dist/vendor/lodash(.min)?.js\";i:21;s:40:\"/wp-includes/js/dist/api-fetch(.min)?.js\";i:22;s:35:\"/wp-includes/js/dist/i18n(.min)?.js\";i:23;s:49:\"/wp-includes/js/dist/vendor/wp-polyfill(.min)?.js\";i:24;s:34:\"/wp-includes/js/dist/url(.min)?.js\";i:25;s:36:\"/wp-includes/js/dist/hooks(.min)?.js\";i:26;s:21:\"www.paypal.com/sdk/js\";i:27;s:18:\"js-eu1.hsforms.net\";i:28;s:18:\"yanovis.Voucher.js\";i:29;s:76:\"/carousel-upsells-and-related-product-for-woocommerce/assets/js/glide.min.js\";i:30;s:15:\"use.typekit.com\";i:31;s:39:\"/artale/modules/kirki/assets/webfont.js\";i:32;s:21:\"/api/scripts/lb_cs.js\";i:33;s:27:\"js.hscta.net/cta/current.js\";i:34;s:16:\"widget.refari.co\";i:35;s:20:\"player.vdocipher.com\";i:36;s:60:\"/wp-content/plugins/wp-rocket/assets/js/lcp-beacon(.min)?.js\";}s:19:\"delay_js_exclusions\";a:74:{i:0;s:10:\"nowprocket\";i:1;s:31:\"/wp-includes/js/wp-embed.min.js\";i:2;s:15:\"lazyLoadOptions\";i:3;s:13:\"lazyLoadThumb\";i:4;s:33:\"wp-rocket/assets/js/lazyload/(.*)\";i:5;s:30:\"et_core_page_resource_fallback\";i:6;s:25:\"window.\\$us === undefined\";i:7;s:8:\"js-extra\";i:8;s:20:\"fusionNavIsCollapsed\";i:9;s:26:\"/assets/js/smush-lazy-load\";i:10;s:13:\"eio_lazy_vars\";i:11;s:34:\"\\/lazysizes(\\.min|-pre|-post)?\\.js\";i:12;s:44:\"document\\.body\\.classList\\.remove\\(\"no-js\"\\)\";i:13;s:64:\"document\\.documentElement\\.className\\.replace\\( \'no-js\', \'js\' \\)\";i:14;s:17:\"et_animation_data\";i:15;s:16:\"wpforms_settings\";i:16;s:11:\"var nfForms\";i:17;s:14:\"//stats.wp.com\";i:18;s:9:\"_stq.push\";i:19;s:29:\"fluent_form_ff_form_instance_\";i:20;s:9:\"cpLoadCSS\";i:21;s:13:\"ninja_column_\";i:22;s:16:\"var rbs_gallery_\";i:23;s:12:\"var lepopup_\";i:24;s:28:\"var billing_additional_field\";i:25;s:10:\"var gtm4wp\";i:26;s:21:\"var dataLayer_content\";i:27;s:54:\"/ewww-image-optimizer/includes/load[_-]webp(\\.min)?.js\";i:28;s:52:\"/ewww-image-optimizer/includes/check-webp(\\.min)?.js\";i:29;s:19:\"ewww_webp_supported\";i:30;s:32:\"/dist/js/browser-redirect/app.js\";i:31;s:31:\"/perfmatters/js/lazyload.min.js\";i:32;s:16:\"lazyLoadInstance\";i:33;s:27:\"scripts.mediavine.com/tags/\";i:34;s:17:\"initCubePortfolio\";i:35;s:9:\"simpli.fi\";i:36;s:17:\"gforms_recaptcha_\";i:37;s:57:\"/jetpack-boost/vendor/automattic/jetpack-lazy-images/(.*)\";i:38;s:30:\"jetpack-lazy-images-js-enabled\";i:39;s:26:\"jetpack-boost-critical-css\";i:40;s:24:\"wpformsRecaptchaCallback\";i:41;s:20:\"booking-suedtirol-js\";i:42;s:26:\"wpcp_css_disable_selection\";i:43;s:41:\"/gravityforms/js/conditional_logic.min.js\";i:44;s:34:\"statcounter.com/counter/counter.js\";i:45;s:14:\"var sc_project\";i:46;s:59:\"/jetpack/jetpack_vendor/automattic/jetpack-lazy-images/(.*)\";i:47;s:55:\"/themify-builder/themify/js/modules/fallback(\\.min)?.js\";i:48;s:16:\"handlePixMessage\";i:49;s:16:\"var corner_video\";i:50;s:26:\"cdn.pixfuture.com/hb_v2.js\";i:51;s:25:\"cdn.pixfuture.com/pbix.js\";i:52;s:43:\"served-by.pixfuture.com/www/delivery/ads.js\";i:53;s:64:\"served-by.pixfuture.com/www/delivery/headerbid_sticky_refresh.js\";i:54;s:35:\"serv-vdo.pixfuture.com/vpaid/ads.js\";i:55;s:14:\"wprRemoveCPCSS\";i:56;s:19:\"window.jdgmSettings\";i:57;s:67:\"/photonic/include/js/front-end/nomodule/photonic-baguettebox.min.js\";i:58;s:52:\"/photonic/include/ext/baguettebox/baguettebox.min.js\";i:59;s:27:\"window.wsf_form_json_config\";i:60;s:20:\"et_link_options_data\";i:61;s:19:\"FuseboxPlayerAPIKey\";i:62;s:27:\"js.hscta.net/cta/current.js\";i:63;s:14:\"hbspt.cta.load\";i:64;s:27:\"consent.cookiebot.com/uc.js\";i:65;s:53:\"/woofilter-pro/woofilterpro/js/ion.rangeSlider.min.js\";i:66;s:21:\"barra.r7.com/barra.js\";i:67;s:26:\"rocket_css_lazyload_launch\";i:68;s:16:\"#wpr-lazyload-bg\";i:69;s:60:\"/wp-content/plugins/wp-rocket/assets/js/lcp-beacon(.min)?.js\";i:70;s:15:\"rocket_lcp_data\";i:71;s:18:\"rocket_beacon_data\";i:72;s:60:\"/wp-content/plugins/wp-rocket/assets/js/wpr-beacon(.min)?.js\";i:73;s:24:\"elm.style.display=\"none\"\";}s:18:\"js_minify_external\";a:126:{i:0;s:8:\"html5.js\";i:1;s:11:\"show_ads.js\";i:2;s:14:\"histats.com/js\";i:3;s:21:\"ws.amazon.com/widgets\";i:4;s:5:\"/ads/\";i:5;s:17:\"intensedebate.com\";i:6;s:20:\"scripts.chitika.net/\";i:7;s:12:\"jotform.com/\";i:8;s:15:\"gist.github.com\";i:9;s:16:\"forms.aweber.com\";i:10;s:21:\"video.unrulymedia.com\";i:11;s:12:\"stats.wp.com\";i:12;s:19:\"stats.wordpress.com\";i:13;s:23:\"widget.rafflecopter.com\";i:14;s:29:\"widget-prime.rafflecopter.com\";i:15;s:23:\"releases.flowplayer.org\";i:16;s:13:\"c.ad6media.fr\";i:17;s:19:\"cdn.stickyadstv.com\";i:18;s:12:\"www.smava.de\";i:19;s:20:\"contextual.media.net\";i:20;s:19:\"app.getresponse.com\";i:21;s:24:\"adserver.reklamstore.com\";i:22;s:9:\"s0.wp.com\";i:23;s:16:\"wprp.zemanta.com\";i:24;s:21:\"files.bannersnack.com\";i:25;s:22:\"smarticon.geotrust.com\";i:26;s:11:\"js.gleam.io\";i:27;s:25:\"ir-na.amazon-adsystem.com\";i:28;s:19:\"web.ventunotech.com\";i:29;s:20:\"verify.authorize.net\";i:30;s:21:\"ads.themoneytizer.com\";i:31;s:20:\"embed.finanzcheck.de\";i:32;s:20:\"imagesrv.adition.com\";i:33;s:15:\"js.juicyads.com\";i:34;s:18:\"form.jotformeu.com\";i:35;s:15:\"speakerdeck.com\";i:36;s:22:\"content.jwplatform.com\";i:37;s:24:\"ads.investingchannel.com\";i:38;s:13:\"app.ecwid.com\";i:39;s:20:\"www.industriejobs.de\";i:40;s:14:\"s.gravatar.com\";i:41;s:21:\"googlesyndication.com\";i:42;s:13:\"a.optmstr.com\";i:43;s:14:\"a.optmnstr.com\";i:44;s:13:\"a.opmnstr.com\";i:45;s:12:\"adthrive.com\";i:46;s:13:\"mediavine.com\";i:47;s:14:\"js.hsforms.net\";i:48;s:20:\"googleadservices.com\";i:49;s:16:\"f.convertkit.com\";i:50;s:16:\"recaptcha/api.js\";i:51;s:12:\"mailmunch.co\";i:52;s:20:\"apps.shareaholic.com\";i:53;s:28:\"dsms0mj1bbhn4.cloudfront.net\";i:54;s:12:\"nutrifox.com\";i:55;s:13:\"code.tidio.co\";i:56;s:16:\"www.uplaunch.com\";i:57;s:24:\"widget.reviewability.com\";i:58;s:36:\"embed-cdn.gettyimages.com/widgets.js\";i:59;s:18:\"app.mailerlite.com\";i:60;s:7:\"ck.page\";i:61;s:28:\"cdn.jsdelivr.net/gh/AmauriC/\";i:62;s:39:\"static.klaviyo.com/onsite/js/klaviyo.js\";i:63;s:32:\"a.omappapi.com/app/js/api.min.js\";i:64;s:19:\"static.zdassets.com\";i:65;s:58:\"feedbackcompany.com/widgets/feedback-company-widget.min.js\";i:66;s:17:\"widget.gleamjs.io\";i:67;s:14:\"phonewagon.com\";i:68;s:35:\"simplybook.asia/v2/widget/widget.js\";i:69;s:33:\"simplybook.it/v2/widget/widget.js\";i:70;s:33:\"simplybook.me/v2/widget/widget.js\";i:71;s:48:\"static.botsrv.com/website/js/widget2.36cf1446.js\";i:72;s:27:\"static.mailerlite.com/data/\";i:73;s:14:\"cdn.voxpow.com\";i:74;s:16:\"loader.knack.com\";i:75;s:46:\"embed.lpcontent.net/leadboxes/current/embed.js\";i:76;s:52:\"cc.cdn.civiccomputing.com/9/cookieControl-9.x.min.js\";i:77;s:21:\"cse.google.com/cse.js\";i:78;s:19:\"kit.fontawesome.com\";i:79;s:51:\"cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js\";i:80;s:46:\"static.leadpages.net/leadbars/current/embed.js\";i:81;s:27:\"booqable.com/v2/booqable.js\";i:82;s:18:\"googleoptimize.com\";i:83;s:52:\"cdna.hubpeople.com/js/widget_standalone_two_modes.js\";i:84;s:18:\"s3.tradingview.com\";i:85;s:26:\"www.vbt.io/ext/vbtforms.js\";i:86;s:16:\"cdn.callrail.com\";i:87;s:40:\"documentcloud.adobe.com/view-sdk/main.js\";i:88;s:21:\"static.cleverpush.com\";i:89;s:15:\"js.afterpay.com\";i:90;s:33:\"cdn.enable.co.il/licenses/enable-\";i:91;s:21:\"hcaptcha.com/1/api.js\";i:92;s:46:\"voucher.getavo.it/public/js/yanovis.Voucher.js\";i:93;s:18:\"js-eu1.hsforms.net\";i:94;s:34:\"statcounter.com/counter/counter.js\";i:95;s:11:\"snapppt.com\";i:96;s:15:\"use.typekit.com\";i:97;s:35:\"secure.gravatar.com/js/gprofiles.js\";i:98;s:32:\"cdn.jsdelivr.net/npm/hockeystack\";i:99;s:22:\"widget.prod.faslet.net\";i:100;s:31:\"ga.getresponse.com/script/ga.js\";i:101;s:16:\"cognitoforms.com\";i:102;s:15:\"usercentrics.eu\";i:103;s:16:\"cdn.amcharts.com\";i:104;s:5:\"umami\";i:105;s:20:\"cdn.popt.in/pixel.js\";i:106;s:9:\"m2d.m2.ai\";i:107;s:11:\"pubguru.net\";i:108;s:13:\"trustindex.io\";i:109;s:37:\"cdnjs.cloudflare.com/ajax/libs/prism/\";i:110;s:25:\"podigee-podcast-player.js\";i:111;s:24:\"tarteaucitron.io/load.js\";i:112;s:29:\"osm.klarnaservices.com/lib.js\";i:113;s:25:\"mein.clickskeks.at/app.js\";i:114;s:21:\"barra.r7.com/barra.js\";i:115;s:16:\"widget.refari.co\";i:116;s:20:\"widget.reviews.co.uk\";i:117;s:20:\"player.vdocipher.com\";i:118;s:26:\"www.instagram.com/embed.js\";i:119;s:13:\"smartframe.io\";i:120;s:36:\"challenges.cloudflare.com/turnstile/\";i:121;s:20:\"script.roboassist.ai\";i:122;s:16:\"cdn.hu-manity.co\";i:123;s:56:\"daumcdn.net/mapjsapi/bundle/postcode/prod/postcode.v2.js\";i:124;s:27:\"consent.cookiebot.com/uc.js\";i:125;s:23:\"umstats.tools.coolw.xyz\";}s:21:\"js_move_after_combine\";a:106:{i:0;s:15:\"map_fusion_map_\";i:1;s:13:\"ec:addProduct\";i:2;s:16:\"ec:addImpression\";i:3;s:30:\"clear_better_facebook_comments\";i:4;s:29:\"vc-row-destroy-equal-heights-\";i:5;s:14:\"dfd-icon-list-\";i:6;s:12:\"SFM_template\";i:7;s:14:\"WLTChangeState\";i:8;s:9:\"wlt_star_\";i:9;s:17:\"wlt_pop_distance_\";i:10;s:14:\"smart_list_tip\";i:11;s:12:\"gd-wgt-pagi-\";i:12;s:11:\"data-rf-id=\";i:13;s:7:\"tvc_po=\";i:14;s:10:\"scrapeazon\";i:15;s:10:\"startclock\";i:16;s:22:\"it_logo_field_owl-box_\";i:17;s:15:\"td_live_css_uid\";i:18;s:17:\"wpvl_paramReplace\";i:19;s:11:\"tdAjaxCount\";i:20;s:9:\"mec_skin_\";i:21;s:4:\"_wca\";i:22;s:8:\"_taboola\";i:23;s:17:\"fbq(\'trackCustom\'\";i:24;s:11:\"fbq(\'track\'\";i:25;s:10:\"data.token\";i:26;s:7:\"sharrre\";i:27;s:19:\"dfads_ajax_load_ads\";i:28;s:13:\"tie_postviews\";i:29;s:10:\"wmp_update\";i:30;s:18:\"h5ab-print-article\";i:31;s:17:\"gform_ajax_frame_\";i:32;s:17:\"gform_post_render\";i:33;s:14:\"mts_view_count\";i:34;s:15:\"act_css_tooltip\";i:35;s:10:\"window.SLB\";i:36;s:14:\"wpt_view_count\";i:37;s:11:\"var dateNow\";i:38;s:16:\"gallery_product_\";i:39;s:21:\".flo-block-slideshow-\";i:40;s:17:\"data=\'api-key=ct-\";i:41;s:20:\"ip_common_function()\";i:42;s:31:\"(\"style#gsf-custom-css\").append\";i:43;s:22:\"a3revWCDynamicGallery_\";i:44;s:24:\"#owl-carousel-instagram-\";i:45;s:19:\"window.FlowFlowOpts\";i:46;s:16:\"jQuery(\'.td_uid_\";i:47;s:16:\"jQuery(\".slider-\";i:48;s:18:\"#dfd-vcard-widget-\";i:49;s:21:\"#sf-instagram-widget-\";i:50;s:18:\".woocommerce-tabs-\";i:51;s:16:\"penci_megamenu__\";i:52;s:18:\"vc_prepareHoverBox\";i:53;s:16:\"wp-temp-form-div\";i:54;s:25:\"_wswebinarsystem_already_\";i:55;s:23:\"#views-extra-css\").text\";i:56;s:20:\"fusetag.setTargeting\";i:57;s:20:\"hit.uptrendsdata.com\";i:58;s:27:\"callback:window.renderBadge\";i:59;s:29:\"test_run_nf_conditional_logic\";i:60;s:9:\"cb_nombre\";i:61;s:12:\"$(\'.fl-node-\";i:62;s:24:\"function($){google_maps_\";i:63;s:14:\"$(\"#myCarousel\";i:64;s:18:\"et_animation_data=\";i:65;s:13:\"current_url=\"\";i:66;s:44:\"CustomEvent.prototype=window.Event.prototype\";i:67;s:26:\"electro-wc-product-gallery\";i:68;s:14:\"woof_is_mobile\";i:69;s:20:\"jQuery(\'.videonextup\";i:70;s:10:\"wpp_params\";i:71;s:24:\"us.templateDirectoryUri=\";i:72;s:17:\".fat-gallery-item\";i:73;s:10:\".ratingbox\";i:74;s:33:\"user_rating.prototype.eraseCookie\";i:75;s:23:\"test_run_nf_conditional\";i:76;s:26:\"dpsp-networks-btns-wrapper\";i:77;s:19:\"pa_woo_product_info\";i:78;s:35:\"sharing_enabled_on_post_via_metabox\";i:79;s:22:\"#product-search-field-\";i:80;s:19:\"GOTMLS_login_offset\";i:81;s:40:\"berocket_aapf_time_to_fix_products_style\";i:82;s:27:\"window.vc_googleMapsPointer\";i:83;s:8:\"sinceID_\";i:84;s:31:\"#ut-background-video-ut-section\";i:85;s:26:\"+window.comment_tab_width+\";i:86;s:19:\"dfd-button-hover-in\";i:87;s:21:\"wpseo-address-wrapper\";i:88;s:24:\"platform.stumbleupon.com\";i:89;s:27:\"#woo_pp_ec_button_mini_cart\";i:90;s:14:\"#supercarousel\";i:91;s:10:\"blockClass\";i:92;s:11:\"tdbMenuItem\";i:93;s:13:\"tdbSearchItem\";i:94;s:17:\"best_seller_badge\";i:95;s:24:\"jQuery(\'#product-top-bar\";i:96;s:8:\"fb_desc-\";i:97;s:21:\"FC_regenerate_captcha\";i:98;s:34:\"wp_post_blocks_vars.listed_posts=[\";i:99;s:12:\"captcha-hash\";i:100;s:9:\"mapdata={\";i:101;s:11:\".ywpc-char-\";i:102;s:17:\").countdowntimer(\";i:103;s:16:\"jQuery(\"#td_uid_\";i:104;s:14:\"find(\'#td_uid_\";i:105;s:22:\"variation_estimate_msg\";}s:18:\"js_excluded_inline\";a:315:{i:0;s:14:\"document.write\";i:1;s:9:\"google_ad\";i:2;s:9:\"edToolbar\";i:3;s:4:\"gtag\";i:4;s:9:\"_gaq.push\";i:5;s:5:\"_gaLt\";i:6;s:21:\"GoogleAnalyticsObject\";i:7;s:17:\"syntaxhighlighter\";i:8;s:11:\"adsbygoogle\";i:9;s:7:\"ci_cap_\";i:10;s:4:\"_stq\";i:11;s:5:\"nonce\";i:12;s:7:\"post_id\";i:13;s:8:\"LogHuman\";i:14;s:15:\"idcomments_acct\";i:15;s:9:\"ch_client\";i:16;s:11:\"sc_online_t\";i:17;s:4:\"_stq\";i:18;s:17:\"bannersnack_embed\";i:19;s:15:\"vtn_player_type\";i:20;s:13:\"ven_video_key\";i:21;s:15:\"ANS_customer_id\";i:22;s:7:\"tdBlock\";i:23;s:12:\"tdLocalCache\";i:24;s:11:\"wpRestNonce\";i:25;s:6:\"\"url\":\";i:26;s:15:\"lazyLoadOptions\";i:27;s:8:\"adthrive\";i:28;s:7:\"loadCSS\";i:29;s:17:\"google_tag_params\";i:30;s:13:\"clicky_custom\";i:31;s:15:\"clicky_site_ids\";i:32;s:14:\"NSLPopupCenter\";i:33;s:4:\"_paq\";i:34;s:3:\"gtm\";i:35;s:9:\"dataLayer\";i:36;s:13:\"RecaptchaLoad\";i:37;s:20:\"WPCOM_sharing_counts\";i:38;s:22:\"jetpack_remote_comment\";i:39;s:15:\"subscribe-field\";i:40;s:9:\"contextly\";i:41;s:7:\"_mmunch\";i:42;s:14:\"gt_request_uri\";i:43;s:12:\"doGTranslate\";i:44;s:8:\"docTitle\";i:45;s:17:\"bs_ajax_paginate_\";i:46;s:20:\"bs_deferred_loading_\";i:47;s:22:\"theChampRedirectionUrl\";i:48;s:20:\"theChampFBCommentUrl\";i:49;s:23:\"theChampTwitterRedirect\";i:50;s:25:\"theChampRegRedirectionUrl\";i:51;s:14:\"ESSB_CACHE_URL\";i:52;s:30:\"oneall_social_login_providers_\";i:53;s:22:\"betterads_screen_width\";i:54;s:40:\"woocommerce_wishlist_add_to_wishlist_url\";i:55;s:21:\"arf_conditional_logic\";i:56;s:27:\"heateorSsHorSharingShortUrl\";i:57;s:8:\"TL_Const\";i:58;s:23:\"bimber_front_microshare\";i:59;s:17:\"setAttribute(\"id\"\";i:60;s:18:\"setAttribute( \"id\"\";i:61;s:14:\"TribeEventsPro\";i:62;s:14:\"peepsotimedata\";i:63;s:9:\"wphc_data\";i:64;s:10:\"hc_rand_id\";i:65;s:7:\"RBL_ADD\";i:66;s:18:\"AfsAnalyticsObject\";i:67;s:18:\"_thriveCurrentPost\";i:68;s:13:\"esc_login_url\";i:69;s:18:\"fwduvpMainPlaylist\";i:70;s:26:\"Bibblio.initRelatedContent\";i:71;s:9:\"showUFC()\";i:72;s:8:\"#iphorm-\";i:73;s:7:\"#fancy-\";i:74;s:13:\"ult-carousel-\";i:75;s:17:\"theChampLJAuthUrl\";i:76;s:6:\"f._fbq\";i:77;s:10:\"Insticator\";i:78;s:15:\"w2dc_js_objects\";i:79;s:11:\"cherry_ajax\";i:80;s:9:\"ad_block_\";i:81;s:23:\"elementorFrontendConfig\";i:82;s:5:\"zeen_\";i:83;s:16:\"disqusIdentifier\";i:84;s:14:\"currentAjaxUrl\";i:85;s:27:\"geodir_event_call_calendar_\";i:86;s:8:\"atatags-\";i:87;s:18:\"hbspt.forms.create\";i:88;s:19:\"function(c,h,i,m,p)\";i:89;s:11:\"dataTable({\";i:90;s:12:\"rankMath = {\";i:91;s:10:\"_atrk_opts\";i:92;s:16:\"quicklinkOptions\";i:93;s:11:\"ct_checkjs_\";i:94;s:18:\"WP_Statistics_http\";i:95;s:12:\"penci_block_\";i:96;s:15:\"omapi_localized\";i:97;s:10:\"omapi_data\";i:98;s:15:\"OptinMonsterApp\";i:99;s:9:\"tminusnow\";i:100;s:7:\"nfForms\";i:101;s:18:\"galleries.gallery_\";i:102;s:14:\"wcj_evt.prodID\";i:103;s:19:\"advads_tracking_ads\";i:104;s:28:\"advadsGATracking.postContext\";i:105;s:14:\"woopack_config\";i:106;s:14:\"ulp_content_id\";i:107;s:26:\"wp-cumulus/tagcloud.swf?r=\";i:108;s:24:\"ctSetCookie(\'ct_checkjs\'\";i:109;s:20:\"woof_really_curr_tax\";i:110;s:17:\"uLogin.customInit\";i:111;s:32:\"i18n_no_matching_variations_text\";i:112;s:22:\"alsp_map_markers_attrs\";i:113;s:13:\"var inc_opt =\";i:114;s:13:\"iworks_upprev\";i:115;s:19:\"yith_wcevti_tickets\";i:116;s:27:\"window.metrilo.ensure_cbuid\";i:117;s:13:\"metrilo.event\";i:118;s:19:\"wordpress_page_root\";i:119;s:9:\"wcct_info\";i:120;s:20:\"Springbot.product_id\";i:121;s:17:\"pysWooProductData\";i:122;s:11:\"dfd-heading\";i:123;s:8:\"owl=$(\"#\";i:124;s:14:\"penci_megamenu\";i:125;s:12:\"fts_security\";i:126;s:19:\"algoliaAutocomplete\";i:127;s:22:\"avia_framework_globals\";i:128;s:23:\"tabs.easyResponsiveTabs\";i:129;s:20:\"searchlocationHeader\";i:130;s:16:\"yithautocomplete\";i:131;s:19:\"data-parallax-speed\";i:132;s:14:\"currency_data=\";i:133;s:11:\"cedexisData\";i:134;s:23:\"function reenableButton\";i:135;s:12:\"#wpnbio-show\";i:136;s:29:\"e.Newsletter2GoTrackingObject\";i:137;s:15:\"var categories_\";i:138;s:14:\"\"+nRemaining+\"\";i:139;s:20:\"cartsguru_cart_token\";i:140;s:21:\"after_share_easyoptin\";i:141;s:18:\"location_data.push\";i:142;s:30:\"thirstyFunctions.isThirstyLink\";i:143;s:23:\"styles: \' #custom-menu-\";i:144;s:20:\"function svc_center_\";i:145;s:25:\"#svc_carousel2_container_\";i:146;s:11:\"advads.move\";i:147;s:9:\"elementid\";i:148;s:14:\"advads_has_ads\";i:149;s:14:\"wpseo_map_init\";i:150;s:20:\"mdf_current_page_url\";i:151;s:12:\"tptn_tracker\";i:152;s:20:\"dpsp_pin_button_data\";i:153;s:27:\"searchwp_live_search_params\";i:154;s:10:\"wpp_params\";i:155;s:21:\"top.location,thispage\";i:156;s:18:\"selection+pagelink\";i:157;s:20:\"ic_window_resolution\";i:158;s:11:\"PHP.wp_p_id\";i:159;s:29:\"ShopifyBuy.UI.onReady(client)\";i:160;s:16:\"orig_request_uri\";i:161;s:16:\"gie.widgets.load\";i:162;s:11:\"Adman.Flash\";i:163;s:11:\"PHP.wp_p_id\";i:164;s:26:\"window.broadstreetKeywords\";i:165;s:15:\"var productId =\";i:166;s:16:\"var flatsomeVars\";i:167;s:21:\"wc_product_block_data\";i:168;s:21:\"static.mailerlite.com\";i:169;s:10:\"amzn_assoc\";i:170;s:22:\"_bs_getParameterByName\";i:171;s:9:\"_stq.push\";i:172;s:9:\"h._remove\";i:173;s:16:\"var FlowFlowOpts\";i:174;s:14:\"var WCPFData =\";i:175;s:14:\"var _beeketing\";i:176;s:16:\"var _statcounter\";i:177;s:13:\"var actions =\";i:178;s:15:\"var current_url\";i:179;s:15:\"var object_name\";i:180;s:19:\"var the_ajax_script\";i:181;s:28:\"var wc_cart_fragments_params\";i:182;s:22:\"var woocommerce_params\";i:183;s:16:\"var wpml_cookies\";i:184;s:21:\"wc_add_to_cart_params\";i:185;s:26:\"window.broadstreetKeywords\";i:186;s:35:\"window.wc_ga_pro.available_gateways\";i:187;s:12:\"xa.prototype\";i:188;s:21:\"HOUZEZ_ajaxcalls_vars\";i:189;s:17:\"w2dc_maps_objects\";i:190;s:26:\"w2dc_controller_args_array\";i:191;s:22:\"w2dc_map_markers_attrs\";i:192;s:9:\"YT.Player\";i:193;s:9:\"WPFC.data\";i:194;s:23:\"function current_video_\";i:195;s:12:\"var videodiv\";i:196;s:22:\"var slider_wppasrotate\";i:197;s:8:\"wppas_ga\";i:198;s:14:\"var blockClass\";i:199;s:13:\"tarteaucitron\";i:200;s:21:\"pw_brand_product_list\";i:201;s:15:\"tminusCountDown\";i:202;s:23:\"pysWooSelectContentData\";i:203;s:13:\"wpvq_ans89733\";i:204;s:12:\"_isp_version\";i:205;s:16:\"price_range_data\";i:206;s:29:\"window.FeedbackCompanyWidgets\";i:207;s:22:\"woocs_current_currency\";i:208;s:30:\"woo_variation_swatches_options\";i:209;s:31:\"woocommerce_price_slider_params\";i:210;s:12:\"scriptParams\";i:211;s:19:\"form-adv-pagination\";i:212;s:23:\"borlabsCookiePrioritize\";i:213;s:21:\"urls_wpwidgetpolylang\";i:214;s:14:\"quickViewNonce\";i:215;s:22:\"frontendscripts_params\";i:216;s:21:\"nj-facebook-messenger\";i:217;s:20:\"var fb_mess_position\";i:218;s:36:\"init_particles_row_background_script\";i:219;s:15:\"setREVStartSize\";i:220;s:7:\"fl-node\";i:221;s:11:\"PPAccordion\";i:222;s:10:\"soliloquy_\";i:223;s:25:\"wprevpublicjs_script_vars\";i:224;s:19:\"DTGS_NONCE_FRONTEND\";i:225;s:17:\"et_animation_data\";i:226;s:17:\"archives-dropdown\";i:227;s:15:\"loftloaderCache\";i:228;s:17:\"SmartSliderSimple\";i:229;s:14:\"var nectarLove\";i:230;s:10:\"var incOpt\";i:231;s:33:\"RocketBrowserCompatibilityChecker\";i:232;s:24:\"RocketPreloadLinksConfig\";i:233;s:18:\"placementVersionId\";i:234;s:11:\"var useEdit\";i:235;s:23:\"var DTGS_NONCE_FRONTEND\";i:236;s:8:\"n2jQuery\";i:237;s:26:\"et_core_api_spam_recaptcha\";i:238;s:6:\"cnArgs\";i:239;s:14:\"__CF$cv$params\";i:240;s:17:\"trustbox_settings\";i:241;s:5:\"aepro\";i:242;s:10:\"cdn.jst.ai\";i:243;s:25:\"w2dc_fields_in_categories\";i:244;s:21:\"jetMenuPublicSettings\";i:245;s:17:\"JetTricksSettings\";i:246;s:10:\"aepc_pixel\";i:247;s:20:\"avadaWooCommerceVars\";i:248;s:7:\"var isb\";i:249;s:9:\"fcaPcPost\";i:250;s:10:\"csrf_token\";i:251;s:24:\"icwp_wpsf_vars_lpantibot\";i:252;s:11:\"wpvViewHead\";i:253;s:16:\"ed_school_plugin\";i:254;s:9:\"aps_comp_\";i:255;s:11:\"guaven_woos\";i:256;s:16:\"__lm_redirect_to\";i:257;s:17:\"__wpdm_view_count\";i:258;s:23:\"bookacti.booking_system\";i:259;s:10:\"nfFrontEnd\";i:260;s:20:\"view_quote_cart_link\";i:261;s:19:\"__eae_decode_emails\";i:262;s:20:\"divioverlays_ajaxurl\";i:263;s:10:\"var _EPYT_\";i:264;s:13:\"#ins-heading-\";i:265;s:12:\"#ins-button-\";i:266;s:20:\"tve_frontend_options\";i:267;s:8:\"lb24.src\";i:268;s:24:\"amazon_Login_accessToken\";i:269;s:21:\"porto_infinite_scroll\";i:270;s:14:\".adace-loader-\";i:271;s:11:\"adace_load_\";i:272;s:41:\"tagGroupsAccordiontaggroupscloudaccordion\";i:273;s:31:\"tagGroupsTabstaggroupscloudtabs\";i:274;s:16:\"jrRelatedWidgets\";i:275;s:14:\"UNCODE.initRow\";i:276;s:28:\"amp_mobile_redirect_disabled\";i:277;s:11:\"wpgdprcData\";i:278;s:28:\"wpml_browser_redirect_params\";i:279;s:13:\"swPreRegister\";i:280;s:15:\"kboard_settings\";i:281;s:23:\"ct_ultimate_gdpr_cookie\";i:282;s:23:\"wcpv_registration_local\";i:283;s:15:\"www.idxhome.com\";i:284;s:24:\"arf_footer_cl_logic_call\";i:285;s:23:\"reload_attached_coupons\";i:286;s:8:\"var ftpp\";i:287;s:15:\"forminatorFront\";i:288;s:6:\"_EPYT_\";i:289;s:23:\"edd_free_downloads_vars\";i:290;s:15:\"edd_stripe_vars\";i:291;s:7:\"var ASP\";i:292;s:18:\"ecwidOriginalTitle\";i:293;s:17:\"defaultCategoryId\";i:294;s:25:\"translation-revision-date\";i:295;s:20:\"google_conversion_id\";i:296;s:5:\"hbspt\";i:297;s:21:\"var marker_locations_\";i:298;s:13:\"var AdmMyAjax\";i:299;s:13:\"ifso_page_url\";i:300;s:21:\"referrer_for_pageload\";i:301;s:38:\"WoocommerceWidget/woocommerceWidget.js\";i:302;s:19:\"var ht_ctc_chat_var\";i:303;s:6:\"spuvar\";i:304;s:16:\"var wpilFrontend\";i:305;s:24:\"urls_polylangREPLACETOID\";i:306;s:34:\"e.setAttribute(\'unselectable\',on);\";i:307;s:16:\"try{Typekit.load\";i:308;s:9:\"iMapsData\";i:309;s:24:\"var wpforms_user_journey\";i:310;s:24:\"rocket_lazyload_css_data\";i:311;s:24:\"wcStoreApiNonceTimestamp\";i:312;s:21:\"createNonceMiddleware\";i:313;s:8:\"pbidHash\";i:314;s:24:\"wcBlocksMiddlewareConfig\";}s:24:\"cache_ignored_parameters\";a:71:{i:0;s:10:\"utm_source\";i:1;s:10:\"utm_medium\";i:2;s:12:\"utm_campaign\";i:3;s:9:\"utm_expid\";i:4;s:8:\"utm_term\";i:5;s:11:\"utm_content\";i:6;s:6:\"utm_id\";i:7;s:19:\"utm_source_platform\";i:8;s:19:\"utm_creative_format\";i:9;s:20:\"utm_marketing_tactic\";i:10;s:10:\"mtm_source\";i:11;s:10:\"mtm_medium\";i:12;s:12:\"mtm_campaign\";i:13;s:11:\"mtm_keyword\";i:14;s:7:\"mtm_cid\";i:15;s:11:\"mtm_content\";i:16;s:9:\"pk_source\";i:17;s:9:\"pk_medium\";i:18;s:11:\"pk_campaign\";i:19;s:10:\"pk_keyword\";i:20;s:6:\"pk_cid\";i:21;s:10:\"pk_content\";i:22;s:13:\"fb_action_ids\";i:23;s:15:\"fb_action_types\";i:24;s:9:\"fb_source\";i:25;s:6:\"fbclid\";i:26;s:10:\"campaignid\";i:27;s:9:\"adgroupid\";i:28;s:4:\"adid\";i:29;s:5:\"gclid\";i:30;s:12:\"age-verified\";i:31;s:12:\"ao_noptimize\";i:32;s:4:\"usqp\";i:33;s:11:\"cn-reloaded\";i:34;s:3:\"_ga\";i:35;s:5:\"sscid\";i:36;s:6:\"gclsrc\";i:37;s:3:\"_gl\";i:38;s:6:\"mc_cid\";i:39;s:6:\"mc_eid\";i:40;s:8:\"_bta_tid\";i:41;s:6:\"_bta_c\";i:42;s:11:\"trk_contact\";i:43;s:7:\"trk_msg\";i:44;s:10:\"trk_module\";i:45;s:7:\"trk_sid\";i:46;s:5:\"gdfms\";i:47;s:6:\"gdftrk\";i:48;s:5:\"gdffi\";i:49;s:3:\"_ke\";i:50;s:3:\"_kx\";i:51;s:21:\"redirect_log_mongo_id\";i:52;s:17:\"redirect_mongo_id\";i:53;s:15:\"sb_referer_host\";i:54;s:5:\"mkwid\";i:55;s:5:\"pcrid\";i:56;s:5:\"ef_id\";i:57;s:7:\"s_kwcid\";i:58;s:7:\"msclkid\";i:59;s:4:\"dm_i\";i:60;s:4:\"epik\";i:61;s:2:\"pp\";i:62;s:6:\"gbraid\";i:63;s:6:\"wbraid\";i:64;s:8:\"ssp_iabi\";i:65;s:8:\"ssp_iaba\";i:66;s:3:\"gad\";i:67;s:6:\"vgo_ee\";i:68;s:10:\"gad_source\";i:69;s:12:\"onlywprocket\";i:70;s:7:\"srsltid\";}s:18:\"preload_exclusions\";a:4:{i:0;s:9:\"void\\(.*;\";i:1;s:17:\"(.*)__trashed(.*)\";i:2;s:14:\"/jet-menu/(.*)\";i:3;s:15:\"/jet-popup/(.*)\";}s:16:\"exclude_js_files\";a:14:{i:0;s:32:\"/wp-includes/js/dist/i18n.min.js\";i:1;s:76:\"/interactive-3d-flipbook-powered-physics-engine/assets/js/html2canvas.min.js\";i:2;s:68:\"/interactive-3d-flipbook-powered-physics-engine/assets/js/pdf.min.js\";i:3;s:70:\"/interactive-3d-flipbook-powered-physics-engine/assets/js/three.min.js\";i:4;s:77:\"/interactive-3d-flipbook-powered-physics-engine/assets/js/3d-flip-book.min.js\";i:5;s:39:\"/google-site-kit/dist/assets/js/(.*).js\";i:6;s:45:\"/wp-live-chat-support/public/js/callus(.*).js\";i:7;s:41:\"/borlabs-cookie/assets/javascript/(.*).js\";i:8;s:60:\"/wp-content/plugins/wp-rocket/assets/js/lcp-beacon(.min)?.js\";i:9;s:38:\"/woocommerce-bookings/dist/frontend.js\";i:10;s:44:\"/plugins/mapify(.*)/assets/js/dist/bundle.js\";i:11;s:60:\"/wp-content/plugins/wp-rocket/assets/js/wpr-beacon(.min)?.js\";i:12;s:47:\"/wp-recipe-maker-premium/dist/public-premium.js\";i:13;s:29:\"/plugins/wp-recipe-maker/(.*)\";}s:15:\"staging_domains\";a:32:{i:0;s:13:\".wpengine.com\";i:1;s:20:\".wpenginepowered.com\";i:2;s:16:\".pantheonsite.io\";i:3;s:18:\".flywheelsites.com\";i:4;s:20:\".flywheelstaging.com\";i:5;s:11:\".kinsta.com\";i:6;s:13:\".kinsta.cloud\";i:7;s:18:\".cloudwaysapps.com\";i:8;s:18:\".azurewebsites.net\";i:9;s:14:\".wpserveur.net\";i:10;s:19:\"-liquidwebsites.com\";i:11;s:16:\".myftpupload.com\";i:12;s:12:\".dream.press\";i:13;s:12:\".sg-host.com\";i:14;s:16:\".platformsh.site\";i:15;s:12:\".wpstage.net\";i:16;s:22:\".bigscoots-staging.com\";i:17;s:10:\".wpsc.site\";i:18;s:14:\".runcloud.link\";i:19;s:14:\".onrocket.site\";i:20;s:18:\".singlestaging.com\";i:21;s:13:\".myraidbox.de\";i:22;s:12:\".instawp.xyz\";i:23;s:11:\".instawp.co\";i:24;s:13:\".instawp.link\";i:25;s:12:\".instawp.app\";i:26;s:12:\".hstgr.cloud\";i:27;s:15:\".myhostpoint.ch\";i:28;s:17:\".wpcomstaging.com\";i:29;s:9:\".nxcli.io\";i:30;s:19:\".lyricalstaging.com\";i:31;s:10:\".myrdbx.io\";}s:19:\"exclude_js_template\";a:3:{i:0;s:13:\"type=\"module\"\";i:1;s:12:\"data-minify=\";i:2;s:15:\"data-no-minify=\";}s:25:\"lazy_rendering_exclusions\";a:35:{i:0;s:16:\"class=\"parallex\"\";i:1;s:28:\"class=\"avada-footer-scripts\"\";i:2;s:18:\"id=\"rhslidingMenu\"\";i:3;s:19:\"class=\"logobsmallt\"\";i:4;s:29:\"id=\"ast-mobile-popup-wrapper\"\";i:5;s:33:\"id=\"cmplz-cookiebanner-container\"\";i:6;s:27:\"class=\"wf-container-footer\"\";i:7;s:30:\"class=\"de-mega-menu-container\"\";i:8;s:14:\"data-nosnippet\";i:9;s:32:\"class=\"floating-menu float-menu-\";i:10;s:19:\"id=\"jeg_off_canvas\"\";i:11;s:31:\"id=\"dipi-popup-maker-container\"\";i:12;s:37:\"class=\"static-position vendor_hidden\"\";i:13;s:29:\"class=\"jws-mini-cart-wrapper\"\";i:14;s:28:\"class=\"home-widgets-section\"\";i:15;s:35:\"elementor-location-floating_buttons\";i:16;s:43:\"class=\"xoo-el-container xoo-el-style-popup\"\";i:17;s:26:\"class=\"off-canvas-wrapper\"\";i:18;s:30:\"id=\"ast-hb-account-login-wrap\"\";i:19;s:21:\"id=\"ak_drawer_holder\"\";i:20;s:15:\"id=\"brx-footer\"\";i:21;s:25:\"elementor-location-footer\";i:22;s:27:\"class=\"ts-floating-sidebar\"\";i:23;s:20:\"id=\"yith-wacp-popup\"\";i:24;s:83:\"class=\"fl-builder-content fl-builder-content-30 fl-builder-global-templates-locked\"\";i:25;s:34:\"class=\"mfn-footer-tmpl mfn-footer\"\";i:26;s:37:\"class=\"fusion-tb-footer fusion-footer\";i:27;s:35:\"class=\"wt-cli-cookie-bar-container\"\";i:28;s:23:\"id=\"lazy-loading-point\"\";i:29;s:25:\"class=\"cp-popup-container\";i:30;s:22:\"class=\"xoo-wsc-markup\"\";i:31;s:20:\"class=\"xoo-wsc-modal\";i:32;s:18:\"class=\"breakdance\"\";i:33;s:43:\"class=\"footer-container color-scheme-light\"\";i:34;s:18:\"class=\"sticky-cta\"\";}}","off"),
("1362","_transient_timeout_wpr_dynamic_lists_incompatible_plugins","1731072185","off"),
("1363","_transient_wpr_dynamic_lists_incompatible_plugins","O:8:\"stdClass\":6:{s:0:\"\";a:36:{i:0;O:8:\"stdClass\":2:{s:4:\"slug\";s:14:\"wp-super-cache\";s:4:\"file\";s:27:\"wp-super-cache/wp-cache.php\";}i:1;O:8:\"stdClass\":2:{s:4:\"slug\";s:23:\"enable-gzip-compression\";s:4:\"file\";s:51:\"enable-gzip-compression/enable-gzip-compression.php\";}i:2;O:8:\"stdClass\":2:{s:4:\"slug\";s:11:\"quick-cache\";s:4:\"file\";s:27:\"quick-cache/quick-cache.php\";}i:3;O:8:\"stdClass\":2:{s:4:\"slug\";s:31:\"leverage-browser-caching-ninjas\";s:4:\"file\";s:66:\"leverage-browser-caching-ninjas/leverage-browser-caching-ninja.php\";}i:4;O:8:\"stdClass\":2:{s:4:\"slug\";s:28:\"wp-performance-score-booster\";s:4:\"file\";s:61:\"wp-performance-score-booster/wp-performance-score-booster.php\";}i:5;O:8:\"stdClass\":2:{s:4:\"slug\";s:15:\"litespeed-cache\";s:4:\"file\";s:35:\"litespeed-cache/litespeed-cache.php\";}i:6;O:8:\"stdClass\":2:{s:4:\"slug\";s:42:\"remove-query-strings-from-static-resources\";s:4:\"file\";s:67:\"remove-query-strings-from-static-resources/remove-query-strings.php\";}i:7;O:8:\"stdClass\":2:{s:4:\"slug\";s:19:\"wp-http-compression\";s:4:\"file\";s:43:\"wp-http-compression/wp-http-compression.php\";}i:8;O:8:\"stdClass\":2:{s:4:\"slug\";s:21:\"query-strings-remover\";s:4:\"file\";s:47:\"query-strings-remover/query-strings-remover.php\";}i:9;O:8:\"stdClass\":2:{s:4:\"slug\";s:13:\"page-optimize\";s:4:\"file\";s:31:\"page-optimize/page-optimize.php\";}i:10;O:8:\"stdClass\":2:{s:4:\"slug\";s:18:\"speed-booster-pack\";s:4:\"file\";s:41:\"speed-booster-pack/speed-booster-pack.php\";}i:11;O:8:\"stdClass\":2:{s:4:\"slug\";s:17:\"swift-performance\";s:4:\"file\";s:33:\"swift-performance/performance.php\";}i:12;O:8:\"stdClass\":2:{s:4:\"slug\";s:28:\"gzip-ninja-speed-compression\";s:4:\"file\";s:49:\"gzip-ninja-speed-compression/gzip-ninja-speed.php\";}i:13;O:8:\"stdClass\":2:{s:4:\"slug\";s:18:\"super-static-cache\";s:4:\"file\";s:41:\"super-static-cache/super-static-cache.php\";}i:14;O:8:\"stdClass\":2:{s:4:\"slug\";s:10:\"lite-cache\";s:4:\"file\";s:21:\"lite-cache/plugin.php\";}i:15;O:8:\"stdClass\":2:{s:4:\"slug\";s:11:\"hyper-cache\";s:4:\"file\";s:22:\"hyper-cache/plugin.php\";}i:16;O:8:\"stdClass\":2:{s:4:\"slug\";s:7:\"wp-ffpc\";s:4:\"file\";s:19:\"wp-ffpc/wp-ffpc.php\";}i:17;O:8:\"stdClass\":2:{s:4:\"slug\";s:13:\"wp-fast-cache\";s:4:\"file\";s:31:\"wp-fast-cache/wp-fast-cache.php\";}i:18;O:8:\"stdClass\":2:{s:4:\"slug\";s:19:\"psn-pagespeed-ninja\";s:4:\"file\";s:38:\"psn-pagespeed-ninja/pagespeedninja.php\";}i:19;O:8:\"stdClass\":2:{s:4:\"slug\";s:22:\"swift-performance-lite\";s:4:\"file\";s:38:\"swift-performance-lite/performance.php\";}i:20;O:8:\"stdClass\":2:{s:4:\"slug\";s:10:\"force-gzip\";s:4:\"file\";s:25:\"force-gzip/force-gzip.php\";}i:21;O:8:\"stdClass\":2:{s:4:\"slug\";s:19:\"add-expires-headers\";s:4:\"file\";s:43:\"add-expires-headers/add-expires-headers.php\";}i:22;O:8:\"stdClass\":2:{s:4:\"slug\";s:20:\"hyper-cache-extended\";s:4:\"file\";s:31:\"hyper-cache-extended/plugin.php\";}i:23;O:8:\"stdClass\":2:{s:4:\"slug\";s:11:\"gator-cache\";s:4:\"file\";s:27:\"gator-cache/gator-cache.php\";}i:24;O:8:\"stdClass\":2:{s:4:\"slug\";s:10:\"flexicache\";s:4:\"file\";s:24:\"flexicache/wp-plugin.php\";}i:25;O:8:\"stdClass\":2:{s:4:\"slug\";s:16:\"wp-fastest-cache\";s:4:\"file\";s:35:\"wp-fastest-cache/wpFastestCache.php\";}i:26;O:8:\"stdClass\":2:{s:4:\"slug\";s:26:\"wordpress-gzip-compression\";s:4:\"file\";s:35:\"wordpress-gzip-compression/ezgz.php\";}i:27;O:8:\"stdClass\":2:{s:4:\"slug\";s:11:\"wp-optimize\";s:4:\"file\";s:27:\"wp-optimize/wp-optimize.php\";}i:28;O:8:\"stdClass\":2:{s:4:\"slug\";s:33:\"check-and-enable-gzip-compression\";s:4:\"file\";s:54:\"check-and-enable-gzip-compression/richards-toolbox.php\";}i:29;O:8:\"stdClass\":2:{s:4:\"slug\";s:24:\"far-future-expiry-header\";s:4:\"file\";s:50:\"far-future-expiry-header/far-future-expiration.php\";}i:30;O:8:\"stdClass\":2:{s:4:\"slug\";s:24:\"leverage-browser-caching\";s:4:\"file\";s:53:\"leverage-browser-caching/leverage-browser-caching.php\";}i:31;O:8:\"stdClass\":2:{s:4:\"slug\";s:12:\"wpcompressor\";s:4:\"file\";s:29:\"wpcompressor/wpcompressor.php\";}i:32;O:8:\"stdClass\":2:{s:4:\"slug\";s:11:\"combine-css\";s:4:\"file\";s:27:\"combine-css/combine-css.php\";}i:33;O:8:\"stdClass\":2:{s:4:\"slug\";s:14:\"w3-total-cache\";s:4:\"file\";s:33:\"w3-total-cache/w3-total-cache.php\";}i:34;O:8:\"stdClass\":2:{s:4:\"slug\";s:7:\"airlift\";s:4:\"file\";s:19:\"airlift/airlift.php\";}i:35;O:8:\"stdClass\":2:{s:4:\"slug\";s:13:\"cache-enabler\";s:4:\"file\";s:31:\"cache-enabler/cache-enabler.php\";}}s:21:\"minify_css||minify_js\";a:9:{i:0;O:8:\"stdClass\":2:{s:4:\"slug\";s:20:\"merge-minify-refresh\";s:4:\"file\";s:45:\"merge-minify-refresh/merge-minify-refresh.php\";}i:1;O:8:\"stdClass\":2:{s:4:\"slug\";s:16:\"async-js-and-css\";s:4:\"file\";s:34:\"async-js-and-css/asyncJSandCSS.php\";}i:2;O:8:\"stdClass\":2:{s:4:\"slug\";s:15:\"wp-super-minify\";s:4:\"file\";s:35:\"wp-super-minify/wp-super-minify.php\";}i:3;O:8:\"stdClass\":2:{s:4:\"slug\";s:20:\"fast-velocity-minify\";s:4:\"file\";s:28:\"fast-velocity-minify/fvm.php\";}i:4;O:8:\"stdClass\":2:{s:4:\"slug\";s:23:\"dependency-minification\";s:4:\"file\";s:51:\"dependency-minification/dependency-minification.php\";}i:5;O:8:\"stdClass\":2:{s:4:\"slug\";s:10:\"bwp-minify\";s:4:\"file\";s:25:\"bwp-minify/bwp-minify.php\";}i:6;O:8:\"stdClass\":2:{s:4:\"slug\";s:8:\"minqueue\";s:4:\"file\";s:19:\"minqueue/plugin.php\";}i:7;O:8:\"stdClass\":2:{s:4:\"slug\";s:12:\"scripts-gzip\";s:4:\"file\";s:29:\"scripts-gzip/scripts_gzip.php\";}i:8;O:8:\"stdClass\":2:{s:4:\"slug\";s:9:\"wp-minify\";s:4:\"file\";s:23:\"wp-minify/wp-minify.php\";}}s:8:\"lazyload\";a:6:{i:0;O:8:\"stdClass\":2:{s:4:\"slug\";s:9:\"lazy-load\";s:4:\"file\";s:23:\"lazy-load/lazy-load.php\";}i:1;O:8:\"stdClass\":2:{s:4:\"slug\";s:12:\"bj-lazy-load\";s:4:\"file\";s:29:\"bj-lazy-load/bj-lazy-load.php\";}i:2;O:8:\"stdClass\":2:{s:4:\"slug\";s:25:\"jquery-image-lazy-loading\";s:4:\"file\";s:46:\"jquery-image-lazy-loading/jq_img_lazy_load.php\";}i:3;O:8:\"stdClass\":2:{s:4:\"slug\";s:10:\"crazy-lazy\";s:4:\"file\";s:25:\"crazy-lazy/crazy-lazy.php\";}i:4;O:8:\"stdClass\":2:{s:4:\"slug\";s:24:\"specify-image-dimensions\";s:4:\"file\";s:53:\"specify-image-dimensions/specify-image-dimensions.php\";}i:5;O:8:\"stdClass\":2:{s:4:\"slug\";s:18:\"advanced-lazy-load\";s:4:\"file\";s:40:\"advanced-lazy-load/advanced_lazyload.php\";}}s:9:\"minify_js\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"slug\";s:5:\"wp-js\";s:4:\"file\";s:15:\"wp-js/wp-js.php\";}i:1;O:8:\"stdClass\":2:{s:4:\"slug\";s:20:\"scripts-to-footerphp\";s:4:\"file\";s:42:\"scripts-to-footerphp/scripts-to-footer.php\";}i:2;O:8:\"stdClass\":2:{s:4:\"slug\";s:10:\"combine-js\";s:4:\"file\";s:25:\"combine-js/combine-js.php\";}i:3;O:8:\"stdClass\":2:{s:4:\"slug\";s:17:\"footer-javascript\";s:4:\"file\";s:39:\"footer-javascript/footer-javascript.php\";}}s:17:\"control_heartbeat\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"slug\";s:17:\"heartbeat-control\";s:4:\"file\";s:39:\"heartbeat-control/heartbeat-control.php\";}}s:16:\"lazyload_iframes\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"slug\";s:20:\"lazy-load-for-videos\";s:4:\"file\";s:37:\"lazy-load-for-videos/codeispoetry.php\";}}}","off"),
("1364","_transient_timeout_rocket_mod_pagespeed_enabled","1730553796","off"),
("1365","_transient_rocket_mod_pagespeed_enabled","0","off"),
("1366","_transient_timeout_rocketcdn_pricing","1730488996","off"),
("1367","_transient_rocketcdn_pricing","a:7:{s:18:\"is_discount_active\";b:1;s:24:\"discounted_price_monthly\";d:6.99;s:23:\"discounted_price_yearly\";d:78.99;s:22:\"discount_campaign_name\";s:16:\"Anniversary 2022\";s:8:\"end_date\";s:10:\"2022-07-19\";s:13:\"monthly_price\";d:7.99;s:12:\"annual_price\";d:79.99;}","off"),
("1368","_transient_timeout_rocket_imagify_plugin_data","1731072197","off"),
("1369","_transient_rocket_imagify_plugin_data","O:8:\"stdClass\":14:{s:4:\"name\";s:84:\"Imagify – Optimize Images &#038; Convert WebP &#038; AVIF | Compress Images Easily\";s:4:\"slug\";s:7:\"imagify\";s:7:\"version\";s:5:\"2.2.2\";s:6:\"author\";s:98:\"<a href=\"https://imagify.io\">Imagify Image Optimizer – Optimize Images & Convert WebP & Avif</a>\";s:14:\"author_profile\";s:40:\"https://profiles.wordpress.org/wp_media/\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:86;s:7:\"ratings\";a:5:{i:5;i:1181;i:4;i:58;i:3;i:25;i:2;i:41;i:1;i:195;}s:11:\"num_ratings\";i:1500;s:15:\"support_threads\";i:13;s:24:\"support_threads_resolved\";i:13;s:15:\"active_installs\";i:900000;s:13:\"download_link\";s:56:\"https://downloads.wordpress.org/plugin/imagify.2.2.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:52:\"https://ps.w.org/imagify/assets/icon.svg?rev=2833113\";s:3:\"svg\";s:52:\"https://ps.w.org/imagify/assets/icon.svg?rev=2833113\";}}","off"),
("1371","wp_rocket_hide_deactivation_form","1","auto"),
("1388","wp_smush_event_times","a:1:{s:16:\"plugin_installed\";i:1730467535;}","off"),
("1389","wp-smush-settings","a:27:{s:4:\"auto\";b:1;s:5:\"lossy\";i:0;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:0;s:6:\"backup\";b:0;s:8:\"no_scale\";b:0;s:10:\"png_to_jpg\";b:0;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:5:\"gform\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:0;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:0;s:16:\"background_email\";b:0;s:22:\"webp_direct_conversion\";b:0;s:13:\"webp_fallback\";b:0;}","auto"),
("1390","wp-smush-install-type","existing","off"),
("1391","wp-smush-version","3.16.8","off"),
("1394","_transient_timeout_wp-smush-conflict_check","1730471209","off"),
("1395","_transient_wp-smush-conflict_check","a:0:{}","off"),
("1396","wp_smush_pre_3_12_6_site","0","off"),
("1397","wp_smush_global_stats","a:1:{s:25:\"rescan_required_timestamp\";i:1730467536;}","off"),
("1398","wp_smush_image_sizes_state","a:2:{s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:3:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";b:1;}s:6:\"medium\";a:3:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;}s:5:\"large\";a:3:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;}s:9:\"1536x1536\";a:3:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";b:0;}s:9:\"2048x2048\";a:3:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";b:0;}s:12:\"medium_large\";a:2:{s:5:\"width\";i:768;s:6:\"height\";i:0;}}s:4:\"hash\";i:46247379563;}","auto"),
("1399","_transient_timeout_wp_smush_skip_image_sizes_recheck","1730471136","off"),
("1400","_transient_wp_smush_skip_image_sizes_recheck","1","off"),
("1402","wp-smush-preset_configs","a:1:{i:0;a:5:{s:2:\"id\";i:1;s:4:\"name\";s:14:\"Default config\";s:11:\"description\";s:46:\"Recommended performance config for every site.\";s:7:\"default\";b:1;s:6:\"config\";a:2:{s:7:\"configs\";a:1:{s:8:\"settings\";a:23:{s:4:\"auto\";b:1;s:5:\"lossy\";i:1;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:1;s:6:\"backup\";b:1;s:10:\"png_to_jpg\";b:1;s:16:\"background_email\";b:0;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:0;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:0;}}s:7:\"strings\";a:6:{s:10:\"bulk_smush\";a:1:{i:0;s:219:\"Smush Mode - Super\r\nAutomatic compression - Active\r\nMetadata - Active\r\nImage Resizing - Inactive\r\nOriginal Images - Active\r\nBackup Original Images - Active\r\nPNG to JPEG Conversion - Active\r\nEmail Notification - Inactive\";}s:9:\"lazy_load\";a:1:{i:0;s:8:\"Inactive\";}s:3:\"cdn\";a:1:{i:0;s:8:\"Inactive\";}s:8:\"webp_mod\";a:1:{i:0;s:8:\"Inactive\";}s:12:\"integrations\";a:1:{i:0;s:112:\"Gutenberg Support - Inactive\r\nWPBakery Page Builder - Inactive\r\nAmazon S3 - Inactive\r\nNextGen Gallery - Inactive\";}s:8:\"settings\";a:1:{i:0;s:125:\"Image Resize Detection - Inactive\r\nColor Accessibility - Inactive\r\nUsage Tracking - Inactive\r\nKeep Data On Uninstall - Active\";}}}}}","off"),
("1403","skip-smush-setup","1","auto"),
("1405","dir_smush_stats","a:1:{s:9:\"dir_smush\";a:2:{s:5:\"total\";i:0;s:9:\"optimised\";i:0;}}","off"),
("1423","admin_site_enhancements","a:231:{s:18:\"enable_duplication\";b:1;s:32:\"duplication_redirect_destination\";s:4:\"edit\";s:26:\"enable_duplication_link_at\";a:3:{i:0;s:11:\"post-action\";i:1;s:9:\"admin-bar\";i:2;s:15:\"publish-section\";}s:37:\"enable_duplication_on_post_types_type\";s:7:\"only-on\";s:22:\"enable_duplication_for\";a:5:{s:13:\"administrator\";b:1;s:6:\"editor\";b:1;s:6:\"author\";b:1;s:11:\"contributor\";b:1;s:10:\"subscriber\";b:1;}s:20:\"hide_modify_elements\";b:1;s:20:\"hide_ab_wp_logo_menu\";b:1;s:20:\"hide_ab_updates_menu\";b:1;s:21:\"hide_ab_comments_menu\";b:1;s:13:\"hide_ab_howdy\";b:1;s:16:\"hide_help_drawer\";b:1;s:25:\"disable_dashboard_widgets\";b:1;s:34:\"disable_welcome_panel_in_dashboard\";b:1;s:26:\"disabled_dashboard_widgets\";a:7:{s:41:\"duplicator_dashboard_widget__normal__core\";b:1;s:34:\"dashboard_site_health__normal__low\";b:1;s:32:\"dashboard_right_now__normal__low\";b:1;s:31:\"dashboard_activity__normal__low\";b:1;s:32:\"dashboard_quick_press__side__low\";b:1;s:28:\"dashboard_primary__side__low\";b:1;s:46:\"wordfence_activity_report_widget__normal__core\";b:1;}s:19:\"admin_logo_location\";s:9:\"admin_bar\";s:16:\"admin_logo_image\";s:0:\"\";s:16:\"admin_menu_width\";s:5:\"180px\";s:17:\"custom_menu_order\";s:293:\"menu-dashboard,separator1,menu-posts,menu-media,menu-pages,menu-comments,toplevel_page_wpcf7,separator2,menu-appearance,menu-plugins,menu-users,menu-tools,menu-settings,toplevel_page_easy-wp-smtp,separator-last,toplevel_page_Wordfence,toplevel_page_duplicator-pro,toplevel_page_itsec-dashboard\";s:18:\"custom_menu_titles\";s:208:\"menu-posts__Posts,toplevel_page_wpcf7__Contact,toplevel_page_easy-wp-smtp__Easy WP SMTP,toplevel_page_Wordfence__Wordfence ,toplevel_page_duplicator-pro__Duplicator Pro,toplevel_page_itsec-dashboard__Security\";s:21:\"custom_submenus_order\";s:1567:\"{\"index__php\":\"index.php,update-core.php\",\"edit__php\":\"edit.php,post-new.php,edit-tags.php?taxonomy=category,edit-tags.php?taxonomy=post_tag\",\"upload__php\":\"upload.php,media-new.php\",\"edit__php___post_type____page\":\"edit.php?post_type=page,post-new.php?post_type=page\",\"wpcf7\":\"wpcf7,wpcf7-new,wpcf7-integration\",\"themes__php\":\"themes.php,site-editor.php\",\"plugins__php\":\"plugins.php,plugin-install.php\",\"users__php\":\"users.php,user-new.php,profile.php\",\"tools__php\":\"tools.php,import.php,export.php,site-health.php,export-personal-data.php,erase-personal-data.php,admin-site-enhancements\",\"options-general__php\":\"options-general.php,options-writing.php,options-reading.php,options-discussion.php,options-media.php,options-permalink.php,options-privacy.php,ithemes-licensing,menu_editor,ame-admin-customizer,ame-easy-hide,ws-admin-bar-editor\",\"easy-wp-smtp\":\"easy-wp-smtp,easy-wp-smtp-tools&tab=test,easy-wp-smtp-logs,easy-wp-smtp-reports,easy-wp-smtp-tools,https://easywpsmtp.com/lite-upgrade/?utm_source=WordPress&utm_medium=admin-menu&utm_campaign=liteplugin&utm_locale=en_us&utm_content=Upgrade%20to%20Pro%20-%20tools_page_admin-site-enhancements\",\"Wordfence\":\"Wordfence,WordfenceWAF,WordfenceScan,WordfenceTools,WFLS,WordfenceOptions,WordfenceSupport,WordfenceUpgradeToCare\",\"duplicator-pro\":\"duplicator-pro,duplicator-pro-import,duplicator-pro-schedules,duplicator-pro-storage,duplicator-pro-tools,duplicator-pro-settings\",\"itsec-dashboard\":\"itsec-dashboard,itsec-site-scan,itsec-firewall,itsec-vulnerabilities,itsec-user-security,itsec,itsec-tools,itsec-logs\"}\";s:25:\"custom_menu_always_hidden\";s:3499:\"{\"menu-dashboard\":{\"menu_title\":\"Dashboard\",\"original_menu_id\":\"menu-dashboard\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"index.php\"},\"separator1\":{\"menu_title\":\"\",\"original_menu_id\":\"separator1\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"\"},\"menu-posts\":{\"menu_title\":\"Posts\",\"original_menu_id\":\"menu-posts\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"edit.php\"},\"menu-media\":{\"menu_title\":\"Media\",\"original_menu_id\":\"menu-media\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"upload.php\"},\"menu-pages\":{\"menu_title\":\"Pages\",\"original_menu_id\":\"menu-pages\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"edit.php?post_type=page\"},\"menu-comments\":{\"menu_title\":\"Comments \",\"original_menu_id\":\"menu-comments\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"edit-comments.php\"},\"toplevel_page_wpcf7\":{\"menu_title\":\"Contact\",\"original_menu_id\":\"toplevel_page_wpcf7\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"wpcf7\"},\"separator2\":{\"menu_title\":\"\",\"original_menu_id\":\"separator2\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"\"},\"menu-appearance\":{\"menu_title\":\"Appearance\",\"original_menu_id\":\"menu-appearance\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"themes.php\"},\"menu-plugins\":{\"menu_title\":\"Plugins \",\"original_menu_id\":\"menu-plugins\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"plugins.php\"},\"menu-users\":{\"menu_title\":\"Users\",\"original_menu_id\":\"menu-users\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"users.php\"},\"menu-tools\":{\"menu_title\":\"Tools\",\"original_menu_id\":\"menu-tools\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"tools.php\"},\"menu-settings\":{\"menu_title\":\"Settings\",\"original_menu_id\":\"menu-settings\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"options-general.php\"},\"toplevel_page_easy-wp-smtp\":{\"menu_title\":\"Easy WP SMTP\",\"original_menu_id\":\"toplevel_page_easy-wp-smtp\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"easy-wp-smtp\"},\"separator-last\":{\"menu_title\":\"\",\"original_menu_id\":\"separator-last\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"\"},\"toplevel_page_Wordfence\":{\"menu_title\":\"Wordfence \",\"original_menu_id\":\"toplevel_page_Wordfence\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"Wordfence\"},\"toplevel_page_duplicator-pro\":{\"menu_title\":\"Duplicator Pro\",\"original_menu_id\":\"toplevel_page_duplicator-pro\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"duplicator-pro\"},\"toplevel_page_itsec-dashboard\":{\"menu_title\":\"Security\",\"original_menu_id\":\"toplevel_page_itsec-dashboard\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"itsec-dashboard\"}}\";s:21:\"custom_submenu_hidden\";s:0:\"\";s:28:\"custom_submenu_always_hidden\";s:15096:\"{\"index__php_-_home-_-9\":{\"menu_title\":\"Home\",\"original_menu_id\":\"index.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"index.php\"},\"index__php_-_updates-1-_-15\":{\"menu_title\":\"Updates \",\"original_menu_id\":\"update-core.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"update-core.php\"},\"edit__php_-_all-posts-_-8\":{\"menu_title\":\"All Posts\",\"original_menu_id\":\"edit.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"edit.php\"},\"edit__php_-_add-new-post-_-12\":{\"menu_title\":\"Add New Post\",\"original_menu_id\":\"post-new.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"post-new.php\"},\"edit__php_-_categories-_-31\":{\"menu_title\":\"Categories\",\"original_menu_id\":\"edit-tags.php?taxonomy=category\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"edit-tags.php?taxonomy=category\"},\"edit__php_-_tags-_-31\":{\"menu_title\":\"Tags\",\"original_menu_id\":\"edit-tags.php?taxonomy=post_tag\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"edit-tags.php?taxonomy=post_tag\"},\"upload__php_-_library-_-10\":{\"menu_title\":\"Library\",\"original_menu_id\":\"upload.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"upload.php\"},\"upload__php_-_add-new-media-file-_-13\":{\"menu_title\":\"Add New Media File\",\"original_menu_id\":\"media-new.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"media-new.php\"},\"edit__php___post_type____page_-_all-pages-_-23\":{\"menu_title\":\"All Pages\",\"original_menu_id\":\"edit.php?post_type=page\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"edit.php?post_type=page\"},\"edit__php___post_type____page_-_add-new-page-_-27\":{\"menu_title\":\"Add New Page\",\"original_menu_id\":\"post-new.php?post_type=page\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"post-new.php?post_type=page\"},\"wpcf7_-_contact-forms-_-5\":{\"menu_title\":\"Contact Forms\",\"original_menu_id\":\"wpcf7\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"wpcf7\"},\"wpcf7_-_add-new-_-9\":{\"menu_title\":\"Add New\",\"original_menu_id\":\"wpcf7-new\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"wpcf7-new\"},\"wpcf7_-_integration-_-17\":{\"menu_title\":\"Integration\",\"original_menu_id\":\"wpcf7-integration\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"wpcf7-integration\"},\"themes__php_-_themes-0-_-10\":{\"menu_title\":\"Themes \",\"original_menu_id\":\"themes.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"themes.php\"},\"themes__php_-_editor-_-15\":{\"menu_title\":\"Editor\",\"original_menu_id\":\"site-editor.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"site-editor.php\"},\"plugins__php_-_installed-plugins-_-11\":{\"menu_title\":\"Installed Plugins\",\"original_menu_id\":\"plugins.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"plugins.php\"},\"plugins__php_-_add-new-plugin-_-18\":{\"menu_title\":\"Add New Plugin\",\"original_menu_id\":\"plugin-install.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"plugin-install.php\"},\"users__php_-_all-users-_-9\":{\"menu_title\":\"All Users\",\"original_menu_id\":\"users.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"users.php\"},\"users__php_-_add-new-user-_-12\":{\"menu_title\":\"Add New User\",\"original_menu_id\":\"user-new.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"user-new.php\"},\"users__php_-_profile-_-11\":{\"menu_title\":\"Profile\",\"original_menu_id\":\"profile.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"profile.php\"},\"tools__php_-_available-tools-_-9\":{\"menu_title\":\"Available Tools\",\"original_menu_id\":\"tools.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"tools.php\"},\"tools__php_-_import-_-10\":{\"menu_title\":\"Import\",\"original_menu_id\":\"import.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"import.php\"},\"tools__php_-_export-_-10\":{\"menu_title\":\"Export\",\"original_menu_id\":\"export.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"export.php\"},\"tools__php_-_site-health-1-_-15\":{\"menu_title\":\"Site Health \",\"original_menu_id\":\"site-health.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"site-health.php\"},\"tools__php_-_export-personal-data-_-24\":{\"menu_title\":\"Export Personal Data\",\"original_menu_id\":\"export-personal-data.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"export-personal-data.php\"},\"tools__php_-_erase-personal-data-_-23\":{\"menu_title\":\"Erase Personal Data\",\"original_menu_id\":\"erase-personal-data.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"erase-personal-data.php\"},\"tools__php_-_enhancements-_-23\":{\"menu_title\":\"Enhancements\",\"original_menu_id\":\"admin-site-enhancements\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"admin-site-enhancements\"},\"options-general__php_-_general-_-19\":{\"menu_title\":\"General\",\"original_menu_id\":\"options-general.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"options-general.php\"},\"options-general__php_-_writing-_-19\":{\"menu_title\":\"Writing\",\"original_menu_id\":\"options-writing.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"options-writing.php\"},\"options-general__php_-_reading-_-19\":{\"menu_title\":\"Reading\",\"original_menu_id\":\"options-reading.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"options-reading.php\"},\"options-general__php_-_discussion-_-22\":{\"menu_title\":\"Discussion\",\"original_menu_id\":\"options-discussion.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"options-discussion.php\"},\"options-general__php_-_media-_-17\":{\"menu_title\":\"Media\",\"original_menu_id\":\"options-media.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"options-media.php\"},\"options-general__php_-_permalinks-_-21\":{\"menu_title\":\"Permalinks\",\"original_menu_id\":\"options-permalink.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"options-permalink.php\"},\"options-general__php_-_privacy-_-19\":{\"menu_title\":\"Privacy\",\"original_menu_id\":\"options-privacy.php\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"options-privacy.php\"},\"options-general__php_-_solidwp-licensing-_-17\":{\"menu_title\":\"SolidWP Licensing\",\"original_menu_id\":\"ithemes-licensing\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"ithemes-licensing\"},\"options-general__php_-_menu-editor-pro-_-11\":{\"menu_title\":\"Menu Editor Pro\",\"original_menu_id\":\"menu_editor\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"menu_editor\"},\"options-general__php_-_admin-customizer-_-20\":{\"menu_title\":\"Admin Customizer\",\"original_menu_id\":\"ame-admin-customizer\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"ame-admin-customizer\"},\"options-general__php_-_easy-hide-_-13\":{\"menu_title\":\"Easy Hide\",\"original_menu_id\":\"ame-easy-hide\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"ame-easy-hide\"},\"options-general__php_-_toolbar-editor-_-19\":{\"menu_title\":\"Toolbar Editor\",\"original_menu_id\":\"ws-admin-bar-editor\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"ws-admin-bar-editor\"},\"easy-wp-smtp_-_settings-_-12\":{\"menu_title\":\"Settings\",\"original_menu_id\":\"easy-wp-smtp\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"easy-wp-smtp\"},\"easy-wp-smtp_-_send-a-test-_-27\":{\"menu_title\":\"Send a Test\",\"original_menu_id\":\"easy-wp-smtp-tools&tab=test\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"easy-wp-smtp-tools&tab=test\"},\"easy-wp-smtp_-_email-log-_-17\":{\"menu_title\":\"Email Log\",\"original_menu_id\":\"easy-wp-smtp-logs\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"easy-wp-smtp-logs\"},\"easy-wp-smtp_-_email-reports-_-20\":{\"menu_title\":\"Email Reports\",\"original_menu_id\":\"easy-wp-smtp-reports\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"easy-wp-smtp-reports\"},\"easy-wp-smtp_-_tools-_-18\":{\"menu_title\":\"Tools\",\"original_menu_id\":\"easy-wp-smtp-tools\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"easy-wp-smtp-tools\"},\"easy-wp-smtp_-_upgrade-to-pro-_-212\":{\"menu_title\":\"Upgrade to Pro\",\"original_menu_id\":\"https://easywpsmtp.com/lite-upgrade/?utm_source=WordPress&utm_medium=admin-menu&utm_campaign=liteplugin&utm_locale=en_us&utm_content=Upgrade%20to%20Pro%20-%20tools_page_admin-site-enhancements\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"https://easywpsmtp.com/lite-upgrade/?utm_source=WordPress&utm_medium=admin-menu&utm_campaign=liteplugin&utm_locale=en_us&utm_content=Upgrade%20to%20Pro%20-%20tools_page_admin-site-enhancements\"},\"Wordfence_-_dashboard-1-_-9\":{\"menu_title\":\"Dashboard \",\"original_menu_id\":\"Wordfence\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"Wordfence\"},\"Wordfence_-_firewall-_-12\":{\"menu_title\":\"Firewall\",\"original_menu_id\":\"WordfenceWAF\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"WordfenceWAF\"},\"Wordfence_-_scan-_-13\":{\"menu_title\":\"Scan\",\"original_menu_id\":\"WordfenceScan\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"WordfenceScan\"},\"Wordfence_-_tools-_-14\":{\"menu_title\":\"Tools\",\"original_menu_id\":\"WordfenceTools\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"WordfenceTools\"},\"Wordfence_-_login-security-_-4\":{\"menu_title\":\"Login Security\",\"original_menu_id\":\"WFLS\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"WFLS\"},\"Wordfence_-_all-options-_-16\":{\"menu_title\":\"All Options\",\"original_menu_id\":\"WordfenceOptions\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"WordfenceOptions\"},\"Wordfence_-_help-_-16\":{\"menu_title\":\"Help\",\"original_menu_id\":\"WordfenceSupport\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"WordfenceSupport\"},\"Wordfence_-_upgrade-to-care-_-22\":{\"menu_title\":\"\",\"original_menu_id\":\"WordfenceUpgradeToCare\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"WordfenceUpgradeToCare\"},\"duplicator-pro_-_backups-_-14\":{\"menu_title\":\"Backups\",\"original_menu_id\":\"duplicator-pro\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"duplicator-pro\"},\"duplicator-pro_-_import-backups-_-21\":{\"menu_title\":\"Import Backups\",\"original_menu_id\":\"duplicator-pro-import\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"duplicator-pro-import\"},\"duplicator-pro_-_schedule-backups-_-24\":{\"menu_title\":\"Schedule Backups\",\"original_menu_id\":\"duplicator-pro-schedules\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"duplicator-pro-schedules\"},\"duplicator-pro_-_storage-_-22\":{\"menu_title\":\"Storage\",\"original_menu_id\":\"duplicator-pro-storage\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"duplicator-pro-storage\"},\"duplicator-pro_-_tools-_-20\":{\"menu_title\":\"Tools\",\"original_menu_id\":\"duplicator-pro-tools\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"duplicator-pro-tools\"},\"duplicator-pro_-_settings-_-23\":{\"menu_title\":\"Settings\",\"original_menu_id\":\"duplicator-pro-settings\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"duplicator-pro-settings\"},\"itsec-dashboard_-_dashboard-_-15\":{\"menu_title\":\"Dashboard\",\"original_menu_id\":\"itsec-dashboard\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"itsec-dashboard\"},\"itsec-dashboard_-_site-scans-_-15\":{\"menu_title\":\"Site Scans\",\"original_menu_id\":\"itsec-site-scan\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"itsec-site-scan\"},\"itsec-dashboard_-_firewall-_-14\":{\"menu_title\":\"Firewall\",\"original_menu_id\":\"itsec-firewall\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"itsec-firewall\"},\"itsec-dashboard_-_vulnerabilities-_-21\":{\"menu_title\":\"Vulnerabilities\",\"original_menu_id\":\"itsec-vulnerabilities\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"itsec-vulnerabilities\"},\"itsec-dashboard_-_user-security-_-19\":{\"menu_title\":\"User Security\",\"original_menu_id\":\"itsec-user-security\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"itsec-user-security\"},\"itsec-dashboard_-_settings-_-5\":{\"menu_title\":\"Settings\",\"original_menu_id\":\"itsec\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"itsec\"},\"itsec-dashboard_-_tools-_-11\":{\"menu_title\":\"Tools\",\"original_menu_id\":\"itsec-tools\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"itsec-tools\"},\"itsec-dashboard_-_logs-_-10\":{\"menu_title\":\"Logs\",\"original_menu_id\":\"itsec-logs\",\"hide_by_toggle\":false,\"always_hide\":false,\"always_hide_for\":\"\",\"which_roles\":[],\"menu_url_fragment\":\"itsec-logs\"}}\";s:26:\"custom_menu_new_separators\";s:0:\"\";s:24:\"custom_admin_footer_left\";s:0:\"\";s:25:\"custom_admin_footer_right\";s:0:\"\";s:17:\"custom_login_slug\";s:7:\"backend\";s:27:\"default_login_redirect_slug\";s:9:\"not_found\";s:13:\"login_id_type\";s:8:\"username\";s:24:\"login_page_form_position\";s:6:\"center\";s:28:\"login_page_form_color_scheme\";s:5:\"light\";s:32:\"login_page_form_section_color_bg\";s:7:\"#1e73be\";s:42:\"login_page_form_section_color_transparency\";s:3:\"0.8\";s:26:\"login_page_logo_image_type\";s:6:\"custom\";s:21:\"login_page_logo_image\";s:0:\"\";s:27:\"login_page_logo_image_width\";s:0:\"\";s:28:\"login_page_logo_image_height\";s:0:\"\";s:21:\"login_page_background\";s:7:\"pattern\";s:27:\"login_page_background_image\";s:0:\"\";s:29:\"login_page_background_pattern\";s:20:\"blurry-gradient-blue\";s:27:\"login_page_background_color\";s:7:\"#eeeeee\";s:21:\"login_page_custom_css\";s:0:\"\";s:25:\"redirect_after_login_type\";s:10:\"single_url\";s:28:\"redirect_after_login_to_slug\";s:0:\"\";s:38:\"redirect_after_login_for_separate_slug\";a:5:{s:13:\"administrator\";s:0:\"\";s:6:\"editor\";s:0:\"\";s:6:\"author\";s:0:\"\";s:11:\"contributor\";s:0:\"\";s:10:\"subscriber\";s:0:\"\";}s:26:\"redirect_after_logout_type\";s:10:\"single_url\";s:29:\"redirect_after_logout_to_slug\";s:0:\"\";s:39:\"redirect_after_logout_for_separate_slug\";a:5:{s:13:\"administrator\";s:0:\"\";s:6:\"editor\";s:0:\"\";s:6:\"author\";s:0:\"\";s:11:\"contributor\";s:0:\"\";s:10:\"subscriber\";s:0:\"\";}s:16:\"custom_admin_css\";s:0:\"\";s:28:\"custom_frontend_css_priority\";s:2:\"10\";s:19:\"custom_frontend_css\";s:0:\"\";s:18:\"head_code_priority\";s:2:\"10\";s:9:\"head_code\";s:0:\"\";s:18:\"body_code_priority\";s:2:\"10\";s:9:\"body_code\";s:0:\"\";s:20:\"footer_code_priority\";s:2:\"10\";s:11:\"footer_code\";s:0:\"\";s:15:\"ads_txt_content\";s:0:\"\";s:19:\"app_ads_txt_content\";s:0:\"\";s:18:\"robots_txt_content\";s:63866:\"&lt;!DOCTYPE html&gt;\r\n&lt;html lang=&quot;fr-FR&quot;&gt;\r\n&lt;head&gt;\r\n	&lt;meta charset=&quot;UTF-8&quot; /&gt;\r\n	&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot; /&gt;\r\n&lt;meta name=&#039;robots&#039; content=&#039;noindex, nofollow&#039; /&gt;\r\n&lt;title&gt;Page non trouvée &amp;#8211; CREAWEB.MA&lt;/title&gt;\r\n&lt;link rel=&quot;alternate&quot; type=&quot;application/rss+xml&quot; title=&quot;CREAWEB.MA &amp;raquo; Flux&quot; href=&quot;http://192.168.100.112:8012/duplicator-creaweb/feed/&quot; /&gt;\r\n&lt;link rel=&quot;alternate&quot; type=&quot;application/rss+xml&quot; title=&quot;CREAWEB.MA &amp;raquo; Flux des commentaires&quot; href=&quot;http://192.168.100.112:8012/duplicator-creaweb/comments/feed/&quot; /&gt;\r\n&lt;script&gt;\r\nwindow._wpemojiSettings = {&quot;baseUrl&quot;:&quot;https:\\/\\/s.w.org\\/images\\/core\\/emoji\\/15.0.3\\/72x72\\/&quot;,&quot;ext&quot;:&quot;.png&quot;,&quot;svgUrl&quot;:&quot;https:\\/\\/s.w.org\\/images\\/core\\/emoji\\/15.0.3\\/svg\\/&quot;,&quot;svgExt&quot;:&quot;.svg&quot;,&quot;source&quot;:{&quot;concatemoji&quot;:&quot;http:\\/\\/192.168.100.112:8012\\/duplicator-creaweb\\/wp-includes\\/js\\/wp-emoji-release.min.js?ver=6.6.2&quot;}};\r\n/*! This file is auto-generated */\r\n!function(i,n){var o,s,e;function c(e){try{var t={supportTests:e,timestamp:(new Date).valueOf()};sessionStorage.setItem(o,JSON.stringify(t))}catch(e){}}function p(e,t,n){e.clearRect(0,0,e.canvas.width,e.canvas.height),e.fillText(t,0,0);var t=new Uint32Array(e.getImageData(0,0,e.canvas.width,e.canvas.height).data),r=(e.clearRect(0,0,e.canvas.width,e.canvas.height),e.fillText(n,0,0),new Uint32Array(e.getImageData(0,0,e.canvas.width,e.canvas.height).data));return t.every(function(e,t){return e===r[t]})}function u(e,t,n){switch(t){case&quot;flag&quot;:return n(e,&quot;\\ud83c\\udff3\\ufe0f\\u200d\\u26a7\\ufe0f&quot;,&quot;\\ud83c\\udff3\\ufe0f\\u200b\\u26a7\\ufe0f&quot;)?!1:!n(e,&quot;\\ud83c\\uddfa\\ud83c\\uddf3&quot;,&quot;\\ud83c\\uddfa\\u200b\\ud83c\\uddf3&quot;)&amp;&amp;!n(e,&quot;\\ud83c\\udff4\\udb40\\udc67\\udb40\\udc62\\udb40\\udc65\\udb40\\udc6e\\udb40\\udc67\\udb40\\udc7f&quot;,&quot;\\ud83c\\udff4\\u200b\\udb40\\udc67\\u200b\\udb40\\udc62\\u200b\\udb40\\udc65\\u200b\\udb40\\udc6e\\u200b\\udb40\\udc67\\u200b\\udb40\\udc7f&quot;);case&quot;emoji&quot;:return!n(e,&quot;\\ud83d\\udc26\\u200d\\u2b1b&quot;,&quot;\\ud83d\\udc26\\u200b\\u2b1b&quot;)}return!1}function f(e,t,n){var r=&quot;undefined&quot;!=typeof WorkerGlobalScope&amp;&amp;self instanceof WorkerGlobalScope?new OffscreenCanvas(300,150):i.createElement(&quot;canvas&quot;),a=r.getContext(&quot;2d&quot;,{willReadFrequently:!0}),o=(a.textBaseline=&quot;top&quot;,a.font=&quot;600 32px Arial&quot;,{});return e.forEach(function(e){o[e]=t(a,e,n)}),o}function t(e){var t=i.createElement(&quot;script&quot;);t.src=e,t.defer=!0,i.head.appendChild(t)}&quot;undefined&quot;!=typeof Promise&amp;&amp;(o=&quot;wpEmojiSettingsSupports&quot;,s=[&quot;flag&quot;,&quot;emoji&quot;],n.supports={everything:!0,everythingExceptFlag:!0},e=new Promise(function(e){i.addEventListener(&quot;DOMContentLoaded&quot;,e,{once:!0})}),new Promise(function(t){var n=function(){try{var e=JSON.parse(sessionStorage.getItem(o));if(&quot;object&quot;==typeof e&amp;&amp;&quot;number&quot;==typeof e.timestamp&amp;&amp;(new Date).valueOf()&lt;e.timestamp+604800&amp;&amp;&quot;object&quot;==typeof e.supportTests)return e.supportTests}catch(e){}return null}();if(!n){if(&quot;undefined&quot;!=typeof Worker&amp;&amp;&quot;undefined&quot;!=typeof OffscreenCanvas&amp;&amp;&quot;undefined&quot;!=typeof URL&amp;&amp;URL.createObjectURL&amp;&amp;&quot;undefined&quot;!=typeof Blob)try{var e=&quot;postMessage(&quot;+f.toString()+&quot;(&quot;+[JSON.stringify(s),u.toString(),p.toString()].join(&quot;,&quot;)+&quot;));&quot;,r=new Blob([e],{type:&quot;text/javascript&quot;}),a=new Worker(URL.createObjectURL(r),{name:&quot;wpTestEmojiSupports&quot;});return void(a.onmessage=function(e){c(n=e.data),a.terminate(),t(n)})}catch(e){}c(n=f(s,u,p))}t(n)}).then(function(e){for(var t in e)n.supports[t]=e[t],n.supports.everything=n.supports.everything&amp;&amp;n.supports[t],&quot;flag&quot;!==t&amp;&amp;(n.supports.everythingExceptFlag=n.supports.everythingExceptFlag&amp;&amp;n.supports[t]);n.supports.everythingExceptFlag=n.supports.everythingExceptFlag&amp;&amp;!n.supports.flag,n.DOMReady=!1,n.readyCallback=function(){n.DOMReady=!0}}).then(function(){return e}).then(function(){var e;n.supports.everything||(n.readyCallback(),(e=n.source||{}).concatemoji?t(e.concatemoji):e.wpemoji&amp;&amp;e.twemoji&amp;&amp;(t(e.twemoji),t(e.wpemoji)))}))}((window,document),window._wpemojiSettings);\r\n&lt;/script&gt;\r\n&lt;style id=&#039;wp-block-site-logo-inline-css&#039;&gt;\r\n.wp-block-site-logo{box-sizing:border-box;line-height:0}.wp-block-site-logo a{display:inline-block;line-height:0}.wp-block-site-logo.is-default-size img{height:auto;width:120px}.wp-block-site-logo img{height:auto;max-width:100%}.wp-block-site-logo a,.wp-block-site-logo img{border-radius:inherit}.wp-block-site-logo.aligncenter{margin-left:auto;margin-right:auto;text-align:center}:root :where(.wp-block-site-logo.is-style-rounded){border-radius:9999px}\r\n&lt;/style&gt;\r\n&lt;style id=&#039;wp-block-site-title-inline-css&#039;&gt;\r\n:root :where(.wp-block-site-title a){color:inherit}\r\n&lt;/style&gt;\r\n&lt;style id=&#039;wp-block-group-inline-css&#039;&gt;\r\n.wp-block-group{box-sizing:border-box}:where(.wp-block-group.wp-block-group-is-layout-constrained){position:relative}\r\n&lt;/style&gt;\r\n&lt;style id=&#039;wp-block-page-list-inline-css&#039;&gt;\r\n.wp-block-navigation .wp-block-page-list{align-items:var(--navigation-layout-align,initial);background-color:inherit;display:flex;flex-direction:var(--navigation-layout-direction,initial);flex-wrap:var(--navigation-layout-wrap,wrap);justify-content:var(--navigation-layout-justify,initial)}.wp-block-navigation .wp-block-navigation-item{background-color:inherit}\r\n&lt;/style&gt;\r\n&lt;link rel=&#039;stylesheet&#039; id=&#039;wp-block-navigation-css&#039; href=&#039;http://192.168.100.112:8012/duplicator-creaweb/wp-includes/blocks/navigation/style.min.css?ver=6.6.2&#039; media=&#039;all&#039; /&gt;\r\n&lt;style id=&#039;wp-block-heading-inline-css&#039;&gt;\r\nh1.has-background,h2.has-background,h3.has-background,h4.has-background,h5.has-background,h6.has-background{padding:1.25em 2.375em}h1.has-text-align-left[style*=writing-mode]:where([style*=vertical-lr]),h1.has-text-align-right[style*=writing-mode]:where([style*=vertical-rl]),h2.has-text-align-left[style*=writing-mode]:where([style*=vertical-lr]),h2.has-text-align-right[style*=writing-mode]:where([style*=vertical-rl]),h3.has-text-align-left[style*=writing-mode]:where([style*=vertical-lr]),h3.has-text-align-right[style*=writing-mode]:where([style*=vertical-rl]),h4.has-text-align-left[style*=writing-mode]:where([style*=vertical-lr]),h4.has-text-align-right[style*=writing-mode]:where([style*=vertical-rl]),h5.has-text-align-left[style*=writing-mode]:where([style*=vertical-lr]),h5.has-text-align-right[style*=writing-mode]:where([style*=vertical-rl]),h6.has-text-align-left[style*=writing-mode]:where([style*=vertical-lr]),h6.has-text-align-right[style*=writing-mode]:where([style*=vertical-rl]){rotate:180deg}\r\n\r\n				.is-style-asterisk:before {\r\n					content: &#039;&#039;;\r\n					width: 1.5rem;\r\n					height: 3rem;\r\n					background: var(--wp--preset--color--contrast-2, currentColor);\r\n					clip-path: path(&#039;M11.93.684v8.039l5.633-5.633 1.216 1.23-5.66 5.66h8.04v1.737H13.2l5.701 5.701-1.23 1.23-5.742-5.742V21h-1.737v-8.094l-5.77 5.77-1.23-1.217 5.743-5.742H.842V9.98h8.162l-5.701-5.7 1.23-1.231 5.66 5.66V.684h1.737Z&#039;);\r\n					display: block;\r\n				}\r\n\r\n				/* Hide the asterisk if the heading has no content, to avoid using empty headings to display the asterisk only, which is an A11Y issue */\r\n				.is-style-asterisk:empty:before {\r\n					content: none;\r\n				}\r\n\r\n				.is-style-asterisk:-moz-only-whitespace:before {\r\n					content: none;\r\n				}\r\n\r\n				.is-style-asterisk.has-text-align-center:before {\r\n					margin: 0 auto;\r\n				}\r\n\r\n				.is-style-asterisk.has-text-align-right:before {\r\n					margin-left: auto;\r\n				}\r\n\r\n				.rtl .is-style-asterisk.has-text-align-left:before {\r\n					margin-right: auto;\r\n				}\r\n&lt;/style&gt;\r\n&lt;style id=&#039;wp-block-paragraph-inline-css&#039;&gt;\r\n.is-small-text{font-size:.875em}.is-regular-text{font-size:1em}.is-large-text{font-size:2.25em}.is-larger-text{font-size:3em}.has-drop-cap:not(:focus):first-letter{float:left;font-size:8.4em;font-style:normal;font-weight:100;line-height:.68;margin:.05em .1em 0 0;text-transform:uppercase}body.rtl .has-drop-cap:not(:focus):first-letter{float:none;margin-left:.1em}p.has-drop-cap.has-background{overflow:hidden}:root :where(p.has-background){padding:1.25em 2.375em}:where(p.has-text-color:not(.has-link-color)) a{color:inherit}p.has-text-align-left[style*=&quot;writing-mode:vertical-lr&quot;],p.has-text-align-right[style*=&quot;writing-mode:vertical-rl&quot;]{rotate:180deg}\r\n&lt;/style&gt;\r\n&lt;style id=&#039;wp-block-search-inline-css&#039;&gt;\r\n.wp-block-search__button{margin-left:10px;word-break:normal}.wp-block-search__button.has-icon{line-height:0}.wp-block-search__button svg{height:1.25em;min-height:24px;min-width:24px;width:1.25em;fill:currentColor;vertical-align:text-bottom}:where(.wp-block-search__button){border:1px solid #ccc;padding:6px 10px}.wp-block-search__inside-wrapper{display:flex;flex:auto;flex-wrap:nowrap;max-width:100%}.wp-block-search__label{width:100%}.wp-block-search__input{appearance:none;border:1px solid #949494;flex-grow:1;margin-left:0;margin-right:0;min-width:3rem;padding:8px;text-decoration:unset!important}.wp-block-search.wp-block-search__button-only .wp-block-search__button{flex-shrink:0;margin-left:0;max-width:100%}.wp-block-search.wp-block-search__button-only .wp-block-search__button[aria-expanded=true]{max-width:calc(100% - 100px)}.wp-block-search.wp-block-search__button-only .wp-block-search__inside-wrapper{min-width:0!important;transition-property:width}.wp-block-search.wp-block-search__button-only .wp-block-search__input{flex-basis:100%;transition-duration:.3s}.wp-block-search.wp-block-search__button-only.wp-block-search__searchfield-hidden,.wp-block-search.wp-block-search__button-only.wp-block-search__searchfield-hidden .wp-block-search__inside-wrapper{overflow:hidden}.wp-block-search.wp-block-search__button-only.wp-block-search__searchfield-hidden .wp-block-search__input{border-left-width:0!important;border-right-width:0!important;flex-basis:0;flex-grow:0;margin:0;min-width:0!important;padding-left:0!important;padding-right:0!important;width:0!important}:where(.wp-block-search__input){font-family:inherit;font-size:inherit;font-style:inherit;font-weight:inherit;letter-spacing:inherit;line-height:inherit;text-transform:inherit}:where(.wp-block-search__button-inside .wp-block-search__inside-wrapper){border:1px solid #949494;box-sizing:border-box;padding:4px}:where(.wp-block-search__button-inside .wp-block-search__inside-wrapper) .wp-block-search__input{border:none;border-radius:0;padding:0 4px}:where(.wp-block-search__button-inside .wp-block-search__inside-wrapper) .wp-block-search__input:focus{outline:none}:where(.wp-block-search__button-inside .wp-block-search__inside-wrapper) :where(.wp-block-search__button){padding:4px 8px}.wp-block-search.aligncenter .wp-block-search__inside-wrapper{margin:auto}.wp-block[data-align=right] .wp-block-search.wp-block-search__button-only .wp-block-search__inside-wrapper{float:right}\r\n&lt;/style&gt;\r\n&lt;style id=&#039;wp-block-navigation-link-inline-css&#039;&gt;\r\n.wp-block-navigation .wp-block-navigation-item__label{overflow-wrap:break-word}.wp-block-navigation .wp-block-navigation-item__description{display:none}.link-ui-tools{border-top:1px solid #f0f0f0;padding:8px}.link-ui-block-inserter{padding-top:8px}.link-ui-block-inserter__back{margin-left:8px;text-transform:uppercase}\r\n\r\n				.is-style-arrow-link .wp-block-navigation-item__label:after {\r\n					content: &quot;\\2197&quot;;\r\n					padding-inline-start: 0.25rem;\r\n					vertical-align: middle;\r\n					text-decoration: none;\r\n					display: inline-block;\r\n				}\r\n&lt;/style&gt;\r\n&lt;style id=&#039;wp-block-columns-inline-css&#039;&gt;\r\n.wp-block-columns{align-items:normal!important;box-sizing:border-box;display:flex;flex-wrap:wrap!important}@media (min-width:782px){.wp-block-columns{flex-wrap:nowrap!important}}.wp-block-columns.are-vertically-aligned-top{align-items:flex-start}.wp-block-columns.are-vertically-aligned-center{align-items:center}.wp-block-columns.are-vertically-aligned-bottom{align-items:flex-end}@media (max-width:781px){.wp-block-columns:not(.is-not-stacked-on-mobile)&gt;.wp-block-column{flex-basis:100%!important}}@media (min-width:782px){.wp-block-columns:not(.is-not-stacked-on-mobile)&gt;.wp-block-column{flex-basis:0;flex-grow:1}.wp-block-columns:not(.is-not-stacked-on-mobile)&gt;.wp-block-column[style*=flex-basis]{flex-grow:0}}.wp-block-columns.is-not-stacked-on-mobile{flex-wrap:nowrap!important}.wp-block-columns.is-not-stacked-on-mobile&gt;.wp-block-column{flex-basis:0;flex-grow:1}.wp-block-columns.is-not-stacked-on-mobile&gt;.wp-block-column[style*=flex-basis]{flex-grow:0}:where(.wp-block-columns){margin-bottom:1.75em}:where(.wp-block-columns.has-background){padding:1.25em 2.375em}.wp-block-column{flex-grow:1;min-width:0;overflow-wrap:break-word;word-break:break-word}.wp-block-column.is-vertically-aligned-top{align-self:flex-start}.wp-block-column.is-vertically-aligned-center{align-self:center}.wp-block-column.is-vertically-aligned-bottom{align-self:flex-end}.wp-block-column.is-vertically-aligned-stretch{align-self:stretch}.wp-block-column.is-vertically-aligned-bottom,.wp-block-column.is-vertically-aligned-center,.wp-block-column.is-vertically-aligned-top{width:100%}\r\n&lt;/style&gt;\r\n&lt;style id=&#039;wp-emoji-styles-inline-css&#039;&gt;\r\n\r\n	img.wp-smiley, img.emoji {\r\n		display: inline !important;\r\n		border: none !important;\r\n		box-shadow: none !important;\r\n		height: 1em !important;\r\n		width: 1em !important;\r\n		margin: 0 0.07em !important;\r\n		vertical-align: -0.1em !important;\r\n		background: none !important;\r\n		padding: 0 !important;\r\n	}\r\n&lt;/style&gt;\r\n&lt;style id=&#039;wp-block-library-inline-css&#039;&gt;\r\n:root{--wp-admin-theme-color:#007cba;--wp-admin-theme-color--rgb:0,124,186;--wp-admin-theme-color-darker-10:#006ba1;--wp-admin-theme-color-darker-10--rgb:0,107,161;--wp-admin-theme-color-darker-20:#005a87;--wp-admin-theme-color-darker-20--rgb:0,90,135;--wp-admin-border-width-focus:2px;--wp-block-synced-color:#7a00df;--wp-block-synced-color--rgb:122,0,223;--wp-bound-block-color:var(--wp-block-synced-color)}@media (min-resolution:192dpi){:root{--wp-admin-border-width-focus:1.5px}}.wp-element-button{cursor:pointer}:root{--wp--preset--font-size--normal:16px;--wp--preset--font-size--huge:42px}:root .has-very-light-gray-background-color{background-color:#eee}:root .has-very-dark-gray-background-color{background-color:#313131}:root .has-very-light-gray-color{color:#eee}:root .has-very-dark-gray-color{color:#313131}:root .has-vivid-green-cyan-to-vivid-cyan-blue-gradient-background{background:linear-gradient(135deg,#00d084,#0693e3)}:root .has-purple-crush-gradient-background{background:linear-gradient(135deg,#34e2e4,#4721fb 50%,#ab1dfe)}:root .has-hazy-dawn-gradient-background{background:linear-gradient(135deg,#faaca8,#dad0ec)}:root .has-subdued-olive-gradient-background{background:linear-gradient(135deg,#fafae1,#67a671)}:root .has-atomic-cream-gradient-background{background:linear-gradient(135deg,#fdd79a,#004a59)}:root .has-nightshade-gradient-background{background:linear-gradient(135deg,#330968,#31cdcf)}:root .has-midnight-gradient-background{background:linear-gradient(135deg,#020381,#2874fc)}.has-regular-font-size{font-size:1em}.has-larger-font-size{font-size:2.625em}.has-normal-font-size{font-size:var(--wp--preset--font-size--normal)}.has-huge-font-size{font-size:var(--wp--preset--font-size--huge)}.has-text-align-center{text-align:center}.has-text-align-left{text-align:left}.has-text-align-right{text-align:right}#end-resizable-editor-section{display:none}.aligncenter{clear:both}.items-justified-left{justify-content:flex-start}.items-justified-center{justify-content:center}.items-justified-right{justify-content:flex-end}.items-justified-space-between{justify-content:space-between}.screen-reader-text{border:0;clip:rect(1px,1px,1px,1px);clip-path:inset(50%);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px;word-wrap:normal!important}.screen-reader-text:focus{background-color:#ddd;clip:auto!important;clip-path:none;color:#444;display:block;font-size:1em;height:auto;left:5px;line-height:normal;padding:15px 23px 14px;text-decoration:none;top:5px;width:auto;z-index:100000}html :where(.has-border-color){border-style:solid}html :where([style*=border-top-color]){border-top-style:solid}html :where([style*=border-right-color]){border-right-style:solid}html :where([style*=border-bottom-color]){border-bottom-style:solid}html :where([style*=border-left-color]){border-left-style:solid}html :where([style*=border-width]){border-style:solid}html :where([style*=border-top-width]){border-top-style:solid}html :where([style*=border-right-width]){border-right-style:solid}html :where([style*=border-bottom-width]){border-bottom-style:solid}html :where([style*=border-left-width]){border-left-style:solid}html :where(img[class*=wp-image-]){height:auto;max-width:100%}:where(figure){margin:0 0 1em}html :where(.is-position-sticky){--wp-admin--admin-bar--position-offset:var(--wp-admin--admin-bar--height,0px)}@media screen and (max-width:600px){html :where(.is-position-sticky){--wp-admin--admin-bar--position-offset:0px}}\r\n&lt;/style&gt;\r\n&lt;style id=&#039;global-styles-inline-css&#039;&gt;\r\n:root{--wp--preset--aspect-ratio--square: 1;--wp--preset--aspect-ratio--4-3: 4/3;--wp--preset--aspect-ratio--3-4: 3/4;--wp--preset--aspect-ratio--3-2: 3/2;--wp--preset--aspect-ratio--2-3: 2/3;--wp--preset--aspect-ratio--16-9: 16/9;--wp--preset--aspect-ratio--9-16: 9/16;--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--color--base: #f9f9f9;--wp--preset--color--base-2: #ffffff;--wp--preset--color--contrast: #111111;--wp--preset--color--contrast-2: #636363;--wp--preset--color--contrast-3: #A4A4A4;--wp--preset--color--accent: #cfcabe;--wp--preset--color--accent-2: #c2a990;--wp--preset--color--accent-3: #d8613c;--wp--preset--color--accent-4: #b1c5a4;--wp--preset--color--accent-5: #b5bdbc;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--gradient--gradient-1: linear-gradient(to bottom, #cfcabe 0%, #F9F9F9 100%);--wp--preset--gradient--gradient-2: linear-gradient(to bottom, #C2A990 0%, #F9F9F9 100%);--wp--preset--gradient--gradient-3: linear-gradient(to bottom, #D8613C 0%, #F9F9F9 100%);--wp--preset--gradient--gradient-4: linear-gradient(to bottom, #B1C5A4 0%, #F9F9F9 100%);--wp--preset--gradient--gradient-5: linear-gradient(to bottom, #B5BDBC 0%, #F9F9F9 100%);--wp--preset--gradient--gradient-6: linear-gradient(to bottom, #A4A4A4 0%, #F9F9F9 100%);--wp--preset--gradient--gradient-7: linear-gradient(to bottom, #cfcabe 50%, #F9F9F9 50%);--wp--preset--gradient--gradient-8: linear-gradient(to bottom, #C2A990 50%, #F9F9F9 50%);--wp--preset--gradient--gradient-9: linear-gradient(to bottom, #D8613C 50%, #F9F9F9 50%);--wp--preset--gradient--gradient-10: linear-gradient(to bottom, #B1C5A4 50%, #F9F9F9 50%);--wp--preset--gradient--gradient-11: linear-gradient(to bottom, #B5BDBC 50%, #F9F9F9 50%);--wp--preset--gradient--gradient-12: linear-gradient(to bottom, #A4A4A4 50%, #F9F9F9 50%);--wp--preset--font-size--small: 0.9rem;--wp--preset--font-size--medium: 1.05rem;--wp--preset--font-size--large: clamp(1.39rem, 1.39rem + ((1vw - 0.2rem) * 0.767), 1.85rem);--wp--preset--font-size--x-large: clamp(1.85rem, 1.85rem + ((1vw - 0.2rem) * 1.083), 2.5rem);--wp--preset--font-size--xx-large: clamp(2.5rem, 2.5rem + ((1vw - 0.2rem) * 1.283), 3.27rem);--wp--preset--font-family--body: &quot;Inter&quot;, sans-serif;--wp--preset--font-family--heading: Cardo;--wp--preset--font-family--system-sans-serif: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;--wp--preset--font-family--system-serif: Iowan Old Style, Apple Garamond, Baskerville, Times New Roman, Droid Serif, Times, Source Serif Pro, serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol;--wp--preset--spacing--20: min(1.5rem, 2vw);--wp--preset--spacing--30: min(2.5rem, 3vw);--wp--preset--spacing--40: min(4rem, 5vw);--wp--preset--spacing--50: min(6.5rem, 8vw);--wp--preset--spacing--60: min(10.5rem, 13vw);--wp--preset--spacing--70: 3.38rem;--wp--preset--spacing--80: 5.06rem;--wp--preset--spacing--10: 1rem;--wp--preset--shadow--natural: 6px 6px 9px rgba(0, 0, 0, 0.2);--wp--preset--shadow--deep: 12px 12px 50px rgba(0, 0, 0, 0.4);--wp--preset--shadow--sharp: 6px 6px 0px rgba(0, 0, 0, 0.2);--wp--preset--shadow--outlined: 6px 6px 0px -3px rgba(255, 255, 255, 1), 6px 6px rgba(0, 0, 0, 1);--wp--preset--shadow--crisp: 6px 6px 0px rgba(0, 0, 0, 1);}:root { --wp--style--global--content-size: 620px;--wp--style--global--wide-size: 1280px; }:where(body) { margin: 0; }.wp-site-blocks { padding-top: var(--wp--style--root--padding-top); padding-bottom: var(--wp--style--root--padding-bottom); }.has-global-padding { padding-right: var(--wp--style--root--padding-right); padding-left: var(--wp--style--root--padding-left); }.has-global-padding &gt; .alignfull { margin-right: calc(var(--wp--style--root--padding-right) * -1); margin-left: calc(var(--wp--style--root--padding-left) * -1); }.has-global-padding :where(:not(.alignfull.is-layout-flow) &gt; .has-global-padding:not(.wp-block-block, .alignfull)) { padding-right: 0; padding-left: 0; }.has-global-padding :where(:not(.alignfull.is-layout-flow) &gt; .has-global-padding:not(.wp-block-block, .alignfull)) &gt; .alignfull { margin-left: 0; margin-right: 0; }.wp-site-blocks &gt; .alignleft { float: left; margin-right: 2em; }.wp-site-blocks &gt; .alignright { float: right; margin-left: 2em; }.wp-site-blocks &gt; .aligncenter { justify-content: center; margin-left: auto; margin-right: auto; }:where(.wp-site-blocks) &gt; * { margin-block-start: 1.2rem; margin-block-end: 0; }:where(.wp-site-blocks) &gt; :first-child { margin-block-start: 0; }:where(.wp-site-blocks) &gt; :last-child { margin-block-end: 0; }:root { --wp--style--block-gap: 1.2rem; }:root :where(.is-layout-flow) &gt; :first-child{margin-block-start: 0;}:root :where(.is-layout-flow) &gt; :last-child{margin-block-end: 0;}:root :where(.is-layout-flow) &gt; *{margin-block-start: 1.2rem;margin-block-end: 0;}:root :where(.is-layout-constrained) &gt; :first-child{margin-block-start: 0;}:root :where(.is-layout-constrained) &gt; :last-child{margin-block-end: 0;}:root :where(.is-layout-constrained) &gt; *{margin-block-start: 1.2rem;margin-block-end: 0;}:root :where(.is-layout-flex){gap: 1.2rem;}:root :where(.is-layout-grid){gap: 1.2rem;}.is-layout-flow &gt; .alignleft{float: left;margin-inline-start: 0;margin-inline-end: 2em;}.is-layout-flow &gt; .alignright{float: right;margin-inline-start: 2em;margin-inline-end: 0;}.is-layout-flow &gt; .aligncenter{margin-left: auto !important;margin-right: auto !important;}.is-layout-constrained &gt; .alignleft{float: left;margin-inline-start: 0;margin-inline-end: 2em;}.is-layout-constrained &gt; .alignright{float: right;margin-inline-start: 2em;margin-inline-end: 0;}.is-layout-constrained &gt; .aligncenter{margin-left: auto !important;margin-right: auto !important;}.is-layout-constrained &gt; :where(:not(.alignleft):not(.alignright):not(.alignfull)){max-width: var(--wp--style--global--content-size);margin-left: auto !important;margin-right: auto !important;}.is-layout-constrained &gt; .alignwide{max-width: var(--wp--style--global--wide-size);}body .is-layout-flex{display: flex;}.is-layout-flex{flex-wrap: wrap;align-items: center;}.is-layout-flex &gt; :is(*, div){margin: 0;}body .is-layout-grid{display: grid;}.is-layout-grid &gt; :is(*, div){margin: 0;}body{background-color: var(--wp--preset--color--base);color: var(--wp--preset--color--contrast);font-family: var(--wp--preset--font-family--body);font-size: var(--wp--preset--font-size--medium);font-style: normal;font-weight: 400;line-height: 1.55;--wp--style--root--padding-top: 0px;--wp--style--root--padding-right: var(--wp--preset--spacing--50);--wp--style--root--padding-bottom: 0px;--wp--style--root--padding-left: var(--wp--preset--spacing--50);}a:where(:not(.wp-element-button)){color: var(--wp--preset--color--contrast);text-decoration: underline;}:root :where(a:where(:not(.wp-element-button)):hover){text-decoration: none;}h1, h2, h3, h4, h5, h6{color: var(--wp--preset--color--contrast);font-family: var(--wp--preset--font-family--heading);font-weight: 400;line-height: 1.2;}h1{font-size: var(--wp--preset--font-size--xx-large);line-height: 1.15;}h2{font-size: var(--wp--preset--font-size--x-large);}h3{font-size: var(--wp--preset--font-size--large);}h4{font-size: clamp(1.1rem, 1.1rem + ((1vw - 0.2rem) * 0.767), 1.5rem);}h5{font-size: var(--wp--preset--font-size--medium);}h6{font-size: var(--wp--preset--font-size--small);}:root :where(.wp-element-button, .wp-block-button__link){background-color: var(--wp--preset--color--contrast);border-radius: .33rem;border-color: var(--wp--preset--color--contrast);border-width: 0;color: var(--wp--preset--color--base);font-family: inherit;font-size: var(--wp--preset--font-size--small);font-style: normal;font-weight: 500;line-height: inherit;padding-top: 0.6rem;padding-right: 1rem;padding-bottom: 0.6rem;padding-left: 1rem;text-decoration: none;}:root :where(.wp-element-button:hover, .wp-block-button__link:hover){background-color: var(--wp--preset--color--contrast-2);border-color: var(--wp--preset--color--contrast-2);color: var(--wp--preset--color--base);}:root :where(.wp-element-button:focus, .wp-block-button__link:focus){background-color: var(--wp--preset--color--contrast-2);border-color: var(--wp--preset--color--contrast-2);color: var(--wp--preset--color--base);outline-color: var(--wp--preset--color--contrast);outline-offset: 2px;}:root :where(.wp-element-button:active, .wp-block-button__link:active){background-color: var(--wp--preset--color--contrast);color: var(--wp--preset--color--base);}:root :where(.wp-element-caption, .wp-block-audio figcaption, .wp-block-embed figcaption, .wp-block-gallery figcaption, .wp-block-image figcaption, .wp-block-table figcaption, .wp-block-video figcaption){color: var(--wp--preset--color--contrast-2);font-family: var(--wp--preset--font-family--body);font-size: 0.8rem;}.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-base-color{color: var(--wp--preset--color--base) !important;}.has-base-2-color{color: var(--wp--preset--color--base-2) !important;}.has-contrast-color{color: var(--wp--preset--color--contrast) !important;}.has-contrast-2-color{color: var(--wp--preset--color--contrast-2) !important;}.has-contrast-3-color{color: var(--wp--preset--color--contrast-3) !important;}.has-accent-color{color: var(--wp--preset--color--accent) !important;}.has-accent-2-color{color: var(--wp--preset--color--accent-2) !important;}.has-accent-3-color{color: var(--wp--preset--color--accent-3) !important;}.has-accent-4-color{color: var(--wp--preset--color--accent-4) !important;}.has-accent-5-color{color: var(--wp--preset--color--accent-5) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-base-background-color{background-color: var(--wp--preset--color--base) !important;}.has-base-2-background-color{background-color: var(--wp--preset--color--base-2) !important;}.has-contrast-background-color{background-color: var(--wp--preset--color--contrast) !important;}.has-contrast-2-background-color{background-color: var(--wp--preset--color--contrast-2) !important;}.has-contrast-3-background-color{background-color: var(--wp--preset--color--contrast-3) !important;}.has-accent-background-color{background-color: var(--wp--preset--color--accent) !important;}.has-accent-2-background-color{background-color: var(--wp--preset--color--accent-2) !important;}.has-accent-3-background-color{background-color: var(--wp--preset--color--accent-3) !important;}.has-accent-4-background-color{background-color: var(--wp--preset--color--accent-4) !important;}.has-accent-5-background-color{background-color: var(--wp--preset--color--accent-5) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-base-border-color{border-color: var(--wp--preset--color--base) !important;}.has-base-2-border-color{border-color: var(--wp--preset--color--base-2) !important;}.has-contrast-border-color{border-color: var(--wp--preset--color--contrast) !important;}.has-contrast-2-border-color{border-color: var(--wp--preset--color--contrast-2) !important;}.has-contrast-3-border-color{border-color: var(--wp--preset--color--contrast-3) !important;}.has-accent-border-color{border-color: var(--wp--preset--color--accent) !important;}.has-accent-2-border-color{border-color: var(--wp--preset--color--accent-2) !important;}.has-accent-3-border-color{border-color: var(--wp--preset--color--accent-3) !important;}.has-accent-4-border-color{border-color: var(--wp--preset--color--accent-4) !important;}.has-accent-5-border-color{border-color: var(--wp--preset--color--accent-5) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-gradient-1-gradient-background{background: var(--wp--preset--gradient--gradient-1) !important;}.has-gradient-2-gradient-background{background: var(--wp--preset--gradient--gradient-2) !important;}.has-gradient-3-gradient-background{background: var(--wp--preset--gradient--gradient-3) !important;}.has-gradient-4-gradient-background{background: var(--wp--preset--gradient--gradient-4) !important;}.has-gradient-5-gradient-background{background: var(--wp--preset--gradient--gradient-5) !important;}.has-gradient-6-gradient-background{background: var(--wp--preset--gradient--gradient-6) !important;}.has-gradient-7-gradient-background{background: var(--wp--preset--gradient--gradient-7) !important;}.has-gradient-8-gradient-background{background: var(--wp--preset--gradient--gradient-8) !important;}.has-gradient-9-gradient-background{background: var(--wp--preset--gradient--gradient-9) !important;}.has-gradient-10-gradient-background{background: var(--wp--preset--gradient--gradient-10) !important;}.has-gradient-11-gradient-background{background: var(--wp--preset--gradient--gradient-11) !important;}.has-gradient-12-gradient-background{background: var(--wp--preset--gradient--gradient-12) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}.has-xx-large-font-size{font-size: var(--wp--preset--font-size--xx-large) !important;}.has-body-font-family{font-family: var(--wp--preset--font-family--body) !important;}.has-heading-font-family{font-family: var(--wp--preset--font-family--heading) !important;}.has-system-sans-serif-font-family{font-family: var(--wp--preset--font-family--system-sans-serif) !important;}.has-system-serif-font-family{font-family: var(--wp--preset--font-family--system-serif) !important;}\r\n:root :where(.wp-block-navigation){font-weight: 500;}\r\n:root :where(.wp-block-navigation a:where(:not(.wp-element-button))){text-decoration: none;}\r\n:root :where(.wp-block-navigation a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\r\n:root :where(.wp-block-search .wp-block-search__label, .wp-block-search .wp-block-search__input, .wp-block-search .wp-block-search__button){font-size: var(--wp--preset--font-size--small);}:root :where(.wp-block-search .wp-block-search__input){border-radius:.33rem}\r\n:root :where(.wp-block-search .wp-element-button,.wp-block-search  .wp-block-button__link){border-radius: .33rem;}\r\n:root :where(.wp-block-site-tagline){color: var(--wp--preset--color--contrast-2);font-size: var(--wp--preset--font-size--small);}\r\n:root :where(.wp-block-site-title){font-family: var(--wp--preset--font-family--body);font-size: clamp(0.875rem, 0.875rem + ((1vw - 0.2rem) * 0.542), 1.2rem);font-style: normal;font-weight: 600;}\r\n:root :where(.wp-block-site-title a:where(:not(.wp-element-button))){text-decoration: none;}\r\n:root :where(.wp-block-site-title a:where(:not(.wp-element-button)):hover){text-decoration: none;}\r\n:where(.wp-site-blocks *:focus){outline-width:2px;outline-style:solid}:root :where(.wp-block-calendar.wp-block-calendar table:where(:not(.has-text-color)) th){background-color:var(--wp--preset--color--contrast-2);color:var(--wp--preset--color--base);border-color:var(--wp--preset--color--contrast-2)}:root :where(.wp-block-calendar table:where(:not(.has-text-color)) td){border-color:var(--wp--preset--color--contrast-2)}:root :where(.wp-block-categories){list-style-type:none;}:root :where(.wp-block-categories li){margin-bottom: 0.5rem;}:root :where(.wp-block-post-comments-form textarea, .wp-block-post-comments-form input){border-radius:.33rem}:root :where(.wp-block-loginout input){border-radius:.33rem;padding:calc(0.667em + 2px);border:1px solid #949494;}:root :where(.wp-block-post-terms .wp-block-post-terms__prefix){color: var(--wp--preset--color--contrast-2);}:root :where(.wp-block-query-title span){font-style: italic;}:root :where(.wp-block-quote :where(p)){margin-block-start:0;margin-block-end:calc(var(--wp--preset--spacing--10) + 0.5rem);}:root :where(.wp-block-quote :where(:last-child)){margin-block-end:0;}:root :where(.wp-block-quote.has-text-align-right.is-style-plain, .rtl .is-style-plain.wp-block-quote:not(.has-text-align-center):not(.has-text-align-left)){border-width: 0 2px 0 0;padding-left:calc(var(--wp--preset--spacing--20) + 0.5rem);padding-right:calc(var(--wp--preset--spacing--20) + 0.5rem);}:root :where(.wp-block-quote.has-text-align-left.is-style-plain, body:not(.rtl) .is-style-plain.wp-block-quote:not(.has-text-align-center):not(.has-text-align-right)){border-width: 0 0 0 2px;padding-left:calc(var(--wp--preset--spacing--20) + 0.5rem);padding-right:calc(var(--wp--preset--spacing--20) + 0.5rem)}:root :where(.wp-block-search .wp-block-search__input){border-radius:.33rem}:root :where(.wp-block-separator){}:root :where(.wp-block-separator:not(.is-style-wide):not(.is-style-dots):not(.alignwide):not(.alignfull)){width: var(--wp--preset--spacing--60)}\r\n&lt;/style&gt;\r\n&lt;style id=&#039;core-block-supports-inline-css&#039;&gt;\r\n.wp-container-core-group-is-layout-1 &gt; *{margin-block-start:0;margin-block-end:0;}.wp-container-core-group-is-layout-1 &gt; * + *{margin-block-start:0px;margin-block-end:0;}.wp-container-core-group-is-layout-2{gap:var(--wp--preset--spacing--20);}.wp-container-core-navigation-is-layout-1{gap:var(--wp--preset--spacing--20);justify-content:flex-end;}.wp-container-core-group-is-layout-3{justify-content:flex-start;}.wp-container-core-group-is-layout-4{justify-content:space-between;}.wp-container-core-group-is-layout-6 &gt; *{margin-block-start:0;margin-block-end:0;}.wp-container-core-group-is-layout-6 &gt; * + *{margin-block-start:var(--wp--preset--spacing--30);margin-block-end:0;}.wp-container-core-group-is-layout-7{flex-direction:column;align-items:flex-start;}.wp-container-core-navigation-is-layout-2{gap:var(--wp--preset--spacing--10);flex-direction:column;align-items:flex-start;}.wp-container-core-group-is-layout-8{gap:var(--wp--preset--spacing--10);flex-direction:column;align-items:flex-start;}.wp-container-core-group-is-layout-9{flex-direction:column;align-items:stretch;}.wp-container-core-navigation-is-layout-3{gap:var(--wp--preset--spacing--10);flex-direction:column;align-items:flex-start;}.wp-container-core-group-is-layout-10{gap:var(--wp--preset--spacing--10);flex-direction:column;align-items:flex-start;}.wp-container-core-group-is-layout-11{flex-direction:column;align-items:stretch;}.wp-container-core-navigation-is-layout-4{gap:var(--wp--preset--spacing--10);flex-direction:column;align-items:flex-start;}.wp-container-core-group-is-layout-12{gap:var(--wp--preset--spacing--10);flex-direction:column;align-items:flex-start;}.wp-container-core-group-is-layout-13{flex-direction:column;align-items:stretch;}.wp-container-core-group-is-layout-14{justify-content:space-between;align-items:flex-start;}.wp-container-core-columns-is-layout-1{flex-wrap:nowrap;}.wp-elements-5d8f50ca2275aec5863d8cce417713cd a:where(:not(.wp-element-button)){color:var(--wp--preset--color--contrast);}\r\n&lt;/style&gt;\r\n&lt;style id=&#039;wp-block-template-skip-link-inline-css&#039;&gt;\r\n\r\n		.skip-link.screen-reader-text {\r\n			border: 0;\r\n			clip: rect(1px,1px,1px,1px);\r\n			clip-path: inset(50%);\r\n			height: 1px;\r\n			margin: -1px;\r\n			overflow: hidden;\r\n			padding: 0;\r\n			position: absolute !important;\r\n			width: 1px;\r\n			word-wrap: normal !important;\r\n		}\r\n\r\n		.skip-link.screen-reader-text:focus {\r\n			background-color: #eee;\r\n			clip: auto !important;\r\n			clip-path: none;\r\n			color: #444;\r\n			display: block;\r\n			font-size: 1em;\r\n			height: auto;\r\n			left: 5px;\r\n			line-height: normal;\r\n			padding: 15px 23px 14px;\r\n			text-decoration: none;\r\n			top: 5px;\r\n			width: auto;\r\n			z-index: 100000;\r\n		}\r\n&lt;/style&gt;\r\n&lt;link rel=&#039;stylesheet&#039; id=&#039;contact-form-7-css&#039; href=&#039;http://192.168.100.112:8012/duplicator-creaweb/wp-content/plugins/contact-form-7/includes/css/styles.css?ver=5.9.8&#039; media=&#039;all&#039; /&gt;\r\n&lt;link rel=&quot;https://api.w.org/&quot; href=&quot;http://192.168.100.112:8012/duplicator-creaweb/wp-json/&quot; /&gt;&lt;link rel=&quot;EditURI&quot; type=&quot;application/rsd+xml&quot; title=&quot;RSD&quot; href=&quot;http://192.168.100.112:8012/duplicator-creaweb/xmlrpc.php?rsd&quot; /&gt;\r\n&lt;meta name=&quot;generator&quot; content=&quot;WordPress 6.6.2&quot; /&gt;\r\n&lt;script id=&quot;wp-load-polyfill-importmap&quot;&gt;\r\n( HTMLScriptElement.supports &amp;&amp; HTMLScriptElement.supports(&quot;importmap&quot;) ) || document.write( &#039;&lt;script src=&quot;http://192.168.100.112:8012/duplicator-creaweb/wp-includes/js/dist/vendor/wp-polyfill-importmap.min.js?ver=1.8.2&quot;&gt;&lt;/scr&#039; + &#039;ipt&gt;&#039; );\r\n&lt;/script&gt;\r\n&lt;script type=&quot;importmap&quot; id=&quot;wp-importmap&quot;&gt;\r\n{&quot;imports&quot;:{&quot;@wordpress\\/interactivity&quot;:&quot;http:\\/\\/192.168.100.112:8012\\/duplicator-creaweb\\/wp-includes\\/js\\/dist\\/interactivity.min.js?ver=6.6.2&quot;}}\r\n&lt;/script&gt;\r\n&lt;script type=&quot;module&quot; src=&quot;http://192.168.100.112:8012/duplicator-creaweb/wp-includes/blocks/navigation/view.min.js?ver=6.6.2&quot; id=&quot;@wordpress/block-library/navigation-js-module&quot;&gt;&lt;/script&gt;\r\n&lt;link rel=&quot;modulepreload&quot; href=&quot;http://192.168.100.112:8012/duplicator-creaweb/wp-includes/js/dist/interactivity.min.js?ver=6.6.2&quot; id=&quot;@wordpress/interactivity-js-modulepreload&quot;&gt;&lt;style id=&#039;wp-fonts-local&#039;&gt;\r\n@font-face{font-family:Inter;font-style:normal;font-weight:300 900;font-display:fallback;src:url(&#039;http://192.168.100.112:8012/duplicator-creaweb/wp-content/themes/twentytwentyfour/assets/fonts/inter/Inter-VariableFont_slnt,wght.woff2&#039;) format(&#039;woff2&#039;);font-stretch:normal;}\r\n@font-face{font-family:Cardo;font-style:normal;font-weight:400;font-display:fallback;src:url(&#039;http://192.168.100.112:8012/duplicator-creaweb/wp-content/themes/twentytwentyfour/assets/fonts/cardo/cardo_normal_400.woff2&#039;) format(&#039;woff2&#039;);}\r\n@font-face{font-family:Cardo;font-style:italic;font-weight:400;font-display:fallback;src:url(&#039;http://192.168.100.112:8012/duplicator-creaweb/wp-content/themes/twentytwentyfour/assets/fonts/cardo/cardo_italic_400.woff2&#039;) format(&#039;woff2&#039;);}\r\n@font-face{font-family:Cardo;font-style:normal;font-weight:700;font-display:fallback;src:url(&#039;http://192.168.100.112:8012/duplicator-creaweb/wp-content/themes/twentytwentyfour/assets/fonts/cardo/cardo_normal_700.woff2&#039;) format(&#039;woff2&#039;);}\r\n&lt;/style&gt;\r\n&lt;/head&gt;\r\n\r\n&lt;body class=&quot;error404 wp-embed-responsive&quot;&gt;\r\n\r\n&lt;div class=&quot;wp-site-blocks&quot;&gt;&lt;header class=&quot;wp-block-template-part&quot;&gt;\r\n&lt;div class=&quot;wp-block-group alignwide has-base-background-color has-background has-global-padding is-layout-constrained wp-block-group-is-layout-constrained&quot;\r\n	style=&quot;padding-top:20px;padding-bottom:20px&quot;&gt;\r\n	\r\n	&lt;div class=&quot;wp-block-group alignwide is-content-justification-space-between is-layout-flex wp-container-core-group-is-layout-4 wp-block-group-is-layout-flex&quot;&gt;\r\n		\r\n		&lt;div class=&quot;wp-block-group is-layout-flex wp-container-core-group-is-layout-2 wp-block-group-is-layout-flex&quot;&gt;\r\n			\r\n\r\n			\r\n			&lt;div class=&quot;wp-block-group is-layout-flow wp-container-core-group-is-layout-1 wp-block-group-is-layout-flow&quot;&gt;\r\n				&lt;p class=&quot;wp-block-site-title&quot;&gt;&lt;a href=&quot;http://192.168.100.112:8012/duplicator-creaweb&quot; target=&quot;_self&quot; rel=&quot;home&quot;&gt;CREAWEB.MA&lt;/a&gt;&lt;/p&gt;\r\n			&lt;/div&gt;\r\n			\r\n		&lt;/div&gt;\r\n		\r\n\r\n		\r\n		&lt;div class=&quot;wp-block-group is-content-justification-left is-layout-flex wp-container-core-group-is-layout-3 wp-block-group-is-layout-flex&quot;&gt;\r\n			&lt;nav class=&quot;is-responsive items-justified-right wp-block-navigation is-horizontal is-content-justification-right is-layout-flex wp-container-core-navigation-is-layout-1 wp-block-navigation-is-layout-flex&quot; aria-label=&quot;&quot; \r\n		 data-wp-interactive=&quot;core/navigation&quot; data-wp-context=&#039;{&quot;overlayOpenedBy&quot;:{&quot;click&quot;:false,&quot;hover&quot;:false,&quot;focus&quot;:false},&quot;type&quot;:&quot;overlay&quot;,&quot;roleAttribute&quot;:&quot;&quot;,&quot;ariaLabel&quot;:&quot;Menu&quot;}&#039;&gt;&lt;button aria-haspopup=&quot;dialog&quot; aria-label=&quot;Ouvrir le menu&quot; class=&quot;wp-block-navigation__responsive-container-open &quot; \r\n				data-wp-on-async--click=&quot;actions.openMenuOnClick&quot;\r\n				data-wp-on--keydown=&quot;actions.handleMenuKeydown&quot;\r\n			&gt;&lt;svg width=&quot;24&quot; height=&quot;24&quot; xmlns=&quot;http://www.w3.org/2000/svg&quot; viewBox=&quot;0 0 24 24&quot; aria-hidden=&quot;true&quot; focusable=&quot;false&quot;&gt;&lt;rect x=&quot;4&quot; y=&quot;7.5&quot; width=&quot;16&quot; height=&quot;1.5&quot; /&gt;&lt;rect x=&quot;4&quot; y=&quot;15